/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.bundleupgrade.service.impl;

import com.huawei.bundleupgrade.entity.UpgradeDeviceEntity;
import com.huawei.bundleupgrade.entity.fusionstrg.UpgDeviceExtendFSDataEntity;
import com.huawei.bundleupgrade.model.ExecuteResult;
import com.huawei.bundleupgrade.service.connection.fusionstrg.FusionStorageRestConnector;
import com.huawei.bundleupgrade.service.connection.fusionstrg.FusionStorageSshConnector;
import com.huawei.bundleupgrade.service.connection.fusionstrg.FusionStorageSshPool;
import com.huawei.bundleupgrade.service.impl.OutBandUpgradeServiceServiceImpl;
import com.huawei.bundleupgrade.utils.BundleUpgradeContext;
import com.huawei.bundleupgrade.utils.SHAAndRSASignCheckUtil;
import com.huawei.bundleupgrade.utils.ServiceUtil;
import com.huawei.bundleupgrade.utils.SystemConfigUtil;
import com.huawei.bundleupgrade.utils.UpgradeCustomizationUtil;
import com.huawei.bundleupgrade.utils.UpgradeScenarioUtil;
import com.huawei.bundleupgrade.utils.fusionstrg.FusionStrgUpgradeContext;
import com.huawei.ism.tool.framework.platform.exception.SignException;
import com.huawei.ism.tool.framework.platform.util.LanguageManager;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.protocol.rest.RestConnection;
import com.huawei.ism.tool.pyengine.engine.JythonExecuter;
import com.huawei.uMate.common.UMateException;
import com.huawei.uMate.common.utils.ResUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FusionStorageCheckService {
    private static final Logger log = LoggerFactory.getLogger(FusionStorageCheckService.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(OutBandUpgradeServiceServiceImpl.class);
    private static final ResUtil RES = ResUtil.getInstance((String)"BundleUpgrade");
    private static final String STEP_OPERATION_SUCC_MSG = "step.operation.basic.succ";
    private UpgradeDeviceEntity deviceEntity;
    private FusionStorageRestConnector floatIpRestConnector;

    public FusionStorageCheckService(UpgradeDeviceEntity device) {
        this.deviceEntity = device;
    }

    public String preCheckPoolStatus(String canonicalScriptPath) throws UMateException {
        LOGGER.info("entering FusionStorageCheckService check pool status operation.");
        return this.executeFusionStorageScripts(canonicalScriptPath);
    }

    public String preCheckFusionStorgeOnDeviceUpgrade(String canonicalScriptPath) throws UMateException {
        LOGGER.info("entering FusionStorageCheckService pre-check operation.");
        return this.executeFusionStorageScripts(canonicalScriptPath);
    }

    private String executeFusionStorageScripts(String canonicalScriptPath) throws UMateException {
        List<File> scriptDir = UpgradeScenarioUtil.getAllDirectoriesInTargetDir(canonicalScriptPath);
        LOGGER.info(String.format(Locale.ENGLISH, "execution script %s.", canonicalScriptPath));
        try {
            SHAAndRSASignCheckUtil.verifyEntireDirScriptsSignature(FileUtils.getFile((String[])new String[]{canonicalScriptPath}).getParentFile());
            JythonExecuter executor = new JythonExecuter(scriptDir);
            executor.compileScript(FileUtils.getFile((String[])new String[]{canonicalScriptPath}));
            List ret = executor.invokeFunction("execute", this.buildScriptEnvs());
            return this.parseScriptResults(ret);
        }
        catch (FileNotFoundException fnf) {
            LOGGER.error("file {} not found, tools parts broken.", (Object)FileUtils.getFile((String[])new String[]{canonicalScriptPath}).getName());
            throw new UMateException(RES.getString("tool.parts.lost.please.reinstall"));
        }
        catch (SignException signE) {
            LOGGER.error("sign exception:", (Throwable)signE);
            throw new UMateException(RES.getString("sign.exception.might.altered"));
        }
        catch (UMateException e) {
            LOGGER.error("Business exception:", (Throwable)e);
            throw e;
        }
        catch (Exception exception) {
            LOGGER.error("exception occurred :", (Throwable)exception);
            LOGGER.error("After retry for set times, the execution still failed, quit.....");
            throw new UMateException(RES.getString("script.execution.failed.after.retry.all.times"));
        }
    }

    private String parseScriptResults(List<Object> ret) throws UMateException {
        if (null == ret || ret.size() < 2) {
            LOGGER.error("the script's execution result is not valid!");
            throw new UMateException("script.execution.not.recognized.result");
        }
        try {
            if (!Boolean.parseBoolean((String)ret.get(0))) {
                return (String)ret.get(1);
            }
        }
        catch (ClassCastException exp) {
            LOGGER.error("class cast exception:", (Throwable)exp);
            throw new UMateException("script.execution.not.recognized.result");
        }
        return "";
    }

    private Map<String, Object> buildScriptEnvs() throws UMateException {
        HashMap<String, Object> ssEnv = new HashMap<String, Object>(2);
        ssEnv.put("logger", LOGGER);
        this.floatIpRestConnector = this.getFloatIpConnector();
        ssEnv.put("connector", this.floatIpRestConnector);
        ssEnv.put("managementIP", this.getManagementIP());
        ssEnv.put("deviceEntity", this.deviceEntity);
        ssEnv.put("lang", LanguageManager.getInstance().getCurrentLanguage().getLanguage());
        ssEnv.put("rLock", FusionStrgUpgradeContext.getInstance().getrLock());
        ssEnv.put("nmaProcessRebootTimeOut", UpgradeScenarioUtil.getWaitingNmaRebootTimeOut());
        ssEnv.put("nodeSSHPool", FusionStorageSshPool.class);
        ssEnv.put("osAuth", BundleUpgradeContext.getInstance().isSshAuthCheckOpen());
        ssEnv.put("isSingleManagementRestart", this.isSingleManagementRestart());
        ssEnv.put("isCheckNodeStatus", UpgradeCustomizationUtil.isCheckNodeStatus(ServiceUtil.getFSClusterVersion(this.deviceEntity)));
        return ssEnv;
    }

    public boolean isSingleManagementRestart() {
        List<String> managementIps = this.deviceEntity.getDeviceEntity().getManagementIps();
        if (managementIps.size() == 1) {
            return this.deviceEntity.getDeviceEntity().getIp().equals(managementIps.get(0));
        }
        return false;
    }

    private String getManagementIP() {
        UpgDeviceExtendFSDataEntity fsDataEntity = FusionStrgUpgradeContext.getInstance().getBusinessIpMapper().get(this.deviceEntity);
        return fsDataEntity.getManagementIp();
    }

    private FusionStorageRestConnector getFloatIpConnector() throws UMateException {
        UpgDeviceExtendFSDataEntity fsDataEntity = FusionStrgUpgradeContext.getInstance().getBusinessIpMapper().get(this.deviceEntity);
        return new FusionStorageRestConnector(fsDataEntity.getBelongsClusterEntity());
    }

    public String postCheckFusionStorgeOnDeviceUpgrade(String canonicalScriptPath) throws UMateException {
        LOGGER.info("entering FusionStorageCheckService post-check operation.");
        return this.executeFusionStorageScripts(canonicalScriptPath);
    }

    public void releaseRestConnection() {
        if (this.floatIpRestConnector != null) {
            this.floatIpRestConnector.releaseConn();
        } else {
            LOGGER.info("The REST connection does not exist and does not need to be released.");
        }
    }

    public boolean directPlaneUpgradeCheck() {
        if (!Boolean.parseBoolean(SystemConfigUtil.getSysConfig("direct.port.check"))) {
            LOGGER.info("Do not need port check.");
            return true;
        }
        this.drawNewProgress("bundle.upgrade.check.portStatus.tittle");
        String chassisId = this.deviceEntity.getDeviceEntity().getChassisId();
        List<UpgradeDeviceEntity> nodeInSameChassis = this.filterNodeInSameChassis(chassisId);
        if (nodeInSameChassis.isEmpty()) {
            LOGGER.info("Do not exist node in this chassis {}.", (Object)chassisId);
            this.updateLastProcessDetailsProgress(RES.getString(STEP_OPERATION_SUCC_MSG), this.getLastProcessProgress() + 5.0, true);
            return true;
        }
        if (!this.portRedundancyCheck(nodeInSameChassis)) {
            return false;
        }
        if (!this.portStatusCheck(nodeInSameChassis)) {
            return false;
        }
        this.updateLastProcessDetailsProgress(RES.getString(STEP_OPERATION_SUCC_MSG), this.getLastProcessProgress() + 5.0, true);
        return true;
    }

    private boolean portStatusCheck(List<UpgradeDeviceEntity> nodeInSameChassis) {
        String errMsg = nodeInSameChassis.stream().map(this::nodePortsStatusCheck).filter(Objects::nonNull).collect(Collectors.joining("\n"));
        if (StringUtils.isNULLStr((String)errMsg)) {
            return true;
        }
        this.updateLastProcessDetailsProgress(RES.getStringWithParams("bundle.upgrade.check.portStatus.notPass", new Object[]{errMsg}), this.getLastProcessProgress(), false);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String nodePortsStatusCheck(UpgradeDeviceEntity node) {
        UpgDeviceExtendFSDataEntity dev = FusionStrgUpgradeContext.getInstance().getFsDeviceEntityByBmcIp(node.getDeviceEntity().getIp());
        try {
            FusionStorageSshConnector ssh = FusionStorageSshPool.getFsSshConnection(dev);
            List notHealthPort = node.getDeviceEntity().getBackEndPortAndFrontEndPortList().stream().filter(portName -> !this.portStatusCheck(ssh, (String)portName)).collect(Collectors.toList());
            if (notHealthPort.isEmpty()) {
                String string = null;
                return string;
            }
            String string = RES.getStringWithParams("bundle.upgrade.check.portStatus.waring", new Object[]{dev.getManagementIp(), notHealthPort});
            return string;
        }
        catch (Exception ex) {
            LOGGER.error("Query port status error.", (Throwable)ex);
            String string = RES.getStringWithParams("bundle.upgrade.check.portStatus.waring1", new Object[]{dev.getManagementIp()});
            return string;
        }
        finally {
            FusionStorageSshPool.releaseFsSshConnection(dev);
        }
    }

    private boolean portStatusCheck(FusionStorageSshConnector ssh, String portName) {
        try {
            String cmd = "ethtool %s";
            String ret = ssh.executeCmd(String.format(Locale.ENGLISH, cmd, portName));
            String keyLine = "Link detected: yes";
            return Arrays.stream(ret.split("\n")).anyMatch(line -> line.contains(keyLine));
        }
        catch (Exception e) {
            LOGGER.error("Port {} check error.", (Object)portName);
            return false;
        }
    }

    private boolean portRedundancyCheck(List<UpgradeDeviceEntity> nodeInSameChassis) {
        List notPassNodes = nodeInSameChassis.stream().filter(dev -> dev.getDeviceEntity().getStorageBackEndPortList().size() == 1).collect(Collectors.toList());
        notPassNodes.addAll(nodeInSameChassis.stream().filter(dev -> dev.getDeviceEntity().getStorageFrontEndPortList().size() == 1).collect(Collectors.toList()));
        if (notPassNodes.isEmpty()) {
            return true;
        }
        FusionStrgUpgradeContext context = FusionStrgUpgradeContext.getInstance();
        String msg = notPassNodes.stream().map(node -> context.getFsDeviceEntityByBmcIp(node.getDeviceEntity().getIp()).getManagementIp()).collect(Collectors.joining(",\n"));
        this.updateLastProcessDetailsProgress(RES.getStringWithParams("bundle.upgrade.check.portNum.waring", new Object[]{msg}), this.getLastProcessProgress(), false);
        return false;
    }

    private List<UpgradeDeviceEntity> filterNodeInSameChassis(String chassisId) {
        return BundleUpgradeContext.getInstance().getAllDeviceList().stream().filter(dev -> chassisId.equals(dev.getDeviceEntity().getChassisId())).filter(dev -> !dev.isPlaneNode()).collect(Collectors.toList());
    }

    private void drawNewProgress(String title) {
        BundleUpgradeContext.getInstance().getMainDialog().createExecuteResult(this.deviceEntity, RES.getString(title));
    }

    private void updateLastProcessDetailsProgress(String string, double progress, boolean success) {
        BundleUpgradeContext.getInstance().getMainDialog().updateExecuteResult(this.deviceEntity, string, (Double)progress, success);
    }

    private double getLastProcessProgress() {
        List<ExecuteResult> results = this.deviceEntity.getExecuteInfo().getResults();
        if (results.isEmpty() || results.size() == 1) {
            return 0.0;
        }
        if (results.get(results.size() - 1).getTotalProgress() > 0.0) {
            return results.get(results.size() - 1).getTotalProgress();
        }
        return results.get(results.size() - 2).getTotalProgress();
    }

    public RestConnection getRestConnector() throws UMateException {
        if (Objects.isNull(this.floatIpRestConnector)) {
            this.floatIpRestConnector = this.getFloatIpConnector();
        }
        return this.floatIpRestConnector.getRestConnection();
    }

    public String getMgrIp() {
        return FusionStrgUpgradeContext.getInstance().getFsDeviceEntityByBmcIp(this.deviceEntity.getDeviceEntity().getIp()).getManagementIp();
    }

    public void setSwitchOverStatus(boolean isSuccess) {
        this.deviceEntity.getDeviceEntity().setSwitchOverSuccess(isSuccess);
    }

    public boolean getSwitchOverStatus() {
        return this.deviceEntity.getDeviceEntity().isSwitchOverSuccess();
    }

    public String getDiskPoolId() {
        return this.deviceEntity.getDeviceEntity().getDiskPoolId();
    }

    public List<String> getManagements() {
        return this.deviceEntity.getDeviceEntity().getManagementIps();
    }

    public String getBmcIp() {
        return this.deviceEntity.getDeviceEntity().getIp();
    }

    public String getBaseUrl() {
        return this.floatIpRestConnector.getBaseUrl();
    }

    public boolean isSupportDiskPool() {
        return this.deviceEntity.getDeviceEntity().isSupportDiskPool();
    }
}

