/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.bundleupgrade.service.impl;

import com.huawei.bundleupgrade.constants.UpgradeParamConstants;
import com.huawei.bundleupgrade.entity.DeviceEntity;
import com.huawei.bundleupgrade.entity.FirmwarePackageEntity;
import com.huawei.bundleupgrade.entity.UpgradeDeviceEntity;
import com.huawei.bundleupgrade.model.ExecuteInfo;
import com.huawei.bundleupgrade.model.Module;
import com.huawei.bundleupgrade.service.connection.fusionstrg.FusionStorageSshConnector;
import com.huawei.bundleupgrade.service.connection.fusionstrg.FusionStorageSshPool;
import com.huawei.bundleupgrade.ui.BundleUpgradeMainDialog;
import com.huawei.bundleupgrade.utils.BundleUpgradeContext;
import com.huawei.bundleupgrade.utils.fusionstrg.FusionStrgUpgradeContext;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.uMate.common.thread.CommonRunnable;
import com.huawei.uMate.common.utils.ResUtil;
import java.io.File;
import java.util.Arrays;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NVMeDiskUpgradeServiceImpl {
    private static final Logger LOGGER = LoggerFactory.getLogger(NVMeDiskUpgradeServiceImpl.class);
    private static final ResUtil RES = ResUtil.getInstance((String)"BundleUpgrade");
    private static final String EXEC_SUCCESS = RES.getString("step.operation.basic.succ");
    private static final int QUERY_RETRY_TIME = 3;
    private BundleUpgradeMainDialog mainDialog = BundleUpgradeContext.getInstance().getMainDialog();
    private Double lastTotalProgress;
    private UpgradeDeviceEntity upgradeDeviceEntity;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void upgrade(UpgradeDeviceEntity upgradeDeviceEntity, Double progressStepLen) {
        this.upgradeDeviceEntity = upgradeDeviceEntity;
        this.lastTotalProgress = this.getLastTotalProgress(upgradeDeviceEntity);
        Double sshConnectionProgress = this.lastTotalProgress + progressStepLen * 0.1;
        String curDes = RES.getString("upgrade.sub.nvme.title");
        this.mainDialog.createExecuteResult(upgradeDeviceEntity, curDes);
        try {
            FusionStorageSshConnector ssh;
            List<FirmwarePackageEntity> pkgList = this.getNVMeFirmPackageEntity();
            try {
                ssh = FusionStorageSshPool.getFsSshConnectionByBmcIp(upgradeDeviceEntity.getDeviceEntity().getIp());
            }
            catch (Exception e) {
                LOGGER.error("nvme get ssh connector fail", (Throwable)e);
                String msg = RES.getString("bundle.upgrade.match.ssh.error");
                this.mainDialog.updateExecuteResult(upgradeDeviceEntity, msg, progressStepLen, false);
                this.writeUpgradeResult(pkgList.get(0), UpgradeParamConstants.FirmUpgradeStatus.FAILED, UpgradeParamConstants.ModuleType.ES3000, msg);
                FusionStorageSshPool.releaseFsSshConnection(FusionStrgUpgradeContext.getInstance().getFsDeviceEntityByBmcIp(upgradeDeviceEntity.getDeviceEntity().getIp()));
                return;
            }
            this.mainDialog.updateExecuteResult(upgradeDeviceEntity, EXEC_SUCCESS, sshConnectionProgress, true);
            ssh.mkdirs("/tmp/NVMeFwPackage");
            pkgList.forEach(firmwarePackage -> this.executeUpgrade(ssh, (FirmwarePackageEntity)firmwarePackage, progressStepLen / (double)pkgList.size()));
            this.cleanAndDownloadLog(ssh);
        }
        catch (Exception e) {
            LOGGER.error("execute node {} huawei nvme and sas upgrade failed:", (Object)upgradeDeviceEntity.getDeviceEntity().getIp(), (Object)e);
        }
        finally {
            FusionStorageSshPool.releaseFsSshConnection(FusionStrgUpgradeContext.getInstance().getFsDeviceEntityByBmcIp(upgradeDeviceEntity.getDeviceEntity().getIp()));
        }
    }

    private void cleanAndDownloadLog(FusionStorageSshConnector ssh) {
        try {
            String date = StringUtils.formatDate((Object)Calendar.getInstance(), (String)"yyyyMMddHHmmss");
            String localDirDate = StringUtils.formatDate((Object)Calendar.getInstance(), (String)"yyyy-MM-dd");
            String logFileName = String.format(Locale.ENGLISH, "%s_%s_nvme_upgrade_log.zip", this.upgradeDeviceEntity.getDeviceEntity().getIp(), date);
            String localPath = ApplicationContext.getInstance().getWorkPath() + File.separator + "log" + File.separator + localDirDate + File.separator + logFileName.replace(":", "_");
            ssh.executeCmd(String.format(Locale.ENGLISH, "zip -r /var/log/pangea_internal_upgrade/es3000/%s /var/log/pangea_internal_upgrade/es3000", logFileName));
            ssh.getDeviceFile("/var/log/pangea_internal_upgrade/es3000", logFileName, localPath);
            ssh.executeCmd("rm -rf /var/log/pangea_internal_upgrade/es3000");
            ssh.executeCmd("rm -rf /tmp/NVMeFwPackage");
        }
        catch (Exception exception) {
            LOGGER.error("execute node {} huawei clean and download log failed:", (Object)this.upgradeDeviceEntity.getDeviceEntity().getIp(), (Object)exception);
        }
    }

    private void executeUpgrade(FusionStorageSshConnector ssh, FirmwarePackageEntity firmwarePackageEntity, Double progressStepLen) {
        String curDes = RES.getStringWithParams("upgrade.sub.nvme.title.desc", new Object[]{UpgradeParamConstants.ModuleType.parseModule(firmwarePackageEntity.getPackageInfo().getModule()).getModule(), firmwarePackageEntity.getPackageInfo().getVersion()});
        this.mainDialog.createExecuteResult(this.upgradeDeviceEntity, curDes);
        Double uploadFwProgress = this.lastTotalProgress + progressStepLen * 0.3;
        if (!this.uploadFWAndUnZipPackage(ssh, firmwarePackageEntity, uploadFwProgress)) {
            return;
        }
        Double doUpgradeFwProgress = this.lastTotalProgress + progressStepLen * 0.4;
        if (!this.doUpgrade(ssh, firmwarePackageEntity, doUpgradeFwProgress)) {
            return;
        }
        Double queryUpgradeFwProgress = this.lastTotalProgress + progressStepLen;
        if (!this.queryUpgradeStatus(ssh, firmwarePackageEntity, queryUpgradeFwProgress)) {
            return;
        }
        this.writeUpgradeResult(firmwarePackageEntity, UpgradeParamConstants.FirmUpgradeStatus.SUCCESS, UpgradeParamConstants.ModuleType.parseModule(firmwarePackageEntity.getPackageInfo().getModule()), "");
    }

    private boolean queryUpgradeStatus(FusionStorageSshConnector ssh, FirmwarePackageEntity firmwarePackageEntity, Double queryUpgradeFwProgress) {
        int maxUpgradeTime = firmwarePackageEntity.getPackageInfo().getMaxUpgradeTime();
        long start = System.currentTimeMillis();
        long latest = System.currentTimeMillis();
        int errCount = 0;
        String queryUpgradeStatusCmd = firmwarePackageEntity.getInterfaceInfo().getGetUpgradeStatusCmd();
        String failedMsg = RES.getString("upgrade.errror.not.common");
        try {
            CommonRunnable.sleep((int)5000);
            while (latest - start < (long)(maxUpgradeTime * 1000)) {
                LOGGER.info("begin query upgrade status, cmd={}", (Object)queryUpgradeStatusCmd);
                String queryStatusResponse = ssh.executeCmd(queryUpgradeStatusCmd);
                LOGGER.info("cmd={}, response is {}", (Object)queryUpgradeStatusCmd, (Object)queryStatusResponse);
                if (queryStatusResponse.contains("failed")) {
                    LOGGER.info("upgrade failure");
                    this.setUpgradeFail(firmwarePackageEntity, queryUpgradeFwProgress, failedMsg);
                    return false;
                }
                if (queryStatusResponse.contains("success")) {
                    this.mainDialog.updateExecuteResult(this.upgradeDeviceEntity, EXEC_SUCCESS, queryUpgradeFwProgress, true);
                    LOGGER.info("upgrade success");
                    return true;
                }
                if (queryStatusResponse.contains("upgrading")) {
                    List<String> resultList = Arrays.asList(queryStatusResponse.split("\n"));
                    String cmdResult = resultList.subList(1, resultList.size() - 1).get(0);
                    int upgradePercent = Integer.parseInt(cmdResult.split(" ")[1].trim());
                    LOGGER.info("current upgrading process is {}", (Object)upgradePercent);
                    CommonRunnable.sleep((int)5000);
                    latest = System.currentTimeMillis();
                    errCount = 0;
                    continue;
                }
                if (errCount <= 3) {
                    ++errCount;
                    continue;
                }
                LOGGER.error("query upgrade status response error. response is {}", (Object)queryStatusResponse);
                this.setUpgradeFail(firmwarePackageEntity, queryUpgradeFwProgress, failedMsg);
                return false;
            }
        }
        catch (Exception e) {
            LOGGER.info("query status exception:", (Throwable)e);
            this.setUpgradeFail(firmwarePackageEntity, queryUpgradeFwProgress, failedMsg);
            return false;
        }
        failedMsg = RES.getString("bundle.upgrade.main.detail.info.QUERY_STATUS.TIMEOUT");
        this.setUpgradeFail(firmwarePackageEntity, queryUpgradeFwProgress, failedMsg);
        return false;
    }

    private boolean doUpgrade(FusionStorageSshConnector ssh, FirmwarePackageEntity firmwarePackageEntity, Double doUpgradeFwProgress) {
        try {
            ssh.executeCmd(String.format(Locale.ENGLISH, "cd %s", this.getUnzipPath(firmwarePackageEntity)));
            String doUpgradeCmd = firmwarePackageEntity.getInterfaceInfo().getUpgradeCmd();
            ssh.executeCmd(doUpgradeCmd);
            return true;
        }
        catch (Exception e) {
            LOGGER.error("do upgrade fail.", (Throwable)e);
            String msg = RES.getString("bundle.upgrade.main.detail.info.DO_UPGRADE.FAILED");
            this.writeUpgradeResult(firmwarePackageEntity, UpgradeParamConstants.FirmUpgradeStatus.FAILED, UpgradeParamConstants.ModuleType.parseModule(firmwarePackageEntity.getPackageInfo().getModule()), msg);
            this.mainDialog.updateExecuteResult(this.upgradeDeviceEntity, msg, doUpgradeFwProgress, false);
            return false;
        }
    }

    private boolean uploadFWAndUnZipPackage(FusionStorageSshConnector ssh, FirmwarePackageEntity firmwarePackageEntity, Double uploadFwProgress) {
        String targetFilePath = "/tmp/NVMeFwPackage/" + this.getFirmwarePackageName(firmwarePackageEntity);
        String localUploadFilePath = firmwarePackageEntity.getLocalPathAbs();
        try {
            ssh.uploadFile(targetFilePath, localUploadFilePath, true);
        }
        catch (Exception exception) {
            LOGGER.error("upload package info fail", (Throwable)exception);
            String msg = RES.getStringWithParams("bundle.upgrade.main.detail.info.UPLOAD.FAILED", new Object[]{firmwarePackageEntity.getPackageInfo().getPackageName()});
            this.mainDialog.updateExecuteResult(this.upgradeDeviceEntity, msg, uploadFwProgress, false);
            this.writeUpgradeResult(firmwarePackageEntity, UpgradeParamConstants.FirmUpgradeStatus.FAILED, UpgradeParamConstants.ModuleType.parseModule(firmwarePackageEntity.getPackageInfo().getModule()), msg);
            return false;
        }
        String targetUnzipPath = "/tmp/NVMeFwPackage/";
        String unzipCmd = String.format(Locale.ENGLISH, "unzip -qo %s -d %s", targetFilePath, targetUnzipPath);
        try {
            ssh.executeCmd(unzipCmd);
        }
        catch (Exception exception) {
            LOGGER.error("unzip package info fail", (Throwable)exception);
            String msg = RES.getString("bundle.upgrade.main.detail.info.UNZIP.FAILED");
            this.mainDialog.updateExecuteResult(this.upgradeDeviceEntity, msg, uploadFwProgress, false);
            this.writeUpgradeResult(firmwarePackageEntity, UpgradeParamConstants.FirmUpgradeStatus.FAILED, UpgradeParamConstants.ModuleType.parseModule(firmwarePackageEntity.getPackageInfo().getModule()), msg);
            return false;
        }
        return true;
    }

    private List<FirmwarePackageEntity> getNVMeFirmPackageEntity() {
        ConcurrentHashMap<String, FirmwarePackageEntity> firmwarePackageMap = BundleUpgradeContext.getInstance().getFirmwarePackageMap();
        return BundleUpgradeContext.getInstance().getStrategyEntityMap().get(this.upgradeDeviceEntity.getAssociatedStrategyId()).getModuleTargetFirmwareMap().get((Object)UpgradeParamConstants.ModuleType.ES3000).stream().map(info -> firmwarePackageMap.getOrDefault(info, null)).collect(Collectors.toList());
    }

    private void writeUpgradeResult(FirmwarePackageEntity firmwarePackageEntity, UpgradeParamConstants.FirmUpgradeStatus status, UpgradeParamConstants.ModuleType module, String resultMsg) {
        UpgradeDeviceEntity.FirmUpgradeResult firmUpgradeResult = new UpgradeDeviceEntity.FirmUpgradeResult();
        firmUpgradeResult.setStatus(status);
        firmUpgradeResult.setResultMsg(resultMsg);
        firmUpgradeResult.setFromVersion(this.getFwVersionInCurrentDevice(firmwarePackageEntity));
        firmUpgradeResult.setToVersion(firmwarePackageEntity.getPackageInfo().getVersion());
        firmUpgradeResult.setFirmwarePackage(firmwarePackageEntity);
        List rets = this.upgradeDeviceEntity.getUpgradeDetails().getOrDefault((Object)module, new LinkedList());
        rets.add(firmUpgradeResult);
        this.upgradeDeviceEntity.getUpgradeDetails().putIfAbsent(module, rets);
    }

    private Double getLastTotalProgress(UpgradeDeviceEntity upgradeDeviceEntity) {
        ExecuteInfo info = upgradeDeviceEntity.getExecuteInfo();
        Double progress = 0.0;
        if (!info.getResults().isEmpty()) {
            progress = info.getResults().get(info.getResults().size() - 1).getTotalProgress();
        }
        LOGGER.info(String.format(Locale.ENGLISH, "before NVMe and SAS upgrade progress is :%s", progress));
        return progress;
    }

    private String getFirmwarePackageName(FirmwarePackageEntity entity) {
        File file = new File(entity.getLocalPathAbs());
        return file.getName();
    }

    private String getUnzipPath(FirmwarePackageEntity pkg) {
        return "/tmp/NVMeFwPackage/" + this.getFirmwarePackageName(pkg).split("\\.")[0];
    }

    private void setUpgradeFail(FirmwarePackageEntity firmwarePackageEntity, Double process, String msg) {
        this.mainDialog.updateExecuteResult(this.upgradeDeviceEntity, msg, process, false);
        this.writeUpgradeResult(firmwarePackageEntity, UpgradeParamConstants.FirmUpgradeStatus.FAILED, UpgradeParamConstants.ModuleType.parseModule(firmwarePackageEntity.getPackageInfo().getModule()), msg);
    }

    private String getFwVersionInCurrentDevice(FirmwarePackageEntity pkg) {
        List<DeviceEntity.DiskModel> hwDiskModels = new Module.ES3000().filterSupportDisk(this.upgradeDeviceEntity.getDeviceEntity(), pkg);
        if (hwDiskModels.isEmpty()) {
            return "--";
        }
        String split = ";</br>";
        return hwDiskModels.stream().map(DeviceEntity.DiskModel::getEsnAndVersion).collect(Collectors.joining(split));
    }
}

