/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.bundleupgrade.service.impl;

import com.huawei.bundleupgrade.constants.UpgradeParamConstants;
import com.huawei.bundleupgrade.entity.BmcActiveModeEnum;
import com.huawei.bundleupgrade.entity.DeviceEntity;
import com.huawei.bundleupgrade.entity.FirmwarePackageEntity;
import com.huawei.bundleupgrade.entity.FunctionMap;
import com.huawei.bundleupgrade.entity.RetimerTypeEnum;
import com.huawei.bundleupgrade.entity.ScriptResultEntity;
import com.huawei.bundleupgrade.entity.UpgradeDeviceEntity;
import com.huawei.bundleupgrade.entity.UpgradeStrategyEntity;
import com.huawei.bundleupgrade.service.IUpgradeService;
import com.huawei.bundleupgrade.service.connection.RestConnPool;
import com.huawei.bundleupgrade.service.connection.SSHAndSFTPConnectionPool;
import com.huawei.bundleupgrade.service.system.impl.PowerOperationService;
import com.huawei.bundleupgrade.ui.IUpgradeUiObserver;
import com.huawei.bundleupgrade.utils.SHAAndRSASignCheckUtil;
import com.huawei.bundleupgrade.utils.SystemConfigUtil;
import com.huawei.bundleupgrade.utils.UpgradeScenarioUtil;
import com.huawei.ism.tool.framework.platform.exception.SignException;
import com.huawei.ism.tool.framework.platform.util.LanguageManager;
import com.huawei.ism.tool.obase.connection.support.ConnUtils;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.pyengine.engine.JythonExecuter;
import com.huawei.uMate.common.UMateException;
import com.huawei.uMate.common.utils.ResUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutBandUpgradeServiceServiceImpl
implements IUpgradeService {
    private static final Logger LOGGER = LoggerFactory.getLogger(OutBandUpgradeServiceServiceImpl.class);
    private static final ResUtil RES = ResUtil.getInstance((String)"BundleUpgrade");
    private static final Object FRAME_MODULE_BLOCK = new Object();
    private UpgradeDeviceEntity device;
    private IUpgradeUiObserver uiObserver;
    private FirmwarePackageEntity firmwarePackage;

    public OutBandUpgradeServiceServiceImpl(UpgradeDeviceEntity device, FirmwarePackageEntity firmwarePackage, IUpgradeUiObserver uiObserver) {
        this.device = device;
        this.uiObserver = uiObserver;
        this.firmwarePackage = firmwarePackage;
    }

    private ScriptResultEntity convertResult2Entity(List<Object> ret) throws UMateException {
        if (null == ret || ret.size() < 2) {
            LOGGER.error("the script's execution result is not valid!");
            throw new UMateException("script.execution.not.recognized.result");
        }
        try {
            UpgradeParamConstants.ScriptResultStatus resultStatus;
            int state = Integer.parseInt((String)ret.get(0));
            if (state == UpgradeParamConstants.ScriptResultStatus.PASS.ordinal()) {
                resultStatus = UpgradeParamConstants.ScriptResultStatus.PASS;
            } else if (state == UpgradeParamConstants.ScriptResultStatus.WARNING.ordinal()) {
                resultStatus = UpgradeParamConstants.ScriptResultStatus.WARNING;
            } else if (state == UpgradeParamConstants.ScriptResultStatus.FAILED.ordinal()) {
                resultStatus = UpgradeParamConstants.ScriptResultStatus.FAILED;
            } else {
                throw new UMateException(RES.getString("python.return.value.not.valid"));
            }
            String errorMessage = "";
            if (ret.get(1) instanceof String) {
                errorMessage = ret.get(1).toString();
            }
            return new ScriptResultEntity(resultStatus, errorMessage);
        }
        catch (ClassCastException | NumberFormatException numbExp) {
            LOGGER.error("return value of current python script is not valid!");
            throw new UMateException(RES.getString("python.return.value.not.valid"));
        }
    }

    private Map<String, Object> buildScriptEnvs(String profilePath, UpgradeParamConstants.ModuleType moduleType) throws UMateException {
        HashMap<String, Object> ssEnv = new HashMap<String, Object>(10);
        ssEnv.put("logger", LOGGER);
        try {
            ssEnv.put("profile", FileUtils.getFile((String[])new String[]{profilePath}).getCanonicalPath());
        }
        catch (IOException excpt) {
            ssEnv.put("profile", FileUtils.getFile((String[])new String[]{profilePath}).getPath());
        }
        ssEnv.put("device", this.device);
        ssEnv.put("module", moduleType.getModule());
        ssEnv.put("observer", this.uiObserver);
        ssEnv.put("ssh_and_sftp", (Object)SSHAndSFTPConnectionPool.getSSHAndSFTPConnection(this.device.getDeviceEntity()));
        ssEnv.put("lang", LanguageManager.getInstance().getCurrentLanguage().getLanguage());
        ssEnv.put("package_dir", ApplicationContext.getInstance().getPackagesPath() + File.separator);
        ssEnv.put("rest_conn", RestConnPool.getRedFishConnection(this.device.getDeviceEntity()));
        return ssEnv;
    }

    private int getUserDefinedMaxRetryTimes() {
        String userSetVal = SystemConfigUtil.getSysConfig("python.retry.max.times");
        if (!StringUtils.isNULLStr((String)userSetVal)) {
            int retryMax;
            try {
                retryMax = Integer.parseInt(userSetVal);
            }
            catch (NumberFormatException e) {
                LOGGER.error("the value user defined of key python.retry.max.times is not valid, use default one.");
                retryMax = 3;
            }
            return retryMax;
        }
        return 3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void upgradeModule(String profilePath, String localExecTmpDir, String targetScriptFilePath, UpgradeParamConstants.ModuleType module, UpgradeDeviceEntity.FirmUpgradeResult fwUpgradeResult) throws UMateException {
        if (FunctionMap.ModuleFunction.getModule(module.getModule()).isFrameModule(this.device.getDeviceEntity())) {
            LOGGER.info("Current module {} is frame module,upgrade synchronized.", (Object)module.getModule());
            Object object = FRAME_MODULE_BLOCK;
            synchronized (object) {
                if (!this.updateVersionAndCompare(module)) {
                    fwUpgradeResult.setStatus(UpgradeParamConstants.FirmUpgradeStatus.SUCCESS);
                    this.device.setSpecifiedFirmwareUpgradeDetail(module, fwUpgradeResult);
                    return;
                }
                this.upgrade(profilePath, targetScriptFilePath, module, fwUpgradeResult);
            }
        } else {
            LOGGER.info("Start upgrade module {}.", (Object)module.getModule());
            this.upgrade(profilePath, targetScriptFilePath, module, fwUpgradeResult);
        }
    }

    private boolean updateVersionAndCompare(UpgradeParamConstants.ModuleType module) {
        try {
            String currentVer = UpgradeScenarioUtil.getTargetModuleVersion(this.device.getDeviceEntity(), module, this.firmwarePackage);
            String targetVer = this.firmwarePackage.getPackageInfo().getVersion();
            FunctionMap.ModuleFunction.getModule(module.getModule()).updateVersion(this.device.getDeviceEntity());
            String newVer = UpgradeScenarioUtil.getTargetModuleVersion(this.device.getDeviceEntity(), module, this.firmwarePackage);
            LOGGER.info("Current ver {}, new ver {} and target ver {}.", new Object[]{currentVer, newVer, targetVer});
            if (RetimerTypeEnum.isRetimerModule(module)) {
                return UpgradeScenarioUtil.canUpgradeRetimerModule(currentVer, newVer, targetVer, module, this.device);
            }
            if (!(currentVer.equals(newVer) || !newVer.equals(targetVer) && UpgradeScenarioUtil.isFromVersionLowerThanToVersion(newVer, targetVer))) {
                LOGGER.info("Abort upgrade module {} .", (Object)module.getModule());
                return false;
            }
        }
        catch (Exception e) {
            LOGGER.error("Query and compare version error.");
        }
        return true;
    }

    private void upgrade(String profilePath, String targetScriptFilePath, UpgradeParamConstants.ModuleType module, UpgradeDeviceEntity.FirmUpgradeResult fwUpgradeResult) throws UMateException {
        List<File> scriptDir = UpgradeScenarioUtil.getAllDirectoriesInTargetDir(targetScriptFilePath);
        int maxRetryTimes = this.getUserDefinedMaxRetryTimes();
        LOGGER.info(String.format(Locale.ENGLISH, "the script will try %d times till success.", maxRetryTimes));
        for (int tryTimes = 0; tryTimes < maxRetryTimes; ++tryTimes) {
            try {
                SHAAndRSASignCheckUtil.verifyEntireDirScriptsSignature(FileUtils.getFile((String[])new String[]{targetScriptFilePath}).getParentFile());
                JythonExecuter executor = new JythonExecuter(scriptDir);
                executor.compileScript(FileUtils.getFile((String[])new String[]{targetScriptFilePath}));
                List ret = executor.invokeFunction("execute", this.buildScriptEnvs(profilePath, module));
                ScriptResultEntity result = this.convertResult2Entity(ret);
                this.sealingTargetFirmwarePackageResult(result, fwUpgradeResult);
                this.device.setSpecifiedFirmwareUpgradeDetail(module, fwUpgradeResult);
                return;
            }
            catch (FileNotFoundException fnf) {
                LOGGER.error("file {} not found, tools parts broken.", (Object)FileUtils.getFile((String[])new String[]{targetScriptFilePath}).getName());
                throw new UMateException(RES.getString("tool.parts.lost.please.reinstall"));
            }
            catch (ToolException tep) {
                LOGGER.error("ToolException occurred:", (Throwable)tep);
                continue;
            }
            catch (SignException signE) {
                LOGGER.error("sign exception:", (Throwable)signE);
                throw new UMateException(RES.getString("sign.exception.might.altered"));
            }
            catch (UMateException e) {
                LOGGER.error("Business exception:", (Throwable)e);
                throw e;
            }
            catch (Throwable exception) {
                LOGGER.error("exception occurred :", exception);
            }
        }
        LOGGER.error("After retry for set times, the execution still failed, quit.....");
        if (this.device.getUpgradeDetails().get((Object)module) == null) {
            throw new UMateException(RES.getString("script.execution.failed.after.retry.all.times"));
        }
    }

    @Override
    public void doOperationAfterUpgrade(UpgradeStrategyEntity strategy, UpgradeParamConstants.ModuleType module, UpgradeDeviceEntity.FirmUpgradeResult fwUpgradeResult, DeviceEntity device) throws UMateException {
        if (module == UpgradeParamConstants.ModuleType.iBMC && this.isUpgradeSuccess(fwUpgradeResult)) {
            if (device.isSpecificDevice() && BmcActiveModeEnum.IMMEDIATELY.equals((Object)device.getBmcActiveMode())) {
                LOGGER.info("node [{}] bmc Immediately ActiveMode wait 120s for bmc restart", (Object)device.getIp(), (Object)device);
                ConnUtils.sleep((int)120000);
            } else {
                this.restartIBMCModuleAfterUpgrade(fwUpgradeResult);
            }
        } else {
            LOGGER.info("upgrade finished, no - post check about this module upgrade.");
        }
    }

    private void restartIBMCModuleAfterUpgrade(UpgradeDeviceEntity.FirmUpgradeResult fwUpgradeResult) throws UMateException {
        PowerOperationService powerService = new PowerOperationService(this.device);
        try {
            powerService.restartIBMCModuleAfterUpgrade();
        }
        catch (UMateException exception) {
            fwUpgradeResult.setStatus(UpgradeParamConstants.FirmUpgradeStatus.FAILED);
            fwUpgradeResult.setResultMsg(fwUpgradeResult.getResultMsg() + exception.getMessage());
        }
    }

    private boolean isUpgradeSuccess(UpgradeDeviceEntity.FirmUpgradeResult fwUpgradeResult) {
        if (fwUpgradeResult.getStatus() != UpgradeParamConstants.FirmUpgradeStatus.SUCCESS) {
            LOGGER.error("the upgrade is not success, no need to restart iBMC after this upgrade.");
            return false;
        }
        return true;
    }

    @Override
    public void preCheckBeforeUpgrade(UpgradeStrategyEntity strategy, UpgradeParamConstants.ModuleType module, UpgradeDeviceEntity.FirmUpgradeResult fwResult, DeviceEntity deviceEntity) throws UMateException {
        PowerOperationService powerService = new PowerOperationService(this.device);
        powerService.powerOnDeviceUsingAllMethodsIfNowOff();
    }

    private void sealingTargetFirmwarePackageResult(ScriptResultEntity result, UpgradeDeviceEntity.FirmUpgradeResult fwResult) {
        if (result.getExecResult().equals((Object)UpgradeParamConstants.ScriptResultStatus.PASS) || result.getExecResult().equals((Object)UpgradeParamConstants.ScriptResultStatus.WARNING)) {
            fwResult.setStatus(UpgradeParamConstants.FirmUpgradeStatus.SUCCESS);
        } else {
            fwResult.setStatus(UpgradeParamConstants.FirmUpgradeStatus.FAILED);
            fwResult.setResultMsg(result.getErrReason());
        }
    }
}

