/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.bundleupgrade.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.huawei.bundleupgrade.constants.UpgradeParamConstants;
import com.huawei.bundleupgrade.entity.FirmwarePackageEntity;
import com.huawei.bundleupgrade.entity.UpgradeDeviceEntity;
import com.huawei.bundleupgrade.entity.UpgradeStrategyEntity;
import com.huawei.bundleupgrade.model.DfsModule;
import com.huawei.bundleupgrade.model.DriveModule;
import com.huawei.bundleupgrade.model.ExecuteInfo;
import com.huawei.bundleupgrade.model.Module;
import com.huawei.bundleupgrade.service.connection.fusionstrg.FusionStorageSshConnector;
import com.huawei.bundleupgrade.service.connection.fusionstrg.FusionStorageSshPool;
import com.huawei.bundleupgrade.ui.BundleUpgradeMainDialog;
import com.huawei.bundleupgrade.utils.BundleUpgradeContext;
import com.huawei.bundleupgrade.utils.SHAAndRSASignCheckUtil;
import com.huawei.bundleupgrade.utils.ScriptExecuteUtil;
import com.huawei.bundleupgrade.utils.ServiceUtil;
import com.huawei.bundleupgrade.utils.UpgradeConstants;
import com.huawei.bundleupgrade.utils.UpgradeScenarioUtil;
import com.huawei.bundleupgrade.utils.VersionComparisonTools;
import com.huawei.bundleupgrade.utils.fusionstrg.FusionStrgUpgradeContext;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.uMate.common.UMateException;
import com.huawei.uMate.common.thread.CommonRunnable;
import com.huawei.uMate.common.utils.ResUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanGeaInBandUpgradeServiceImpl {
    private static final Logger LOGGER = LoggerFactory.getLogger(PanGeaInBandUpgradeServiceImpl.class);
    private static final int QUERY_RETRY_TIME = 3;
    private static final ResUtil RES = ResUtil.getInstance((String)"BundleUpgrade");
    private static final String EMPTY_INFO = RES.getString("bundle.upgrade.main.detail.info.empty");
    private static final String ERROR_DETAIL = "reason";
    private static final String SUCCESS = "success";
    private Map<String, String> fwPackagePathsOnServer = new HashMap<String, String>();
    private UpgradeDeviceEntity upgradeDeviceEntity;
    private BundleUpgradeMainDialog mainDialog = BundleUpgradeContext.getInstance().getMainDialog();
    private final Map<UpgradeParamConstants.ModuleType, BiFunction<String, String, Boolean>> moduleUpgradeFlag = new ConcurrentHashMap<UpgradeParamConstants.ModuleType, BiFunction<String, String, Boolean>>();
    private final Map<UpgradeParamConstants.ModuleType, BiFunction<String, String, String>> moduleVersion = new ConcurrentHashMap<UpgradeParamConstants.ModuleType, BiFunction<String, String, String>>();
    private final Map<UpgradeParamConstants.ModuleType, Function<String, String>> handleUpgradeResult = new ConcurrentHashMap<UpgradeParamConstants.ModuleType, Function<String, String>>();

    public PanGeaInBandUpgradeServiceImpl(UpgradeDeviceEntity upgradeDeviceEntity) {
        this.moduleUpgradeFlag.put(UpgradeParamConstants.ModuleType.DRIVE, (current, target) -> !DriveModule.combineVersion(current).equals(DriveModule.combineVersion(target)));
        this.moduleUpgradeFlag.put(UpgradeParamConstants.ModuleType.DFS, (current, target) -> !DfsModule.combineVersion(current).equals(DfsModule.combineVersion(target)));
        this.moduleUpgradeFlag.put(UpgradeParamConstants.ModuleType.BASE_KNL, Module.BaseKnl::isCurrentLowerThanTarget);
        this.moduleVersion.put(UpgradeParamConstants.ModuleType.SES, VersionComparisonTools::findUpgradeVersionForSes);
        this.moduleVersion.put(UpgradeParamConstants.ModuleType.GLOUN, VersionComparisonTools::findUpgradeVersionForGloun);
        this.handleUpgradeResult.put(UpgradeParamConstants.ModuleType.DFS, this::handleUpgradeResultDfs);
        this.upgradeDeviceEntity = upgradeDeviceEntity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void upgrade(UpgradeParamConstants.ModuleType module, Double progressStepLen) {
        Double lastTotalProgress = this.getLastTotalProgress();
        FirmwarePackageEntity fireWareEntity = this.getPanGeaInBandFwPackageEntityMap(this.upgradeDeviceEntity).get(module.getModule());
        String curDes = RES.getStringWithParams("upgrade.sub.process.title", new Object[]{module.getModule(), fireWareEntity.getPackageInfo().getSupportModelUID()});
        Double finishedProgress = lastTotalProgress + progressStepLen;
        UpgradeStrategyEntity strategy = BundleUpgradeContext.getInstance().getStrategyEntityMap().get(this.upgradeDeviceEntity.getAssociatedStrategyId());
        try {
            FusionStorageSshConnector ssh;
            this.mainDialog.createExecuteResult(this.upgradeDeviceEntity, curDes);
            try {
                ssh = FusionStorageSshPool.getFsSshConnectionByBmcIp(this.upgradeDeviceEntity.getDeviceEntity().getIp());
                if (ssh == null) {
                    throw new ToolException("Build ssh error.", false);
                }
            }
            catch (Exception e) {
                LOGGER.error("get ssh connector fail", (Throwable)e);
                String msg = RES.getString("bundle.upgrade.match.ssh.error");
                this.mainDialog.updateExecuteResult(this.upgradeDeviceEntity, msg, finishedProgress, false);
                this.writeUpgradeResult(UpgradeParamConstants.FirmUpgradeStatus.FAILED, module, msg);
                FusionStorageSshPool.releaseFsSshConnection(FusionStrgUpgradeContext.getInstance().getFsDeviceEntityByBmcIp(this.upgradeDeviceEntity.getDeviceEntity().getIp()));
                return;
            }
            if (!this.canUpgradedByVer(this.upgradeDeviceEntity, module, ssh)) {
                String resultDes = RES.getString("current.strategy.ignore.this.upgrade");
                this.mainDialog.updateResult(this.upgradeDeviceEntity, resultDes, finishedProgress, UpgradeParamConstants.SubProcessExecutionResult.NOT_INVOLVED, resultDes);
                return;
            }
            if (!this.uploadFWAndUnZipPackage(ssh, module, finishedProgress)) {
                return;
            }
            if (!this.doUpgrade(ssh, module, finishedProgress)) {
                this.collectFailLog(this.upgradeDeviceEntity, strategy, module, ssh);
                this.clearEnv(ssh);
                return;
            }
            if (!this.queryUpgradeStatus(ssh, module, finishedProgress)) {
                this.collectFailLog(this.upgradeDeviceEntity, strategy, module, ssh);
                this.clearEnv(ssh);
                return;
            }
            this.clearEnv(ssh);
            this.writeUpgradeResult(UpgradeParamConstants.FirmUpgradeStatus.SUCCESS, module, "");
        }
        finally {
            FusionStorageSshPool.releaseFsSshConnection(FusionStrgUpgradeContext.getInstance().getFsDeviceEntityByBmcIp(this.upgradeDeviceEntity.getDeviceEntity().getIp()));
        }
    }

    private void collectFailLog(UpgradeDeviceEntity device, UpgradeStrategyEntity strategy, UpgradeParamConstants.ModuleType module, FusionStorageSshConnector ssh) {
        try {
            String deviceIp = device.getDeviceEntity().getIp();
            if (device.getUpgradeDetails().get((Object)module).stream().anyMatch(result -> !result.isSuc())) {
                String serverIp = FusionStrgUpgradeContext.getInstance().getFsDeviceEntityByBmcIp(deviceIp).getManagementIp();
                String date = StringUtils.formatDate((Object)Calendar.getInstance(), (String)"yyyyMMddHHmmss");
                String logFileName = String.format(Locale.ENGLISH, "%s_%s_pangea_internal_upgrade.zip", serverIp, date);
                String localPath = strategy.getFailLogPath() + File.separator + logFileName.replace(":", "_");
                ssh.executeCmd(String.format(Locale.ENGLISH, "zip -r /var/log/pangea_internal_upgrade/%s /var/log/pangea_internal_upgrade", logFileName));
                ssh.getDeviceFile("/var/log/pangea_internal_upgrade", logFileName, localPath);
                LOGGER.info("download server log success to {}", (Object)localPath);
                ssh.executeCmd(String.format(Locale.ENGLISH, "rm -f %s/%s", "/var/log/pangea_internal_upgrade", logFileName));
            }
        }
        catch (Exception ex) {
            LOGGER.error("collectFailLogAndClearEnv fail", (Throwable)ex);
        }
    }

    private void clearEnv(FusionStorageSshConnector ssh) {
        try {
            ssh.executeCmd(UpgradeConstants.CMD_RM_LOG_AND_PACKAGE);
        }
        catch (Exception e) {
            LOGGER.error("clear upgrade dir failed.", (Throwable)e);
        }
    }

    public boolean canUpgradedByVer(UpgradeDeviceEntity upgradeDevice, UpgradeParamConstants.ModuleType module, FusionStorageSshConnector ssh) {
        FirmwarePackageEntity fireWareEntity = this.getPanGeaInBandFwPackageEntityMap(this.upgradeDeviceEntity).get(module.getModule());
        this.initModuleVersion(upgradeDevice, module, ssh, fireWareEntity);
        UpgradeStrategyEntity strategy = BundleUpgradeContext.getInstance().getStrategyEntityMap().get(upgradeDevice.getAssociatedStrategyId());
        if (UpgradeParamConstants.FirmwareUpgradeStrategy.MANDATORY_UPGRADE == strategy.getUpgradeStrategyMap().get(ServiceUtil.getPackageInfoKey(fireWareEntity))) {
            return true;
        }
        String currentVersion = this.upgradeDeviceEntity.getDeviceEntity().getPanGeaInBandModuleVersion().getOrDefault(module.getModule(), "--");
        if (UpgradeScenarioUtil.isYinglong() && "--".equals(currentVersion)) {
            return true;
        }
        if (!UpgradeScenarioUtil.isValidVersion(currentVersion, module.getModule())) {
            LOGGER.warn("Invalid firmware version,the version is empty, '--' or 'NOT_MATCH'");
            return false;
        }
        if (UpgradeScenarioUtil.isValidVersionInPangea(currentVersion, module.getModule())) {
            LOGGER.info("The version is -- components [{}] that can be upgraded.", (Object)module.getModule());
            return true;
        }
        String targetVersion = fireWareEntity.getPackageInfo().getVersion();
        String finalCurrentVersion = currentVersion;
        currentVersion = this.moduleVersion.getOrDefault((Object)module, (current, target) -> finalCurrentVersion).apply(currentVersion, targetVersion);
        if (UpgradeParamConstants.versionDiffUpgradeModules().contains(module.getModule())) {
            return UpgradeScenarioUtil.isCurrentNotEqualTarget(currentVersion, targetVersion);
        }
        return this.moduleUpgradeFlag.getOrDefault((Object)module, (current, target) -> {
            try {
                return UpgradeScenarioUtil.isFromVersionLowerThanToVersion(current, target);
            }
            catch (UMateException e) {
                LOGGER.error("Invalid firmware version", (Throwable)e);
                return false;
            }
        }).apply(currentVersion, targetVersion);
    }

    private void initModuleVersion(UpgradeDeviceEntity upgradeDevice, UpgradeParamConstants.ModuleType module, FusionStorageSshConnector ssh, FirmwarePackageEntity fireWareEntity) {
        if (this.upgradeDeviceEntity.getDeviceEntity().getPanGeaInBandModuleVersion().containsKey(module.getModule())) {
            return;
        }
        try {
            if (UpgradeParamConstants.ModuleType.DRIVE.equals((Object)module)) {
                this.upgradeDeviceEntity.getDeviceEntity().getPanGeaInBandModuleVersion().put(module.getModule(), new DriveModule().queryCurrentVersion(upgradeDevice.getDeviceEntity(), fireWareEntity, ssh));
            } else if (UpgradeParamConstants.ModuleType.DFS.equals((Object)module)) {
                this.upgradeDeviceEntity.getDeviceEntity().getPanGeaInBandModuleVersion().put(module.getModule(), new DfsModule().getOriginVersion(upgradeDevice.getDeviceEntity(), fireWareEntity, ssh));
            } else {
                this.upgradeDeviceEntity.getDeviceEntity().getPanGeaInBandModuleVersion().put(module.getModule(), Module.getPanGeaInBandVersionOnServer(fireWareEntity, ssh));
            }
        }
        catch (Exception e) {
            LOGGER.error("Init module version error,module name {} ", (Object)module.getModule());
        }
    }

    private boolean uploadFWAndUnZipPackage(FusionStorageSshConnector sshAndSftp, UpgradeParamConstants.ModuleType module, Double errProgress) {
        String targetFileName;
        LOGGER.info(String.format(Locale.ENGLISH, "begin upload %s module", module.getModule()));
        String targetServerFwPath = UpgradeConstants.PAN_GEA_PACKAGE_UPLOAD_PATH;
        sshAndSftp.mkdirs(targetServerFwPath);
        String moduleStr = module.getModule();
        Map<String, FirmwarePackageEntity> panGeaInBandFwPackageInfoMap = this.getPanGeaInBandFwPackageEntityMap(this.upgradeDeviceEntity);
        FirmwarePackageEntity fwPackageEntity = panGeaInBandFwPackageInfoMap.get(moduleStr);
        try {
            String localPathAbs = fwPackageEntity.getLocalPathAbs();
            List<String> failedPkgPath = SHAAndRSASignCheckUtil.getSignatureFailedFileInfos(localPathAbs);
            if (!failedPkgPath.isEmpty()) {
                LOGGER.error("Failed to verify component {}. Upgrade terminated.", (Object)module.getModule());
                this.mainDialog.updateExecuteResult(this.upgradeDeviceEntity, failedPkgPath.get(0), errProgress, false);
                this.writeUpgradeResult(UpgradeParamConstants.FirmUpgradeStatus.FAILED, module, failedPkgPath.get(0));
                return false;
            }
            targetFileName = this.getFwPathInNode(fwPackageEntity);
            sshAndSftp.uploadFile(targetFileName, localPathAbs, true);
        }
        catch (Exception e) {
            LOGGER.error("upload package info fail", (Throwable)e);
            String msg = RES.getString("bundle.upgrade.main.detail.info.UPLOAD.FAILED");
            this.mainDialog.updateExecuteResult(this.upgradeDeviceEntity, msg, errProgress, false);
            this.writeUpgradeResult(UpgradeParamConstants.FirmUpgradeStatus.FAILED, module, msg);
            return false;
        }
        try {
            if (ScriptExecuteUtil.needUnzipTwice(fwPackageEntity)) {
                String unzipPath = ScriptExecuteUtil.unzipTwice(sshAndSftp, targetFileName, this.getUnzipPath(fwPackageEntity));
                this.fwPackagePathsOnServer.computeIfAbsent(fwPackageEntity.getPackageInfo().getModule(), path -> unzipPath);
            } else {
                String unzipCmd = String.format(Locale.ENGLISH, "unzip -qo %s -d %s", targetFileName, this.getUploadFwUnzipPath(fwPackageEntity));
                sshAndSftp.executeCmd(unzipCmd);
            }
        }
        catch (Exception e) {
            LOGGER.error(String.format(Locale.ENGLISH, "upload pangea in band package fail %s", e));
            String msg = RES.getString("bundle.upgrade.main.detail.info.UNZIP.FAILED");
            this.mainDialog.updateExecuteResult(this.upgradeDeviceEntity, msg, errProgress, false);
            this.writeUpgradeResult(UpgradeParamConstants.FirmUpgradeStatus.FAILED, module, msg);
            return false;
        }
        return true;
    }

    private String getUploadFwUnzipPath(FirmwarePackageEntity pkg) {
        return this.fwPackagePathsOnServer.computeIfAbsent(pkg.getPackageInfo().getModule(), path -> this.getUnzipPath(pkg));
    }

    private String getUnzipPath(FirmwarePackageEntity pkg) {
        return UpgradeConstants.PAN_GEA_PACKAGE_UPLOAD_PATH + "/" + this.getFwFileName(pkg).split("\\.")[0];
    }

    private String getFwPathInNode(FirmwarePackageEntity entity) {
        return UpgradeConstants.PAN_GEA_PACKAGE_UPLOAD_PATH + "/" + this.getFwFileName(entity);
    }

    private String getFwFileName(FirmwarePackageEntity entity) {
        File file = new File(entity.getLocalPathAbs());
        return file.getName();
    }

    boolean doUpgrade(FusionStorageSshConnector sshAndSftp, UpgradeParamConstants.ModuleType module, Double errProgress) {
        Map<String, FirmwarePackageEntity> panGeaInBandFwPackageInfoMap = this.getPanGeaInBandFwPackageEntityMap(this.upgradeDeviceEntity);
        try {
            String path = this.fwPackagePathsOnServer.get(module.getModule());
            LOGGER.info("Start to upgrade components:{}", (Object)module.getModule());
            FirmwarePackageEntity fireWare = panGeaInBandFwPackageInfoMap.get(module.getModule());
            sshAndSftp.executeCmd(String.format(Locale.ENGLISH, "cd %s", path));
            String doUpgradeCmd = fireWare.getInterfaceInfo().getUpgradeCmd();
            String cmdResponse = sshAndSftp.executeCmd(doUpgradeCmd);
            String msg = this.handleUpgradeResult.getOrDefault((Object)module, this::handleUpgradeResultDefault).apply(cmdResponse);
            if (!StringUtils.isNULLStr((String)msg)) {
                this.writeUpgradeResult(UpgradeParamConstants.FirmUpgradeStatus.FAILED, module, msg);
                this.mainDialog.updateExecuteResult(this.upgradeDeviceEntity, msg, errProgress, false);
                LOGGER.error("execute upgrade cmd={} fail, response is {}", (Object)doUpgradeCmd, (Object)cmdResponse);
                return false;
            }
        }
        catch (Exception e) {
            LOGGER.error("do upgrade fail.", (Throwable)e);
            String msg = RES.getString("bundle.upgrade.main.detail.info.DO_UPGRADE.FAILED");
            this.writeUpgradeResult(UpgradeParamConstants.FirmUpgradeStatus.FAILED, module, msg);
            this.mainDialog.updateExecuteResult(this.upgradeDeviceEntity, msg, errProgress, false);
            return false;
        }
        return true;
    }

    private String handleUpgradeResultDefault(String cmdResponse) {
        if (cmdResponse.contains(SUCCESS)) {
            return "";
        }
        String msg = RES.getString("bundle.upgrade.main.detail.info.DO_UPGRADE.FAILED");
        if (cmdResponse.contains(ERROR_DETAIL)) {
            msg = msg + "\n" + cmdResponse;
        }
        return msg;
    }

    private String handleUpgradeResultDfs(String cmdResponse) {
        DfsModule dfsModule = new DfsModule();
        Optional<JSONObject> jsonObject = dfsModule.verifyAndToJson(cmdResponse);
        if (!jsonObject.isPresent()) {
            return RES.getString("bundle.upgrade.main.detail.info.DO_UPGRADE.FAILED");
        }
        if (!SUCCESS.equals(jsonObject.get().get((Object)"status").toString())) {
            return "\n" + jsonObject.get().get((Object)"desc").toString();
        }
        return "";
    }

    private boolean queryUpgradeStatus(FusionStorageSshConnector sshAndSftp, UpgradeParamConstants.ModuleType module, Double process) {
        Map<String, FirmwarePackageEntity> panGeaInBandFwPackageInfoMap = this.getPanGeaInBandFwPackageEntityMap(this.upgradeDeviceEntity);
        try {
            String path = this.fwPackagePathsOnServer.get(module.getModule());
            LOGGER.info("Start to query the component: {} upgrade progress.", (Object)module.getModule());
            FirmwarePackageEntity fireWare = panGeaInBandFwPackageInfoMap.get(module.getModule());
            String queryUpgradeStatusCmd = fireWare.getInterfaceInfo().getGetUpgradeStatusCmd();
            return this.pollingUpgradeStatus(sshAndSftp, module, process, fireWare, queryUpgradeStatusCmd);
        }
        catch (Exception e) {
            LOGGER.error(String.format(Locale.ENGLISH, "upload pangea in band package fail %s", e));
            this.setUpgradeFail(module, process, RES.getString("upgrade.errror.not.common"));
            return false;
        }
    }

    private boolean pollingUpgradeStatus(FusionStorageSshConnector sshAndSftp, UpgradeParamConstants.ModuleType module, Double process, FirmwarePackageEntity fireWare, String queryUpgradeStatusCmd) throws Exception {
        String failedMsg = RES.getString("upgrade.errror.not.common");
        int maxUpgradeTime = fireWare.getPackageInfo().getMaxUpgradeTime();
        long start = System.currentTimeMillis();
        long latest = System.currentTimeMillis();
        int errCount = 0;
        while (latest - start < (long)(maxUpgradeTime * 1000)) {
            LOGGER.info("Polling the upgrade status, module={},cmd={}", (Object)queryUpgradeStatusCmd, (Object)module.getModule());
            String queryStatusResponse = sshAndSftp.executeCmd(queryUpgradeStatusCmd);
            queryStatusResponse = this.adapterM2Response(module, queryStatusResponse);
            LOGGER.info("Polling result,module={}, cmd={}, response is {}", new Object[]{module.getModule(), queryUpgradeStatusCmd, queryStatusResponse});
            if (queryStatusResponse.contains("failure")) {
                if (queryStatusResponse.contains(ERROR_DETAIL) || queryStatusResponse.contains("desc")) {
                    failedMsg = failedMsg + "\n" + queryStatusResponse;
                }
                this.setUpgradeFail(module, process, failedMsg);
                return false;
            }
            if (!queryStatusResponse.contains("upgrading") && !queryStatusResponse.contains("executing")) {
                if (queryStatusResponse.contains(SUCCESS)) {
                    LOGGER.info(String.format(Locale.ENGLISH, "upgrade %s success", module.getModule()));
                    this.mainDialog.updateExecuteResult(this.upgradeDeviceEntity, EMPTY_INFO, process, true);
                    return true;
                }
                if (errCount <= 3) {
                    ++errCount;
                    continue;
                }
                LOGGER.error(String.format(Locale.ENGLISH, "query upgrade status response error. response is %s", queryStatusResponse));
                this.setUpgradeFail(module, process, failedMsg);
                return false;
            }
            errCount = 0;
            List<String> resultList = Arrays.asList(queryStatusResponse.split("\n"));
            String cmdResult = resultList.subList(1, resultList.size() - 1).get(0);
            int upgradePercent = Integer.parseInt(cmdResult.split(" ")[1].trim().replaceAll("progress|%", ""));
            LOGGER.info(String.format(Locale.ENGLISH, "current upgrading process is %s", upgradePercent));
            CommonRunnable.sleep((int)5000);
            latest = System.currentTimeMillis();
        }
        failedMsg = RES.getString("bundle.upgrade.main.detail.info.QUERY_STATUS.TIMEOUT");
        this.setUpgradeFail(module, process, failedMsg);
        return false;
    }

    private String adapterM2Response(UpgradeParamConstants.ModuleType module, String response) {
        if (!UpgradeParamConstants.ModuleType.DFS.getModule().equals(module.getModule())) {
            return response;
        }
        Optional<JSONObject> progressOfM2 = new DfsModule().verifyAndToJson(response);
        if (!progressOfM2.isPresent()) {
            return response;
        }
        String status = progressOfM2.get().getOrDefault((Object)"status", (Object)"").toString();
        String desc = progressOfM2.get().getOrDefault((Object)"desc", (Object)"").toString();
        String progress = progressOfM2.get().getOrDefault((Object)"progress", (Object)"").toString();
        return String.join((CharSequence)" ", status, desc, progress);
    }

    private void setUpgradeFail(UpgradeParamConstants.ModuleType module, Double process, String msg) {
        this.mainDialog.updateExecuteResult(this.upgradeDeviceEntity, msg, process, false);
        this.writeUpgradeResult(UpgradeParamConstants.FirmUpgradeStatus.FAILED, module, msg);
    }

    public Map<String, FirmwarePackageEntity> getPanGeaInBandFwPackageEntityMap(UpgradeDeviceEntity upgradeDevice) {
        UpgradeStrategyEntity strategy = BundleUpgradeContext.getInstance().getStrategyEntityMap().get(upgradeDevice.getAssociatedStrategyId());
        Map<UpgradeParamConstants.ModuleType, List<String>> moduleTargetFirmwareMap = strategy.getModuleTargetFirmwareMap();
        ConcurrentHashMap<String, FirmwarePackageEntity> firmwarePackageMap = BundleUpgradeContext.getInstance().getFirmwarePackageMap();
        Iterator<Map.Entry<UpgradeParamConstants.ModuleType, List<String>>> it = moduleTargetFirmwareMap.entrySet().iterator();
        ArrayList firmwareFileInfoList = new ArrayList();
        while (it.hasNext()) {
            Map.Entry<UpgradeParamConstants.ModuleType, List<String>> entry = it.next();
            if (!UpgradeParamConstants.ModuleType.getPanGeaInBandModules().contains((Object)entry.getKey())) continue;
            LOGGER.info(String.format(Locale.ENGLISH, "Device %s inband firmware fileInfo is %s", upgradeDevice.getDeviceEntity().getIp(), entry.getValue()));
            firmwareFileInfoList.addAll(entry.getValue());
        }
        HashMap<String, FirmwarePackageEntity> fwTypeEntityMap = new HashMap<String, FirmwarePackageEntity>();
        if (!firmwareFileInfoList.isEmpty()) {
            for (String firmwareInfo : firmwareFileInfoList) {
                FirmwarePackageEntity packageEntity = (FirmwarePackageEntity)firmwarePackageMap.get(firmwareInfo);
                fwTypeEntityMap.put(packageEntity.getPackageInfo().getModule(), packageEntity);
            }
        } else {
            LOGGER.error(String.format(Locale.ENGLISH, "Device %s inband firmwareFileInfoList is empty", upgradeDevice.getDeviceEntity().getIp()));
        }
        return fwTypeEntityMap;
    }

    public void writeUpgradeResult(UpgradeParamConstants.FirmUpgradeStatus status, UpgradeParamConstants.ModuleType module, String resultMsg) {
        FirmwarePackageEntity fireWareEntity = this.getPanGeaInBandFwPackageEntityMap(this.upgradeDeviceEntity).get(module.getModule());
        UpgradeDeviceEntity.FirmUpgradeResult firmUpgradeResult = new UpgradeDeviceEntity.FirmUpgradeResult();
        firmUpgradeResult.setFirmwareUid(fireWareEntity.getPackageInfo().getSupportModelUID());
        firmUpgradeResult.setFromVersion(this.upgradeDeviceEntity.getDeviceEntity().getPanGeaInBandModuleVersion().getOrDefault(module.getModule(), "--"));
        firmUpgradeResult.setToVersion(fireWareEntity.getPackageInfo().getVersion());
        firmUpgradeResult.setStatus(status);
        firmUpgradeResult.setResultMsg(resultMsg);
        firmUpgradeResult.setFirmwarePackage(fireWareEntity);
        LinkedList<UpgradeDeviceEntity.FirmUpgradeResult> newFirmUpgradeResultList = new LinkedList<UpgradeDeviceEntity.FirmUpgradeResult>();
        newFirmUpgradeResultList.add(firmUpgradeResult);
        this.upgradeDeviceEntity.getUpgradeDetails().put(module, newFirmUpgradeResultList);
    }

    public Double getLastTotalProgress() {
        ExecuteInfo info = this.upgradeDeviceEntity.getExecuteInfo();
        Double lastTotalProgress = 0.0;
        if (!info.getResults().isEmpty()) {
            lastTotalProgress = info.getResults().get(info.getResults().size() - 1).getTotalProgress();
        }
        LOGGER.info(String.format(Locale.ENGLISH, "before PCIE upgrade progress is :%s", lastTotalProgress));
        return lastTotalProgress;
    }
}

