/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.bundleupgrade.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.huawei.bundleupgrade.constants.UpgradeParamConstants;
import com.huawei.bundleupgrade.entity.FirmwarePackageEntity;
import com.huawei.bundleupgrade.entity.FunctionMap;
import com.huawei.bundleupgrade.entity.OperationResultEntity;
import com.huawei.bundleupgrade.entity.PcieCardEntity;
import com.huawei.bundleupgrade.entity.UpgradeDeviceEntity;
import com.huawei.bundleupgrade.entity.UpgradeStrategyEntity;
import com.huawei.bundleupgrade.model.ExecuteInfo;
import com.huawei.bundleupgrade.model.ExecuteResult;
import com.huawei.bundleupgrade.service.DeviceInfoByRedfishService;
import com.huawei.bundleupgrade.utils.BundleUpgradeContext;
import com.huawei.bundleupgrade.utils.WatchDogSettingUtil;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.uMate.common.UMateException;
import com.huawei.uMate.common.file.FileOperation;
import com.huawei.uMate.common.ftp.SFTPServer;
import com.huawei.uMate.common.utils.RedfishUtils;
import com.huawei.uMate.common.utils.ResUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PcieUpgradeServiceImpl {
    private static final Logger log = LoggerFactory.getLogger(PcieUpgradeServiceImpl.class);
    private static final ResUtil RES = ResUtil.getInstance((String)"BundleUpgrade");
    private UpgradeDeviceEntity upgradeDeviceEntity;

    public PcieUpgradeServiceImpl(UpgradeDeviceEntity upgradeDeviceEntity) {
        this.upgradeDeviceEntity = upgradeDeviceEntity;
    }

    private boolean startSpSetWatchDogStatus(UpgradeDeviceEntity upgradeDevice, DeviceInfoByRedfishService service, Double rebootSpProgress) {
        if (!service.startSp().booleanValue()) {
            BundleUpgradeContext.getInstance().getMainDialog().updateExecuteResult(upgradeDevice, RES.getString("bundle.upgrade.task.pcie.sp.error"), rebootSpProgress, false);
            this.writePcieUpgradeResult(upgradeDevice, "", false, RES.getString("bundle.upgrade.task.pcie.sp.error"));
            return true;
        }
        OperationResultEntity spbootWatchDogResult = WatchDogSettingUtil.setSpbootWatchDog(upgradeDevice, service);
        if (!spbootWatchDogResult.isPassed()) {
            BundleUpgradeContext.getInstance().getMainDialog().updateExecuteResult(upgradeDevice, RES.getString("bundle.upgrade.task.pcie.setwatchdog.error"), rebootSpProgress, false);
            return true;
        }
        return false;
    }

    private boolean refreshDetailPcieUpgradeEnd(UpgradeDeviceEntity upgradeDevice, DeviceInfoByRedfishService service, Double pcieUpgradeProgress) {
        BundleUpgradeContext.getInstance().getMainDialog().createExecuteResult(upgradeDevice, RES.getString("bundle.upgrade.main.detail.info.PCIEUPGRADE"));
        OperationResultEntity pcieUpgradeResult = service.getPCIECardsResult(upgradeDevice);
        if (!pcieUpgradeResult.isPassed()) {
            BundleUpgradeContext.getInstance().getMainDialog().updateExecuteResult(upgradeDevice, RES.getString("bundle.upgrade.task.pcie.result.error"), pcieUpgradeProgress, false);
            this.writePcieUpgradeResult(upgradeDevice, "", false, RES.getString("bundle.upgrade.task.pcie.result.error"));
            return true;
        }
        this.writePcieUpgradeResult(upgradeDevice, pcieUpgradeResult.getReturnParam(), true, "");
        this.refreshPcieUpgradeDetail(pcieUpgradeResult.getReturnParam(), upgradeDevice, pcieUpgradeProgress);
        HashMap<String, String> orgBiosConfigItemMap = WatchDogSettingUtil.getBiosConfigItem(upgradeDevice.getDeviceEntity().getWatchDogModel());
        OperationResultEntity reSpbootWatchDogResult = WatchDogSettingUtil.resumSpbootWatchDog(upgradeDevice, service, WatchDogSettingUtil.getOrgBiosCfgItem(orgBiosConfigItemMap));
        if (!reSpbootWatchDogResult.isPassed()) {
            BundleUpgradeContext.getInstance().getMainDialog().updateExecuteResult(upgradeDevice, RES.getString("bundle.upgrade.task.pcie.resumwatchdog.error"), pcieUpgradeProgress, false);
            return true;
        }
        return false;
    }

    private OperationResultEntity downloadFrimwarePackages(UpgradeDeviceEntity upgradeDevice, DeviceInfoByRedfishService service, ArrayList<String> iplist, Map<String, String> pcieFirmwarePackageInfoMap) throws InterruptedException {
        ArrayList<String> fileNameList = new ArrayList<String>();
        for (Map.Entry<String, String> entry : pcieFirmwarePackageInfoMap.entrySet()) {
            log.info(String.format(Locale.ENGLISH, "firmware package fileName is %s", entry.getKey()));
            fileNameList.add(entry.getKey());
        }
        return service.downloadFwFileListBySftp(iplist, fileNameList);
    }

    public Map<String, String> getPcieFirmwarePackageInfo(UpgradeDeviceEntity upgradeDevice) {
        UpgradeStrategyEntity strategy = BundleUpgradeContext.getInstance().getStrategyEntityMap().get(upgradeDevice.getAssociatedStrategyId());
        Map<UpgradeParamConstants.ModuleType, List<String>> moduleTargetFirmwareMap = strategy.getModuleTargetFirmwareMap();
        ConcurrentHashMap<String, FirmwarePackageEntity> firmwarePackageMap = BundleUpgradeContext.getInstance().getFirmwarePackageMap();
        Iterator<Map.Entry<UpgradeParamConstants.ModuleType, List<String>>> it = moduleTargetFirmwareMap.entrySet().iterator();
        ArrayList firmwareFileInfoList = new ArrayList();
        while (it.hasNext()) {
            Map.Entry<UpgradeParamConstants.ModuleType, List<String>> entry = it.next();
            if (UpgradeParamConstants.ModuleType.getOutBandModules().contains((Object)entry.getKey())) continue;
            log.info(String.format(Locale.ENGLISH, "Device %s PCIE firmware fileInfo is %s", upgradeDevice.getDeviceEntity().getIp(), entry.getValue()));
            firmwareFileInfoList.addAll(entry.getValue());
        }
        HashMap<String, String> firmwareNamePathMap = new HashMap<String, String>();
        if (firmwareFileInfoList.size() != 0) {
            for (String firmwareInfo : firmwareFileInfoList) {
                FirmwarePackageEntity packageEntity = (FirmwarePackageEntity)firmwarePackageMap.get(firmwareInfo);
                String localPathAbs = packageEntity.getLocalPathAbs();
                if (localPathAbs.contains("/")) {
                    firmwareNamePathMap.put(localPathAbs.substring(localPathAbs.lastIndexOf("/") + 1), packageEntity.getLocalPathAbs());
                    continue;
                }
                if (localPathAbs.contains("\\")) {
                    firmwareNamePathMap.put(localPathAbs.substring(localPathAbs.lastIndexOf("\\") + 1), packageEntity.getLocalPathAbs());
                    continue;
                }
                log.error(String.format(Locale.ENGLISH, "Device %s PCIE firmwarePackage localPathAbs %s is wrong", upgradeDevice.getDeviceEntity().getIp(), localPathAbs));
            }
        } else {
            log.error(String.format(Locale.ENGLISH, "Device %s PCIE firmwareFileInfoList is empty", upgradeDevice.getDeviceEntity().getIp()));
        }
        return firmwareNamePathMap;
    }

    public Map<String, FirmwarePackageEntity> getPcieFirmwareUID(UpgradeDeviceEntity upgradeDevice) {
        UpgradeStrategyEntity strategy = BundleUpgradeContext.getInstance().getStrategyEntityMap().get(upgradeDevice.getAssociatedStrategyId());
        Map<UpgradeParamConstants.ModuleType, List<String>> moduleTargetFirmwareMap = strategy.getModuleTargetFirmwareMap();
        ConcurrentHashMap<String, FirmwarePackageEntity> firmwarePackageMap = BundleUpgradeContext.getInstance().getFirmwarePackageMap();
        Iterator<Map.Entry<UpgradeParamConstants.ModuleType, List<String>>> it = moduleTargetFirmwareMap.entrySet().iterator();
        ArrayList firmwareFileInfoList = new ArrayList();
        while (it.hasNext()) {
            Map.Entry<UpgradeParamConstants.ModuleType, List<String>> entry = it.next();
            if (UpgradeParamConstants.ModuleType.getOutBandModules().contains((Object)entry.getKey())) continue;
            log.info(String.format(Locale.ENGLISH, "Device %s PCIE firmware fileInfo is %s", upgradeDevice.getDeviceEntity().getIp(), entry.getValue()));
            firmwareFileInfoList.addAll(entry.getValue());
        }
        HashMap<String, FirmwarePackageEntity> supportModelUIDMap = new HashMap<String, FirmwarePackageEntity>();
        if (firmwareFileInfoList.size() != 0) {
            for (String firmwareInfo : firmwareFileInfoList) {
                FirmwarePackageEntity packageEntity = (FirmwarePackageEntity)firmwarePackageMap.get(firmwareInfo);
                String supportModelUID = packageEntity.getPackageInfo().getSupportModelUID();
                String supportModel = packageEntity.getPackageInfo().getSupportModel();
                if (StringUtils.isNULLStr((String)supportModelUID) && !StringUtils.isNULLStr((String)supportModel)) {
                    supportModelUIDMap.put(supportModel, packageEntity);
                    continue;
                }
                supportModelUIDMap.put(supportModelUID, packageEntity);
            }
        } else {
            log.error(String.format(Locale.ENGLISH, "Device %s PCIE firmwareFileInfoList is empty", upgradeDevice.getDeviceEntity().getIp()));
        }
        return supportModelUIDMap;
    }

    public synchronized OperationResultEntity copyPcieFirmwarefile(Map<String, String> firmwareNamePathMap) {
        FileOperation op = new FileOperation();
        for (Map.Entry<String, String> entry : firmwareNamePathMap.entrySet()) {
            String filePath = String.format(Locale.ENGLISH, "%s/%s", "template/BundleUpgrade/FirmwarePackages/", entry.getKey());
            String ascFilePath = String.format(Locale.ENGLISH, "%s/%s.asc", "template/BundleUpgrade/FirmwarePackages/", entry.getKey());
            log.info(String.format(Locale.ENGLISH, "Copy file %s from %s to %s", entry.getKey(), entry.getValue(), filePath));
            try {
                FileOperation.copyFile((String)entry.getValue(), (String)filePath);
                FileOperation.copyFile((String)String.format(Locale.ENGLISH, "%s.asc", entry.getValue()), (String)ascFilePath);
            }
            catch (UMateException e) {
                log.error(String.format(Locale.ENGLISH, "Copy PCIE Firmware packages %s failed!", filePath));
                new OperationResultEntity(false, String.format(Locale.ENGLISH, RES.getStringWithParams("bundle.upgrade.task.pcie.copy.error", new Object[]{filePath}), new Object[0]));
            }
            catch (IOException e) {
                log.error(String.format(Locale.ENGLISH, "Copy PCIE Firmware packages %s failed!!!", filePath));
                new OperationResultEntity(false, String.format(Locale.ENGLISH, RES.getStringWithParams("bundle.upgrade.task.pcie.copy.error", new Object[]{filePath}), new Object[0]));
            }
        }
        return new OperationResultEntity(true, "");
    }

    public void writePcieUpgradeResult(UpgradeDeviceEntity upgradeDevice, String pcieUpgradeResultStr, Boolean endFlag, String resultMsg) {
        Map<String, FirmwarePackageEntity> pcieFirmwarePackageUIDMap = this.getPcieFirmwareUID(upgradeDevice);
        Map<String, List<PcieCardEntity>> pcieCardsMap = upgradeDevice.getDeviceEntity().getPcieCardsInfos();
        for (Map.Entry<String, FirmwarePackageEntity> supportEntry : pcieFirmwarePackageUIDMap.entrySet()) {
            String quaternary = supportEntry.getKey();
            String[] fwUIDs = new String[]{};
            if (!StringUtils.isNULLStr((String)quaternary)) {
                fwUIDs = quaternary.split(";");
            }
            String fromVersion = this.getFromVersion(pcieCardsMap, fwUIDs);
            String firmware = "";
            String status = "";
            String description = resultMsg;
            String newVersion = "";
            String module = supportEntry.getValue().getPackageInfo().getModule();
            if (endFlag.booleanValue()) {
                JSONArray detailArray = (JSONArray)RedfishUtils.getObjectAttr((String)pcieUpgradeResultStr, JSONArray.class, (String[])new String[]{"Detail"});
                for (int i = 0; i < detailArray.size(); ++i) {
                    JSONObject pcieUpgradeJson = detailArray.getJSONObject(i);
                    firmware = pcieUpgradeJson.getString("Firmware");
                    if (StringUtils.isNULLStr((String)firmware) || !supportEntry.getValue().getLocalPathAbs().contains(firmware)) continue;
                    status = pcieUpgradeJson.getString("Status");
                    description = pcieUpgradeJson.getString("Description");
                    newVersion = pcieUpgradeJson.getString("NewVersion");
                    module = supportEntry.getValue().getPackageInfo().getModule();
                }
            }
            UpgradeDeviceEntity.FirmUpgradeResult firmUpgradeResult = this.creatFirmUpgradeResult(quaternary, fromVersion, status, description, newVersion, supportEntry.getValue());
            String finalModule = module;
            if (Stream.of(UpgradeParamConstants.ModuleType.SSD_SP.getModule(), UpgradeParamConstants.ModuleType.HDD.getModule()).anyMatch(diskModule -> diskModule.equalsIgnoreCase(finalModule))) {
                FunctionMap.ModuleFunction.getModule(finalModule).setFromVersion(upgradeDevice, firmUpgradeResult);
            }
            this.addUpgradeDetails(upgradeDevice, module, firmUpgradeResult);
        }
    }

    private void addUpgradeDetails(UpgradeDeviceEntity upgradeDevice, String moduleStr, UpgradeDeviceEntity.FirmUpgradeResult firmUpgradeResult) {
        UpgradeParamConstants.ModuleType module = UpgradeParamConstants.ModuleType.parseModule(moduleStr);
        log.info(String.format(Locale.ENGLISH, "transfer str %s to the pcie module %s", moduleStr, module.getModule()));
        Map<UpgradeParamConstants.ModuleType, List<UpgradeDeviceEntity.FirmUpgradeResult>> upgradeDetails = upgradeDevice.getUpgradeDetails();
        List<UpgradeDeviceEntity.FirmUpgradeResult> firmUpgradeResultList = upgradeDetails.get((Object)module);
        if (firmUpgradeResultList != null) {
            firmUpgradeResultList.add(firmUpgradeResult);
        } else {
            LinkedList<UpgradeDeviceEntity.FirmUpgradeResult> newfirmUpgradeResultList = new LinkedList<UpgradeDeviceEntity.FirmUpgradeResult>();
            newfirmUpgradeResultList.add(firmUpgradeResult);
            upgradeDetails.put(module, newfirmUpgradeResultList);
        }
    }

    private UpgradeDeviceEntity.FirmUpgradeResult creatFirmUpgradeResult(String quaternary, String fromVersion, String status, String description, String newVersion, FirmwarePackageEntity firmwarePackageEntity) {
        UpgradeDeviceEntity.FirmUpgradeResult firmUpgradeResult = new UpgradeDeviceEntity.FirmUpgradeResult();
        if (status.equalsIgnoreCase("upgraded")) {
            firmUpgradeResult.setStatus(UpgradeParamConstants.FirmUpgradeStatus.SUCCESS);
        } else {
            firmUpgradeResult.setStatus(UpgradeParamConstants.FirmUpgradeStatus.FAILED);
        }
        firmUpgradeResult.setResultMsg(description);
        firmUpgradeResult.setFromVersion(fromVersion);
        firmUpgradeResult.setToVersion(newVersion);
        firmUpgradeResult.setFirmwareUid(quaternary);
        firmUpgradeResult.setFirmwarePackage(firmwarePackageEntity);
        return firmUpgradeResult;
    }

    private String getFromVersion(Map<String, List<PcieCardEntity>> pcieCardsMap, String[] fwUIDs) {
        String fromVersion = "";
        for (Map.Entry<String, List<PcieCardEntity>> entry : pcieCardsMap.entrySet()) {
            String key = entry.getKey();
            String[] deviceModuleUIDs = key.substring(1, key.length() - 1).split(",");
            if (!this.getPCIeModuleMatchedResult(fwUIDs, deviceModuleUIDs)) continue;
            fromVersion = String.join((CharSequence)";", (CharSequence[])entry.getValue().stream().map(PcieCardEntity::getFirmwareVersion).toArray(String[]::new));
            break;
        }
        return fromVersion;
    }

    private boolean getPCIeModuleMatchedResult(String[] fwUIDs, String[] deviceModuleUIDs) {
        for (String fwUID : fwUIDs) {
            for (String deviceUID : deviceModuleUIDs) {
                if (!fwUID.equalsIgnoreCase(deviceUID)) continue;
                return true;
            }
        }
        return false;
    }

    public void refreshPcieUpgradeDetail(String pcieUpgradeResultStr, UpgradeDeviceEntity upgradeDevice, Double pcieUpgradeProgress) {
        JSONArray detailArray = (JSONArray)RedfishUtils.getObjectAttr((String)pcieUpgradeResultStr, JSONArray.class, (String[])new String[]{"Detail"});
        StringBuffer detail = new StringBuffer();
        ArrayList<String> statusList = new ArrayList<String>();
        for (int i = 0; i < detailArray.size(); ++i) {
            JSONObject pcieUpgradeJson = detailArray.getJSONObject(i);
            String status = pcieUpgradeJson.getString("Status");
            String deviceType = pcieUpgradeJson.getString("DeviceType");
            String description = pcieUpgradeJson.getString("Description");
            String newVersion = pcieUpgradeJson.getString("NewVersion");
            String device = pcieUpgradeJson.getString("Device");
            String detailStr = String.format(Locale.ENGLISH, "", new Object[0]);
            if (StringUtils.isNULLStr((String)deviceType)) {
                deviceType = "PCIE";
            }
            if (!StringUtils.isNULLStr((String)status)) {
                statusList.add(status);
            }
            if (status.equals("failed")) {
                detail = detail.append(String.format(Locale.ENGLISH, RES.getStringWithParams("bundle.upgrade.task.pcie.result.fail", new Object[]{i + 1, deviceType, device}), new Object[0]));
                detail = detail.append(String.format(Locale.ENGLISH, RES.getStringWithParams("bundle.upgrade.task.pcie.result.failinfo", new Object[]{"  ", description}), new Object[0]));
                continue;
            }
            detail = detail.append(String.format(Locale.ENGLISH, RES.getStringWithParams("bundle.upgrade.task.pcie.result.success", new Object[]{i + 1, deviceType, device}), new Object[0]));
        }
        if (statusList.contains("failed") && !statusList.contains("upgraded")) {
            BundleUpgradeContext.getInstance().getMainDialog().updateExecuteResult(upgradeDevice, detail.toString(), pcieUpgradeProgress, false);
        } else if (!statusList.contains("failed") && statusList.contains("upgraded")) {
            BundleUpgradeContext.getInstance().getMainDialog().updateExecuteResult(upgradeDevice, detail.toString(), pcieUpgradeProgress, true);
        } else {
            BundleUpgradeContext.getInstance().getMainDialog().updateExecuteResult(upgradeDevice, detail.toString(), pcieUpgradeProgress, UpgradeParamConstants.SubProcessExecutionResult.PARITIAL_SUCC);
        }
    }

    public Double getLastTotalProgress(UpgradeDeviceEntity upgradeDevice) {
        int lastIndex;
        ExecuteInfo info = upgradeDevice.getExecuteInfo();
        Double lastTotalProgress = 0.0;
        if (!info.getResults().isEmpty() && (lastIndex = info.getResults().size() - 1) >= 0) {
            ExecuteResult lastResult = info.getResults().get(lastIndex);
            lastTotalProgress = lastResult.getTotalProgress();
        }
        log.info(String.format(Locale.ENGLISH, "before PCIE upgrade progress is :%s", lastTotalProgress));
        return lastTotalProgress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public OperationResultEntity upgradeManual(UpgradeDeviceEntity upgradeDevice, Double progressStepLen) throws InterruptedException {
        Double lastTotalProgress = this.getLastTotalProgress(upgradeDevice);
        Double downloadFwProgress = lastTotalProgress + progressStepLen * 0.4;
        BundleUpgradeContext.getInstance().getMainDialog().createExecuteResult(upgradeDevice, RES.getString("bundle.upgrade.main.detail.info.DOWNLOADFW"));
        try (DeviceInfoByRedfishService service = this.getDeviceInfoByRedfishService(upgradeDevice);){
            if (!SFTPServer.getSFTP_SERVER().isAlive()) {
                BundleUpgradeContext.updateProcessInfo(upgradeDevice, RES.getString("bundle.upgrade.task.pcie.sftp.error"), downloadFwProgress, false);
                this.writePcieUpgradeResult(upgradeDevice, "", false, RES.getString("bundle.upgrade.task.pcie.sftp.error"));
                OperationResultEntity operationResultEntity = new OperationResultEntity(false, RES.getString("bundle.upgrade.task.pcie.sftp.error"));
                return operationResultEntity;
            }
            Object object = PcieUpgradeServiceImpl.class;
            synchronized (PcieUpgradeServiceImpl.class) {
                OperationResultEntity uploadPackagesResult = this.uploadBySftp(upgradeDevice, service, downloadFwProgress);
                // ** MonitorExit[var8_12] (shouldn't be in output)
                if (uploadPackagesResult.isPassed()) {
                    BundleUpgradeContext.updateProcessInfo(upgradeDevice, RES.getString("step.operation.basic.succ"), downloadFwProgress, true);
                    Double rebootSpProgress = lastTotalProgress + progressStepLen * 0.7;
                    BundleUpgradeContext.getInstance().getMainDialog().createExecuteResult(upgradeDevice, RES.getString("bundle.upgrade.main.detail.info.SPBOOT"));
                    if (this.startSpSetWatchDogStatus(upgradeDevice, service, rebootSpProgress)) {
                        OperationResultEntity operationResultEntity = new OperationResultEntity(false, RES.getString("bundle.upgrade.main.detail.info.SPBOOT.failed"));
                        return operationResultEntity;
                    }
                    BundleUpgradeContext.updateProcessInfo(upgradeDevice, RES.getString("step.operation.basic.succ"), rebootSpProgress, true);
                    return new OperationResultEntity(true, "");
                }
                BundleUpgradeContext.updateProcessInfo(upgradeDevice, uploadPackagesResult.getReturnParam(), downloadFwProgress, false);
                object = new OperationResultEntity(false, RES.getString("bundle.upgrade.main.detail.info.upload.pcie.failed"));
                return object;
            }
        }
    }

    private OperationResultEntity uploadBySftp(UpgradeDeviceEntity upgradeDevice, DeviceInfoByRedfishService service, Double downloadFwProgress) throws InterruptedException {
        ArrayList<String> iplist = service.getLocalIP();
        Map<String, String> pcieFirmwarePackageInfoMap = this.getPcieFirmwarePackageInfo(upgradeDevice);
        OperationResultEntity copyPcieFwpckResult = this.copyPcieFirmwarefile(pcieFirmwarePackageInfoMap);
        if (!copyPcieFwpckResult.isPassed()) {
            log.error(copyPcieFwpckResult.getReturnParam());
            BundleUpgradeContext.updateProcessInfo(upgradeDevice, copyPcieFwpckResult.getReturnParam(), downloadFwProgress, false);
            return new OperationResultEntity(false, RES.getString("bundle.upgrade.task.pcie.copy.failed"));
        }
        OperationResultEntity downloadFrimwarePackagesResult = this.downloadFrimwarePackages(upgradeDevice, service, iplist, pcieFirmwarePackageInfoMap);
        if (!downloadFrimwarePackagesResult.isPassed()) {
            log.error(downloadFrimwarePackagesResult.getReturnParam());
            BundleUpgradeContext.updateProcessInfo(upgradeDevice, downloadFrimwarePackagesResult.getReturnParam(), downloadFwProgress, false);
            return new OperationResultEntity(false, RES.getString("bundle.upgrade.task.pcie.download.failed1"));
        }
        return new OperationResultEntity(true, "");
    }

    public OperationResultEntity afterUpgradeOperation(UpgradeDeviceEntity upgradeDevice, Double pcieUpgradeProgress) {
        try (DeviceInfoByRedfishService service = this.getDeviceInfoByRedfishService(upgradeDevice);){
            if (this.refreshDetailPcieUpgradeEnd(upgradeDevice, service, pcieUpgradeProgress)) {
                OperationResultEntity operationResultEntity = new OperationResultEntity(false, "");
                return operationResultEntity;
            }
        }
        return new OperationResultEntity(true, "");
    }

    public OperationResultEntity upgradeSp(UpgradeStrategyEntity strategy, UpgradeDeviceEntity upgradeDevice, Double progressStepLen) throws InterruptedException {
        OperationResultEntity uploadPackagesResult;
        BundleUpgradeContext.getInstance().getMainDialog().createExecuteResult(upgradeDevice, RES.getString("bundle.upgrade.main.detail.info.sp.upgrade"));
        String targetVersion = strategy.getUpgradeSpParams().getTargetVersion();
        String currentVersion = upgradeDevice.getDeviceEntity().getSpVersion();
        if (!this.checkNeedUpgrade(strategy, upgradeDevice, progressStepLen)) {
            return new OperationResultEntity(true, "");
        }
        Double lastTotalProgress = this.getLastTotalProgress(upgradeDevice);
        Double downloadFwProgress = lastTotalProgress + progressStepLen * 0.4;
        try (DeviceInfoByRedfishService service = this.getDeviceInfoByRedfishService(upgradeDevice);){
            uploadPackagesResult = service.transportSpPackageByCifs(strategy.getUpgradeSpParams());
        }
        if (!uploadPackagesResult.isPassed()) {
            BundleUpgradeContext.updateProcessInfo(upgradeDevice, uploadPackagesResult.getReturnParam(), downloadFwProgress, false);
            String errorMsg = RES.getString("bundle.upgrade.main.detail.info.upload.pcie.failed");
            this.writeSpUpgradeResult(currentVersion, targetVersion, UpgradeParamConstants.FirmUpgradeStatus.FAILED, errorMsg);
            return new OperationResultEntity(false, errorMsg);
        }
        BundleUpgradeContext.updateProcessInfo(upgradeDevice, RES.getString("step.operation.basic.succ"), downloadFwProgress, true);
        this.writeSpUpgradeResult(upgradeDevice.getDeviceEntity().getSpVersion(), strategy.getUpgradeSpParams().getTargetVersion(), UpgradeParamConstants.FirmUpgradeStatus.SUCCESS, "");
        return new OperationResultEntity(true, "");
    }

    public OperationResultEntity setStartBySpWhenUpgradeSp(UpgradeDeviceEntity upgradeDevice, Double rebootSpProgress) {
        try (DeviceInfoByRedfishService service = this.getDeviceInfoByRedfishService(upgradeDevice);){
            BundleUpgradeContext.getInstance().getMainDialog().createExecuteResult(upgradeDevice, RES.getString("bundle.upgrade.main.detail.info.SPBOOT"));
            if (this.startSpSetWatchDogStatus(upgradeDevice, service, rebootSpProgress)) {
                String errorMsg = RES.getString("bundle.upgrade.main.detail.info.SPBOOT.failed");
                OperationResultEntity operationResultEntity = new OperationResultEntity(false, errorMsg);
                return operationResultEntity;
            }
            BundleUpgradeContext.updateProcessInfo(upgradeDevice, RES.getString("step.operation.basic.succ"), rebootSpProgress, true);
        }
        return new OperationResultEntity(true, "");
    }

    private boolean checkNeedUpgrade(UpgradeStrategyEntity strategy, UpgradeDeviceEntity upgradeDevice, Double progressStepLen) {
        String targetVersion = strategy.getUpgradeSpParams().getTargetVersion();
        String currentVersion = upgradeDevice.getDeviceEntity().getSpVersion();
        List needUpgrade = Arrays.stream(currentVersion.split("/")).filter(version -> !version.trim().equalsIgnoreCase(targetVersion)).collect(Collectors.toList());
        String upgradeMode = strategy.getUpgradeSpParams().getUpgradeMode();
        if ("Auto".equalsIgnoreCase(upgradeMode) && needUpgrade.isEmpty()) {
            String msg = RES.getString("bundle.upgrade.sp.ignore");
            BundleUpgradeContext.getInstance().getMainDialog().updateResult(upgradeDevice, msg, progressStepLen, UpgradeParamConstants.SubProcessExecutionResult.NOT_INVOLVED, msg);
            return false;
        }
        return true;
    }

    private void writeSpUpgradeResult(String fromVersion, String targetVersion, UpgradeParamConstants.FirmUpgradeStatus status, String resultMsg) {
        UpgradeDeviceEntity.FirmUpgradeResult firmUpgradeResult = new UpgradeDeviceEntity.FirmUpgradeResult();
        firmUpgradeResult.setStatus(status);
        firmUpgradeResult.setResultMsg(resultMsg);
        firmUpgradeResult.setFromVersion(fromVersion);
        firmUpgradeResult.setToVersion(targetVersion);
        firmUpgradeResult.setFirmwarePackage(new FirmwarePackageEntity());
        List rets = this.upgradeDeviceEntity.getUpgradeDetails().getOrDefault((Object)UpgradeParamConstants.ModuleType.SP, new LinkedList());
        rets.add(firmUpgradeResult);
        this.upgradeDeviceEntity.getUpgradeDetails().putIfAbsent(UpgradeParamConstants.ModuleType.SP, rets);
    }

    public OperationResultEntity afterUpgradeSpOperation(UpgradeDeviceEntity upgradeDevice, UpgradeStrategyEntity strategy, Double upgradeProgress) {
        try (DeviceInfoByRedfishService service = this.getDeviceInfoByRedfishService(upgradeDevice);){
            if (this.resetWatchDog(upgradeDevice, service, upgradeProgress)) {
                OperationResultEntity operationResultEntity = new OperationResultEntity(false, "");
                return operationResultEntity;
            }
            OperationResultEntity operationResultEntity = new OperationResultEntity(true, "");
            return operationResultEntity;
        }
    }

    @NotNull
    private DeviceInfoByRedfishService getDeviceInfoByRedfishService(UpgradeDeviceEntity upgradeDevice) {
        return new DeviceInfoByRedfishService(upgradeDevice.getDeviceEntity().getIp(), upgradeDevice.getDeviceEntity().getHttpsPort(), upgradeDevice.getDeviceEntity().getAccount().getUserName(), upgradeDevice.getDeviceEntity().getAccount().getPassword(), upgradeDevice.getDeviceEntity().isSupportRedfish());
    }

    private boolean resetWatchDog(UpgradeDeviceEntity upgradeDevice, DeviceInfoByRedfishService service, Double pcieUpgradeProgress) {
        HashMap<String, String> orgBiosConfigItemMap = WatchDogSettingUtil.getBiosConfigItem(upgradeDevice.getDeviceEntity().getWatchDogModel());
        OperationResultEntity reSpbootWatchDogResult = WatchDogSettingUtil.resumSpbootWatchDog(upgradeDevice, service, WatchDogSettingUtil.getOrgBiosCfgItem(orgBiosConfigItemMap));
        if (!reSpbootWatchDogResult.isPassed()) {
            BundleUpgradeContext.getInstance().getMainDialog().updateExecuteResult(upgradeDevice, RES.getString("bundle.upgrade.task.pcie.resumwatchdog.error"), pcieUpgradeProgress, false);
            return true;
        }
        return false;
    }
}

