/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.bundleupgrade.service.impl;

import com.huawei.bundleupgrade.entity.ComputeNodeUpgradeResult;
import com.huawei.bundleupgrade.service.ReportComputeNodeService;
import com.huawei.ism.tool.base.utils.DateUtil;
import com.huawei.ism.tool.base.utils.FileUtils;
import com.huawei.ism.tool.base.utils.ZipUtils;
import com.huawei.ism.tool.distributedfwupg.service.FsUpgradeService;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.framework.platform.util.UserOpDataSaveUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.uMate.common.file.FileOperation;
import com.huawei.uMate.common.utils.ResUtil;
import com.huawei.uMate.common.utils.TemplateUtils;
import java.io.File;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportComputeNodeImpl
implements ReportComputeNodeService<ComputeNodeUpgradeResult> {
    private static final Logger log = LoggerFactory.getLogger(ReportComputeNodeImpl.class);
    private static final ResUtil RES = ResUtil.getInstance((String)"BundleUpgrade");
    private static final String TEMPLATE_PATH = ApplicationContext.getInstance().getWorkPath() + File.separator + "template" + File.separator + "ComputeNodeUpgrade";
    private static final String[] REPORT_FTL_FILES = new String[]{"index.html", "data/leftTree.html", "data/head/cover.html", "data/head/upgradeSummary.html"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean generateReport(String destPath, ComputeNodeUpgradeResult data) {
        boolean bl;
        File tmpPathFile;
        block8: {
            boolean bl2;
            block7: {
                tmpPathFile = null;
                try {
                    String tmpPath = ApplicationContext.getInstance().getTmpPath() + File.separator + System.currentTimeMillis();
                    tmpPathFile = new File(tmpPath);
                    if (!tmpPathFile.mkdirs()) {
                        log.info("failed to create file dir.");
                        bl2 = false;
                        log.info("Delete temp path {}", (Object)tmpPathFile);
                        break block7;
                    }
                    FileOperation.copyFolder((String)TEMPLATE_PATH, (String)tmpPath);
                    bl = this.generateReport(this.prepareData(data), tmpPath, destPath);
                    log.info("Delete temp path {}", (Object)tmpPathFile);
                    break block8;
                }
                catch (Exception e) {
                    log.error("error to generate report", (Throwable)e);
                    boolean bl3 = false;
                    return bl3;
                }
            }
            FileUtils.deleteFile((File)tmpPathFile);
            return bl2;
        }
        FileUtils.deleteFile((File)tmpPathFile);
        return bl;
        finally {
            log.info("Delete temp path {}", tmpPathFile);
            FileUtils.deleteFile(tmpPathFile);
        }
    }

    private Map<String, Object> prepareData(ComputeNodeUpgradeResult data) {
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put("fsCluster", FsUpgradeService.getCurUpgradeFsDev(false));
        dataMap.put("result", data);
        dataMap.put("RES", RES);
        ReportComputeNodeImpl.addComputeNodeCoverInfo(dataMap);
        return dataMap;
    }

    private boolean generateReport(Map<String, Object> dataMap, String tmpPath, String destPath) {
        for (String pathFile : REPORT_FTL_FILES) {
            String destHomePath = tmpPath + File.separator + pathFile;
            if (TemplateUtils.processorFtl((String)pathFile, dataMap, (String)destHomePath)) continue;
            return false;
        }
        return ZipUtils.compressFile((String)destPath, (String)tmpPath);
    }

    private static void addComputeNodeCoverInfo(Map<String, Object> data) {
        data.put("title", RES.getString("cover.title"));
        data.put("genneratedate", ReportComputeNodeImpl.dealDateStr(StringUtils.formatDate((Object)new Date(), (String)"yyyy-MM-dd HH:mm:ss 'GMT'Z")));
        data.put("toolversion", UserOpDataSaveUtil.getViewVersion());
        data.put("toolkitversion", UserOpDataSaveUtil.getToolBoxIniProp((String)"app.version"));
        data.put("date", UserOpDataSaveUtil.getToolIniProp((String)"date"));
        data.put("curYear", String.valueOf(DateUtil.getUTCYear((Calendar)Calendar.getInstance())));
    }

    private static String dealDateStr(String dateStr) {
        String temp = ":" + dateStr.substring(dateStr.length() - 2);
        StringBuilder str = new StringBuilder(dateStr);
        str.replace(dateStr.length() - 2, dateStr.length(), temp);
        return str.toString();
    }

    static {
        TemplateUtils.setTemplateLoader((String)TEMPLATE_PATH);
    }
}

