/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.bundleupgrade.service.impl;

import com.huawei.bundleupgrade.constants.UpgradeParamConstants;
import com.huawei.bundleupgrade.entity.FirmwarePackageEntity;
import com.huawei.bundleupgrade.entity.UpgradeDeviceEntity;
import com.huawei.bundleupgrade.entity.UpgradeStrategyEntity;
import com.huawei.bundleupgrade.service.ReportService;
import com.huawei.bundleupgrade.utils.BundleUpgradeContext;
import com.huawei.bundleupgrade.utils.UpgradeScenarioUtil;
import com.huawei.ism.tool.base.utils.FileUtils;
import com.huawei.ism.tool.base.utils.OSCmdUtils;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.base.utils.ZipUtils;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.framework.platform.util.UserOpDataSaveUtil;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.dialog.WarningDialog;
import com.huawei.uMate.common.SystemInfo;
import com.huawei.uMate.common.file.FileOperation;
import com.huawei.uMate.common.utils.ResUtil;
import com.huawei.uMate.common.utils.TemplateUtils;
import java.awt.Window;
import java.io.File;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportServiceImpl
implements ReportService {
    private static final Logger log = LoggerFactory.getLogger(ReportServiceImpl.class);
    private static final String[] REPORT_FTL_FILES = new String[]{"index.html", "data/leftTree.html", "data/head/appendix.html", "data/head/cover.html", "data/head/upgradeSummary.html", "data/details/upgradeDetails.html"};
    private static final ResUtil RES = ResUtil.getInstance((String)"BundleUpgrade");
    private static final String TEMPLATE_PATH = ApplicationContext.getInstance().getWorkPath() + File.separator + "template" + File.separator + "BundleUpgrade";
    private static ReportService SERVICE = new ReportServiceImpl();

    private ReportServiceImpl() {
    }

    public static ReportService getInstance() {
        return SERVICE;
    }

    @Override
    public boolean generateReport(String destPath, List<UpgradeDeviceEntity> data) {
        FileOperation op = new FileOperation();
        try {
            HashMap<String, Object> dataMap = new HashMap<String, Object>(1);
            this.prepareData(data, dataMap);
            String tmpPath = ApplicationContext.getInstance().getTmpPath() + File.separator + System.currentTimeMillis();
            File tmpPathFile = new File(tmpPath);
            if (!tmpPathFile.mkdirs()) {
                log.info("failed to create file dir.");
                return false;
            }
            FileOperation.copyFolder((String)TEMPLATE_PATH, (String)tmpPath);
            if (!this.generateReport(dataMap, tmpPath, destPath)) {
                return false;
            }
            this.showResultOnSuccess(destPath, tmpPathFile);
            return true;
        }
        catch (Exception e) {
            log.error("error to generate report", (Throwable)e);
            return false;
        }
    }

    private void prepareData(List<UpgradeDeviceEntity> data, Map<String, Object> dataMap) {
        dataMap.put("results", this.groupResultByDeviceType(data));
        dataMap.put("RES", RES);
        TemplateUtils.addAppendixInfo(dataMap);
        this.addCoverInfo(dataMap);
    }

    private void addCoverInfo(Map data) {
        data.put("operateTime", SystemInfo.getTimeZoneDateStr((long)System.currentTimeMillis()));
        data.put("toolversion", UserOpDataSaveUtil.getViewVersion());
        data.put("toolkitversion", UserOpDataSaveUtil.getToolBoxIniProp((String)"app.version"));
        data.put("date", UserOpDataSaveUtil.getToolIniProp((String)"date"));
    }

    private boolean generateReport(Map<String, Object> dataMap, String tmpPath, String destPath) {
        for (String pathFile : REPORT_FTL_FILES) {
            String destHomePath = tmpPath + File.separator + pathFile;
            if (TemplateUtils.processorFtl((String)pathFile, dataMap, (String)destHomePath)) continue;
            return false;
        }
        return ZipUtils.compressFile((String)destPath, (String)tmpPath);
    }

    private void showResultOnSuccess(String destPath, File tmpPathFile) {
        FileUtils.deleteFile((File)tmpPathFile);
        log.info(String.format(Locale.ENGLISH, "report generate successfully!destPath:%s", destPath));
        WarningDialog wd = DialogUtils.showYesNoDialog((Window)((Object)BundleUpgradeContext.getInstance().getMainDialog()), (String)RES.getString("bundle.upgrade.task.export.complete.is.to.view.report"));
        if (wd.getValue() == 0) {
            OSCmdUtils.exeExportFile((String)new File(destPath).getParent());
        }
    }

    private Map<String, List<UpgradeDeviceEntity>> groupResultByDeviceType(List<UpgradeDeviceEntity> data) {
        TreeMap<String, List<UpgradeDeviceEntity>> resultMap = new TreeMap<String, List<UpgradeDeviceEntity>>();
        data.forEach(entity -> {
            ArrayList<UpgradeDeviceEntity> devList;
            if (entity.getDeviceEntity() == null || StringUtils.isNULLStr((String)entity.getDeviceEntity().getIp())) {
                return;
            }
            this.setFailedDetailInfo((UpgradeDeviceEntity)entity);
            String devType = entity.getDeviceEntity().getProductTypeForReport();
            if (StringUtils.isNULLStr((String)devType)) {
                devType = "Unknown";
            }
            if ((devList = (ArrayList<UpgradeDeviceEntity>)resultMap.get(devType)) == null) {
                devList = new ArrayList<UpgradeDeviceEntity>();
                resultMap.put(devType, devList);
            }
            devList.add((UpgradeDeviceEntity)entity);
        });
        return resultMap;
    }

    private void setFailedDetailInfo(UpgradeDeviceEntity device) {
        if (device.getProcessStatus().equals((Object)UpgradeParamConstants.UpgradeStatus.FAILED) && device.getUpgradeDetails().isEmpty()) {
            String strategyId = device.getAssociatedStrategyId();
            Map<String, UpgradeStrategyEntity> strategyEntityMap = BundleUpgradeContext.getInstance().getStrategyEntityMap();
            UpgradeStrategyEntity strategyEntity = strategyEntityMap.get(strategyId);
            EnumMap<UpgradeParamConstants.ModuleType, List<UpgradeDeviceEntity.FirmUpgradeResult>> upgradeDetails = new EnumMap<UpgradeParamConstants.ModuleType, List<UpgradeDeviceEntity.FirmUpgradeResult>>(UpgradeParamConstants.ModuleType.class);
            strategyEntity.getModuleTargetFirmwareMap().forEach((moduleType, targetFwKeys) -> {
                ArrayList resultList = new ArrayList();
                targetFwKeys.forEach(key -> {
                    FirmwarePackageEntity fwPackage = BundleUpgradeContext.getInstance().getFirmwarePackageMap().get(key);
                    if (fwPackage != null) {
                        UpgradeDeviceEntity.FirmUpgradeResult result = new UpgradeDeviceEntity.FirmUpgradeResult();
                        result.setFirmwareUid(fwPackage.getPackageInfo().getSupportModelUID());
                        result.setFromVersion(UpgradeScenarioUtil.getTargetModuleVersion(device.getDeviceEntity(), moduleType, fwPackage));
                        result.setToVersion(fwPackage.getPackageInfo().getVersion());
                        result.setResultMsg(device.getResultMsg());
                        result.setStatus(UpgradeParamConstants.FirmUpgradeStatus.FAILED);
                        resultList.add(result);
                    }
                });
                if (!resultList.isEmpty()) {
                    upgradeDetails.put((UpgradeParamConstants.ModuleType)((Object)moduleType), resultList);
                }
            });
            device.setUpgradeDetails(upgradeDetails);
        }
    }

    static {
        TemplateUtils.setTemplateLoader((String)TEMPLATE_PATH);
    }
}

