/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.bundleupgrade.service.impl;

import com.huawei.bundleupgrade.constants.UpgradeParamConstants;
import com.huawei.bundleupgrade.entity.FunctionMap;
import com.huawei.bundleupgrade.entity.PcieCardEntity;
import com.huawei.bundleupgrade.entity.UpgradeDeviceEntity;
import com.huawei.bundleupgrade.model.Module;
import com.huawei.bundleupgrade.service.connection.fusionstrg.FusionStorageSshConnector;
import com.huawei.bundleupgrade.service.connection.fusionstrg.FusionStorageSshPool;
import com.huawei.bundleupgrade.utils.UpgradeScenarioUtil;
import com.huawei.bundleupgrade.utils.fusionstrg.FusionStrgUpgradeContext;
import com.huawei.uMate.common.UMateException;
import com.huawei.uMate.common.utils.ResUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VerifyVersionImpl {
    private static final Logger LOGGER = LoggerFactory.getLogger(VerifyVersionImpl.class);
    private static final ResUtil RES = ResUtil.getInstance((String)"BundleUpgrade");
    private UpgradeDeviceEntity device;
    private Map<UpgradeParamConstants.ModuleType, List<UpgradeDeviceEntity.FirmUpgradeResult>> currentNeedVerifyFwResultMap = new HashMap<UpgradeParamConstants.ModuleType, List<UpgradeDeviceEntity.FirmUpgradeResult>>();
    FusionStorageSshConnector ssh;

    public VerifyVersionImpl(UpgradeDeviceEntity device) {
        this.device = device;
        device.getUpgradeDetails().forEach((type, upgradeResults) -> {
            List successUpgradedResults = upgradeResults.stream().filter(UpgradeDeviceEntity.FirmUpgradeResult::isNeedVerify).collect(Collectors.toList());
            if (!successUpgradedResults.isEmpty()) {
                this.currentNeedVerifyFwResultMap.put((UpgradeParamConstants.ModuleType)((Object)type), successUpgradedResults);
            }
        });
        if (UpgradeScenarioUtil.isOutBound()) {
            return;
        }
        if (device.isPlaneNode()) {
            return;
        }
        try {
            this.ssh = FusionStorageSshPool.getFsSshConnectionByBmcIp(device.getDeviceEntity().getIp());
        }
        catch (UMateException exception) {
            this.ssh = null;
            FusionStorageSshPool.releaseFsSshConnection(FusionStrgUpgradeContext.getInstance().getFsDeviceEntityByBmcIp(device.getDeviceEntity().getIp()));
            LOGGER.error("verify version create ssh failed:", (Throwable)exception);
        }
    }

    public void verifyFwAndDeviceVersion(List<String> checkDetails) {
        this.currentNeedVerifyFwResultMap.forEach((type, firmwarePackageEntityList) -> firmwarePackageEntityList.forEach(upgradeResult -> {
            if (UpgradeParamConstants.ModuleType.getOverridesCompareModule().contains(type)) {
                this.verifyDeviceVersionAndFwVersion(checkDetails, (UpgradeParamConstants.ModuleType)((Object)type), (UpgradeDeviceEntity.FirmUpgradeResult)upgradeResult);
            } else if (UpgradeParamConstants.ModuleType.getInBandModules().contains(type)) {
                this.verifyInBandSingleFw(checkDetails, (UpgradeParamConstants.ModuleType)((Object)type), (UpgradeDeviceEntity.FirmUpgradeResult)upgradeResult);
            } else if (UpgradeParamConstants.ModuleType.getPanGeaInBandModules().contains(type)) {
                this.verifyPangeaSingleFw(checkDetails, (UpgradeParamConstants.ModuleType)((Object)type), (UpgradeDeviceEntity.FirmUpgradeResult)upgradeResult);
            } else {
                this.verifyNotSupportSingleFw(checkDetails, (UpgradeParamConstants.ModuleType)((Object)type), (UpgradeDeviceEntity.FirmUpgradeResult)upgradeResult);
            }
        }));
        if (UpgradeScenarioUtil.isOutBound()) {
            return;
        }
        FusionStorageSshPool.releaseFsSshConnection(FusionStrgUpgradeContext.getInstance().getFsDeviceEntityByBmcIp(this.device.getDeviceEntity().getIp()));
    }

    private void verifyDeviceVersionAndFwVersion(List<String> checkDetails, UpgradeParamConstants.ModuleType type, UpgradeDeviceEntity.FirmUpgradeResult upgradeResult) {
        String detail = FunctionMap.ModuleFunction.getModule(type.getModule()).verifyDeviceVersionAndFwVersion(this.device.getDeviceEntity(), upgradeResult);
        checkDetails.add(detail);
    }

    private void verifyInBandSingleFw(List<String> checkDetails, UpgradeParamConstants.ModuleType type, UpgradeDeviceEntity.FirmUpgradeResult upgradeResult) {
        String detail;
        String firmwareSupportUID;
        Map<String, List<PcieCardEntity>> pcieCardsInfos = this.device.getDeviceEntity().getPcieCardsInfos();
        List<PcieCardEntity> devicePcieCards = pcieCardsInfos.get(firmwareSupportUID = "[" + upgradeResult.getFirmwarePackage().getPackageInfo().getSupportModelUID() + "]");
        if (devicePcieCards.stream().allMatch(card -> card.getFirmwareVersion().equalsIgnoreCase(upgradeResult.getFirmwarePackage().getPackageInfo().getVersion()))) {
            detail = "";
            upgradeResult.setSuccessVerify(Boolean.TRUE);
        } else {
            String currentVersion = devicePcieCards.stream().map(PcieCardEntity::getFirmwareVersion).distinct().collect(Collectors.joining(";"));
            detail = RES.getStringWithParams("bundle.upgrade.verify.device.firmware.version.error", new Object[]{type.getModule(), currentVersion, upgradeResult.getFirmwarePackage().getPackageInfo().getVersion()});
            upgradeResult.setSuccessVerify(Boolean.FALSE);
            upgradeResult.setToVersion(currentVersion);
            upgradeResult.setStatus(UpgradeParamConstants.FirmUpgradeStatus.FAILED);
        }
        upgradeResult.setResultMsg(detail);
        LOGGER.info("node: {} pcie {} verify, device version {} , package version {} ", new Object[]{this.device.getDeviceEntity().getIp(), type, devicePcieCards.get(0).getFirmwareVersion(), upgradeResult.getFirmwarePackage().getPackageInfo().getVersion()});
        checkDetails.add(detail);
    }

    private void verifyPangeaSingleFw(List<String> checkDetails, UpgradeParamConstants.ModuleType type, UpgradeDeviceEntity.FirmUpgradeResult upgradeResult) {
        if (this.ssh == null) {
            LOGGER.error("ssh connection is null, get pangea version failed");
            String detail = RES.getString("bundle.upgrade.main.connection.error");
            upgradeResult.setToVersion("--");
            upgradeResult.setResultMsg(detail);
            upgradeResult.setSuccessVerify(Boolean.FALSE);
            upgradeResult.setStatus(UpgradeParamConstants.FirmUpgradeStatus.FAILED);
            checkDetails.add(detail);
            return;
        }
        try {
            String panGeaVersion = Module.getPanGeaInBandVersionOnServer(upgradeResult.getFirmwarePackage(), this.ssh);
            this.device.getDeviceEntity().getPanGeaInBandModuleVersion().put(type.getModule(), panGeaVersion);
            if (!panGeaVersion.equals("--") && type.equals((Object)UpgradeParamConstants.ModuleType.SES)) {
                panGeaVersion = Arrays.stream(panGeaVersion.split(" ")).map(version -> version.split(":")[1]).distinct().collect(Collectors.joining(";"));
            }
            if (!panGeaVersion.equals("--")) {
                panGeaVersion = Arrays.stream(panGeaVersion.split("\r")).map(this::getCommonPangeaVersion).distinct().collect(Collectors.joining(";"));
            }
            if (panGeaVersion.equals(upgradeResult.getFirmwarePackage().getPackageInfo().getVersion())) {
                checkDetails.add("");
                upgradeResult.setResultMsg("");
                upgradeResult.setSuccessVerify(Boolean.TRUE);
                upgradeResult.setStatus(UpgradeParamConstants.FirmUpgradeStatus.SUCCESS);
            } else {
                String detail = RES.getStringWithParams("bundle.upgrade.verify.device.firmware.version.error", new Object[]{type.getModule(), panGeaVersion, upgradeResult.getFirmwarePackage().getPackageInfo().getVersion()});
                upgradeResult.setToVersion(panGeaVersion);
                upgradeResult.setResultMsg(detail);
                upgradeResult.setSuccessVerify(Boolean.FALSE);
                upgradeResult.setStatus(UpgradeParamConstants.FirmUpgradeStatus.FAILED);
                checkDetails.add(detail);
            }
            LOGGER.info("node: {} pangea {} verify, device version {} , package version {} ", new Object[]{this.device.getDeviceEntity().getIp(), type, panGeaVersion, upgradeResult.getFirmwarePackage().getPackageInfo().getVersion()});
        }
        catch (Exception exception) {
            LOGGER.error("get pan gea version fail.", (Throwable)exception);
        }
    }

    private String getCommonPangeaVersion(String singleVersion) {
        String[] idAndVersion = singleVersion.split(":");
        if (idAndVersion.length < 2) {
            return singleVersion.trim();
        }
        return idAndVersion[1].trim();
    }

    private void verifyNotSupportSingleFw(List<String> checkDetails, UpgradeParamConstants.ModuleType type, UpgradeDeviceEntity.FirmUpgradeResult upgradeResult) {
        String detail = RES.getStringWithParams("bundle.upgrade.verify.device.firmware.version.error", new Object[]{type.getModule(), "--", upgradeResult.getFirmwarePackage().getPackageInfo().getVersion()});
        upgradeResult.setSuccessVerify(Boolean.FALSE);
        checkDetails.add(detail);
    }
}

