/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.bundleupgrade.service.system.impl;

import com.alibaba.fastjson.JSONArray;
import com.huawei.bundleupgrade.constants.UpgradeParamConstants;
import com.huawei.bundleupgrade.entity.DeviceEntity;
import com.huawei.bundleupgrade.entity.OperationResultEntity;
import com.huawei.bundleupgrade.service.connection.RestConnPool;
import com.huawei.bundleupgrade.service.system.IPowerOperationService;
import com.huawei.bundleupgrade.utils.UpgradeScenarioUtil;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.obase.connection.support.ConnUtils;
import com.huawei.uMate.common.UMateException;
import com.huawei.uMate.common.rest.RedfishConnestion;
import com.huawei.uMate.common.rest.RedfishResult;
import com.huawei.uMate.common.utils.RedfishUtils;
import com.huawei.uMate.common.utils.ResUtil;
import java.util.HashMap;
import java.util.Locale;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PowerOperationRedFishService
implements IPowerOperationService {
    private static final Logger LOGGER = LoggerFactory.getLogger(PowerOperationRedFishService.class);
    private static final ResUtil RES = ResUtil.getInstance((String)"BundleUpgrade");
    private static final int MAX_RETRY_TIMES = 32;
    private static final int MAX_RETRY_TIMES_POEWR_ON = 96;
    private static final int POWER_OFF_MAX_RETRY_TIMES = 30;
    private static final int POWER_FORCE_OFF_RETRY_TIMES = 30;
    private static final String[] HUAWEI_KEY = new String[]{"Oem", "Huawei"};
    private static final String[] PUBLIC_KEY = new String[]{"Oem", "Public"};
    private static final String POWER_ON = "On";
    private static final String POWER_GRACEFUL_OFF = "GracefulShutdown";
    private static final String POWER_FORCE_OFF = "ForceOff";
    private static final String POWER_FORCE_RESTART = "ForceRestart";
    private static final String POWER_FORCE_CYCLE = "ForcePowerCycle";
    private RedfishConnestion redfishConnestion;
    private DeviceEntity device;

    public PowerOperationRedFishService(DeviceEntity device) throws UMateException {
        this.device = device;
        this.redfishConnestion = RestConnPool.getRedFishConnection(device);
    }

    @Override
    public OperationResultEntity powerOnDevice() throws UMateException {
        UpgradeParamConstants.PowerStatus powerStatus = this.getCurrentDevicePowerStatus();
        if (powerStatus == UpgradeParamConstants.PowerStatus.POWER_IS_ON) {
            LOGGER.info("the system is already powered-on.");
            return new OperationResultEntity(true, "");
        }
        for (int loop = 0; loop < 96; ++loop) {
            RedfishResult result = this.requestPowerOperation(this.getSystemPowerOptResource(), POWER_ON);
            ConnUtils.sleep((int)10000);
            if (result.isSuccess() && result.getStatusCode().startsWith("2")) {
                return new OperationResultEntity(true, "");
            }
            LOGGER.error("RedFish to power-On operation failed, retry...");
        }
        return new OperationResultEntity(false, RES.getString("rest.power.off.failed"));
    }

    @Override
    public OperationResultEntity powerOffDevice() throws UMateException {
        UpgradeParamConstants.PowerStatus powerStatus = this.getCurrentDevicePowerStatus();
        if (powerStatus == UpgradeParamConstants.PowerStatus.POWER_IS_OFF) {
            LOGGER.info("the system is already powered-off.");
            return new OperationResultEntity(true, "");
        }
        for (int loop = 0; loop < 30; ++loop) {
            RedfishResult result = this.requestPowerOperation(this.getSystemPowerOptResource(), POWER_GRACEFUL_OFF);
            ConnUtils.sleep((int)10000);
            if (!result.isSuccess() || !result.getStatusCode().startsWith("2")) {
                LOGGER.error("RedFish to power-off operation failed, retry...");
                continue;
            }
            ConnUtils.sleep((int)10000);
            UpgradeParamConstants.PowerStatus curPowerStatus = this.getCurrentDevicePowerStatus();
            LOGGER.info(String.format(Locale.ENGLISH, "Current Power Status is %s", new Object[]{curPowerStatus}));
            if (curPowerStatus == UpgradeParamConstants.PowerStatus.POWER_IS_OFF) {
                return IPowerOperationService.createVacantSuccessfulResult();
            }
            LOGGER.error("RedFish to power-off operation failed, retry......");
        }
        if (this.forcePowerOffSuccess()) {
            return IPowerOperationService.createVacantSuccessfulResult();
        }
        return new OperationResultEntity(false, RES.getString("rest.power.off.failed"));
    }

    private boolean forcePowerOffSuccess() throws UMateException {
        if (!this.isNeedForceRestartDevice()) {
            LOGGER.info("You do not need to run the ForceOff command.");
            return false;
        }
        if (!this.canExecuteForcePowerOff()) {
            return false;
        }
        LOGGER.info("Start to run the force-power-off command.");
        for (int loop = 0; loop < 30; ++loop) {
            RedfishResult result = this.requestPowerOperation(this.getSystemPowerOptResource(), POWER_FORCE_OFF);
            ConnUtils.sleep((int)10000);
            if (!result.isSuccess() || !result.getStatusCode().startsWith("2")) {
                LOGGER.warn("Execute ForceOff cmd failed, retry {}", (Object)loop);
                continue;
            }
            ConnUtils.sleep((int)10000);
            UpgradeParamConstants.PowerStatus curPowerStatus = this.getCurrentDevicePowerStatus();
            LOGGER.info("Current Power Status is {}", (Object)curPowerStatus);
            if (curPowerStatus == UpgradeParamConstants.PowerStatus.POWER_IS_OFF) {
                LOGGER.info("Power is off RedFish to ForceOff operation success");
                return true;
            }
            LOGGER.error("RedFish ForceOff operation failed, retry {}", (Object)loop);
        }
        return false;
    }

    private boolean canExecuteForcePowerOff() {
        String uri = String.format(Locale.ENGLISH, "/redfish/v1/Systems/%s", this.getDeviceSlotId());
        RedfishResult systemInfo = this.redfishConnestion.executeGet(uri);
        if (!systemInfo.isSuccess() || !systemInfo.getStatusCode().startsWith("2")) {
            LOGGER.warn("Failed to obtain system info. reuslt: {}", (Object)systemInfo.getResult());
            return false;
        }
        if (!this.isTimeoutPowerOffEnable(systemInfo)) {
            LOGGER.info("SafePowerOffTimeoutEnabled is not enabled, ForceOff is not required");
            return false;
        }
        return true;
    }

    private boolean isTimeoutPowerOffEnable(RedfishResult systemInfo) {
        String resultStr = (String)RedfishUtils.getObjectAttr((String)systemInfo.getResult(), String.class, (String[])HUAWEI_KEY);
        if (resultStr == null) {
            resultStr = (String)RedfishUtils.getObjectAttr((String)systemInfo.getResult(), String.class, (String[])PUBLIC_KEY);
        }
        return !StringUtils.isNULLStr((String)resultStr) && (Boolean)RedfishUtils.getObjectAttr((String)resultStr, Boolean.class, (String[])new String[]{"SafePowerOffTimeoutEnabled"}) != false;
    }

    private boolean isNeedForceRestartDevice() {
        String kernelVersion = this.device.getKernelVersion().toLowerCase(Locale.ROOT);
        return (kernelVersion.contains("v2r8") || kernelVersion.contains("v2r9")) && !this.device.isDirectPlane() && !UpgradeScenarioUtil.isYinglong();
    }

    private RedfishResult requestPowerOperation(String powerRes, String powerOperation) {
        HashMap<String, String> header = new HashMap<String, String>(1);
        header.put("Content-Type", "application/json;charset=utf-8");
        HashMap<String, String> dataMap = new HashMap<String, String>(1);
        dataMap.put("ResetType", powerOperation);
        return Optional.ofNullable(this.redfishConnestion.request("POST", powerRes, header, dataMap, null)).orElse(new RedfishResult(false, "", "", ""));
    }

    private String getSystemPowerOptResource() {
        return String.format(Locale.ENGLISH, "/redfish/v1/Systems/%s/Actions/ComputerSystem.Reset", this.getDeviceSlotId());
    }

    @Override
    public OperationResultEntity sendRestartIBMCSignal() {
        String requestUri = String.format(Locale.ENGLISH, "/redfish/v1/Managers/%s/Actions/Manager.Reset", this.getDeviceSlotId());
        for (int loop = 0; loop < 32; ++loop) {
            RedfishResult result = this.requestPowerOperation(requestUri, POWER_FORCE_RESTART);
            ConnUtils.sleep((int)5000);
            if (result.isSuccess() && result.getStatusCode().startsWith("2")) {
                LOGGER.info("BMC restart command sent successfully");
                return IPowerOperationService.createVacantSuccessfulResult();
            }
            LOGGER.error("RedFish rest iBMC operation failed, retry...");
        }
        return new OperationResultEntity(false, RES.getString("restart.iBMC.failed"));
    }

    @Override
    public UpgradeParamConstants.PowerStatus getCurrentDevicePowerStatus() throws UMateException {
        String slotId = this.getDeviceSlotId();
        String uri = String.format(Locale.ENGLISH, "/redfish/v1/Systems/%s", slotId);
        for (int loop = 0; loop < 32; ++loop) {
            if (StringUtils.isNULLStr((String)slotId)) {
                LOGGER.info("Device {} slotd is {} retry", (Object)this.device.getIp(), (Object)slotId);
                slotId = this.getDeviceSlotId();
                uri = String.format(Locale.ENGLISH, "/redfish/v1/Systems/%s", slotId);
                ConnUtils.sleep((int)5000);
                continue;
            }
            RedfishResult result = this.redfishConnestion.executeGet(uri);
            if (!result.isSuccess() || !result.getStatusCode().startsWith("2")) {
                LOGGER.error("RedFish get power status failed, retry...");
                ConnUtils.sleep((int)5000);
                continue;
            }
            LOGGER.info(String.format(Locale.ENGLISH, "Power status fetched successfully: %s", result.getResult()));
            String transferState = (String)RedfishUtils.getObjectAttr((String)result.getResult(), String.class, (String[])new String[]{"PowerState"});
            if (!StringUtils.isNULLStr((String)transferState) && "on".equalsIgnoreCase(transferState)) {
                return UpgradeParamConstants.PowerStatus.POWER_IS_ON;
            }
            return UpgradeParamConstants.PowerStatus.POWER_IS_OFF;
        }
        throw new UMateException(RES.getString("get.power.status.failed"));
    }

    @Override
    public String getProtocolType() {
        return "RedFish";
    }

    @Override
    public OperationResultEntity waitTillIBMCModuleRestarted() {
        if (UpgradeScenarioUtil.isYinglong() && UpgradeScenarioUtil.isOutBound()) {
            LOGGER.info("now wait 120s till iBMC restarted successfully...");
            ConnUtils.sleep((int)120000);
        } else {
            LOGGER.info("now wait iBMC restarted ...");
        }
        long currentTime = System.currentTimeMillis();
        while ((System.currentTimeMillis() - currentTime) / 1000L < 900L) {
            ConnUtils.sleep((int)10000);
            try {
                this.getCurrentDevicePowerStatus();
                return new OperationResultEntity(true, "");
            }
            catch (UMateException ignored) {
                LOGGER.error("system not ready yet.");
            }
        }
        LOGGER.error("timeout waiting for iBMC restart!!!!");
        return new OperationResultEntity(false, RES.getString("restart.iBMC.failed"));
    }

    public String getDeviceSlotId() {
        String slotInfo = "";
        RedfishResult result = this.redfishConnestion.executeGet("/redfish/v1/Managers/");
        if (!result.isSuccess()) {
            return slotInfo;
        }
        if (RedfishUtils.hasKeyObject((String)result.getResult(), (String[])new String[]{"Members"})) {
            JSONArray array = (JSONArray)RedfishUtils.getObjectAttr((String)result.getResult(), JSONArray.class, (String[])new String[]{"Members"});
            slotInfo = array == null || array.size() == 0 ? null : array.getJSONObject(0).getString("@odata.id");
            return StringUtils.isNULLStr((String)slotInfo) ? "" : slotInfo.split("/")[4];
        }
        return slotInfo;
    }
}

