/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.bundleupgrade.service.system.impl;

import com.huawei.bundleupgrade.constants.UpgradeParamConstants;
import com.huawei.bundleupgrade.entity.OperationResultEntity;
import com.huawei.bundleupgrade.entity.UpgradeDeviceEntity;
import com.huawei.bundleupgrade.service.connection.fusionstrg.FusionStorageSshConnector;
import com.huawei.bundleupgrade.service.connection.fusionstrg.FusionStorageSshPool;
import com.huawei.bundleupgrade.service.system.IPowerOperationService;
import com.huawei.bundleupgrade.service.system.impl.PowerOperationRedFishService;
import com.huawei.bundleupgrade.utils.BundleUpgradeContext;
import com.huawei.bundleupgrade.utils.UpgradeCustomizationUtil;
import com.huawei.bundleupgrade.utils.fusionstrg.FusionStrgUpgradeContext;
import com.huawei.ism.tool.obase.connection.support.ConnUtils;
import com.huawei.uMate.common.UMateException;
import com.huawei.uMate.common.utils.ResUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PowerOperationService {
    private static final Logger log = LoggerFactory.getLogger(PowerOperationService.class);
    private static final ResUtil RES = ResUtil.getInstance((String)"BundleUpgrade");
    private List<IPowerOperationService> connections;
    private UpgradeDeviceEntity device;

    public PowerOperationService(UpgradeDeviceEntity device) throws UMateException {
        this.device = device;
        this.connections = new ArrayList<IPowerOperationService>();
        if (BundleUpgradeContext.getInstance().isBmcAuthCheckOpen() && this.device.getDeviceEntity().isSupportRedfish()) {
            this.connections.add(new PowerOperationRedFishService(this.device.getDeviceEntity()));
        }
    }

    public void powerOffUsingAllMethodsIfNowOn() throws UMateException {
        if (!BundleUpgradeContext.getInstance().isBmcAuthCheckOpen() || !this.device.getDeviceEntity().isSupportRedfish()) {
            log.info("Do not has bmc auth,ignore power off");
            return;
        }
        log.info("Powering off...");
        this.dateSync();
        for (IPowerOperationService powerService : this.connections) {
            try {
                OperationResultEntity resultEntity = powerService.powerOffDevice();
                if (!resultEntity.isPassed()) continue;
                log.info(String.format(Locale.ENGLISH, "power off using %s successfully.", powerService.getProtocolType()));
                return;
            }
            catch (UMateException | InterruptedException exception) {
                log.error(String.format(Locale.ENGLISH, "using %s to power off failed.", powerService.getProtocolType()), exception);
            }
        }
        throw new UMateException(RES.getString("power.off.failed"));
    }

    private void dateSync() {
        if (UpgradeCustomizationUtil.canConnectOs(this.device.getDeviceEntity())) {
            try {
                log.info("Strat data synchronization");
                FusionStorageSshConnector ssh = FusionStorageSshPool.getFsSshConnectionByBmcIp(this.device.getDeviceEntity().getIp());
                ssh.executeCommand("sync", 30000);
                log.info("Data synchronization success");
            }
            catch (Exception e) {
                log.warn("Data synchronization fails. Querying the version after the upgrade may fail.");
            }
            finally {
                FusionStorageSshPool.releaseFsSshConnection(FusionStrgUpgradeContext.getInstance().getFsDeviceEntityByBmcIp(this.device.getDeviceEntity().getIp()));
            }
        }
    }

    public void powerOnDeviceUsingAllMethodsIfNowOff() throws UMateException {
        if (!BundleUpgradeContext.getInstance().isBmcAuthCheckOpen() || !this.device.getDeviceEntity().isSupportRedfish()) {
            log.info("Do not has bmc auth,ignore power on.");
            return;
        }
        this.doPowerOnDevice();
        this.sleepAndWait4SystemRestarted();
    }

    private void doPowerOnDevice() throws UMateException {
        boolean isSignalSent = false;
        for (IPowerOperationService powerService : this.connections) {
            try {
                OperationResultEntity resultEntity = powerService.powerOnDevice();
                if (resultEntity.isPassed()) {
                    log.info(String.format(Locale.ENGLISH, "[device %s] successfully powered on using %s.", this.device.getDeviceEntity().getIp(), powerService.getProtocolType()));
                    isSignalSent = true;
                    break;
                }
                log.warn(String.format(Locale.ENGLISH, "[device %s] failed to power on using %s, now try others.", this.device.getDeviceEntity().getIp(), powerService.getProtocolType()));
                ConnUtils.sleep((int)10000);
            }
            catch (UMateException | InterruptedException exception) {
                log.error("exception occurred execution power on command.", exception);
            }
        }
        if (!isSignalSent) {
            throw new UMateException(RES.getString("power.on.operation.not.valid.after.upgrade"));
        }
    }

    private void sleepAndWait4SystemRestarted() throws UMateException {
        ConnUtils.sleep((int)10000);
        log.info(" now try to check whether device is already in power on status");
        for (IPowerOperationService powerService : this.connections) {
            try {
                if (!this.queryPowerStatus(powerService)) continue;
                return;
            }
            catch (UMateException | InterruptedException exception) {
                log.error(String.format(Locale.ENGLISH, "get power status using %s failed.", powerService.getProtocolType()), exception);
            }
        }
        throw new UMateException(RES.getString("get.power.status.failed") + RES.getString("power.on.operation.not.valid.after.upgrade"));
    }

    boolean queryPowerStatus(IPowerOperationService powerService) throws UMateException, InterruptedException {
        boolean isTimeout = this.getPowerStatusWithRetry(powerService);
        if (powerService.getCurrentDevicePowerStatus() == UpgradeParamConstants.PowerStatus.POWER_IS_ON) {
            log.info("get power status on");
            return true;
        }
        if (!isTimeout) {
            ConnUtils.sleep((int)30000);
            this.getPowerStatusWithRetry(powerService);
            if (powerService.getCurrentDevicePowerStatus() == UpgradeParamConstants.PowerStatus.POWER_IS_ON) {
                log.info("get power status on");
                return true;
            }
        }
        return false;
    }

    boolean getPowerStatusWithRetry(IPowerOperationService powerService) throws UMateException, InterruptedException {
        long firstTime = System.currentTimeMillis();
        int retryCount = 0;
        boolean isTimeout = true;
        while (System.currentTimeMillis() - firstTime < 600000L) {
            UpgradeParamConstants.PowerStatus status = powerService.getCurrentDevicePowerStatus();
            log.info(String.format(Locale.ENGLISH, "time %s get power status %s", retryCount++, status.name()));
            if (UpgradeParamConstants.PowerStatus.POWER_IS_ON.equals((Object)status)) {
                isTimeout = false;
                break;
            }
            this.doPowerOnDevice();
            ConnUtils.sleep((int)10000);
        }
        return isTimeout;
    }

    public void restartIBMCModuleAfterUpgrade() throws UMateException {
        log.info("now start to restart IBMC after upgrade iBMC script executed.");
        boolean isCmdSent = false;
        for (IPowerOperationService powerService : this.connections) {
            try {
                OperationResultEntity resultEntity = powerService.sendRestartIBMCSignal();
                if (!resultEntity.isPassed()) continue;
                log.info(String.format(Locale.ENGLISH, "send IBMC restart signal using %s successfully.", powerService.getProtocolType()));
                isCmdSent = true;
                break;
            }
            catch (UMateException | InterruptedException e) {
                log.error("exception occurred on restart iBMC after script finished.", e);
            }
        }
        if (!isCmdSent) {
            throw new UMateException(RES.getString("restart.IBMC.after.upgrade.failed"));
        }
        this.wait4BmcEnable2QueryPowerStatus();
    }

    public void wait4BmcEnable2QueryPowerStatus() throws UMateException {
        log.info("now waiting for BMC restart finish.");
        for (IPowerOperationService powerService : this.connections) {
            try {
                OperationResultEntity resultEntity = powerService.waitTillIBMCModuleRestarted();
                if (!resultEntity.isPassed()) continue;
                log.info(String.format(Locale.ENGLISH, "iBMC restart successfully using %s.", powerService.getProtocolType()));
                return;
            }
            catch (InterruptedException e) {
                log.error("exception occurred on restart iBMC after script finished.", (Throwable)e);
            }
        }
    }

    public void rebootDevice() throws UMateException {
        FusionStorageSshConnector ssh = FusionStorageSshPool.getFsSshConnectionByBmcIp(this.device.getDeviceEntity().getIp());
        try {
            if (!ssh.isConnected()) {
                log.error("Network disconnected, please try again later.");
                throw new UMateException(RES.getString("node.connect.error"));
            }
            ssh.executeCmd("reboot");
            log.info("reboot device successfully");
        }
        catch (Exception e) {
            log.error("Unknown error occurred during restart");
            throw new UMateException(RES.getString("node.reboot.error"));
        }
        finally {
            FusionStorageSshPool.releaseFsSshConnection(FusionStrgUpgradeContext.getInstance().getFsDeviceEntityByBmcIp(this.device.getDeviceEntity().getIp()));
        }
    }
}

