/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.bundleupgrade.tasks;

import com.huawei.bundleupgrade.constants.BundleUpgradeConstants;
import com.huawei.bundleupgrade.constants.UpgradeParamConstants;
import com.huawei.bundleupgrade.entity.DeviceEntity;
import com.huawei.bundleupgrade.entity.FirmwarePackageEntity;
import com.huawei.bundleupgrade.entity.OperationResultEntity;
import com.huawei.bundleupgrade.entity.RetimerTypeEnum;
import com.huawei.bundleupgrade.entity.ScriptResultEntity;
import com.huawei.bundleupgrade.entity.UpgradeDeviceEntity;
import com.huawei.bundleupgrade.entity.UpgradeStrategyEntity;
import com.huawei.bundleupgrade.entity.fusionstrg.UpgDeviceExtendFSDataEntity;
import com.huawei.bundleupgrade.model.ExecuteInfo;
import com.huawei.bundleupgrade.model.ExecuteResult;
import com.huawei.bundleupgrade.service.DeviceInfoByRedfishService;
import com.huawei.bundleupgrade.service.QueryDeviceInfoService;
import com.huawei.bundleupgrade.service.connection.SSHAndSFTPConnectionPool;
import com.huawei.bundleupgrade.service.connection.fusionstrg.FusionStorageRestConnector;
import com.huawei.bundleupgrade.service.connection.fusionstrg.FusionStorageSshConnector;
import com.huawei.bundleupgrade.service.connection.fusionstrg.FusionStorageSshPool;
import com.huawei.bundleupgrade.service.impl.DiskUpgradeByDiskToolImpl;
import com.huawei.bundleupgrade.service.impl.FusionStorageCheckService;
import com.huawei.bundleupgrade.service.impl.NVMeDiskUpgradeServiceImpl;
import com.huawei.bundleupgrade.service.impl.OutBandUpgradeServiceServiceImpl;
import com.huawei.bundleupgrade.service.impl.PanGeaInBandUpgradeServiceImpl;
import com.huawei.bundleupgrade.service.impl.PcieUpgradeServiceImpl;
import com.huawei.bundleupgrade.service.impl.VerifyVersionImpl;
import com.huawei.bundleupgrade.service.system.impl.PowerOperationRedFishService;
import com.huawei.bundleupgrade.service.system.impl.PowerOperationService;
import com.huawei.bundleupgrade.tasks.PoolUpgradeTask;
import com.huawei.bundleupgrade.ui.BundleUpgradeMainDialog;
import com.huawei.bundleupgrade.ui.IUpgradeUiObserver;
import com.huawei.bundleupgrade.utils.BundleUpgradeContext;
import com.huawei.bundleupgrade.utils.FsmNode;
import com.huawei.bundleupgrade.utils.NodeServiceUtils;
import com.huawei.bundleupgrade.utils.SHAAndRSASignCheckUtil;
import com.huawei.bundleupgrade.utils.ScriptConfigUtil;
import com.huawei.bundleupgrade.utils.ScriptExecuteUtil;
import com.huawei.bundleupgrade.utils.ServiceUtil;
import com.huawei.bundleupgrade.utils.SwitchActiveNodeUtils;
import com.huawei.bundleupgrade.utils.UpgradeCustomizationUtil;
import com.huawei.bundleupgrade.utils.UpgradeScenarioUtil;
import com.huawei.bundleupgrade.utils.fusionstrg.FusionStrgUpgradeContext;
import com.huawei.ism.tool.distributedfwupg.utils.CommonUtils;
import com.huawei.ism.tool.obase.connection.support.ConnUtils;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.obase.utils.ZipUtils;
import com.huawei.ism.tool.protocol.rest.RestConnection;
import com.huawei.ism.tool.protocol.rest.RestConnectionManager;
import com.huawei.ism.tool.protocol.rest.entity.ResponseInfo;
import com.huawei.ism.tool.protocol.utils.RestUtil;
import com.huawei.ism.tool.service.rest.model.entity.SwitchoverEnum;
import com.huawei.ism.tool.service.rest.query.NodePoolService;
import com.huawei.json.JSONArray;
import com.huawei.json.JSONObject;
import com.huawei.uMate.common.SystemConfig;
import com.huawei.uMate.common.UMateException;
import com.huawei.uMate.common.file.FileOperation;
import com.huawei.uMate.common.utils.ResUtil;
import com.huawei.uMate.common.utils.VersionCompartor;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeviceUpgradeMainTask
implements Callable<UpgradeDeviceEntity> {
    private static final Logger log = LoggerFactory.getLogger(DeviceUpgradeMainTask.class);
    private static final long DOWNLOAD_FIRMWARE_MAX_TIME_MILLS = 600000L;
    private static final String STEP_OPERATION_SUCC_MSG = "step.operation.basic.succ";
    private static final Object LOCK = new Object();
    private static final ReentrantLock REENTRANT_LOCK = new ReentrantLock();
    private static final ResUtil RES = ResUtil.getInstance((String)"BundleUpgrade");
    private static final String FIRMWARE_PACKAGE_DIR = "firmwarePackages";
    private static final String APP_TMP_PATH = ApplicationContext.getInstance().getTmpPath();
    private static final String UPGRADE_SUB_PROCESS_TITLE = "upgrade.sub.process.title";
    private boolean anyOneModuleNeedUpgrade = false;
    private UpgradeDeviceEntity device;
    private String localExecTmpDir = null;
    private IUpgradeUiObserver uiObserver;
    private BundleUpgradeMainDialog mainDialog;
    private CountDownLatch countDownLatch;

    public DeviceUpgradeMainTask(UpgradeDeviceEntity deviceEntity, IUpgradeUiObserver uiObserver) {
        this(deviceEntity, uiObserver, null);
    }

    public DeviceUpgradeMainTask(UpgradeDeviceEntity deviceEntity, IUpgradeUiObserver uiObserver, CountDownLatch countDownLatch) {
        this.device = deviceEntity;
        this.uiObserver = uiObserver;
        this.mainDialog = BundleUpgradeContext.getInstance().getMainDialog();
        this.countDownLatch = countDownLatch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpgradeDeviceEntity call() throws InterruptedException {
        String oldThreadName = Thread.currentThread().getName();
        FusionStorageCheckService fsService = new FusionStorageCheckService(this.device);
        try {
            Thread.currentThread().setName("UpgradeTask_" + this.device.getDeviceEntity().getIp());
            UpgradeStrategyEntity strategy = this.getStrategy();
            this.setDeviceStartTime();
            if (!this.execTask(fsService, strategy)) {
                log.error("Task exec failed.");
                UpgradeDeviceEntity upgradeDeviceEntity = this.device;
                return upgradeDeviceEntity;
            }
            this.composeDeviceExecutionResult(null);
            UpgradeDeviceEntity upgradeDeviceEntity = this.device;
            return upgradeDeviceEntity;
        }
        catch (UMateException excp) {
            log.error(">>>> error occurred: ", (Throwable)excp);
            this.composeDeviceExecutionResult(excp.getMessage());
        }
        catch (InterruptedException excp) {
            log.error(String.format(Locale.ENGLISH, "[Device %s]DeviceUpgradeMainTask was interrupted!", this.device.getDeviceEntity().getIp()));
            this.composeDeviceExecutionResult(RES.getString("system.interrupted"));
            throw excp;
        }
        catch (Exception exception) {
            log.error(String.format(Locale.ENGLISH, "[device %s]exception occurred on device upgrade.", this.device.getDeviceEntity().getIp()), (Throwable)exception);
            this.composeDeviceExecutionResult(RES.getString("unknown.exception.occurred"));
        }
        finally {
            if (this.device.getProcessStatus().equals((Object)UpgradeParamConstants.UpgradeStatus.COMPLETED) || this.device.getProcessStatus().equals((Object)UpgradeParamConstants.UpgradeStatus.UPGRADE_PARTIAL_SUCCESS)) {
                this.device.setRebootTask(false);
            }
            this.refreshedfinishDev();
            this.onSubHealthIsolation();
            SSHAndSFTPConnectionPool.releaseConnection(this.device.getDeviceEntity());
            Thread.currentThread().setName(oldThreadName);
        }
        return this.device;
    }

    private void endIgnoreUpgradeTask() {
        if (!this.canIgnoreUpgrade()) {
            return;
        }
        try {
            log.info("Device {} is ignored and no further action is required.", (Object)this.device.getDeviceEntity().getIp());
        }
        finally {
            if (this.countDownLatch != null) {
                this.countDownLatch.countDown();
            }
            this.device.setRebootTask(false);
        }
    }

    private boolean canIgnoreUpgrade() {
        boolean needPreCheck = Boolean.parseBoolean(CommonUtils.getSystemConfig("is.execute.version.pre.check", "true"));
        boolean isIgnoreStatus = UpgradeParamConstants.UpgradeStatus.NOT_EXECUTED.equals((Object)this.device.getProcessStatus());
        boolean precheckFinish = this.device.isPrecheckFinish();
        log.info("Device: {} Reuslt,needPreCheck: {} isIgnoreStatus: {},precheckFinish: {}", new Object[]{this.device.getDeviceEntity().getIp(), needPreCheck, isIgnoreStatus, precheckFinish});
        return needPreCheck && precheckFinish && !this.anyOneModuleNeedUpgrade && isIgnoreStatus;
    }

    private void onSubHealthIsolation() {
        if (UpgradeScenarioUtil.isYinglong()) {
            return;
        }
        List<UpgradeDeviceEntity> toUpgradeDevs = BundleUpgradeContext.getInstance().getDeviceUpgradeInfos();
        if (toUpgradeDevs.stream().anyMatch(UpgradeDeviceEntity::isUpgrading)) {
            log.info("other device is upgrading, wait to finish.");
            return;
        }
        this.setHealthIsolationOn();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setHealthIsolationOn() {
        DevNode devNode = FusionStorageRestConnector.buildDevNode(FusionStrgUpgradeContext.getInstance().getBusinessIpMapper().get(this.device).getBelongsClusterEntity());
        Object object = LOCK;
        synchronized (object) {
            try {
                RestConnection rest = RestConnectionManager.getRestConnection((DevNode)devNode);
                this.executeCmd(devNode, rest);
            }
            catch (ToolException e) {
                log.error("init connection for {}, cause:", (Object)devNode.getIp(), (Object)e);
            }
            finally {
                RestConnectionManager.releaseConn((DevNode)devNode);
            }
        }
    }

    private void executeCmd(DevNode devNode, RestConnection rest) {
        String url = RestUtil.getDstorageBaseUrl((DevNode)devNode) + "/network_service/isolation";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("action", "on");
        for (String managerIp : FusionStrgUpgradeContext.getInstance().getOffHealthIsolationList()) {
            params.put("management_ip", managerIp);
            try {
                ResponseInfo responseInfo = rest.execPut(url, params);
                log.info("Device {} execute cmd result :{}", (Object)managerIp, (Object)responseInfo.getContent());
            }
            catch (ToolException e) {
                log.error("Exec action on error for {},cause:", (Object)managerIp, (Object)e);
            }
        }
    }

    private void setDeviceStartTime() {
        if (!Objects.isNull(this.device.getStartTaskTime())) {
            return;
        }
        log.info("The upgrade task of node {} starts", (Object)this.device.getDeviceEntity().getIp());
        this.device.setStartTaskTime(new Date());
    }

    private boolean execTask(FusionStorageCheckService fsService, UpgradeStrategyEntity strategy) throws UMateException, InterruptedException {
        if (!this.device.isRebootTask()) {
            log.info("Start exec upgrade task.");
            this.cleanUpUIAndPreparations(strategy);
            this.device.setOnlineFirmwareUpgraded(false);
            boolean result = this.executeUpgrade(strategy, true);
            this.device.setOnlineFirmwareUpgraded(result);
            if (!this.device.needOffLineUpgrade()) {
                this.refreshAllFirmwaresCurrentVersion();
            }
            return result;
        }
        return this.execRebootTask(fsService, strategy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean execRebootTask(FusionStorageCheckService fsService, UpgradeStrategyEntity strategy) throws UMateException, InterruptedException {
        boolean success = true;
        try {
            UpgradeCustomizationUtil.upgradeSesWhenVnodeEcPool(fsService, strategy, this.device, this.getFusionStoragePreAndPostProcessProgress());
            if (!this.device.needOffLineUpgrade() || this.device.isOnlyUpgradeSesInVnodeEc()) {
                this.refreshAllFirmwaresCurrentVersion();
                boolean bl = success;
                return bl;
            }
            this.device.setProcessStatus(UpgradeParamConstants.UpgradeStatus.RUNNING);
            this.mainDialog.refreshTable(this.device);
            log.info("Start exec reboot task.");
            success = !this.device.isPlaneNode() ? this.execStorageRebootTask(fsService, strategy) : this.execPlaneNodeRebootTask(fsService, strategy);
            if (success) {
                this.refreshAllFirmwaresCurrentVersion();
            }
        }
        finally {
            this.mainDialog.refreshTable(this.device);
            if (this.countDownLatch != null) {
                this.countDownLatch.countDown();
            }
        }
        return success;
    }

    private boolean execPlaneNodeRebootTask(FusionStorageCheckService fsService, UpgradeStrategyEntity strategy) throws UMateException, InterruptedException {
        this.localExecTmpDir = this.createLocalExecutionTmpPath();
        this.device.getFirmRebootResult().setResultMsg("");
        this.device.getUpgradeDetails().clear();
        if (!fsService.directPlaneUpgradeCheck()) {
            this.device.setProcessStatus(UpgradeParamConstants.UpgradeStatus.FAILED);
            this.device.getFirmRebootResult().setResultMsg(RES.getString("bundle.upgrade.check.portStatus.failed"));
            this.terminateAllDeviceTasksInSamePool();
            return false;
        }
        if (!this.stepUpgradeOfflineModules(strategy)) {
            return false;
        }
        if (!this.device.needReboot()) {
            this.updateLastProcessDetailsProgress(RES.getString(STEP_OPERATION_SUCC_MSG), 95.0, true);
            log.info("Current strategy do not need reboot.");
            return true;
        }
        this.drawNewProgress("step.power.device.reboot");
        log.info("now reboot device with out-band and in-band modules");
        try {
            this.setWatchDogwhenUpgradeSp(strategy, 80.0);
            this.doReboot();
        }
        catch (UMateException e) {
            log.error("Exec reboot failed.", (Throwable)e);
            String msg = e.getMessage();
            this.device.getFirmRebootResult().setResultMsg(msg);
            this.device.setProcessStatus(UpgradeParamConstants.UpgradeStatus.FAILED);
            this.updateLastProcessDetailsProgress(msg, 95.0, false);
            this.terminateAllDeviceTasksInSamePool();
            return false;
        }
        this.updateLastProcessDetailsProgress(RES.getString(STEP_OPERATION_SUCC_MSG), 95.0, true);
        return true;
    }

    private void setWatchDogwhenUpgradeSp(UpgradeStrategyEntity strategy, Double rebootProgress) throws UMateException {
        PcieUpgradeServiceImpl pcieUpgrade;
        OperationResultEntity resultEntity;
        List<UpgradeParamConstants.ModuleType> moduleTypes = strategy.getUpgradeOrders().stream().flatMap(Collection::stream).collect(Collectors.toList());
        if (UpgradeScenarioUtil.isSpModule(moduleTypes) && !(resultEntity = (pcieUpgrade = new PcieUpgradeServiceImpl(this.device)).setStartBySpWhenUpgradeSp(this.device, rebootProgress)).isPassed()) {
            this.updateLastProcessDetailsProgress(resultEntity.getReturnParam(), this.getLastProcessProgress(), false);
            throw new UMateException(resultEntity.getReturnParam());
        }
    }

    private boolean execStorageRebootTask(FusionStorageCheckService fsService, UpgradeStrategyEntity strategy) throws UMateException, InterruptedException {
        this.stepPrepareReboot(strategy);
        if (!this.stepConsistencyCheck()) {
            return false;
        }
        if (!this.stepOfflineStorageNode(fsService, strategy)) {
            return false;
        }
        if (!this.stepUpgradeOfflineModules(strategy)) {
            return false;
        }
        this.stepReboot(strategy);
        return this.stepOnlineStorageNode(fsService);
    }

    private boolean stepOfflineStorageNode(FusionStorageCheckService fsService, UpgradeStrategyEntity strategy) throws UMateException {
        if (UpgradeScenarioUtil.isYinglong()) {
            return true;
        }
        this.device.setProcessStatus(UpgradeParamConstants.UpgradeStatus.REBOOT);
        if (!this.offlineStorageNode(fsService, strategy)) {
            this.terminateAllDeviceTasksInSamePool();
            this.device.setProcessStatus(UpgradeParamConstants.UpgradeStatus.FAILED);
            log.error("offline device error");
            return false;
        }
        return true;
    }

    private boolean stepConsistencyCheck() {
        if (UpgradeScenarioUtil.isYinglong()) {
            return true;
        }
        this.drawNewProgress("step.power.device.reboot.precheck");
        if (NodeServiceUtils.checkServiceInfoOrStoragePoolChange(this.device)) {
            this.device.getFirmRebootResult().setResultMsg(RES.getString("step.power.device.change.failed"));
            this.composeDeviceExecutionResult(RES.getString("step.power.device.change.failed") + RES.getString("step.power.device.change.failed.tips"));
            log.error("check service change failed");
            return false;
        }
        if (UpgradeCustomizationUtil.isContainsSsdSp(this.getStrategy()) && !UpgradeCustomizationUtil.checkCanUpgradeSsdSp(this.device)) {
            String msg = RES.getStringWithParams("step.power.device.change.info", new Object[]{UpgradeParamConstants.ModuleType.SSD_SP.getModule()});
            this.device.setProcessStatus(UpgradeParamConstants.UpgradeStatus.NOT_INVOLVED);
            this.mainDialog.updateResult(this.device, msg, this.getFusionStoragePreAndPostProcessProgress(), UpgradeParamConstants.SubProcessExecutionResult.NOT_INVOLVED, msg);
            return false;
        }
        this.updateLastProcessDetailsProgress(RES.getString(STEP_OPERATION_SUCC_MSG), this.getFusionStoragePreAndPostProcessProgress(), true);
        return true;
    }

    private boolean stepCheckPoolRatio(UpgradeStrategyEntity strategy) {
        if (!this.needCheckPoolFreeRatio(strategy)) {
            return true;
        }
        this.drawNewProgress("step.power.device.pool.ratio");
        ScriptResultEntity scriptResultEntity = this.executePoolRatioCheck();
        if (scriptResultEntity.getExecResult() != UpgradeParamConstants.ScriptResultStatus.PASS) {
            this.device.getFirmRebootResult().setResultMsg(RES.getString("step.power.device.pool.ratio.failed"));
            this.composeDeviceExecutionResult(RES.getString("step.power.device.pool.ratio.failed") + "\n" + scriptResultEntity.getErrReason());
            log.error("pool ratio check failed");
            return false;
        }
        this.updateLastProcessDetailsProgress(RES.getString("step.power.device.pool.ratio.succeed"), this.getFusionStoragePreAndPostProcessProgress(), true);
        return true;
    }

    private boolean needCheckPoolFreeRatio(UpgradeStrategyEntity strategy) {
        String productVer = ServiceUtil.getFSClusterVersion(this.device);
        String supportVersion = SystemConfig.createSystemConfig().getConfigVlaue("fw.pool.ratio.check.support.version");
        if (StringUtils.isNULLStr((String)supportVersion)) {
            return false;
        }
        boolean isSupportVersion = Arrays.stream(supportVersion.trim().split(";")).anyMatch(productVer::contains);
        boolean isNeeCheck = Boolean.parseBoolean(SystemConfig.createSystemConfig().getConfigVlaue("fw.pool.ratio.check"));
        boolean isContainsDriveModule = strategy.getUpgradeOrders().stream().flatMap(Collection::stream).anyMatch(moduleType -> UpgradeParamConstants.ModuleType.getDiskModule().contains(moduleType));
        return isNeeCheck && isContainsDriveModule && isSupportVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ScriptResultEntity executePoolRatioCheck() {
        String sourceScript = this.intoCanonicalScriptPath(ScriptConfigUtil.getScriptRelativePath("fusionStorage", "poolRatiocheck"));
        try {
            FusionStorageSshConnector ssh = FusionStorageSshPool.getFsSshConnectionByBmcIp(this.device.getDeviceEntity().getIp());
            List<String> scriptResult = ScriptExecuteUtil.uploadAndExecuteScript(ssh, ScriptExecuteUtil.ScriptType.SHELL, sourceScript, "/tmp/SmartKitScript");
            String executeResult = this.parseResult(scriptResult);
            String resultToOneLine = scriptResult.stream().collect(Collectors.joining("\n"));
            String rstPath = ScriptConfigUtil.getScriptRelativePath("result", "poolRatiocheck");
            String rstResult = ScriptExecuteUtil.catRstFile(ssh, rstPath);
            ScriptExecuteUtil.removeDir(ssh, "/tmp/SmartKitScript");
            if (executeResult.equals("0")) {
                ScriptResultEntity scriptResultEntity = new ScriptResultEntity(UpgradeParamConstants.ScriptResultStatus.PASS, RES.getStringWithParams("step.power.device.pool.ratio.result", new Object[]{resultToOneLine, rstResult}));
                return scriptResultEntity;
            }
            ScriptResultEntity scriptResultEntity = new ScriptResultEntity(UpgradeParamConstants.ScriptResultStatus.FAILED, RES.getStringWithParams("step.power.device.pool.ratio.result", new Object[]{resultToOneLine, rstResult}));
            return scriptResultEntity;
        }
        catch (UMateException e) {
            log.error("get ssh connector fail.", (Throwable)e);
        }
        finally {
            FusionStorageSshPool.releaseFsSshConnection(FusionStrgUpgradeContext.getInstance().getFsDeviceEntityByBmcIp(this.device.getDeviceEntity().getIp()));
        }
        return new ScriptResultEntity(UpgradeParamConstants.ScriptResultStatus.FAILED, ScriptExecuteUtil.EXECUTE_FAIL);
    }

    private String parseResult(List<String> scriptResult) {
        return scriptResult.stream().filter(resultLine -> resultLine.contains("result=")).findFirst().map(result -> result.replace("result=", "").trim()).orElse("-1");
    }

    private void stepPrepareReboot(UpgradeStrategyEntity strategy) throws UMateException, InterruptedException {
        this.drawNewProgress("step.precheck.of.reboot");
        this.clearOfflineUpgradeDetails(strategy);
        this.rebootIBMCBeforeUpgradeIfRequired();
        this.updateLastProcessDetailsProgress(RES.getString(STEP_OPERATION_SUCC_MSG), this.getFusionStoragePreAndPostProcessProgress(), true);
    }

    private boolean stepOnlineStorageNode(FusionStorageCheckService fsService) throws UMateException {
        if (UpgradeScenarioUtil.isYinglong()) {
            return true;
        }
        if (!this.onlineStorageNode(fsService)) {
            this.device.setProcessStatus(UpgradeParamConstants.UpgradeStatus.FAILED);
            this.terminateAllDeviceTasksInSamePool();
            return false;
        }
        String errorMsg = this.failBackNode(fsService);
        if (!this.refreshFusionStorageOperationResult(errorMsg)) {
            this.device.setProcessStatus(UpgradeParamConstants.UpgradeStatus.FAILED);
            this.terminateAllDeviceTasksInSamePool();
            return false;
        }
        return true;
    }

    private void stepReboot(UpgradeStrategyEntity strategy) throws UMateException {
        try {
            this.setWatchDogwhenUpgradeSp(strategy, 80.0);
            if (this.device.needReboot()) {
                this.offOrOnSubHealthIsolation("off");
                this.executeReboot();
            }
        }
        catch (UMateException exception) {
            this.terminateAllDeviceTasksInSamePool();
            throw exception;
        }
    }

    private boolean stepUpgradeOfflineModules(UpgradeStrategyEntity strategy) throws UMateException, InterruptedException {
        if (UpgradeScenarioUtil.isYinglong()) {
            return true;
        }
        try {
            if (!this.executeUpgrade(strategy, false)) {
                this.terminateAllDeviceTasksInSamePool();
                return false;
            }
        }
        catch (UMateException | InterruptedException exception) {
            this.terminateAllDeviceTasksInSamePool();
            throw exception;
        }
        return true;
    }

    private void offOrOnSubHealthIsolation(String action) {
        if (UpgradeScenarioUtil.isYinglong()) {
            return;
        }
        try {
            UpgDeviceExtendFSDataEntity fsDataEntity = FusionStrgUpgradeContext.getInstance().getBusinessIpMapper().get(this.device);
            String managerIp = FusionStrgUpgradeContext.getInstance().getFsDeviceEntityByBmcIp(this.device.getDeviceEntity().getIp()).getManagementIp();
            if ("off".equals(action)) {
                FusionStrgUpgradeContext.getInstance().getOffHealthIsolationList().add(managerIp);
            }
            DevNode devNode = FusionStorageRestConnector.buildDevNode(fsDataEntity.getBelongsClusterEntity());
            RestConnection rest = RestConnectionManager.getRestConnection((DevNode)devNode);
            String url = RestUtil.getDstorageBaseUrl((DevNode)devNode) + "/network_service/isolation";
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("action", action);
            params.put("management_ip", managerIp);
            ResponseInfo responseInfo = rest.execPut(url, params);
            log.info("Exec action {} result {} .", (Object)action, (Object)responseInfo.getContent());
        }
        catch (Exception e) {
            log.error("Exec action {} failed.", (Object)action);
        }
    }

    private void refreshedfinishDev() {
        if (this.device.isUpdEnd()) {
            this.mainDialog.getMainPanel().getTableContentPane().finishOneDev();
        }
    }

    private void terminateAllDeviceTasksInSamePool() {
        log.error("Due to Fusion Storage's demand, all other devices of the same pool should be terminated.");
        if (this.device.isNodeC()) {
            log.error("The device is no service, no need to terminited other devices.");
            return;
        }
        String poolId = this.device.getDeviceEntity().getPoolId();
        if (this.device.isNodeB()) {
            poolId = "serviceBType";
        }
        Map<String, PoolUpgradeTask> poolUpgradeTaskMap = FusionStrgUpgradeContext.getInstance().getPoolTaskMap();
        PoolUpgradeTask poolUpgradeTask = poolUpgradeTaskMap.get(poolId);
        poolUpgradeTask.cancelPoolTask();
        List<UpgradeDeviceEntity> samePoolDevices = this.getSamePoolDevices();
        for (UpgradeDeviceEntity entity : samePoolDevices) {
            if (!UpgradeParamConstants.UpgradeStatus.WAIT_REBOOT.equals((Object)entity.getProcessStatus())) continue;
            this.refreshDevice2Abort(entity);
        }
    }

    private List<UpgradeDeviceEntity> getSamePoolDevices() {
        ArrayList<UpgradeDeviceEntity> samePoolDevices = new ArrayList<UpgradeDeviceEntity>();
        for (UpgradeDeviceEntity entity : BundleUpgradeContext.getInstance().getDeviceUpgradeInfos()) {
            if (this.device.isNodeB() && entity.isNodeB()) {
                samePoolDevices.add(entity);
                continue;
            }
            if (!this.device.isParallelByPoolId() || !this.device.getDeviceEntity().getPoolId().equals(entity.getDeviceEntity().getPoolId())) continue;
            samePoolDevices.add(entity);
        }
        return samePoolDevices;
    }

    private void refreshDevice2Abort(UpgradeDeviceEntity entity) {
        entity.setProcessStatus(UpgradeParamConstants.UpgradeStatus.ABORT_REBOOT);
        entity.setResultMsg(RES.getStringWithParams("former.device.in.cluster.failed.restart", new Object[]{this.device.getDeviceEntity().getIp()}));
        this.mainDialog.createExecuteResult(entity, entity.getResultMsg());
        double refreshProgress = entity.getExecuteInfo().getResults().size() == 0 ? 0.0 : entity.getExecuteInfo().getResults().stream().max(Comparator.comparingDouble(ExecuteResult::getTotalProgress)).get().getTotalProgress();
        this.mainDialog.updateExecuteResult(entity, entity.getResultMsg(), (Double)refreshProgress, false);
        this.mainDialog.refreshTable(entity);
    }

    private void cleanUpUIAndPreparations(UpgradeStrategyEntity strategy) throws UMateException, InterruptedException {
        this.device.setProcessStatus(UpgradeParamConstants.UpgradeStatus.RUNNING);
        if (!this.device.isRebootTask()) {
            this.device.getExecuteInfo().getResults().clear();
            this.device.getUpgradeDetails().clear();
        }
        this.mainDialog.refreshTable(this.device);
        this.device.setStartTime(String.valueOf(System.currentTimeMillis()));
        this.drawNewProgress("step.precheck.of.upgrade");
        log.info("now checking whether all devices' upgrade packages downloaded successfully...");
        this.wait4AllUpgradePackagesDownloadedSuccessfully(strategy);
        this.localExecTmpDir = this.createLocalExecutionTmpPath();
        this.rebootIBMCBeforeUpgradeIfRequired();
        this.updateLastProcessDetailsProgress(RES.getString(STEP_OPERATION_SUCC_MSG), 1.2, true);
    }

    private boolean canUpgradAnyModule(UpgradeStrategyEntity strategy) throws UMateException {
        if (!this.device.isPrecheckFinish() && Boolean.parseBoolean(CommonUtils.getSystemConfig("is.execute.version.pre.check", "true"))) {
            this.preCheckModuleCanUpgrade(strategy);
            this.device.setPrecheckFinish(true);
            if (this.anyOneModuleNeedUpgrade) {
                log.info("Device {} Pre-check pass, Continue the upgrade", (Object)this.device.getDeviceEntity().getIp());
                return true;
            }
            log.info("Device {} no component can be upgraded,end", (Object)this.device.getDeviceEntity().getIp());
            return false;
        }
        log.info("Device {} No pre-check required, Continue the upgrade", (Object)this.device.getDeviceEntity().getIp());
        return true;
    }

    private void clearOfflineUpgradeDetails(UpgradeStrategyEntity strategy) {
        if (UpgradeScenarioUtil.isYinglong()) {
            return;
        }
        List offlineUpgradeModulesList = this.filterModulesByUpgradeMode(strategy, false).stream().flatMap(Collection::stream).collect(Collectors.toList());
        Map<UpgradeParamConstants.ModuleType, List<UpgradeDeviceEntity.FirmUpgradeResult>> upgradedDetails = this.device.getUpgradeDetails();
        Iterator<Map.Entry<UpgradeParamConstants.ModuleType, List<UpgradeDeviceEntity.FirmUpgradeResult>>> it = upgradedDetails.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<UpgradeParamConstants.ModuleType, List<UpgradeDeviceEntity.FirmUpgradeResult>> item = it.next();
            UpgradeParamConstants.ModuleType detailKey = item.getKey();
            if (!offlineUpgradeModulesList.stream().anyMatch(detailKey::equals)) continue;
            it.remove();
        }
    }

    private UpgradeStrategyEntity getStrategy() {
        return BundleUpgradeContext.getInstance().getStrategyEntityMap().get(this.device.getAssociatedStrategyId());
    }

    private void executeReboot() throws UMateException {
        UpgradeStrategyEntity strategy = this.getStrategy();
        List<List<UpgradeParamConstants.ModuleType>> upgradeOrders = strategy.getUpgradeOrders();
        boolean containInBandModule = upgradeOrders.stream().anyMatch(UpgradeScenarioUtil::containsInBandModuleUpgrade);
        this.drawNewProgress("step.power.device.reboot");
        log.info("now reboot device with out-band and in-band modules");
        this.rebootDevice(upgradeOrders);
        this.updateLastProcessDetailsProgress(RES.getString(STEP_OPERATION_SUCC_MSG), 80.0, true);
        if (containInBandModule) {
            PcieUpgradeServiceImpl pcieUpgrade = new PcieUpgradeServiceImpl(this.device);
            pcieUpgrade.afterUpgradeOperation(this.device, 90.0);
        } else if (upgradeOrders.stream().anyMatch(UpgradeScenarioUtil::isSpModule)) {
            PcieUpgradeServiceImpl pcieUpgrade = new PcieUpgradeServiceImpl(this.device);
            pcieUpgrade.afterUpgradeSpOperation(this.device, strategy, 90.0);
        }
    }

    private void rebootDevice(List<List<UpgradeParamConstants.ModuleType>> upgradeOrders) throws UMateException {
        if (upgradeOrders.stream().allMatch(UpgradeScenarioUtil::containsRebootBySshModules)) {
            this.doRebootBySsh();
            return;
        }
        this.doReboot();
    }

    private void doReboot() throws UMateException {
        PowerOperationService powerOperationService = new PowerOperationService(this.device);
        powerOperationService.powerOffUsingAllMethodsIfNowOn();
        powerOperationService.wait4BmcEnable2QueryPowerStatus();
        powerOperationService.powerOnDeviceUsingAllMethodsIfNowOff();
        this.waitForOsRestartComplete();
    }

    private void doRebootBySsh() throws UMateException {
        PowerOperationService powerOperationService = new PowerOperationService(this.device);
        powerOperationService.rebootDevice();
        this.waitForOsRestartComplete();
    }

    private boolean waitForOsRestartComplete() throws UMateException {
        if (!UpgradeCustomizationUtil.canConnectOs(this.device.getDeviceEntity())) {
            return true;
        }
        long timeOut = UpgradeScenarioUtil.getWaitingNmaRebootTimeOut() * 1000;
        long startTime = System.currentTimeMillis();
        while (System.currentTimeMillis() - startTime < timeOut) {
            try {
                FusionStorageSshPool.getFsSshConnectionByBmcIp(this.device.getDeviceEntity().getIp());
                log.info("os is ready.");
                return true;
            }
            catch (UMateException exception) {
                log.warn("os is not ready, continue to wait.");
                ServiceUtil.safeSleep(5000L);
            }
        }
        FusionStorageSshPool.releaseFsSshConnection(FusionStrgUpgradeContext.getInstance().getFsDeviceEntityByBmcIp(this.device.getDeviceEntity().getIp()));
        throw new UMateException(RES.getString("bundle.upgrade.reboot.os.timeout"));
    }

    private boolean executeUpgrade(UpgradeStrategyEntity strategy, boolean onlineUpgrade) throws UMateException, InterruptedException {
        PowerOperationService powerOperationService = new PowerOperationService(this.device);
        try {
            powerOperationService.powerOnDeviceUsingAllMethodsIfNowOff();
        }
        catch (UMateException e) {
            this.device.setProcessStatus(UpgradeParamConstants.UpgradeStatus.FAILED);
            this.drawNewProgress("step.power.device.before.upgrade.poweron");
            this.updateLastProcessDetailsProgress(e.getMessage(), this.getLastProcessProgress(), false);
            return false;
        }
        List<List<UpgradeParamConstants.ModuleType>> upgradeModulesList = strategy.getUpgradeOrders();
        if (!UpgradeScenarioUtil.isYinglong()) {
            upgradeModulesList = this.filterModulesByUpgradeMode(strategy, onlineUpgrade);
        }
        if (upgradeModulesList.isEmpty()) {
            return true;
        }
        Double totalStepLens = this.device.needOffLineUpgrade() ? 50.0 : 80.0;
        Double progressStepLen = totalStepLens / (double)Integer.max(1, strategy.getUpgradeOrders().size());
        log.info(String.format(Locale.ENGLISH, "progress step size :%s", progressStepLen));
        log.info("upgrade modules {}.", upgradeModulesList);
        for (List<UpgradeParamConstants.ModuleType> upgradeModules : upgradeModulesList) {
            if (this.device.isFinishModule(upgradeModules.stream().findFirst().orElse(UpgradeParamConstants.ModuleType.UNKNOWN))) {
                log.info("modules {} do not need upgrade", upgradeModules);
                continue;
            }
            this.upgradeCurrentModuleGroup(strategy, upgradeModules, progressStepLen);
        }
        return true;
    }

    private List<List<UpgradeParamConstants.ModuleType>> filterModulesByUpgradeMode(UpgradeStrategyEntity strategy, boolean onlineUpgrade) {
        List<UpgradeParamConstants.ModuleType> onlineModules = ServiceUtil.getOnlineUpgModuleByVer(this.device);
        if (onlineUpgrade) {
            return strategy.getUpgradeOrders().stream().filter(onlineModules::containsAll).collect(Collectors.toList());
        }
        return strategy.getUpgradeOrders().stream().filter(modules -> modules.stream().anyMatch(module -> !onlineModules.contains(module))).collect(Collectors.toList());
    }

    private void drawNewProgress(String title) {
        this.mainDialog.createExecuteResult(this.device, RES.getString(title));
    }

    private void updateLastProcessDetailsProgress(String string, double double1f2, boolean b) {
        this.mainDialog.updateExecuteResult(this.device, string, (Double)double1f2, b);
    }

    private boolean onlineStorageNode(FusionStorageCheckService fsService) throws UMateException {
        this.drawNewProgress("fusion.storage.postcheck.of.upgrade");
        String errMsg = fsService.postCheckFusionStorgeOnDeviceUpgrade(this.intoCanonicalScriptPath(ScriptConfigUtil.getScriptRelativePath("fusionStorage", "postcheck")));
        return this.refreshFusionStorageOperationResult(errMsg);
    }

    private String failBackNode(FusionStorageCheckService fsService) throws UMateException {
        if (!fsService.getSwitchOverStatus()) {
            return "";
        }
        RestConnection restConnector = fsService.getRestConnector();
        String mgrIp = fsService.getMgrIp();
        String baseUrl = fsService.getBaseUrl();
        this.drawNewProgress("node.failback");
        if (!NodePoolService.switchbackNode((RestConnection)restConnector, (String)baseUrl.concat("/dsware/service/fail_over/failback"), (String)mgrIp)) {
            return RES.getString("node.failback.startup.failed");
        }
        if (!this.needSwitchBack(restConnector, baseUrl.concat("/dsware/service/fail_over/checkfailoverstatus"), mgrIp)) {
            log.info("The current node {} does not need to be switched back.", (Object)mgrIp);
            return "";
        }
        if (!NodePoolService.taskIsCompleted((RestConnection)restConnector, (SwitchoverEnum)SwitchoverEnum.FAILBACK, (String)(baseUrl + "/dsware/service/task/queryTaskInfo"))) {
            return RES.getString("node.failback.startup.failed");
        }
        return "";
    }

    private boolean needSwitchBack(RestConnection restConnector, String url, String mgrIp) throws UMateException {
        try {
            JSONObject response = new JSONObject(restConnector.execGet(url).getContent());
            if ("0".equals(response.get("result").toString())) {
                return false;
            }
            JSONArray detail = response.getJSONArray("detail");
            ArrayList<String> errorIps = new ArrayList<String>();
            for (int index = 0; index < detail.length(); ++index) {
                errorIps.add(detail.getJSONObject(index).get("ip").toString());
            }
            return errorIps.contains(mgrIp);
        }
        catch (ToolException e) {
            throw new UMateException(RES.getString("http.connection.error.tool.exception"));
        }
    }

    private boolean refreshFusionStorageOperationResult(String errMsg) {
        if (this.device.isRebootTask()) {
            this.device.getFirmRebootResult().setResultMsg(errMsg);
        }
        if (!StringUtils.isNULLStr((String)errMsg)) {
            this.updateLastProcessDetailsProgress(errMsg, this.getLastProcessProgress(), false);
            this.composeDeviceExecutionResult(errMsg);
            return false;
        }
        this.updateLastProcessDetailsProgress(RES.getString(STEP_OPERATION_SUCC_MSG), this.getFusionStoragePreAndPostProcessProgress(), true);
        return true;
    }

    private double getFusionStoragePreAndPostProcessProgress() {
        ExecuteInfo executeInfo = this.device.getExecuteInfo();
        double totalProgress = executeInfo.getTotalProcess();
        return totalProgress += 5.0;
    }

    private boolean offlineStorageNode(FusionStorageCheckService fsService, UpgradeStrategyEntity strategy) throws UMateException {
        this.drawNewProgress(fsService.isSupportDiskPool() ? "fusion.disk.poolstatus.of.upgrade" : "fusion.storage.poolstatus.of.upgrade");
        String errMsg = fsService.preCheckPoolStatus(this.intoCanonicalScriptPath(ScriptConfigUtil.getScriptRelativePath("fusionStorage", "poolstatus")));
        if (!this.refreshFusionStorageOperationResult(errMsg)) {
            log.error(String.format(Locale.ENGLISH, "failed on precheck: %s", errMsg));
            return false;
        }
        if (!this.stepCheckPoolRatio(strategy)) {
            return false;
        }
        String errorMsg = this.nodeSwitchover(fsService);
        if (!this.refreshFusionStorageOperationResult(errorMsg)) {
            log.error(String.format(Locale.ENGLISH, "failed on precheck: %s", errMsg));
            return false;
        }
        this.drawNewProgress("fusion.storage.precheck.of.upgrade");
        errMsg = fsService.preCheckFusionStorgeOnDeviceUpgrade(this.intoCanonicalScriptPath(ScriptConfigUtil.getScriptRelativePath("fusionStorage", "precheck")));
        return this.refreshFusionStorageOperationResult(errMsg);
    }

    private String nodeSwitchover(FusionStorageCheckService fsService) throws UMateException {
        String baseUrl;
        String diskPoolId = fsService.getDiskPoolId();
        if (StringUtils.isNULLStr((String)diskPoolId)) {
            return "";
        }
        RestConnection restConnector = fsService.getRestConnector();
        if (!NodePoolService.isVnodeEcPool((RestConnection)restConnector, (String)((baseUrl = fsService.getBaseUrl()) + "/dsware/service/resource/queryPoolBasicInfo"), (String)diskPoolId)) {
            return "";
        }
        this.drawNewProgress("node.switchover");
        this.switchActiveNodeAndRelogin(fsService);
        if (!NodePoolService.switchoverNode((RestConnection)restConnector, (String)(baseUrl + "/dsware/service/fail_over/failover"), (String)fsService.getMgrIp())) {
            return RES.getString("node.switchover.startup.failed");
        }
        if (!NodePoolService.taskIsCompleted((RestConnection)restConnector, (SwitchoverEnum)SwitchoverEnum.SWITCHOVER, (String)(baseUrl + "/dsware/service/task/queryTaskInfo"))) {
            return RES.getString("node.switchover.startup.failed");
        }
        fsService.setSwitchOverStatus(true);
        return "";
    }

    private void switchActiveNodeAndRelogin(FusionStorageCheckService fsService) throws UMateException {
        List<String> managements = fsService.getManagements();
        FusionStorageSshConnector ssh = FusionStorageSshPool.getFsSshConnectionByBmcIp(fsService.getBmcIp());
        if (!managements.contains(fsService.getBmcIp()) || !SwitchActiveNodeUtils.isActiveNode(ssh)) {
            log.info("Node {} is not the active node. No switchover is required.", (Object)fsService.getMgrIp());
            return;
        }
        FsmNode oldFsmNodes = SwitchActiveNodeUtils.queryNodeStatu(ssh);
        if (!SwitchActiveNodeUtils.switchActive(ssh, oldFsmNodes)) {
            throw new UMateException(RES.getString("node.switch.active.error"));
        }
        if (!SwitchActiveNodeUtils.isLogSuccess(fsService.getRestConnector())) {
            throw new UMateException(RES.getString("node.switch.active.error"));
        }
    }

    private void wait4AllUpgradePackagesDownloadedSuccessfully(UpgradeStrategyEntity strategy) throws UMateException {
        Set<Map.Entry<UpgradeParamConstants.ModuleType, List<String>>> firmwareEntitySet = strategy.getModuleTargetFirmwareMap().entrySet();
        for (Map.Entry<UpgradeParamConstants.ModuleType, List<String>> moduleTypeListEntry : firmwareEntitySet) {
            List<String> value = moduleTypeListEntry.getValue();
            for (String firmwareKey : value) {
                this.waitTillDownloadPackage2Local(firmwareKey);
            }
        }
    }

    private void waitTillDownloadPackage2Local(String firmwareKey) throws UMateException {
        long currentTimeMills = System.currentTimeMillis();
        while (System.currentTimeMillis() - currentTimeMills < 600000L) {
            FirmwarePackageEntity firmwarePackageEntity = BundleUpgradeContext.getInstance().getFirmwarePackageMap().get(firmwareKey);
            if (null == firmwarePackageEntity || StringUtils.isNULLStr((String)firmwarePackageEntity.getOnlinePathAbs()) || firmwarePackageEntity.isDownloaded() && !StringUtils.isNULLStr((String)firmwarePackageEntity.getLocalPathAbs())) {
                return;
            }
            log.info(String.format(Locale.ENGLISH, "executing firmware download of firmware from %s.", firmwarePackageEntity.getOnlinePathAbs()));
            ConnUtils.sleep((int)1000);
        }
        throw new UMateException(RES.getString("timeout.downloading.firmware.packages"));
    }

    private void composeDeviceExecutionResult(String errMsg) {
        this.device.setResultMsg(errMsg);
        if (this.device.getUpgradeDetails() != null) {
            boolean hasFail;
            boolean hasSuc = this.device.getUpgradeDetails().values().stream().flatMap(Collection::stream).anyMatch(UpgradeDeviceEntity.FirmUpgradeResult::isSuc);
            boolean bl = hasFail = errMsg != null || this.device.getUpgradeDetails().values().stream().flatMap(Collection::stream).anyMatch(result -> !result.isSuc());
            if (hasSuc && hasFail) {
                this.device.setProcessStatus(UpgradeParamConstants.UpgradeStatus.UPGRADE_PARTIAL_SUCCESS);
            } else if (hasFail) {
                this.device.setProcessStatus(UpgradeParamConstants.UpgradeStatus.FAILED);
            } else {
                this.device.setProcessStatus(UpgradeParamConstants.UpgradeStatus.COMPLETED);
            }
        } else {
            this.device.setProcessStatus(UpgradeParamConstants.UpgradeStatus.FAILED);
        }
        if (!StringUtils.isNULLStr((String)errMsg)) {
            if (this.device.isRebootTask()) {
                this.device.setProcessStatus(UpgradeParamConstants.UpgradeStatus.FAILED);
            }
            double progress = this.device.getExecuteInfo().getResults().stream().max(Comparator.comparingDouble(ExecuteResult::getTotalProgress)).get().getTotalProgress();
            this.updateLastProcessDetailsProgress(errMsg, progress, false);
        } else if (this.device.isRebootTask()) {
            this.rebootComposeDeviceExecutionResult();
        } else {
            this.composeDeviceExecutionSuccessResult();
        }
        this.mainDialog.refreshTable(this.device);
    }

    private void composeDeviceExecutionSuccessResult() {
        ExecuteResult executeLastResult = this.device.getExecuteInfo().getResults().get(this.device.getExecuteInfo().getResults().size() - 1);
        if (UpgradeParamConstants.SubProcessExecutionResult.FAILED.equals((Object)executeLastResult.getExecuteResult())) {
            this.updateLastProcessDetailsProgress(executeLastResult.getDetail(), this.getLastProcessProgress() + 1.0, false);
        } else if (UpgradeParamConstants.SubProcessExecutionResult.NOT_INVOLVED.equals((Object)executeLastResult.getExecuteResult())) {
            this.mainDialog.resultCallBack(this.device);
        } else {
            this.updateLastProcessDetailsProgress(RES.getString(STEP_OPERATION_SUCC_MSG), this.getLastProcessProgress() + 1.0, true);
        }
        if (UpgradeParamConstants.UpgradeStatus.FAILED.equals((Object)this.device.getProcessStatus())) {
            return;
        }
        if (!this.device.needOffLineUpgrade()) {
            this.rebootComposeDeviceExecutionResult();
            this.mainDialog.resultCallBack(this.device);
        } else {
            this.device.setProcessStatus(UpgradeParamConstants.UpgradeStatus.WAIT_REBOOT);
        }
    }

    private void rebootComposeDeviceExecutionResult() {
        if (this.device.getFirmRebootResult().isSuccess()) {
            ExecuteResult result = this.device.getExecuteInfo().getResults().get(this.device.getExecuteInfo().getResults().size() - 1);
            this.updateLastProcessDetailsProgress(result.getDetail(), 100.0, result.isSuccess());
            Optional<ExecuteResult> executeVerifyResult = this.device.getExecuteInfo().getResults().stream().filter(executeResult -> executeResult.getDescription().equals(RES.getString("refresh.all.firmwares.version"))).findFirst();
            if (!executeVerifyResult.isPresent()) {
                return;
            }
            if (executeVerifyResult.get().equals((Object)UpgradeParamConstants.SubProcessExecutionResult.FAILED)) {
                this.device.setProcessStatus(UpgradeParamConstants.UpgradeStatus.FAILED);
            }
        }
    }

    private void upgradeCurrentModuleGroup(UpgradeStrategyEntity strategy, List<UpgradeParamConstants.ModuleType> upgradeModules, Double progressStepLen) throws UMateException, InterruptedException {
        boolean isOutBandModules = UpgradeScenarioUtil.containsOutBandModuleUpgrade(upgradeModules);
        if (isOutBandModules) {
            log.info("now start to upgrade out-band modules.");
            Set<UpgradeParamConstants.ModuleType> modules = UpgradeScenarioUtil.getOutBandToBeUpgradeModules(upgradeModules);
            if (modules.isEmpty()) {
                log.error(">>>> error! out-band modules of size 0! quit");
                return;
            }
            Double subProcessStepLen = progressStepLen / (double)modules.size();
            for (UpgradeParamConstants.ModuleType module : modules) {
                this.upgradeSingleOutBandModuleComponents(this.localExecTmpDir, module, strategy, subProcessStepLen);
            }
        } else if (UpgradeScenarioUtil.containsInBandModuleUpgrade(upgradeModules)) {
            log.info("now start to upgrade in-band modules.");
            log.info(String.format(Locale.ENGLISH, "PCIE upgrade progress step size :%s", progressStepLen));
            PcieUpgradeServiceImpl pcieUpgrade = new PcieUpgradeServiceImpl(this.device);
            OperationResultEntity operationResultEntity = pcieUpgrade.upgradeManual(this.device, progressStepLen);
            if (!operationResultEntity.isPassed()) {
                this.updateLastProcessDetailsProgress(operationResultEntity.getReturnParam(), this.getLastProcessProgress(), false);
                throw new UMateException(operationResultEntity.getReturnParam());
            }
        } else if (UpgradeScenarioUtil.containsPanGeaInBandModuleUpgrade(upgradeModules)) {
            log.info("now start to upgrade pangea in-band modules.");
            log.info(String.format(Locale.ENGLISH, "upgrade progress step size :%s", progressStepLen));
            PanGeaInBandUpgradeServiceImpl panGeaInBandUpgrade = new PanGeaInBandUpgradeServiceImpl(this.device);
            panGeaInBandUpgrade.upgrade(upgradeModules.get(0), progressStepLen);
        } else if (UpgradeScenarioUtil.containsFwUpgradeBySshForDisk(upgradeModules)) {
            log.info("now start to upgrade disk fw modules.");
            DiskUpgradeByDiskToolImpl impl = new DiskUpgradeByDiskToolImpl(this.device);
            impl.upgrade(upgradeModules.get(0), progressStepLen);
        } else if (UpgradeScenarioUtil.containsEs3000Module(upgradeModules)) {
            log.info("now start to upgrade Es3000 disk fw modules.");
            NVMeDiskUpgradeServiceImpl impl = new NVMeDiskUpgradeServiceImpl();
            impl.upgrade(this.device, progressStepLen);
        } else if (UpgradeScenarioUtil.isSpModule(upgradeModules)) {
            this.upgradeSmartProvisioning(strategy, progressStepLen);
        } else {
            log.error(">>>> Illegal target module type, cannot figure out whether is PCIe modules or out-band modules.");
        }
    }

    private void upgradeSmartProvisioning(UpgradeStrategyEntity strategy, Double progressStepLen) throws InterruptedException, UMateException {
        log.info("now start to upgrade sp module.");
        log.info(String.format(Locale.ENGLISH, "SP upgrade progress step size :%s", progressStepLen));
        PcieUpgradeServiceImpl pcieUpgrade = new PcieUpgradeServiceImpl(this.device);
        OperationResultEntity operationResultEntity = pcieUpgrade.upgradeSp(strategy, this.device, progressStepLen);
        if (!operationResultEntity.isPassed()) {
            this.updateLastProcessDetailsProgress(operationResultEntity.getReturnParam(), this.getLastProcessProgress(), false);
            throw new UMateException(operationResultEntity.getReturnParam());
        }
    }

    private void refreshAllFirmwaresCurrentVersion() {
        log.info(">>>> Now refreshing all modules' fw versions.");
        this.drawNewProgress("refresh.all.firmwares.version");
        this.setDeviceEndTime();
        List<Object> details = new ArrayList();
        try (DeviceInfoByRedfishService redfishService = new DeviceInfoByRedfishService(this.device.getDeviceEntity());){
            QueryDeviceInfoService.getInstance().updateFwInfo(redfishService, this.device, new StringBuffer());
            details = this.verifyUpgradedFwAndDeviceVersion();
        }
        catch (Exception e) {
            log.error("exception occurred on fetch device module version, continue", (Throwable)e);
        }
        if (details.isEmpty()) {
            this.updateLastProcessDetailsProgress(RES.getString(STEP_OPERATION_SUCC_MSG), this.getLastProcessProgress(), true);
        } else {
            this.updateLastProcessDetailsProgress(String.join((CharSequence)";\r\n", details), this.getLastProcessProgress(), false);
        }
    }

    private void setDeviceEndTime() {
        log.info("The upgrade task of node {} ends", (Object)this.device.getDeviceEntity().getIp());
        this.device.setEndTaskTime(new Date());
    }

    private List<String> verifyUpgradedFwAndDeviceVersion() {
        ArrayList<String> checkDetails = new ArrayList<String>();
        VerifyVersionImpl verifyVersionImpl = new VerifyVersionImpl(this.device);
        verifyVersionImpl.verifyFwAndDeviceVersion(checkDetails);
        return checkDetails.stream().filter(detail -> !StringUtils.isNULLStr((String)detail)).collect(Collectors.toList());
    }

    private void rebootIBMCBeforeUpgradeIfRequired() throws UMateException, InterruptedException {
        try {
            PowerOperationRedFishService powerSwitchService;
            OperationResultEntity resultEntity;
            if (VersionCompartor.isVersionLowerThan((String)this.device.getDeviceEntity().getMasterBMC(), (String)String.valueOf(BundleUpgradeConstants.BMC_RISK_VERSION_THRESHOLD)) && !(resultEntity = (powerSwitchService = new PowerOperationRedFishService(this.device.getDeviceEntity())).sendRestartIBMCSignal()).isPassed()) {
                throw new UMateException(RES.getString("PreRequisite.check.not.satisfied.or.failed.check"));
            }
        }
        catch (NumberFormatException exp) {
            log.error(">>>> The iBMC version is not readable, cannot be parsed into number format.");
        }
    }

    private void upgradeSingleOutBandModuleComponents(String localTmpDir, UpgradeParamConstants.ModuleType module, UpgradeStrategyEntity strategy, Double subProcessStepLen) throws UMateException, InterruptedException {
        List<String> packages = this.getPkgToUpgrade(module, strategy);
        if (packages.isEmpty()) {
            log.error(">>>> upgradeSingleOutBandModuleComponents but packages matched is empty!");
            this.createEmptyExecutionResultAsFwPackagesNotMatch(module, strategy, subProcessStepLen);
            return;
        }
        for (String packageKey : packages) {
            double targetProgress = this.getLastProcessProgress() + subProcessStepLen / (double)packages.size();
            this.prepareAndExecuteModuleUpgrade(localTmpDir, module, strategy, targetProgress, packageKey);
        }
    }

    List<String> getPkgToUpgrade(UpgradeParamConstants.ModuleType module, UpgradeStrategyEntity strategy) throws UMateException {
        if (!RetimerTypeEnum.isRetimerModule(module)) {
            return this.getMappedOutBandFirmwarePackageEntityWithGivingModule(strategy, module);
        }
        String minRetimerVersion = this.device.getDeviceEntity().getMinRetimerVersion(module);
        if ("--".equals(minRetimerVersion)) {
            log.info("The current node {} does not have the pcie_retimer and does not need to be upgraded.", (Object)this.device.getDeviceEntity().getIp());
            return Collections.emptyList();
        }
        return this.getMappedOutBandFirmwarePackageEntityWithGivingModule(strategy, module);
    }

    private void prepareAndExecuteModuleUpgrade(String localTmpDir, UpgradeParamConstants.ModuleType module, UpgradeStrategyEntity strategy, Double targetProgress, String packageKey) throws UMateException, InterruptedException {
        FirmwarePackageEntity firmwarePackage = this.getTargetFirmwarePackageEntity(module, strategy, targetProgress, packageKey);
        if (firmwarePackage == null) {
            return;
        }
        log.info(String.format(Locale.ENGLISH, "[device %s] found matched firmware package of type %s: %s, now start to upgrade", this.device.getDeviceEntity().getIp(), module.getModule(), firmwarePackage.getLocalPathAbs()));
        String targetScriptFilePath = this.intoCanonicalScriptPath(ScriptConfigUtil.getScriptRelativePath(module));
        if (StringUtils.isNULLStr((String)targetScriptFilePath)) {
            throw new UMateException(RES.getString("failed.to.get.target.script.path"));
        }
        List<String> steps = this.getCurrentModuleStepKeys(module, firmwarePackage.getPackageInfo().getSupportModelUID());
        double lastProgress = this.getLastProcessProgress();
        double stepLength = (targetProgress - lastProgress) / (double)steps.size();
        for (int step = 0; step < steps.size(); ++step) {
            this.mainDialog.createExecuteResult(this.device, steps.get(step));
            String targetFirmwareFilePath = this.getTargetHpmFileLocation(firmwarePackage, module);
            log.info(String.format(Locale.ENGLISH, "target script file Path : %s.", targetScriptFilePath));
            String profilePath = this.buildUpgradeProfile(localTmpDir, module, targetFirmwareFilePath);
            UpgradeDeviceEntity.FirmUpgradeResult fwResult = this.performModuleUpgrade(module, strategy, firmwarePackage, targetScriptFilePath, profilePath);
            this.refreshCurrentUpgradeProgress(lastProgress + (double)(step + 1) * stepLength, fwResult);
        }
    }

    private FirmwarePackageEntity getTargetFirmwarePackageEntity(UpgradeParamConstants.ModuleType module, UpgradeStrategyEntity strategy, Double targetProgress, String packageKey) throws UMateException {
        FirmwarePackageEntity firmwarePackage = BundleUpgradeContext.getInstance().getFirmwarePackageMap().get(packageKey);
        if (firmwarePackage == null || !this.isCurrentStrategyAndDeviceEval2Upgrade(firmwarePackage, strategy.getUpgradeStrategyMap().get(packageKey), module)) {
            String supportModelUID = firmwarePackage != null && firmwarePackage.getPackageInfo() != null ? firmwarePackage.getPackageInfo().getSupportModelUID() : "unknown";
            BundleUpgradeContext.getInstance().getMainDialog().createExecuteResult(this.device, RES.getStringWithParams(UPGRADE_SUB_PROCESS_TITLE, new Object[]{module.getModule(), supportModelUID}));
            log.error(String.format(Locale.ENGLISH, "current strategy's fw %s and device module not match.", firmwarePackage));
            String errorMsg = RES.getString("current.strategy.ignore.this.upgrade");
            BundleUpgradeContext.getInstance().getMainDialog().updateResult(this.device, errorMsg, targetProgress, UpgradeParamConstants.SubProcessExecutionResult.NOT_INVOLVED, errorMsg);
            return null;
        }
        return firmwarePackage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void preCheckModuleCanUpgrade(UpgradeStrategyEntity strategy) throws UMateException {
        LinkedList<String> precheckResult = new LinkedList<String>();
        List<List<UpgradeParamConstants.ModuleType>> upgradeModulesList = strategy.getUpgradeOrders();
        try {
            boolean anyModuleOutband = upgradeModulesList.stream().anyMatch(modules -> UpgradeScenarioUtil.containsOutBandModuleUpgrade(modules));
            boolean anyModuleInband = upgradeModulesList.stream().anyMatch(modules -> UpgradeScenarioUtil.containsPanGeaInBandModuleUpgrade(modules));
            boolean anyModuleDiskFw = upgradeModulesList.stream().anyMatch(modules -> UpgradeScenarioUtil.containsFwUpgradeBySshForDisk(modules));
            if (!(anyModuleOutband || anyModuleInband || anyModuleDiskFw)) {
                this.anyOneModuleNeedUpgrade = true;
                log.info("Other components need to be upgraded by default.");
                return;
            }
            this.drawNewProgress("step.power.device.pre.check.version");
            if (anyModuleOutband) {
                upgradeModulesList.stream().forEach(modules -> this.addOutBandModulePrechekResult(strategy, precheckResult, (List<UpgradeParamConstants.ModuleType>)modules));
            }
            if (anyModuleInband && UpgradeCustomizationUtil.canConnectOs(this.device.getDeviceEntity())) {
                PanGeaInBandUpgradeServiceImpl panGeaService = new PanGeaInBandUpgradeServiceImpl(this.device);
                FusionStorageSshConnector finalSsh = FusionStorageSshPool.getFsSshConnectionByBmcIp(this.device.getDeviceEntity().getIp());
                upgradeModulesList.stream().forEach(modules -> this.addInBandModulePrechekResult(panGeaService, precheckResult, finalSsh, (List<UpgradeParamConstants.ModuleType>)modules));
            }
            if (anyModuleDiskFw && UpgradeCustomizationUtil.canConnectOs(this.device.getDeviceEntity())) {
                DiskUpgradeByDiskToolImpl diskTool = new DiskUpgradeByDiskToolImpl(this.device);
                upgradeModulesList.stream().forEach(modules -> this.addDiskFwModulePrechekResult(diskTool, precheckResult, (List<UpgradeParamConstants.ModuleType>)modules));
            }
            this.handlePreCheckResult(precheckResult);
        }
        finally {
            if (UpgradeCustomizationUtil.canConnectOs(this.device.getDeviceEntity())) {
                FusionStorageSshPool.releaseFsSshConnection(FusionStrgUpgradeContext.getInstance().getFsDeviceEntityByBmcIp(this.device.getDeviceEntity().getIp()));
            }
        }
    }

    private void addOutBandModulePrechekResult(UpgradeStrategyEntity strategy, LinkedList<String> precheckResult, List<UpgradeParamConstants.ModuleType> upgradeModules) {
        if (UpgradeScenarioUtil.containsOutBandModuleUpgrade(upgradeModules)) {
            log.info("Pre-check, Checking the out band component Version");
            UpgradeScenarioUtil.getOutBandToBeUpgradeModules(upgradeModules).stream().forEach(module -> this.addOutBandPreChekReuslt(strategy, precheckResult, (UpgradeParamConstants.ModuleType)((Object)module)));
        }
    }

    private void addInBandModulePrechekResult(PanGeaInBandUpgradeServiceImpl panGeaService, LinkedList<String> precheckResult, FusionStorageSshConnector ssh, List<UpgradeParamConstants.ModuleType> upgradeModules) {
        if (UpgradeScenarioUtil.containsPanGeaInBandModuleUpgrade(upgradeModules)) {
            log.info("Pre-check, Checking the in band Component Version");
            upgradeModules.forEach(module -> precheckResult.add(this.getInBandPrecheckResult(ssh, panGeaService, (UpgradeParamConstants.ModuleType)((Object)module))));
        }
    }

    private void addDiskFwModulePrechekResult(DiskUpgradeByDiskToolImpl diskTool, LinkedList<String> precheckResult, List<UpgradeParamConstants.ModuleType> upgradeModules) {
        if (UpgradeScenarioUtil.containsFwUpgradeBySshForDisk(upgradeModules)) {
            log.info("Pre-check, Checking the DISK_FW Component Version");
            upgradeModules.forEach(module -> precheckResult.add(this.getDiskFwPrecheckResult(diskTool, (UpgradeParamConstants.ModuleType)((Object)module))));
        }
    }

    private String getDiskFwPrecheckResult(DiskUpgradeByDiskToolImpl diskTool, UpgradeParamConstants.ModuleType module) {
        List<DeviceEntity.DiskModel> needUpgradeDisk = diskTool.getNeedUpgradeDisk(module);
        if (needUpgradeDisk.isEmpty()) {
            return RES.getStringWithParams("current.strategy.ignore.disk.fw", new Object[]{module.getModule()});
        }
        this.anyOneModuleNeedUpgrade = true;
        log.info("DISK_FW model The version meets the upgrade requirements.");
        return "";
    }

    private void addOutBandPreChekReuslt(UpgradeStrategyEntity strategy, LinkedList<String> precheckResult, UpgradeParamConstants.ModuleType module) {
        try {
            List<String> packages = this.getPkgToUpgrade(module, strategy);
            if (packages.isEmpty()) {
                log.error("Pre-check, >>>> upgradeSingleOutBandModuleComponents but packages matched is empty!");
                precheckResult.add(RES.getStringWithParams("current.strategy.model.not.match.pre.check", new Object[]{module.getModule()}));
                return;
            }
            List checkVersionResults = packages.stream().map(pkgKey -> this.checkOutBandModuleCanIgnore(module, strategy, (String)pkgKey)).collect(Collectors.toList());
            precheckResult.addAll(checkVersionResults);
        }
        catch (UMateException e) {
            log.info("Pre-check failed", (Throwable)e);
            precheckResult.add(e.getMessage());
        }
    }

    private String checkOutBandModuleCanIgnore(UpgradeParamConstants.ModuleType module, UpgradeStrategyEntity strategy, String packageKey) {
        FirmwarePackageEntity fwPackage = BundleUpgradeContext.getInstance().getFirmwarePackageMap().get(packageKey);
        String currentVer = UpgradeScenarioUtil.getTargetModuleVersion(this.device.getDeviceEntity(), module, fwPackage);
        String targetVersion = fwPackage.getPackageInfo().getVersion();
        try {
            if (fwPackage == null || !this.isCurrentStrategyAndDeviceEval2Upgrade(fwPackage, strategy.getUpgradeStrategyMap().get(packageKey), module)) {
                return this.getTipFromResouce("current.strategy.ignore.tip2", module, currentVer, targetVersion);
            }
            this.anyOneModuleNeedUpgrade = true;
            return this.getTipFromResouce("current.strategy.ignore.tip3", module, currentVer, targetVersion);
        }
        catch (UMateException e) {
            log.warn("Pre-check failed.", (Throwable)e);
            return e.getMessage();
        }
    }

    private String getInBandPrecheckResult(FusionStorageSshConnector ssh, PanGeaInBandUpgradeServiceImpl panGeaService, UpgradeParamConstants.ModuleType module) {
        String currentVer = null;
        String tagetVersion = panGeaService.getPanGeaInBandFwPackageEntityMap(this.device).get(module.getModule()).getPackageInfo().getVersion();
        if (!panGeaService.canUpgradedByVer(this.device, module, ssh)) {
            currentVer = this.device.getDeviceEntity().getPanGeaInBandModuleVersion().getOrDefault(module.getModule(), "--");
            if (!UpgradeScenarioUtil.isValidVersion(currentVer, module.getModule())) {
                return RES.getStringWithParams("current.strategy.model.not.match.pre.check", new Object[]{module.getModule()});
            }
            return this.getTipFromResouce("current.strategy.ignore.tip2", module, currentVer, tagetVersion);
        }
        this.anyOneModuleNeedUpgrade = true;
        return this.getTipFromResouce("current.strategy.ignore.tip3", module, currentVer, tagetVersion);
    }

    private String getTipFromResouce(String resouceKey, UpgradeParamConstants.ModuleType module, String currentVer, String tagetVersion) {
        return RES.getStringWithParams(resouceKey, new Object[]{module.getModule(), currentVer, tagetVersion});
    }

    private void handlePreCheckResult(LinkedList<String> precheckResult) {
        if (!this.anyOneModuleNeedUpgrade) {
            log.info("Pre-check, No components need to be upgraded.");
            precheckResult.addFirst(RES.getString("current.strategy.ignore.tip1"));
            String checkResult = precheckResult.stream().collect(Collectors.joining());
            log.info("Pre-check reuslt {}", (Object)checkResult);
            this.device.setProcessStatus(UpgradeParamConstants.UpgradeStatus.NOT_EXECUTED);
            this.device.setResultMsg(checkResult);
            BundleUpgradeContext.getInstance().getMainDialog().updateResult(this.device, checkResult, 100.0, UpgradeParamConstants.SubProcessExecutionResult.IGNORE, checkResult);
        } else {
            log.info("Pre-check, The currently selected component contains executable items. Continue upgrade.");
            log.info("Pre-check reuslt {}", (Object)precheckResult.stream().collect(Collectors.joining()));
            this.updateLastProcessDetailsProgress(RES.getString(STEP_OPERATION_SUCC_MSG), 1.0, true);
        }
    }

    private List<String> getCurrentModuleStepKeys(UpgradeParamConstants.ModuleType module, String supportModelUID) {
        if (module == UpgradeParamConstants.ModuleType.iBMC) {
            return Arrays.asList(RES.getStringWithParams(UPGRADE_SUB_PROCESS_TITLE, new Object[]{module.getModule() + RES.getString("module.type.slave"), supportModelUID}), RES.getStringWithParams(UPGRADE_SUB_PROCESS_TITLE, new Object[]{module.getModule() + RES.getString("module.type.master"), supportModelUID}));
        }
        return Collections.singletonList(RES.getStringWithParams(UPGRADE_SUB_PROCESS_TITLE, new Object[]{module.getModule(), supportModelUID}));
    }

    private UpgradeDeviceEntity.FirmUpgradeResult performModuleUpgrade(UpgradeParamConstants.ModuleType module, UpgradeStrategyEntity strategy, FirmwarePackageEntity firmwarePackage, String targetScriptFilePath, String profilePath) throws UMateException, InterruptedException {
        OutBandUpgradeServiceServiceImpl upgradeService = new OutBandUpgradeServiceServiceImpl(this.device, firmwarePackage, this.uiObserver);
        UpgradeDeviceEntity.FirmUpgradeResult fwResult = this.buildNewTargetFirmwarePackageResult(module, firmwarePackage);
        try {
            upgradeService.preCheckBeforeUpgrade(strategy, module, fwResult, this.device.getDeviceEntity());
            List<String> failedPkgPath = SHAAndRSASignCheckUtil.getSignatureFailedFileInfos(firmwarePackage.getLocalPathAbs());
            if (!failedPkgPath.isEmpty()) {
                log.error("Failed to verify component {}. Upgrade terminated.", (Object)module.getModule());
                fwResult.setStatus(UpgradeParamConstants.FirmUpgradeStatus.FAILED);
                fwResult.setResultMsg(failedPkgPath.get(0));
                this.device.setSpecifiedFirmwareUpgradeDetail(module, fwResult);
                return fwResult;
            }
            upgradeService.upgradeModule(profilePath, this.localExecTmpDir, targetScriptFilePath, module, fwResult);
            upgradeService.doOperationAfterUpgrade(strategy, module, fwResult, this.device.getDeviceEntity());
        }
        catch (UMateException e) {
            fwResult.setStatus(UpgradeParamConstants.FirmUpgradeStatus.FAILED);
            fwResult.setResultMsg(e.getMessage());
            throw e;
        }
        return fwResult;
    }

    private void createEmptyExecutionResultAsFwPackagesNotMatch(UpgradeParamConstants.ModuleType module, UpgradeStrategyEntity strategy, Double subProcessStepLen) {
        double previousProcess = this.getLastProcessProgress();
        List<String> fwEntityKeys = strategy.getModuleTargetFirmwareMap().get((Object)module);
        String curDesKey = RES.getStringWithParams(UPGRADE_SUB_PROCESS_TITLE, new Object[]{module.getModule(), BundleUpgradeContext.getInstance().getFirmwarePackageMap().entrySet().stream().filter(entry -> fwEntityKeys.contains(entry.getKey())).map(Map.Entry::getValue).map(FirmwarePackageEntity::getPackageInfo).map(FirmwarePackageEntity.PackageInfo::getSupportModelUID).collect(Collectors.joining(","))});
        this.mainDialog.createExecuteResult(this.device, curDesKey);
        String errorMsg = RES.getString("current.strategy.model.not.match");
        BundleUpgradeContext.getInstance().getMainDialog().updateResult(this.device, errorMsg, previousProcess + subProcessStepLen, UpgradeParamConstants.SubProcessExecutionResult.NOT_INVOLVED, errorMsg);
    }

    private double getLastProcessProgress() {
        List<ExecuteResult> results = this.device.getExecuteInfo().getResults();
        if (results.isEmpty() || results.size() == 1) {
            return 0.0;
        }
        if (results.get(results.size() - 1).getTotalProgress() > 0.0) {
            return results.get(results.size() - 1).getTotalProgress();
        }
        return results.get(results.size() - 2).getTotalProgress();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getTargetHpmFileLocation(FirmwarePackageEntity firmwarePackage, UpgradeParamConstants.ModuleType module) throws UMateException {
        REENTRANT_LOCK.lock();
        try {
            String targetFirmwareFilePath = firmwarePackage.getUnzippedPackagePath();
            if (StringUtils.isNULLStr((String)targetFirmwareFilePath) || !FileUtils.getFile((String[])new String[]{targetFirmwareFilePath}).exists()) {
                targetFirmwareFilePath = this.unzipFirmwarePackage2TargetPathAndSaveIt(firmwarePackage, module);
            }
            String string = targetFirmwareFilePath;
            return string;
        }
        finally {
            REENTRANT_LOCK.unlock();
        }
    }

    private UpgradeDeviceEntity.FirmUpgradeResult buildNewTargetFirmwarePackageResult(UpgradeParamConstants.ModuleType module, FirmwarePackageEntity firmwarePackage) {
        UpgradeDeviceEntity.FirmUpgradeResult firmUpgradeResult = new UpgradeDeviceEntity.FirmUpgradeResult();
        firmUpgradeResult.setFirmwareUid(firmwarePackage.getPackageInfo().getSupportModelUID());
        String targetModuleVersion = UpgradeScenarioUtil.getTargetModuleVersion(this.device.getDeviceEntity(), module, firmwarePackage);
        targetModuleVersion = this.changeShowFormat(module, targetModuleVersion);
        firmUpgradeResult.setFromVersion(targetModuleVersion);
        firmUpgradeResult.setToVersion(firmwarePackage.getPackageInfo().getVersion());
        firmUpgradeResult.setFirmwarePackage(firmwarePackage);
        return firmUpgradeResult;
    }

    private String changeShowFormat(UpgradeParamConstants.ModuleType module, String targetModuleVersion) {
        String tempVersion = targetModuleVersion;
        if (UpgradeParamConstants.ModuleType.PCIE_RETIMER.equals((Object)module)) {
            tempVersion = targetModuleVersion.replace(";", "\n");
        }
        return tempVersion;
    }

    private void refreshCurrentUpgradeProgress(double targetProgress, UpgradeDeviceEntity.FirmUpgradeResult result) {
        log.info(String.format(Locale.ENGLISH, "refreshing progress to %s.", targetProgress));
        String resultMessage = result.isSuc() ? RES.getString("report.result.result.success") : RES.getString("report.result.result.failed") + "\n\n" + result.getResultMsg();
        this.updateLastProcessDetailsProgress(resultMessage, targetProgress, result.isSuc());
    }

    private boolean isCurrentStrategyAndDeviceEval2Upgrade(FirmwarePackageEntity firmwarePackage, UpgradeParamConstants.FirmwareUpgradeStrategy firmwareUpgradeStrategy, UpgradeParamConstants.ModuleType module) throws UMateException {
        String currentVer = UpgradeScenarioUtil.getTargetModuleVersion(this.device.getDeviceEntity(), module, firmwarePackage);
        log.info(String.format(Locale.ENGLISH, "[device %s] module %s of package key <<%s>>'s version:%s", this.device.getDeviceEntity().getIp(), module.getModule(), firmwarePackage.getPackageInfo().getSupportModelUID(), currentVer));
        if (firmwareUpgradeStrategy == UpgradeParamConstants.FirmwareUpgradeStrategy.MANDATORY_UPGRADE) {
            log.info(String.format(Locale.ENGLISH, "[device %s] module %s user choose to mandatory upgrade.", this.device.getDeviceEntity().getIp(), module.getModule()));
            return true;
        }
        if (this.checkCanUpgrade(currentVer, firmwarePackage.getPackageInfo().getVersion(), module)) {
            log.info(String.format(Locale.ENGLISH, "[device %s] module %s user choose to lower version upgrade, now do upgrade.", this.device.getDeviceEntity().getIp(), module.getModule()));
            return true;
        }
        log.info(String.format(Locale.ENGLISH, "[device %s] module %s user choose to lower version upgrade, no need to upgrade.", this.device.getDeviceEntity().getIp(), module.getModule()));
        return false;
    }

    private boolean checkCanUpgrade(String currentVer, String targetVersion, UpgradeParamConstants.ModuleType module) throws UMateException {
        if (UpgradeParamConstants.ModuleType.BIOS.equals((Object)module)) {
            return !com.google.common.base.Objects.equal((Object)currentVer, (Object)targetVersion);
        }
        String tempDumpVersion = currentVer;
        if (UpgradeParamConstants.ModuleType.VRD.equals((Object)module)) {
            tempDumpVersion = Arrays.stream(currentVer.split("\\.")).findFirst().orElse("--");
        }
        if (RetimerTypeEnum.isRetimerModule(module)) {
            tempDumpVersion = this.device.getDeviceEntity().getMinRetimerVersion(module);
        }
        return UpgradeScenarioUtil.isFromVersionLowerThanToVersion(tempDumpVersion, targetVersion);
    }

    private String intoCanonicalScriptPath(String targetScriptFilePath) {
        String targetAbsPath = ApplicationContext.getInstance().getPackagesPath() + File.separator + targetScriptFilePath;
        try {
            return FileUtils.getFile((String[])new String[]{targetAbsPath}).getCanonicalPath();
        }
        catch (IOException e) {
            log.error(String.format(Locale.ENGLISH, "failed to get canonical path of %s.", targetAbsPath));
            return targetAbsPath;
        }
    }

    private String unzipFirmwarePackage2TargetPathAndSaveIt(FirmwarePackageEntity firmwarePackage, UpgradeParamConstants.ModuleType module) throws UMateException {
        if (firmwarePackage == null) {
            throw new UMateException(RES.getString("error.no.target.firwmare.detected"));
        }
        log.info(String.format(Locale.ENGLISH, "[device %s] now start to unzip firmware Package.", this.device.getDeviceEntity().getIp()));
        String localZipFilePath = firmwarePackage.getLocalPathAbs();
        String localUnzipTargetDir = BundleUpgradeContext.getInstance().getCurrentTempPath() + File.separator + UpgradeScenarioUtil.replaceSpecialChar2UnderlineString(firmwarePackage.getPackageInfo().getPackageName() + this.getFirmwarePackageUniqueMd5(firmwarePackage));
        log.info(String.format(Locale.ENGLISH, "[device %s] target unzipped firmware package path: %s.", this.device.getDeviceEntity().getIp(), localUnzipTargetDir));
        File packageZipFile = FileUtils.getFile((String[])new String[]{localZipFilePath});
        if (!packageZipFile.exists()) {
            this.updateNewTargetFirmwarePackageResult(firmwarePackage, module, RES.getStringWithParams("the.follow.packages.does.not.exist", new Object[]{firmwarePackage.getLocalPathAbs()}));
            throw new UMateException(RES.getStringWithParams("the.follow.packages.does.not.exist", new Object[]{firmwarePackage.getLocalPathAbs()}));
        }
        try {
            ZipUtils.decompressFile((File)packageZipFile, (String)localUnzipTargetDir);
        }
        catch (IOException e) {
            log.error(">>>> io exception occurred on unzip files", (Throwable)e);
            this.updateNewTargetFirmwarePackageResult(firmwarePackage, module, RES.getStringWithParams("package.unzip.failed", new Object[]{module.getModule()}));
            throw new UMateException(RES.getStringWithParams("package.unzip.failed", new Object[]{module.getModule()}));
        }
        String targetFilePathAbs = this.parse4CoreFirmwareFileFromUnzippedDir(localUnzipTargetDir, firmwarePackage);
        if (StringUtils.isNULLStr((String)targetFilePathAbs) || !FileUtils.getFile((String[])new String[]{targetFilePathAbs}).exists()) {
            this.updateNewTargetFirmwarePackageResult(firmwarePackage, module, RES.getStringWithParams("target.core.firmware.file.not.exist.on.unzip.dir", new Object[]{module.getModule()}));
            throw new UMateException(RES.getStringWithParams("target.core.firmware.file.not.exist.on.unzip.dir", new Object[]{module.getModule()}));
        }
        log.info(String.format(Locale.ENGLISH, "[device %s] target core firmware package path: %s.", this.device.getDeviceEntity().getIp(), targetFilePathAbs));
        firmwarePackage.setUnzippedPackagePath(targetFilePathAbs);
        return targetFilePathAbs;
    }

    private String getFirmwarePackageUniqueMd5(FirmwarePackageEntity firmwarePackage) {
        FirmwarePackageEntity.PackageInfo packageInfo = firmwarePackage.getPackageInfo();
        String oriStr = packageInfo.getSupportModelUID() + packageInfo.getVersion();
        if (!StringUtils.isNULLStr((String)packageInfo.getObjectID())) {
            oriStr = oriStr + packageInfo.getObjectID();
        }
        if (!StringUtils.isNULLStr((String)packageInfo.getObject())) {
            oriStr = oriStr + packageInfo.getObject();
        }
        return DigestUtils.md5Hex(oriStr);
    }

    private void updateNewTargetFirmwarePackageResult(FirmwarePackageEntity firmwarePackage, UpgradeParamConstants.ModuleType module, String errMsg) {
        UpgradeDeviceEntity.FirmUpgradeResult firmwareUpgradeResult = this.buildNewTargetFirmwarePackageResult(module, firmwarePackage);
        firmwareUpgradeResult.setStatus(UpgradeParamConstants.FirmUpgradeStatus.FAILED);
        firmwareUpgradeResult.setResultMsg(errMsg);
        Map<UpgradeParamConstants.ModuleType, List<UpgradeDeviceEntity.FirmUpgradeResult>> deviceUpgradeDetails = this.device.getUpgradeDetails();
        List<UpgradeDeviceEntity.FirmUpgradeResult> firmUpgradeResultList = deviceUpgradeDetails.get((Object)module);
        if (firmUpgradeResultList == null) {
            firmUpgradeResultList = new ArrayList<UpgradeDeviceEntity.FirmUpgradeResult>(4);
            this.device.getUpgradeDetails().put(module, firmUpgradeResultList);
        }
        firmUpgradeResultList.add(firmwareUpgradeResult);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String parse4CoreFirmwareFileFromUnzippedDir(String localUnzipTargetDir, FirmwarePackageEntity firmwarePackageEntity) {
        try (Stream<Path> fileStream = Files.walk(Paths.get(localUnzipTargetDir, new String[0]), 2, new FileVisitOption[0]);){
            String string = fileStream.map(Path::toString).filter(filePath -> filePath.endsWith(firmwarePackageEntity.getPackageInfo().getFileName())).findAny().orElse("");
            return string;
        }
        catch (IOException exp) {
            log.error(String.format(Locale.ENGLISH, "io exception occurred on parse4CoreFirmwareFileFromUnzippedDir: %s", exp));
            return "";
        }
    }

    private List<String> getMappedOutBandFirmwarePackageEntityWithGivingModule(UpgradeStrategyEntity strategy, UpgradeParamConstants.ModuleType module) throws UMateException {
        List<String> firmwareKeys = strategy.getModuleTargetFirmwareMap().get((Object)module);
        if (null == firmwareKeys || firmwareKeys.isEmpty()) {
            throw new UMateException(RES.getStringWithParams("target.module.has.no.firmware.configured", new Object[]{module.getModule()}));
        }
        switch (module) {
            case BIOS: 
            case CDR: 
            case Retimer: 
            case iBMC: 
            case MCU: 
            case FAN: 
            case VRD: {
                return this.getMappedFirmwarePackageEntityWithDeviceUID(firmwareKeys, this.device.getDeviceEntity().getProductUniqueId());
            }
            case BBU: {
                return this.getBbuKeys(firmwareKeys);
            }
            case ETH_CDR: 
            case PCIE_RETIMER: 
            case PCIE_RETIMER_TI_RETIMER: {
                return this.getMappedFirmwarePackageEntityWithDeviceUIDOrAll(firmwareKeys, this.device.getDeviceEntity().getProductUniqueId());
            }
            case CPLD: {
                return this.getMappedCPLDFirmwarePackageEntity(firmwareKeys, this.device.getDeviceEntity().getCpldModels().stream().filter(cpldModule -> cpldModule.getDeviceType().equalsIgnoreCase("Backplane")).collect(Collectors.toList()));
            }
            case PSU: {
                return this.getMappedPSUFirmwarePackageEntity(firmwareKeys, this.device.getDeviceEntity().getPsuModels());
            }
            case CPLD_MAIN: {
                if (this.device.isPlaneNode() || this.device.getDeviceEntity().isDirectPlane()) {
                    return this.getMappedFirmwarePackageEntityWithDeviceUID(firmwareKeys, this.device.getDeviceEntity().getProductUniqueId());
                }
                return this.getMappedCPLDFirmwarePackageEntity(firmwareKeys, this.device.getDeviceEntity().getCpldModels().stream().filter(cpldModule -> cpldModule.getDeviceType().equalsIgnoreCase("MainBoard")).collect(Collectors.toList()));
            }
        }
        return new ArrayList<String>();
    }

    @NotNull
    private List<String> getBbuKeys(List<String> firmwareKeys) {
        return firmwareKeys.stream().filter(key -> {
            String supportUid = BundleUpgradeContext.getInstance().getFirmwarePackageMap().get(key).getPackageInfo().getSupportModelUID().toLowerCase(Locale.ENGLISH);
            return this.device.getDeviceEntity().getBbuModels().stream().anyMatch(bbu -> supportUid.contains(bbu.getSupportModelUID().toLowerCase(Locale.ENGLISH)));
        }).collect(Collectors.toList());
    }

    private List<String> getMappedPSUFirmwarePackageEntity(List<String> firmwareKeys, List<DeviceEntity.PsuModel> psuModels) {
        if (psuModels == null || psuModels.isEmpty()) {
            return new ArrayList<String>();
        }
        return firmwareKeys.stream().filter(mapUidFirmware -> this.isCurrentPsuFirmwarePackageMatchedDevice((String)mapUidFirmware, psuModels)).collect(Collectors.toList());
    }

    private boolean isCurrentPsuFirmwarePackageMatchedDevice(String mapUidFirmware, List<DeviceEntity.PsuModel> psuModels) {
        FirmwarePackageEntity.PackageInfo packageInfo = this.getFirmwarePackageInfo(mapUidFirmware);
        if (packageInfo == null) {
            log.error(String.format(Locale.ENGLISH, "error: psu firmware %s has no firmware package info!", mapUidFirmware));
            return false;
        }
        String supportUid = packageInfo.getSupportModelUID().toLowerCase(Locale.ENGLISH);
        return psuModels.stream().anyMatch(psu -> supportUid.contains(psu.getSupportModelUID().toLowerCase(Locale.ENGLISH)));
    }

    private List<String> getMappedCPLDFirmwarePackageEntity(List<String> firmwareKeys, List<DeviceEntity.CpldModel> cpldModels) {
        if (cpldModels == null || cpldModels.isEmpty()) {
            return new ArrayList<String>();
        }
        List<String> mapUidFirmwareKeys = this.getMappedFirmwarePackageEntityWithDeviceUID(firmwareKeys, this.device.getDeviceEntity().getProductUniqueId());
        if (this.device.getDeviceEntity().isSpecificDevice()) {
            return mapUidFirmwareKeys;
        }
        if (!mapUidFirmwareKeys.isEmpty()) {
            return mapUidFirmwareKeys.stream().filter(mapUidFirmware -> this.isCurrentCPLDFirmwarePackageMatchedDevice((String)mapUidFirmware, cpldModels)).collect(Collectors.toList());
        }
        return new ArrayList<String>(0);
    }

    private boolean isCurrentCPLDFirmwarePackageMatchedDevice(String mapUidFirmware, List<DeviceEntity.CpldModel> cpldModels) {
        FirmwarePackageEntity.PackageInfo packageInfo = this.getFirmwarePackageInfo(mapUidFirmware);
        if (packageInfo == null) {
            log.error(String.format(Locale.ENGLISH, "error: firmware %s has no firmware package info!", mapUidFirmware));
            return false;
        }
        for (DeviceEntity.CpldModel cpldModel : cpldModels) {
            if ((StringUtils.isNULLStr((String)packageInfo.getObject()) || !packageInfo.getObject().equalsIgnoreCase(cpldModel.getBoardName())) && (StringUtils.isNULLStr((String)packageInfo.getObjectID()) || !packageInfo.getObjectID().toLowerCase(Locale.ENGLISH).contains(cpldModel.getBoardId().toLowerCase(Locale.ENGLISH)))) continue;
            return true;
        }
        return false;
    }

    private FirmwarePackageEntity.PackageInfo getFirmwarePackageInfo(String mapUidFirmware) {
        FirmwarePackageEntity firmwarePackageEntity = BundleUpgradeContext.getInstance().getFirmwarePackageMap().get(mapUidFirmware);
        if (firmwarePackageEntity == null) {
            log.error(String.format(Locale.ENGLISH, "error: firmware %s does not exist!", mapUidFirmware));
            return null;
        }
        return firmwarePackageEntity.getPackageInfo();
    }

    List<String> getMappedFirmwarePackageEntityWithDeviceUID(List<String> firmwareKeys, String productUniqueId) {
        if (StringUtils.isNULLStr((String)productUniqueId)) {
            return Collections.emptyList();
        }
        return firmwareKeys.stream().filter(key -> this.getSupportModeUid((String)key).contains(productUniqueId.toLowerCase(Locale.ENGLISH))).collect(Collectors.toList());
    }

    private String getSupportModeUid(String key) {
        return BundleUpgradeContext.getInstance().getFirmwarePackageMap().get(key).getPackageInfo().getSupportModelUID().toLowerCase(Locale.ENGLISH);
    }

    private List<String> getMappedFirmwarePackageEntityWithDeviceUIDOrAll(List<String> firmwareKeys, String productUniqueId) {
        if (productUniqueId == null || productUniqueId.isEmpty()) {
            return new ArrayList<String>(0);
        }
        return firmwareKeys.stream().filter(key -> {
            String supportUid = BundleUpgradeContext.getInstance().getFirmwarePackageMap().get(key).getPackageInfo().getSupportModelUID().toLowerCase(Locale.ENGLISH);
            return supportUid.contains(productUniqueId.toLowerCase(Locale.ENGLISH)) || supportUid.contains("all");
        }).collect(Collectors.toList());
    }

    private String buildUpgradeProfile(String localTmpDir, UpgradeParamConstants.ModuleType module, String targetFirmwareFilePath) throws UMateException {
        String profileLocation = localTmpDir + File.separator + module.getModule() + File.separator + "profile.xml";
        boolean isOK = FileOperation.mkdirs((File)FileUtils.getFile((String[])new String[]{profileLocation}).getParentFile());
        if (!isOK) {
            throw new UMateException(RES.getStringWithParams("create.profile.xml.failed", new Object[]{module.toString()}));
        }
        if (!UpgradeScenarioUtil.writeServerTargetProfileXMLContent("RACK", module, this.device, targetFirmwareFilePath, profileLocation)) {
            throw new UMateException(RES.getStringWithParams("profile.create.failed.on.module", new Object[]{module.getModule()}));
        }
        return profileLocation;
    }

    private String createLocalExecutionTmpPath() throws UMateException {
        if (this.device.getDeviceEntity() == null || this.device.getDeviceEntity().getIp() == null) {
            throw new UMateException(RES.getString("current.device.ip.invalid"));
        }
        String localNodeTempPath = BundleUpgradeContext.getInstance().getCurrentNodeTempPath(this.device.getDeviceEntity());
        boolean isOK = FileOperation.mkdirs((File)new File(localNodeTempPath));
        if (!isOK) {
            throw new UMateException(RES.getString("create.local.saved.dir.failed"));
        }
        log.info("temporary dir successfully created.");
        return localNodeTempPath;
    }
}

