/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.bundleupgrade.tasks;

import com.huawei.bundleupgrade.constants.UpgradeParamConstants;
import com.huawei.bundleupgrade.entity.FirmwarePackageEntity;
import com.huawei.bundleupgrade.entity.UpgradeStrategyEntity;
import com.huawei.bundleupgrade.utils.BundleUpgradeContext;
import com.huawei.ism.tool.houp.exception.HoupException;
import com.huawei.ism.tool.houp.utils.ClientUtils;
import com.huawei.ism.tool.houp.utils.HoupServer;
import com.huawei.uMate.common.UMateException;
import com.huawei.uMate.common.utils.ResUtil;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnlineFirmwareDownloadTask
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(OnlineFirmwareDownloadTask.class);
    private static final ResUtil RES = ResUtil.getInstance((String)"BundleUpgrade");
    private static final ReentrantLock downloadPermissionLock = new ReentrantLock();
    private UpgradeStrategyEntity strategyEntity;

    public OnlineFirmwareDownloadTask(UpgradeStrategyEntity strategyEntity) {
        this.strategyEntity = strategyEntity;
    }

    @Override
    public void run() {
        log.info(String.format(Locale.ENGLISH, "now start to download firmware packages of strategy %s.", this.strategyEntity.getUuid()));
        Map<UpgradeParamConstants.ModuleType, List<String>> targetFirmwareMap = this.strategyEntity.getModuleTargetFirmwareMap();
        BundleUpgradeContext context = BundleUpgradeContext.getInstance();
        ConcurrentHashMap<String, FirmwarePackageEntity> firmwareMap = context.getFirmwarePackageMap();
        try (CloseableHttpClient httpClient = ClientUtils.getCloseableHttpClient((boolean)context.isVerifyCert());){
            targetFirmwareMap.values().forEach(fwList -> this.downloadFirmwares(context, firmwareMap, (List<String>)fwList, httpClient));
        }
        catch (IOException e) {
            log.error("download packages from houp error!");
        }
        log.info(String.format(Locale.ENGLISH, "the  %s\u2018s firmware upgrade packages download task is finished.", this.strategyEntity.getUuid()));
    }

    private void downloadFirmwares(BundleUpgradeContext context, ConcurrentHashMap<String, FirmwarePackageEntity> firmwareMap, List<String> fwList, CloseableHttpClient httpClient) {
        fwList.stream().map(firmwareMap::get).filter(this::fetchFwDownloadLock).forEach(fw -> this.downloadFirmwareAndUpdateInfo(context, (FirmwarePackageEntity)fw, httpClient));
    }

    private void downloadFirmwareAndUpdateInfo(BundleUpgradeContext context, FirmwarePackageEntity fw, CloseableHttpClient httpClient) {
        String[] separateUrls = fw.getOnlinePathAbs().split("server/Huawei/");
        try {
            this.downloadFile(httpClient, fw.getLocalPathAbs(), fw.getOnlinePathAbs());
            this.downloadFile(httpClient, fw.getLocalPathAbs(), fw.getOnlineAesFilePathAbs());
            fw.setLocalPathAbs(fw.getLocalPathAbs() + File.separator + separateUrls[1]);
            fw.setDownloadStatus(UpgradeParamConstants.FirmwareDownloadStatus.FINISHED);
        }
        catch (UMateException e) {
            log.error(String.format(Locale.ENGLISH, "download error: %s.", RES.getStringWithParams("bundle.upgrade.connection.error5", new Object[]{fw.getPackageInfo().getPackageName()})), (Throwable)e);
            fw.setDownloadStatus(UpgradeParamConstants.FirmwareDownloadStatus.FAILED);
        }
        catch (HoupException ex) {
            log.error(String.format(Locale.ENGLISH, "download error: %s.", RES.getStringWithParams("bundle.upgrade.connection.error5", new Object[]{fw.getPackageInfo().getPackageName()})), (Throwable)ex);
            fw.setDownloadStatus(UpgradeParamConstants.FirmwareDownloadStatus.FAILED);
        }
    }

    private void downloadFile(CloseableHttpClient httpClient, String localPath, String onlinePath) throws UMateException, HoupException {
        HoupServer.downloadFileByAksk((String)this.strategyEntity.getHoupUserName(), (String)this.strategyEntity.getHoupPsd(), (String)onlinePath, (String)localPath, (CloseableHttpClient)httpClient);
    }

    private boolean fetchFwDownloadLock(FirmwarePackageEntity fwEntity) {
        downloadPermissionLock.lock();
        try {
            if (!fwEntity.isDownloaded() && fwEntity.getDownloadStatus() != UpgradeParamConstants.FirmwareDownloadStatus.DOWNLOADING) {
                fwEntity.setDownloadStatus(UpgradeParamConstants.FirmwareDownloadStatus.DOWNLOADING);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            downloadPermissionLock.unlock();
        }
    }
}

