/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.bundleupgrade.tasks;

import com.huawei.bundleupgrade.constants.UpgradeParamConstants;
import com.huawei.bundleupgrade.entity.UpgradeDeviceEntity;
import com.huawei.bundleupgrade.tasks.DeviceUpgradeMainTask;
import com.huawei.bundleupgrade.utils.BundleUpgradeContext;
import com.huawei.bundleupgrade.utils.PoolTaskExecutor;
import com.huawei.bundleupgrade.utils.ServiceUtil;
import com.huawei.uMate.common.utils.ResUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PoolUpgradeTask
implements Callable<UpgradeDeviceEntity> {
    private static final Logger log = LoggerFactory.getLogger(PoolUpgradeTask.class);
    private static final ResUtil RES = ResUtil.getInstance((String)"BundleUpgrade");
    private PoolTaskExecutor executor = new PoolTaskExecutor();
    private CompletionService<UpgradeDeviceEntity> rebootService = new ExecutorCompletionService<UpgradeDeviceEntity>(this.executor);
    private CountDownLatch countDownLatch;
    private Queue<Future<UpgradeDeviceEntity>> rebootedResultQueue = new LinkedBlockingQueue<Future<UpgradeDeviceEntity>>();
    private long nodeCount;
    private List<UpgradeDeviceEntity> finishList = new ArrayList<UpgradeDeviceEntity>();
    private long addedNodeCount = 0L;
    private Queue<UpgradeDeviceEntity> waitAdd2ExecuteQueue = new LinkedBlockingQueue<UpgradeDeviceEntity>();

    public PoolUpgradeTask(CountDownLatch countADownLatch, int nodeCount) {
        this.countDownLatch = countADownLatch;
        this.nodeCount = nodeCount;
    }

    @Override
    public UpgradeDeviceEntity call() {
        while ((long)this.finishList.size() < this.nodeCount) {
            this.submitTask();
            ServiceUtil.safeSleep(1000L);
            if (this.executor.isShutdown() && this.executor.getActiveCount() == 0) {
                log.info("exit pool task.");
                break;
            }
            if (this.rebootedResultQueue.size() == 0) continue;
            Future<UpgradeDeviceEntity> resultFuture = this.rebootedResultQueue.poll();
            if (resultFuture.isDone()) {
                try {
                    UpgradeDeviceEntity bentity = resultFuture.get();
                    this.finishList.add(bentity);
                }
                catch (InterruptedException | ExecutionException e) {
                    e.printStackTrace();
                }
                continue;
            }
            this.rebootedResultQueue.add(resultFuture);
        }
        this.executor.shutdown();
        return this.finishList.get(0);
    }

    private void submitTask() {
        while (!this.waitAdd2ExecuteQueue.isEmpty() && this.addedNodeCount < this.nodeCount) {
            UpgradeDeviceEntity entity = this.waitAdd2ExecuteQueue.poll();
            if (this.executor.isShutdown()) {
                this.refreshDevice2Ternimate(entity);
                continue;
            }
            DeviceUpgradeMainTask task = new DeviceUpgradeMainTask(entity, BundleUpgradeContext.getInstance().getMainDialog(), this.countDownLatch);
            Future<UpgradeDeviceEntity> resultFuture = this.rebootService.submit(task);
            this.rebootedResultQueue.add(resultFuture);
            log.info("add device to reboot pool queue:{}", (Object)entity.getDeviceEntity().getIp());
            ++this.addedNodeCount;
            if (this.addedNodeCount != this.nodeCount) continue;
            this.executor.shutdown();
        }
    }

    public void addNode2RebootQueue(UpgradeDeviceEntity entity) {
        if (this.executor.isShutdown()) {
            this.refreshDevice2Ternimate(entity);
            return;
        }
        this.waitAdd2ExecuteQueue.add(entity);
    }

    private void refreshDevice2Ternimate(UpgradeDeviceEntity entity) {
        this.countDownLatch.countDown();
        entity.setProcessStatus(UpgradeParamConstants.UpgradeStatus.FAILED);
        double progress = entity.getExecuteInfo().getResults().get(entity.getExecuteInfo().getResults().size() - 1).getTotalProgress();
        BundleUpgradeContext.getInstance().getMainDialog().createExecuteResult(entity, RES.getString("former.device.in.cluster.failed.in.same.pool"));
        BundleUpgradeContext.getInstance().getMainDialog().updateExecuteResult(entity, RES.getString("former.device.in.cluster.failed.in.same.pool"), (Double)progress, false);
        log.info("refresh Device to Terminate: {}, count:{}", (Object)entity.getDeviceEntity().getIp(), (Object)this.countDownLatch.toString());
        BundleUpgradeContext.getInstance().getMainDialog().refreshTable(entity);
    }

    public void cancelPoolTask() {
        for (int i = 0; i < this.executor.getQueue().size(); ++i) {
            this.countDownLatch.countDown();
        }
        log.info("cancel pool task,current count down latch:{}", (Object)this.countDownLatch.toString());
        this.executor.getQueue().clear();
        this.executor.shutdown();
    }
}

