/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.bundleupgrade.ui;

import com.huawei.bundleupgrade.actions.ParallelUpgradeAction;
import com.huawei.bundleupgrade.constants.UpgradeParamConstants;
import com.huawei.bundleupgrade.entity.NodeUpgradePriorityEnums;
import com.huawei.bundleupgrade.entity.UpgradeDeviceEntity;
import com.huawei.bundleupgrade.entity.fusionstrg.UpgDeviceExtendFSDataEntity;
import com.huawei.bundleupgrade.model.ExecuteInfo;
import com.huawei.bundleupgrade.model.ExecuteResult;
import com.huawei.bundleupgrade.service.ParseAllDeviceNodesCallable;
import com.huawei.bundleupgrade.service.QueryDeviceInfoService;
import com.huawei.bundleupgrade.service.connection.fusionstrg.FusionStorageRestConnector;
import com.huawei.bundleupgrade.service.impl.ReportServiceImpl;
import com.huawei.bundleupgrade.tasks.PoolUpgradeTask;
import com.huawei.bundleupgrade.ui.IUpgradeUiObserver;
import com.huawei.bundleupgrade.ui.card.ParamSettingWizard;
import com.huawei.bundleupgrade.ui.component.UpgradeStatusCell;
import com.huawei.bundleupgrade.ui.dialog.ExportVersionInfoDialog;
import com.huawei.bundleupgrade.ui.layout.BundleUpgradeLayout;
import com.huawei.bundleupgrade.ui.listener.ParamDetailListener;
import com.huawei.bundleupgrade.ui.listener.UpgradeWindowListener;
import com.huawei.bundleupgrade.utils.BundleUpgradeContext;
import com.huawei.bundleupgrade.utils.ItemProgressUpdateUtil;
import com.huawei.bundleupgrade.utils.UpgradeConstants;
import com.huawei.bundleupgrade.utils.UpgradeScenarioUtil;
import com.huawei.bundleupgrade.utils.UpgradeThreadTaskExecutor;
import com.huawei.bundleupgrade.utils.fusionstrg.FusionStrgUpgradeContext;
import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.tool.base.ui.UiMethod;
import com.huawei.ism.tool.base.ui.dialogs.HelpTitleFrame;
import com.huawei.ism.tool.base.utils.DateUtil;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.bizpack.wizardparse.ui.dialog.ErrorDetailInfoDialog;
import com.huawei.ism.tool.distributedfwupg.utils.CommonUtils;
import com.huawei.ism.tool.distributedfwupg.utils.UpgradeContext;
import com.huawei.ism.tool.obase.filechooser.ToolFileChooser;
import com.huawei.ism.tool.obase.utils.FileUtils;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.dialog.WarningDialog;
import com.huawei.ism.ui.swing.plaf.armor.ArmorListUI;
import com.huawei.ism.ui.swing.table.DefaultTableRow;
import com.huawei.ism.ui.swing.table.IsmTableCell;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.ism.util.SerialSet;
import com.huawei.ism.util.SwingUtil;
import com.huawei.uMate.common.UMateException;
import com.huawei.uMate.common.utils.AppContext;
import com.huawei.uMate.common.utils.ResUtil;
import com.huawei.uMate.common.utils.SecurityUtils;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.ImageObserver;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JScrollBar;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ListUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BundleUpgradeMainDialog
extends HelpTitleFrame
implements IUpgradeUiObserver {
    private static final Logger log = LoggerFactory.getLogger(BundleUpgradeMainDialog.class);
    private static final ResUtil RES = ResUtil.getInstance((String)"BundleUpgrade");
    private static final String GRAY_COLOR = "<font color=#C0C0C0>";
    private static final int PM_TARGET_CELL_POSITION = 1;
    private static final int UT_TARGET_CELL_POSITION = 10;
    private BundleUpgradeLayout mainPanel;
    private List<String> productModels = new ArrayList<String>();
    private List<String> upgradeStatus = new ArrayList<String>();

    public BundleUpgradeMainDialog() {
        List result = AsyncExcutor.execute((Window)((Object)this), (Callable[])new Callable[]{new ParseAllDeviceNodesCallable()});
        boolean resultMsg = Boolean.parseBoolean(result.get(0).toString());
        if (!resultMsg) {
            try {
                TimeUnit.MILLISECONDS.sleep(1200L);
            }
            catch (InterruptedException e1) {
                log.error("Abnormal sleep.", (Throwable)e1);
            }
            String errorMsg = RES.getString("bundle.upgrade.main.find.device.error");
            log.error("Failed to get device information.");
            DialogUtils.showErrorDialog((Window)((Object)this), (String)errorMsg);
            BundleUpgradeContext.getInstance().fireToolStopped();
        }
        this.initUI();
        this.initListener();
        AppContext.getInstance().setMainJFrame((JFrame)((Object)this));
        this.setIconImage(new ImageIcon("images/bundleUpgrade.png").getImage());
        UiMethod.putScreenCenter((Window)((Object)this));
        BundleUpgradeContext.getInstance().setMainDialog(this);
        BundleUpgradeContext.getInstance().addObserver(this);
        this.showAllDevices();
        this.mainPanel.setTableRows(this.mainPanel.getDevTableModel().getAllRows());
        QueryDeviceInfoService.getInstance().queryDeviceInfo(BundleUpgradeContext.getInstance().getDeviceUpgradeInfos());
        UpgradeConstants.PROCESSING_IMAGE.setImageObserver((ImageObserver)((Object)this));
        this.setVisible(true);
    }

    public void doHelpActionWork() {
        FileUtils.openHelpFile((String)"BundleUpgrade", (Window)((Object)this), (String)".chm");
    }

    public BundleUpgradeLayout getMainPanel() {
        return this.mainPanel;
    }

    private void initListener() {
        this.addWindowListener(new UpgradeWindowListener());
        this.mainPanel.getDevTable().addListSelectionListener(ex -> this.refreshDetailList());
        this.mainPanel.getDetailList().addMouseListener(new ListMouseAdapter());
        this.mainPanel.getExportBtn().addActionListener(event -> {
            log.info("click export button.");
            ExportVersionInfoDialog dialog = new ExportVersionInfoDialog((Window)((Object)BundleUpgradeContext.getInstance().getMainDialog()));
            UiMethod.putScreenCenter((Window)((Object)dialog));
            dialog.setVisible(true);
        });
        this.mainPanel.getExportUpdReportBtn().addActionListener(event -> this.exportUpdResultReport());
        this.mainPanel.getProcessBtn().addActionListener(event -> {
            log.info("click process button.");
            ParallelUpgradeAction paralleUpgradeAction = new ParallelUpgradeAction();
            try {
                paralleUpgradeAction.batchDoUpgrade(this.getSelectedNodes(), this);
            }
            catch (UMateException exception) {
                DialogUtils.showErrorDialog((Window)((Object)this), (String)exception.getMessage());
                return;
            }
            catch (Exception exp) {
                log.error("error occurred:", (Throwable)exp);
            }
            if (!FusionStrgUpgradeContext.getInstance().isEndUpgrade()) {
                this.mainPanel.getTerminateBtn().setVisible(true);
            }
        });
        this.mainPanel.getTerminateBtn().addActionListener(event -> this.terminateAllWaitingTaskAction());
        this.mainPanel.getParamSetBtn().addActionListener(event -> this.goToParamSetting());
        this.mainPanel.getTableContentPane().getPmMultiCombox().addActionListener(action -> this.filterDevice());
        this.mainPanel.getTableContentPane().getStatusMultiCombox().addActionListener(action -> this.filterDevice());
    }

    private void filterDevice() {
        List<Object> selectedProductModels = this.mainPanel.getTableContentPane().getPmMultiCombox().getSelectedValues();
        this.productModels.clear();
        for (Object obj : selectedProductModels) {
            if (!(obj instanceof String)) continue;
            this.productModels.add((String)obj);
        }
        List<Object> selectedStatus = this.mainPanel.getTableContentPane().getStatusMultiCombox().getSelectedValues();
        this.upgradeStatus.clear();
        for (Object obj : selectedStatus) {
            if (!(obj instanceof String)) continue;
            this.upgradeStatus.add((String)obj);
        }
        this.fastFilterDevices(this.productModels, this.upgradeStatus);
    }

    private void fastFilterDevices(List<String> selectedProductModels, List<String> selectedStatus) {
        List<TableRow> tableRows = this.filterDeviceWithTarget(selectedProductModels, selectedStatus);
        this.mainPanel.getDevTableModel().removeAll();
        this.mainPanel.getDevTableModel().addRow(tableRows);
        this.mainPanel.getDevTable().repaint();
    }

    private List<TableRow> filterDeviceWithTarget(List<String> selectedProductModels, List<String> selectedStatus) {
        if ((this.productModels.isEmpty() || RES.getString("filter.comboBox.default.all.device.type").equals(this.productModels.get(0))) && (this.upgradeStatus.isEmpty() || RES.getString("filter.comboBox.default.all.upgrade.status").equals(this.upgradeStatus.get(0)))) {
            return this.mainPanel.getTableRows();
        }
        ArrayList<TableRow> matchedTableList = new ArrayList<TableRow>();
        for (TableRow tableRow : this.mainPanel.getTableRows()) {
            Object productModelTargetCell = tableRow.getValueAt(1);
            Object upgradeStatusTargetCell = tableRow.getValueAt(10);
            if (!(productModelTargetCell instanceof String) || !(upgradeStatusTargetCell instanceof UpgradeStatusCell)) continue;
            String productModelCell = (String)productModelTargetCell;
            UpgradeStatusCell tableRowStatusCell = (UpgradeStatusCell)((Object)upgradeStatusTargetCell);
            if (!this.containsProductModel(selectedProductModels, productModelCell) || !this.containsStatus(selectedStatus, tableRowStatusCell)) continue;
            matchedTableList.add(tableRow);
        }
        return matchedTableList;
    }

    private boolean containsProductModel(List<String> selectedProductModels, String productModelCell) {
        if (selectedProductModels.size() == 0 || selectedProductModels.get(0).equals(RES.getString("filter.comboBox.default.all.device.type"))) {
            return true;
        }
        return selectedProductModels.contains(productModelCell);
    }

    private boolean containsStatus(List<String> selectedStatus, UpgradeStatusCell tableRowStatusCell) {
        if (selectedStatus.size() == 0 || selectedStatus.get(0).equals(RES.getString("filter.comboBox.default.all.upgrade.status"))) {
            return true;
        }
        return selectedStatus.contains(tableRowStatusCell.getStatus().toString());
    }

    private void terminatePoolTask() {
        Map<String, PoolUpgradeTask> poolUpgradeTaskMap = FusionStrgUpgradeContext.getInstance().getPoolTaskMap();
        for (PoolUpgradeTask poolUpgradeTask : poolUpgradeTaskMap.values()) {
            poolUpgradeTask.cancelPoolTask();
        }
        this.refreshAllWaitingDevices2Aborted();
    }

    public void terminateAllWaitingTaskAction() {
        log.info("click stop button.");
        if (FusionStrgUpgradeContext.getInstance().isEndUpgrade()) {
            DialogUtils.showInfoDialog((Frame)((Object)this), (String)RES.getString("main.dialogue.show.tip.on.terminate.nosupport"));
            return;
        }
        WarningDialog dialog = DialogUtils.showYesNoDialog((Window)((Object)this), (String)RES.getString("main.dialogue.show.tip.on.terminate.all"), (boolean)true);
        if (0 == dialog.getValue()) {
            FusionStrgUpgradeContext.getInstance().setEndUpgrade(true);
            UpgradeThreadTaskExecutor.getExecutor().purge();
            BlockingQueue<Runnable> waitingQueue = UpgradeThreadTaskExecutor.getExecutor().getQueue();
            log.info(String.format(Locale.ENGLISH, "current execution waiting queue size: %d.", waitingQueue.size()));
            if (!waitingQueue.isEmpty()) {
                ArrayList queueContents = new ArrayList(1);
                int taskSize = waitingQueue.drainTo(queueContents);
                log.warn(String.format(Locale.ENGLISH, "[WARNING]user choose to terminates %d tasks.", taskSize));
                this.refreshAllWaitingDevices2Aborted();
            }
            this.terminatePoolTask();
        } else {
            log.info("Canceling upgrade task.");
        }
    }

    public void refreshAllWaitingDevices2Aborted() {
        for (UpgradeDeviceEntity entity : BundleUpgradeContext.getInstance().getDeviceUpgradeInfos()) {
            if (!entity.isWaiting()) continue;
            if (entity.getProcessStatus().equals((Object)UpgradeParamConstants.UpgradeStatus.WAIT_REBOOT)) {
                entity.setProcessStatus(UpgradeParamConstants.UpgradeStatus.ABORT_REBOOT);
            } else {
                entity.setProcessStatus(UpgradeParamConstants.UpgradeStatus.FAILED);
            }
            entity.setResultMsg(RES.getString("user.cancel.upgrade.operation"));
            this.createExecuteResult(entity, entity.getResultMsg());
            this.updateExecuteResult(entity, entity.getResultMsg(), (Double)100.0, false);
            this.refreshTable(entity);
            this.mainPanel.getTableContentPane().finishOneDev();
        }
    }

    private void exportUpdResultReport() {
        log.info("click export upgrade result report button.");
        if (!this.checkIfCanExport()) {
            return;
        }
        UpgradeContext.getInstance().setSceneCollectDir();
        String time = DateUtil.formatDate((Date)new Date(), (String)"yyyyMMddHHmmss");
        String saveFilePath = ToolFileChooser.getSaveFilePath((String)RES.getString("bundle.upgrade.main.btn.export.result"), (String)"zip", (Window)((Object)BundleUpgradeContext.getInstance().getMainDialog()), (String)("UpgradeReport-" + time + ".zip"), (String)"BundleUpgradeResult");
        if (saveFilePath == null) {
            return;
        }
        if (!SecurityUtils.isValidAndSafePath((String)saveFilePath)) {
            log.error(String.format(Locale.ROOT, " %s is not valid and safe path", saveFilePath));
            return;
        }
        boolean result = ReportServiceImpl.getInstance().generateReport(saveFilePath, BundleUpgradeContext.getInstance().getDeviceUpgradeInfos());
        if (!result) {
            String tipKey = "bundle.upgrade.main.btn.export.result.failed";
            DialogUtils.showInfoDialog((Frame)((Object)BundleUpgradeContext.getInstance().getMainDialog()), (String)RES.getString(tipKey));
        }
    }

    private boolean checkIfCanExport() {
        log.info("No upgrade completed tasks.");
        List<UpgradeDeviceEntity> toUpgradeDevs = BundleUpgradeContext.getInstance().getDeviceUpgradeInfos();
        boolean hasRunning = toUpgradeDevs.stream().anyMatch(UpgradeDeviceEntity::isUpgrading);
        if (hasRunning) {
            DialogUtils.showInfoDialog((Frame)((Object)BundleUpgradeContext.getInstance().getMainDialog()), (String)RES.getString("bundle.upgrade.task.running.export.tip"));
            log.info("no started device.");
            return false;
        }
        boolean isSomeDevUpdEnd = toUpgradeDevs.stream().anyMatch(UpgradeDeviceEntity::isUpdEnd);
        if (!isSomeDevUpdEnd) {
            DialogUtils.showInfoDialog((Frame)((Object)BundleUpgradeContext.getInstance().getMainDialog()), (String)RES.getString("bundle.upgrade.task.no.done.export.tip"));
            log.info("no completed device.");
            return false;
        }
        return true;
    }

    private void initUI() {
        this.mainPanel = new BundleUpgradeLayout();
        this.add(this.mainPanel);
        this.setResizable(true);
        this.validate();
        this.pack();
        this.setSize(new Dimension(1200, 700));
        this.setTitle(RES.getString("bundle.upgrade.name"));
        this.setDefaultCloseOperation(0);
        SwingUtil.putScreenCenter((Window)((Object)this));
    }

    private void showAllDevices() {
        List<UpgradeDeviceEntity> deviceEntities = BundleUpgradeContext.getInstance().getDeviceUpgradeInfos();
        List<UpgradeDeviceEntity> deviceUpgradeInfos = this.sortNodeByServiceType(deviceEntities);
        int[] selectRows = this.mainPanel.getDevTable().getSelectedRows();
        this.mainPanel.getDevTableModel().removeAll();
        for (UpgradeDeviceEntity deviceUpgradeInfo : deviceUpgradeInfos) {
            TableRow<UpgradeDeviceEntity, String> row = this.createDeviceTableRow(deviceUpgradeInfo);
            this.mainPanel.getDevTableModel().addRow(new TableRow[]{row});
        }
        if (selectRows.length == 0) {
            this.mainPanel.getDevTable().selectAll();
        } else {
            for (Object selectedRowIndic : (Object)selectRows) {
                this.mainPanel.getDevTable().markTableRow(new TableRow[]{this.mainPanel.getDevTableModel().getRow((int)selectedRowIndic)});
            }
        }
        this.refreshDetailList();
    }

    private List<UpgradeDeviceEntity> sortNodeByServiceType(List<UpgradeDeviceEntity> deviceUpgradeInfos) {
        Map<NodeUpgradePriorityEnums, List<UpgradeDeviceEntity>> nodeMap = deviceUpgradeInfos.stream().collect(Collectors.groupingBy(node -> node.getDeviceEntity().getServiceType()));
        nodeMap.computeIfPresent(NodeUpgradePriorityEnums.ONLY_STORAGE_POOL_SERVICE, (serverType, nodeList) -> this.crossSortANodes((List<UpgradeDeviceEntity>)nodeList));
        ArrayList<UpgradeDeviceEntity> sortedNodes = new ArrayList<UpgradeDeviceEntity>(deviceUpgradeInfos.size());
        List<NodeUpgradePriorityEnums> addPriority = Arrays.asList(NodeUpgradePriorityEnums.ONLY_STORAGE_POOL_SERVICE, NodeUpgradePriorityEnums.NO_SERVICE, NodeUpgradePriorityEnums.NON_STORAGE_POOL_SERVICE_EXISTS, NodeUpgradePriorityEnums.DIRECT_PLANE);
        addPriority.forEach(serverType -> sortedNodes.addAll(nodeMap.getOrDefault(serverType, Collections.emptyList())));
        for (int index = 0; index < sortedNodes.size(); ++index) {
            ((UpgradeDeviceEntity)sortedNodes.get(index)).setIndex(index);
        }
        return sortedNodes;
    }

    private List<UpgradeDeviceEntity> crossSortANodes(List<UpgradeDeviceEntity> aNodes) {
        Map<String, Queue> groupedDevices = aNodes.stream().collect(Collectors.groupingBy(node -> node.getDeviceEntity().getPoolId(), Collectors.mapping(node -> node, Collectors.toCollection(LinkedList::new))));
        ArrayList<UpgradeDeviceEntity> allNodes = new ArrayList<UpgradeDeviceEntity>();
        while (!groupedDevices.isEmpty()) {
            Iterator<Map.Entry<String, Queue>> deviceIterator = groupedDevices.entrySet().iterator();
            while (deviceIterator.hasNext()) {
                Map.Entry<String, Queue> entry = deviceIterator.next();
                if (entry.getValue().isEmpty()) {
                    deviceIterator.remove();
                    continue;
                }
                allNodes.add((UpgradeDeviceEntity)entry.getValue().poll());
            }
        }
        return allNodes;
    }

    private void refreshDetailList() {
        this.refreshRemainTime();
        this.mainPanel.getDetailList().setListData(new ExecuteResult[0]);
        if (this.mainPanel.getDevTable().getSelectedRows().length > 1) {
            return;
        }
        UpgradeDeviceEntity node = this.getSelectedDevNode();
        this.setListDate(node);
    }

    private void refreshRemainTime() {
        int totalTime = this.calculateRemainTime();
        int totalHours = totalTime / 60;
        int totalMinus = totalTime % 60;
        this.getMainPanel().getTableContentPane().refreshRemainTime(totalHours, totalMinus);
    }

    public int calculateRemainTime() {
        List<UpgradeDeviceEntity> nodes = this.getSelectedNodes();
        HashMap<String, Integer> poolNodeNumMap = new HashMap<String, Integer>();
        int nodeNum = nodes.size();
        int configThreadNum = UpgradeScenarioUtil.getUpgradeExecutionThreadMaxSize();
        int threadPool = Math.max(configThreadNum, 1);
        for (UpgradeDeviceEntity node : nodes) {
            if (!node.isParallelByPoolId()) continue;
            String poolId = node.getDeviceEntity().getPoolId();
            if (poolNodeNumMap.containsKey(poolId)) {
                poolNodeNumMap.put(poolId, (Integer)poolNodeNumMap.get(poolId) + 1);
                continue;
            }
            poolNodeNumMap.put(poolId, 1);
        }
        int poolMaxNodeNum = poolNodeNumMap.values().size() == 0 ? 0 : (Integer)Collections.max(poolNodeNumMap.values());
        int batchNum = nodeNum % threadPool == 0 ? nodeNum / threadPool : nodeNum / threadPool + 1;
        return batchNum * 25 + poolMaxNodeNum * 30 + this.calculateTypeBNodeNum() * 30;
    }

    private int calculateTypeBNodeNum() {
        List<UpgradeDeviceEntity> nodes = this.getSelectedNodes();
        return (int)nodes.stream().filter(UpgradeDeviceEntity::isNodeB).count();
    }

    private void setListDate(UpgradeDeviceEntity node) {
        if (null == node) {
            return;
        }
        List<ExecuteResult> results = node.getExecuteInfo().getResults();
        if (null != results) {
            this.mainPanel.getDetailList().setListData(results.toArray());
        } else {
            this.mainPanel.getDetailList().setListData(new ArrayList().toArray());
        }
    }

    public List<UpgradeDeviceEntity> getSelectedNodes() {
        ArrayList<UpgradeDeviceEntity> upgradeDeviceEntityList = new ArrayList<UpgradeDeviceEntity>();
        int[] rows = this.mainPanel.getDevTable().getSelectedRows();
        if (rows == null || rows.length == 0) {
            return upgradeDeviceEntityList;
        }
        for (int value : rows) {
            int index = this.mainPanel.getDevTable().convertRowIndexToModel(value);
            TableRow row = this.mainPanel.getDevTableModel().getRow(index);
            UpgradeDeviceEntity devNode = (UpgradeDeviceEntity)row.getUserObject();
            upgradeDeviceEntityList.add(devNode);
        }
        return upgradeDeviceEntityList;
    }

    public List<UpgradeDeviceEntity> getAllNodes() {
        SerialSet rowList = this.mainPanel.getDevTableModel().getRowList();
        return rowList.stream().map(row -> (UpgradeDeviceEntity)row.getUserObject()).collect(Collectors.toList());
    }

    private UpgradeDeviceEntity getSelectedDevNode() {
        int[] rows = this.mainPanel.getDevTable().getSelectedRows();
        if (rows == null || rows.length == 0) {
            return null;
        }
        int index = this.mainPanel.getDevTable().convertRowIndexToModel(rows[0]);
        TableRow row = this.mainPanel.getDevTableModel().getRow(index);
        return (UpgradeDeviceEntity)row.getUserObject();
    }

    private TableRow<UpgradeDeviceEntity, String> createDeviceTableRow(UpgradeDeviceEntity upgradeDeviceEntity) {
        String key = upgradeDeviceEntity.getDeviceEntity().getSerialNumber() + upgradeDeviceEntity.getDeviceEntity().getIp();
        DefaultTableRow row = new DefaultTableRow(this.mainPanel.getDevTableModel().getAllColumnCount(), (Object)upgradeDeviceEntity, (Object)key);
        int progress = 0;
        UpgradeParamConstants.UpgradeStatus status = UpgradeParamConstants.UpgradeStatus.NOTASSOCIATED;
        this.fillInTableRowColumns(upgradeDeviceEntity, (TableRow<UpgradeDeviceEntity, String>)row, progress, status);
        return row;
    }

    private void fillInTableRowColumns(UpgradeDeviceEntity upgradeDeviceEntity, TableRow<UpgradeDeviceEntity, String> row, int progress, UpgradeParamConstants.UpgradeStatus status) {
        List<String> currentTableHeaders = BundleUpgradeLayout.getFusionStrgMainTableColumnsList();
        row.setValueAt(currentTableHeaders.indexOf(RES.getString("bundle.upgrade.main.table.col.fs.bmc.ip")), (Object)upgradeDeviceEntity.getDeviceEntity().getIp());
        row.setValueAt(currentTableHeaders.indexOf(RES.getString("bundle.upgrade.main.table.col.fs.mngmnt.ip")), (Object)this.getCorrespondingFusionStorageManagementIp(upgradeDeviceEntity));
        row.setValueAt(currentTableHeaders.indexOf(RES.getString("bundle.upgrade.main.table.col.fs.kernel.version")), (Object)upgradeDeviceEntity.getDeviceEntity().getKernelVersion());
        String poolId = upgradeDeviceEntity.getDeviceEntity().getStoragePoolId();
        poolId = StringUtils.isNULLStr((String)poolId) ? "--" : poolId;
        row.setValueAt(currentTableHeaders.indexOf(RES.getString("bundle.upgrade.main.table.pool.id")), (Object)poolId);
        String diskPoolId = upgradeDeviceEntity.getDeviceEntity().getDiskPoolId();
        diskPoolId = StringUtils.isNULLStr((String)diskPoolId) ? "--" : diskPoolId;
        row.setValueAt(currentTableHeaders.indexOf(RES.getString("bundle.upgrade.main.table.disk.pool.id")), (Object)diskPoolId);
        row.setValueAt(currentTableHeaders.indexOf(RES.getString("bundle.upgrade.main.table.service.type")), (Object)new IsmTableCell.CustomLabelCell(upgradeDeviceEntity.getDeviceEntity().getServiceType().getDes(), (Comparable)new PoolColSorter(upgradeDeviceEntity)));
        row.setValueAt(currentTableHeaders.indexOf(RES.getString("bundle.upgrade.main.table.col.fs.floatip")), (Object)this.getCorrespondingFusionStorageFloatIp(upgradeDeviceEntity));
        row.setValueAt(currentTableHeaders.indexOf(RES.getString("bundle.upgrade.main.table.chassisId")), (Object)upgradeDeviceEntity.getDeviceEntity().getChassisId());
        row.setValueAt(currentTableHeaders.indexOf(RES.getString("bundle.upgrade.main.table.col2")), (Object)upgradeDeviceEntity.getDeviceEntity().getProductTypeShow());
        row.setValueAt(currentTableHeaders.indexOf(RES.getString("bundle.upgrade.main.table.col3")), (Object)this.getVersionPretty(upgradeDeviceEntity.getDeviceEntity().getMasterBMC()));
        row.setValueAt(currentTableHeaders.indexOf(RES.getString("bundle.upgrade.main.table.col4")), (Object)this.getVersionPretty(upgradeDeviceEntity.getDeviceEntity().getBiosVersion()));
        row.setValueAt(currentTableHeaders.indexOf(RES.getString("bundle.upgrade.main.table.col5")), (Object)"--");
        row.setValueAt(currentTableHeaders.indexOf(RES.getString("bundle.upgrade.main.table.col6")), (Object)this.getVersionPretty(upgradeDeviceEntity.getDeviceEntity().getSpVersion()));
        row.setValueAt(currentTableHeaders.indexOf(RES.getString("bundle.upgrade.main.table.col7")), (Object)new IsmTableCell.ProgressCell(progress));
        row.setValueAt(currentTableHeaders.indexOf(RES.getString("bundle.upgrade.main.table.col8")), (Object)new UpgradeStatusCell(status));
        if (status.equals((Object)UpgradeParamConstants.UpgradeStatus.NOTASSOCIATED)) {
            row.setValueAt(currentTableHeaders.indexOf(RES.getString("bundle.upgrade.main.table.col9")), (Object)new IsmTableCell.HyperlinkCell(GRAY_COLOR + RES.getString("bundle.upgrade.main.table.detail.parameter")));
        } else {
            row.setValueAt(currentTableHeaders.indexOf(RES.getString("bundle.upgrade.main.table.col9")), (Object)new IsmTableCell.HyperlinkCell(RES.getString("bundle.upgrade.main.table.detail.parameter"), (ActionListener)new ParamDetailListener(upgradeDeviceEntity)));
        }
    }

    private String getVersionPretty(String masterBMC) {
        return StringUtils.isNULLStr((String)masterBMC) ? "--" : masterBMC;
    }

    private String getCorrespondingFusionStorageManagementIp(UpgradeDeviceEntity upgradeDeviceEntity) {
        UpgDeviceExtendFSDataEntity fsDataEntity = FusionStrgUpgradeContext.getInstance().getBusinessIpMapper().get(upgradeDeviceEntity);
        return fsDataEntity == null ? "--" : fsDataEntity.getManagementIp();
    }

    private String getCorrespondingFusionStorageFloatIp(UpgradeDeviceEntity upgradeDeviceEntity) {
        UpgDeviceExtendFSDataEntity fsDataEntity = FusionStrgUpgradeContext.getInstance().getBusinessIpMapper().get(upgradeDeviceEntity);
        return fsDataEntity == null ? "--" : fsDataEntity.getBelongsClusterEntity().getFloatIp();
    }

    public void resultCallBack(UpgradeDeviceEntity upgradeDeviceEntity) {
        this.refreshTable(upgradeDeviceEntity);
        this.getBottomDetailList();
    }

    private void getBottomDetailList() {
        SwingUtilities.invokeLater(() -> {
            JScrollBar bar = this.mainPanel.getDetailListScrolPane().getVerticalScrollBar();
            bar.setValue(bar.getMaximum());
        });
    }

    public void refreshTable(UpgradeDeviceEntity node) {
        List rows = this.mainPanel.getDevTable().getAllRows();
        TableRow changeRow = this.getTargetRowUsingRowKey(node, rows).orElse(null);
        if (changeRow == null) {
            log.error("resultCallBack error. devNode : " + node.getDeviceEntity().getIp());
            return;
        }
        SwingUtilities.invokeLater(() -> {
            log.info("Update the basic info and upgrade item details of node {}.", (Object)node.getDeviceEntity().getIp());
            this.updateRow(node, (TableRow<UpgradeDeviceEntity, String>)changeRow);
            this.refreshDetailList();
            this.mainPanel.getDevTable().repaint();
        });
    }

    void updateRow(UpgradeDeviceEntity upgradeNode, TableRow<UpgradeDeviceEntity, String> changeRow) {
        List<String> currentTableHeaders = BundleUpgradeLayout.getFusionStrgMainTableColumnsList();
        String kernelVersion = upgradeNode.getDeviceEntity().getKernelVersion();
        changeRow.setValueAt(currentTableHeaders.indexOf(RES.getString("bundle.upgrade.main.table.col.fs.kernel.version")), (Object)(StringUtils.isNULLStr((String)kernelVersion) ? "--" : kernelVersion));
        changeRow.setValueAt(currentTableHeaders.indexOf(RES.getString("bundle.upgrade.main.table.col2")), (Object)upgradeNode.getDeviceEntity().getProductTypeShow());
        changeRow.setValueAt(currentTableHeaders.indexOf(RES.getString("bundle.upgrade.main.table.col3")), (Object)upgradeNode.getDeviceEntity().getMasterBMC());
        changeRow.setValueAt(currentTableHeaders.indexOf(RES.getString("bundle.upgrade.main.table.col4")), (Object)upgradeNode.getDeviceEntity().getBiosVersion());
        changeRow.setValueAt(currentTableHeaders.indexOf(RES.getString("bundle.upgrade.main.table.col5")), (Object)upgradeNode.getDeviceEntity().getActiveCPLDVersion());
        changeRow.setValueAt(currentTableHeaders.indexOf(RES.getString("bundle.upgrade.main.table.col6")), (Object)upgradeNode.getDeviceEntity().getSpVersion());
        UpgradeParamConstants.UpgradeStatus processStatus = upgradeNode.getProcessStatus();
        changeRow.setValueAt(currentTableHeaders.indexOf(RES.getString("bundle.upgrade.main.table.col8")), (Object)new UpgradeStatusCell(processStatus));
        int pro = (int)Math.floor(upgradeNode.getExecuteInfo().getTotalProcess());
        if (!processStatus.equals((Object)UpgradeParamConstants.UpgradeStatus.QUERYDEVINFO)) {
            if (processStatus.equals((Object)UpgradeParamConstants.UpgradeStatus.NOTASSOCIATED) || processStatus.equals((Object)UpgradeParamConstants.UpgradeStatus.NOSUPPORTED) || processStatus.equals((Object)UpgradeParamConstants.UpgradeStatus.UNKNOWN)) {
                changeRow.setValueAt(currentTableHeaders.indexOf(RES.getString("bundle.upgrade.main.table.col9")), (Object)new IsmTableCell.HyperlinkCell(GRAY_COLOR + RES.getString("bundle.upgrade.main.table.detail.parameter")));
                changeRow.setValueAt(currentTableHeaders.indexOf(RES.getString("bundle.upgrade.main.table.col7")), (Object)new IsmTableCell.ProgressCell(0));
            } else {
                changeRow.setValueAt(currentTableHeaders.indexOf(RES.getString("bundle.upgrade.main.table.col7")), (Object)new IsmTableCell.ProgressCell(pro));
                changeRow.setValueAt(currentTableHeaders.indexOf(RES.getString("bundle.upgrade.main.table.col9")), (Object)new IsmTableCell.HyperlinkCell(RES.getString("bundle.upgrade.main.table.detail.parameter"), (ActionListener)new ParamDetailListener(upgradeNode)));
            }
        }
    }

    private Optional<TableRow> getTargetRowUsingRowKey(UpgradeDeviceEntity node, List<TableRow> rows) {
        for (TableRow row : rows) {
            if (!((UpgradeDeviceEntity)row.getUserObject()).getDeviceEntity().getIp().equals(node.getDeviceEntity().getIp())) continue;
            return Optional.of(row);
        }
        return Optional.empty();
    }

    @Override
    public void updateItemProgress(UpgradeDeviceEntity dev, int progress, String itemId) {
        this.updateItemProgress(dev, progress, "", itemId);
    }

    @Override
    public void updateItemProgress(UpgradeDeviceEntity dev, int progress, String timeLeft, String itemId) {
        if (0 > progress || 100 < progress) {
            return;
        }
        ItemProgressUpdateUtil.INS.setProgress(dev.getDeviceEntity().getIp(), progress, timeLeft);
        this.setListDate(dev);
        this.mainPanel.getDetailList().repaint();
    }

    private void goToParamSetting() {
        log.info("Click Set Upgrade Policy.");
        List<UpgradeDeviceEntity> upgradeDeviceEntityList = this.getSelectedNodes();
        BundleUpgradeMainDialog mainDialog = BundleUpgradeContext.getInstance().getMainDialog();
        if (upgradeDeviceEntityList.isEmpty()) {
            DialogUtils.showInfoDialog((Frame)((Object)mainDialog), (String)RES.getString("bundle.upgrade.main.select.tip"));
            return;
        }
        String uidOrType = upgradeDeviceEntityList.get(0).getDeviceEntity().getUidOrType();
        if (upgradeDeviceEntityList.stream().map(UpgradeDeviceEntity::getDeviceEntity).anyMatch(dev -> !uidOrType.equals(dev.getUidOrType()))) {
            DialogUtils.showInfoDialog((Frame)((Object)mainDialog), (String)RES.getString("bundle.upgrade.main.select.warning"));
            return;
        }
        String kernelVersion = upgradeDeviceEntityList.get(0).getDeviceEntity().getKernelVersion();
        String isCheckKernel = CommonUtils.getSystemConfig("is.check.kernel.version", "true");
        if (Boolean.parseBoolean(isCheckKernel) && upgradeDeviceEntityList.stream().map(UpgradeDeviceEntity::getDeviceEntity).anyMatch(dev -> !kernelVersion.equals(dev.getKernelVersion()))) {
            DialogUtils.showInfoDialog((Frame)((Object)mainDialog), (String)RES.getString("bundle.upgrade.main.select.kernelVersion"));
            return;
        }
        List<UpgradeParamConstants.UpgradeStatus> notSupportStatus = UpgradeParamConstants.UpgradeStatus.notSupportSetStrategyUpgradeStatus();
        if (upgradeDeviceEntityList.stream().anyMatch(dev -> notSupportStatus.contains((Object)dev.getProcessStatus()))) {
            DialogUtils.showInfoDialog((Frame)((Object)mainDialog), (String)RES.getString("bundle.upgrade.main.select.warning.upgrade.status"));
            return;
        }
        upgradeDeviceEntityList.forEach(dev -> dev.setPrecheckFinish(false));
        BundleUpgradeContext.getInstance().setSelectedDeviceEntities(upgradeDeviceEntityList);
        BundleUpgradeContext.getInstance().updateFwTempId();
        new ParamSettingWizard();
    }

    public void createExecuteResult(UpgradeDeviceEntity upgradeDevice, String description) {
        ExecuteResult result = new ExecuteResult();
        result.setUpgradeDeviceEntity(upgradeDevice);
        result.setRunning(true);
        result.setDescription(description);
        result.setTime(new Date());
        ExecuteInfo info = upgradeDevice.getExecuteInfo();
        info.addResult(result);
        this.resultCallBack(upgradeDevice);
    }

    public void createResult(UpgradeDeviceEntity upgradeDevice, String moduleName, String hoverTips) {
        ExecuteResult result = new ExecuteResult();
        result.setUpgradeDeviceEntity(upgradeDevice);
        result.setRunning(true);
        result.setDescription(moduleName);
        result.setHoverTips(hoverTips);
        result.setTime(new Date());
        ExecuteInfo info = upgradeDevice.getExecuteInfo();
        info.addResult(result);
        this.resultCallBack(upgradeDevice);
    }

    public synchronized void updateExecuteResult(UpgradeDeviceEntity upgradeDevice, String detail, Double totalProgress, Boolean isSuccess) {
        ExecuteInfo info = upgradeDevice.getExecuteInfo();
        Double oldPro = info.getTotalProcess();
        Double progress = totalProgress;
        if (oldPro.intValue() > progress.intValue() || progress > 100.0) {
            log.info("Illegal pro, old por {} new pro {}.", (Object)oldPro, (Object)progress);
            progress = Math.min(oldPro + 1.0, 95.0);
        }
        log.info("device:{} update detail:{} ,progress:{} ,isSuccess:{}", new Object[]{upgradeDevice.getDeviceEntity().getIp(), detail, progress, isSuccess.toString()});
        if (!info.getResults().isEmpty()) {
            ExecuteResult lastResult = info.getResults().get(info.getResults().size() - 1);
            lastResult.setRunning(false);
            lastResult.setDetail(detail);
            lastResult.setTotalProgress(progress);
            lastResult.setSuccess(isSuccess);
            this.resultCallBack(upgradeDevice);
        }
    }

    public void updateExecuteResult(UpgradeDeviceEntity upgradeDevice, String detail, Double totalProgress, UpgradeParamConstants.SubProcessExecutionResult executionResult) {
        ExecuteInfo info = upgradeDevice.getExecuteInfo();
        if (!info.getResults().isEmpty()) {
            ExecuteResult lastResult = info.getResults().get(info.getResults().size() - 1);
            lastResult.setRunning(false);
            lastResult.setDetail(detail);
            lastResult.setTotalProgress(totalProgress);
            lastResult.setSuccess(executionResult);
            this.resultCallBack(upgradeDevice);
        }
    }

    public void updateResult(UpgradeDeviceEntity upgradeDevice, String executeDetail, Double totalProgress, UpgradeParamConstants.SubProcessExecutionResult executionResult, String hoverTips) {
        ExecuteInfo info = upgradeDevice.getExecuteInfo();
        if (info.getResults().isEmpty()) {
            return;
        }
        ExecuteResult lastResult = info.getResults().get(info.getResults().size() - 1);
        lastResult.setRunning(false);
        lastResult.setDetail(executeDetail);
        lastResult.setHoverTips(hoverTips);
        lastResult.setTotalProgress(totalProgress);
        lastResult.setSuccess(executionResult);
        this.resultCallBack(upgradeDevice);
    }

    public void releaAllNodesFloatIpRestConn() {
        if (UpgradeScenarioUtil.isYinglong()) {
            return;
        }
        FusionStorageRestConnector.releaseConn(this.getAllNodes());
    }

    private class ListMouseAdapter
    extends MouseAdapter {
        private ListMouseAdapter() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (SwingUtilities.isRightMouseButton(e) || e.getClickCount() > 1) {
                return;
            }
            UpgradeDeviceEntity upgradeDeviceNode = BundleUpgradeMainDialog.this.getSelectedDevNode();
            int index = this.getListIndex(e.getPoint(), BundleUpgradeMainDialog.this.mainPanel.getDetailList());
            if (-1 == index) {
                return;
            }
            if (null != upgradeDeviceNode) {
                ExecuteInfo pinfo = upgradeDeviceNode.getExecuteInfo();
                List<ExecuteResult> results = pinfo.getResults();
                ExecuteResult rec = results.get(index);
                ErrorDetailInfoDialog detailDialog = new ErrorDetailInfoDialog(rec.getDetail(), (Window)((Object)BundleUpgradeMainDialog.this));
                detailDialog.setVisible(true);
            }
        }

        private int getListIndex(Point point, JList detailList) {
            int index;
            ListUI obj = detailList.getUI();
            if (obj instanceof ArmorListUI) {
                ArmorListUI ui = (ArmorListUI)obj;
                index = ui.locationToRow(point);
            } else {
                index = detailList.getSelectedIndex();
            }
            return index;
        }
    }

    private static class PoolColSorter
    implements Comparable {
        private UpgradeDeviceEntity deviceEntity;

        public PoolColSorter(UpgradeDeviceEntity deviceEntity) {
            this.deviceEntity = deviceEntity;
        }

        public int compareTo(Object obj) {
            if (obj instanceof PoolColSorter) {
                PoolColSorter other = (PoolColSorter)obj;
                return other.deviceEntity.getIndex() - this.deviceEntity.getIndex();
            }
            return 0;
        }
    }
}

