/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.bundleupgrade.ui.card;

import com.huawei.bundleupgrade.constants.UpgradeParamConstants;
import com.huawei.bundleupgrade.entity.UpgradeDeviceEntity;
import com.huawei.bundleupgrade.utils.BundleUpgradeContext;
import com.huawei.ism.tool.base.ui.component.wizard.IWizardClosingObserver;
import com.huawei.ism.tool.base.ui.component.wizard.ToolWizardDialog;
import com.huawei.ism.tool.base.utils.FileUtils;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.dialog.WarningDialog;
import com.huawei.uMate.common.utils.ResUtil;
import java.awt.Window;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParamSettingCloseObserver
implements IWizardClosingObserver {
    private static final Logger log = LoggerFactory.getLogger(ParamSettingCloseObserver.class);
    private static final ResUtil RES = ResUtil.getInstance((String)"BundleUpgrade");
    private ToolWizardDialog toolWizardDialog;

    public ParamSettingCloseObserver(ToolWizardDialog toolWizardDialog) {
        this.toolWizardDialog = toolWizardDialog;
    }

    public String getListenerName() {
        return null;
    }

    public void onClose() {
        WarningDialog wd = DialogUtils.showYesNoDialog((Window)this.toolWizardDialog, (String)RES.getString("bundle.upgrade.param.wizard.exit"));
        if (wd.getValue() == 0) {
            log.info("user choose to exit..");
            this.clearInBandVersionCacheAndResetSatus();
            this.toolWizardDialog.dispose();
        }
        this.toolWizardDialog.setDefaultCloseOperation(0);
        FileUtils.clearDir((String)BundleUpgradeContext.getInstance().getCurrentPangeaFwTempPath());
        FileUtils.clearDir((String)BundleUpgradeContext.getInstance().getCurrentPsuAndBbuFwTempPath());
        FileUtils.clearDir((String)BundleUpgradeContext.getInstance().getCurrentDiskFwTempPath());
        FileUtils.clearDir((String)BundleUpgradeContext.getInstance().getCurrentPanGeaAndPsuAndBbuPath());
    }

    private void clearInBandVersionCacheAndResetSatus() {
        BundleUpgradeContext.getInstance().getSelectedDeviceEntities().stream().peek(this::refreshProcessStatus).map(UpgradeDeviceEntity::getDeviceEntity).forEach(device -> {
            log.info("clear node {} inBand version cache", (Object)device.getIp());
            device.getPanGeaInBandModuleVersion().clear();
        });
    }

    private void refreshProcessStatus(UpgradeDeviceEntity upgradeDeviceEntity) {
        upgradeDeviceEntity.setProcessStatus(UpgradeParamConstants.UpgradeStatus.NOTASSOCIATED);
        BundleUpgradeContext.getInstance().getMainDialog().refreshTable(upgradeDeviceEntity);
    }

    public void onComplete() {
        log.info("user choose to complete and exit..");
        this.toolWizardDialog.setDefaultCloseOperation(0);
        this.toolWizardDialog.dispose();
    }
}

