/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.bundleupgrade.ui.card;

import com.huawei.bundleupgrade.constants.UpgradeParamConstants;
import com.huawei.bundleupgrade.entity.FirmwarePackageEntity;
import com.huawei.bundleupgrade.entity.StrategySettingTableRowEntity;
import com.huawei.bundleupgrade.entity.UpgradeDeviceEntity;
import com.huawei.bundleupgrade.entity.UpgradeSpParams;
import com.huawei.bundleupgrade.entity.UpgradeStrategyEntity;
import com.huawei.bundleupgrade.model.Module;
import com.huawei.bundleupgrade.service.StrategyOrderSettingService;
import com.huawei.bundleupgrade.ui.card.UpgradeOrderSettingCard;
import com.huawei.bundleupgrade.ui.layout.strategy.SmartProvisioningParamsSettingLayout;
import com.huawei.bundleupgrade.utils.BundleUpgradeContext;
import com.huawei.bundleupgrade.utils.FirmwareXmlParseUtil;
import com.huawei.bundleupgrade.utils.ServiceUtil;
import com.huawei.ism.tool.base.ui.component.wizard.ToolWizardDialog;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.framework.platform.util.XmlEnums;
import com.huawei.ism.tool.obase.filechooser.ToolFileChooser;
import com.huawei.ism.tool.obase.utils.NetUtil;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.table.DefaultTableRow;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.uMate.common.utils.ResUtil;
import com.huawei.uMate.common.utils.SecurityUtils;
import java.awt.BorderLayout;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class SmartProvisioningParamsSettingCard
extends ToolWizardDialog.Card {
    private static final Logger log = LoggerFactory.getLogger(SmartProvisioningParamsSettingCard.class);
    private static final ResUtil RES = ResUtil.getInstance((String)"BundleUpgrade");
    private static String[] ILLEGAL_URLS = new String[]{"|", ";", "&", "$", ">", "<", "\""};
    private static String[] ILLEGAL_USERS = new String[]{"/", "\\", "[", "]", "\"", ":", ";", "|", "<", ">", "+", "=", ",", "?", "*", "&", "$"};
    private static String[] ILLEGAL_PATHS = new String[]{":", "*", "?", "\"", "<", ">", "|", ";", "&", "$"};
    private static final int MAX_URL_LENGTH = 200;
    private static final int MAX_USER_LENGTH = 32;
    private static final int MIN_PWD_LENGTH = 6;
    private SmartProvisioningParamsSettingLayout layout = new SmartProvisioningParamsSettingLayout();
    private StrategyOrderSettingService service = new StrategyOrderSettingService();
    private FirmwarePackageEntity firmwarePackageEntity;
    private List<StrategySettingTableRowEntity> settingTableRowEntityList = new ArrayList<StrategySettingTableRowEntity>();
    private UpgradeSpParams params = new UpgradeSpParams();
    private boolean sameProcessorArchitecture = false;

    public SmartProvisioningParamsSettingCard(ToolWizardDialog.Card previousCard, ToolWizardDialog.Navigation ... supportedNavigation) {
        super(previousCard, supportedNavigation);
        this.setLayout(new BorderLayout());
        this.add(this.layout, "North");
        this.initListener();
    }

    private void initListener() {
        this.layout.getPackagePathSelectButton().addActionListener(event -> this.selectVersionFile());
        this.layout.getMatchSpButton().addActionListener(event -> this.createMatchRow());
        this.layout.getSharedIpFiled().addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                SmartProvisioningParamsSettingCard.this.params.setSharedIP(SmartProvisioningParamsSettingCard.this.layout.getSharedIpFiled().getText().trim());
                SmartProvisioningParamsSettingCard.this.setImageUrl();
            }
        });
        this.layout.getSharedUserFiled().addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                SmartProvisioningParamsSettingCard.this.params.setSharedAccount(SmartProvisioningParamsSettingCard.this.layout.getSharedUserFiled().getText().trim());
                SmartProvisioningParamsSettingCard.this.setImageUrl();
            }
        });
        this.initPwdAndPathListener();
    }

    private void initPwdAndPathListener() {
        this.layout.getSharedPwdFiled().addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                SmartProvisioningParamsSettingCard.this.params.setSharedPwd(SmartProvisioningParamsSettingCard.this.layout.getSharedPwdFiled().getPassword());
                SmartProvisioningParamsSettingCard.this.setImageUrl();
            }
        });
        this.layout.getBasicPathField().addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                String basicUrl = SmartProvisioningParamsSettingCard.this.layout.getBasicPathField().getText().trim();
                if (basicUrl.length() >= 200) {
                    DialogUtils.showInfoDialog((Frame)((Object)BundleUpgradeContext.getInstance().getMainDialog()), (String)RES.getString("bundle.upgrade.sp.check.basicurl.too.long"));
                    return;
                }
                SmartProvisioningParamsSettingCard.this.params.setBasicUrl(basicUrl);
                SmartProvisioningParamsSettingCard.this.setImageUrl();
            }
        });
    }

    private void setImageUrl() {
        String sharedIp = this.layout.getSharedIpFiled().getText().trim();
        String sharedUser = this.layout.getSharedUserFiled().getText().trim();
        char[] sharedPwd = this.layout.getSharedPwdFiled().getPassword();
        String basicPath = this.layout.getBasicPathField().getText().trim();
        if (!(StringUtils.isNULLStr((String)sharedIp) && StringUtils.isNULLStr((String)sharedUser) && sharedPwd.length == 0 && StringUtils.isNULLStr((String)basicPath))) {
            this.layout.getImageUrlFiled().setText(this.params.getImageUrlForUi());
        } else {
            this.layout.getImageUrlFiled().setText("");
        }
    }

    private void selectVersionFile() {
        File file = new File(".");
        String[] fileType = new String[]{"xml"};
        HashMap<String, String> selectFileParams = new HashMap<String, String>();
        selectFileParams.put("title", RES.getString("bundle.upgrade.type.panel.local.btn.select"));
        selectFileParams.put("PathId", file.getPath());
        selectFileParams.put("description", "*.xml");
        File selectedFile = ToolFileChooser.selectFile((Window)((Object)BundleUpgradeContext.getInstance().getMainDialog()), (String[])fileType, (int)0, (boolean)true, selectFileParams);
        if (selectedFile == null || !selectedFile.exists()) {
            return;
        }
        String packagePath = selectedFile.getPath();
        if (!SecurityUtils.isValidAndSafePath((String)packagePath)) {
            log.error(String.format(Locale.ROOT, "%s is not valid and safe path.", packagePath));
            return;
        }
        this.layout.getSpUpgradePkgField().setText(packagePath);
        this.firmwarePackageEntity = this.parseXml(packagePath);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private FirmwarePackageEntity parseXml(String versionFile) {
        FirmwarePackageEntity firmwarePackage = new FirmwarePackageEntity();
        try (FileInputStream inputStream = new FileInputStream(versionFile);){
            Document document = this.getDocument(inputStream);
            if (null == document) {
                log.error("failed to read the version.xml from {} through the local.", (Object)versionFile);
                FirmwarePackageEntity firmwarePackageEntity = firmwarePackage;
                return firmwarePackageEntity;
            }
            Element rootElement = document.getRootElement();
            Element packageElement = rootElement.element("Package");
            FirmwarePackageEntity.PackageInfo packageInfo = FirmwareXmlParseUtil.parsePackageElement(firmwarePackage, packageElement);
            packageInfo.setActiveMode("ResetOS");
            firmwarePackage.setTempId(BundleUpgradeContext.getInstance().getFwTempId());
            firmwarePackage.setPackageInfo(packageInfo);
            firmwarePackage.setLocalPathAbs(versionFile);
            BundleUpgradeContext.getInstance().getFirmwarePackageMap().put(ServiceUtil.getPackageInfoKey(firmwarePackage), firmwarePackage);
            return firmwarePackage;
        }
        catch (IOException | DocumentException | SAXException e) {
            log.error("parse Version.xml error.");
        }
        return firmwarePackage;
    }

    private Document getDocument(InputStream xmlInputStream) throws SAXException, DocumentException {
        SAXReader saxReader = new SAXReader();
        saxReader.setFeature(XmlEnums.DISALLOW_DOCTYPE_DECL.getResourceValue(), true);
        saxReader.setFeature(XmlEnums.EXTERNAL_GENERAL_ENTITY.getResourceValue(), false);
        saxReader.setFeature(XmlEnums.EXTERNAL_PARAMETER_ENTITY.getResourceValue(), false);
        return saxReader.read(xmlInputStream);
    }

    private void createMatchRow() {
        String selectedIp = this.getDeviceIp();
        if ("".equals(selectedIp)) {
            DialogUtils.showInfoDialog((Frame)((Object)BundleUpgradeContext.getInstance().getMainDialog()), (String)RES.getString("bundle.upgrade.sp.check.no.basic.device"));
            return;
        }
        if (StringUtils.isNULLStr((String)this.layout.getSpUpgradePkgField().getText().trim())) {
            DialogUtils.showInfoDialog((Frame)((Object)BundleUpgradeContext.getInstance().getMainDialog()), (String)RES.getString("bundle.upgrade.sp.check.no.version.xml"));
            return;
        }
        this.layout.getDefaultTableModel().removeAll();
        this.settingTableRowEntityList.clear();
        UpgradeDeviceEntity basicDevice = BundleUpgradeContext.getInstance().getDeviceNodeByIp(selectedIp);
        StrategySettingTableRowEntity entity = new Module.Sp().matchAndCreateRow(basicDevice.getDeviceEntity(), this.firmwarePackageEntity);
        this.sameProcessorArchitecture = entity.isMatch();
        if (entity.isMatch()) {
            this.settingTableRowEntityList.add(entity);
            this.layout.getDefaultTableModel().addRow(new TableRow[]{this.createStrategyTableRow(entity)});
        } else {
            this.layout.getDefaultTableModel().addRow(new TableRow[]{this.notMatchTableRow(entity)});
        }
        this.revalidate();
    }

    public String getDeviceIp() {
        Object selectItem = this.layout.getDeviceSelectCombo().getSelectedItem();
        String selectedDeviceIp = "";
        if (selectItem != null && !selectItem.toString().equals(RES.getString("bundle.upgrade.param.device.combo.default"))) {
            selectedDeviceIp = selectItem.toString();
        }
        return selectedDeviceIp;
    }

    private TableRow<StrategySettingTableRowEntity, String> createStrategyTableRow(StrategySettingTableRowEntity entity) {
        String key = entity.getUuid().toString();
        int columnCount = this.layout.getStrategySettingTable().getColumnCount();
        DefaultTableRow row = new DefaultTableRow(columnCount, (Object)entity, (Object)key);
        int col = 0;
        row.setValueAt(col++, (Object)entity.getModule());
        row.setValueAt(col++, (Object)entity.getSupportModel());
        row.setValueAt(col++, (Object)entity.getActiveMode());
        row.setValueAt(col++, (Object)entity.getCurrentVersion());
        row.setValueAt(col++, (Object)entity.getTargetVersion());
        row.setValueAt(col++, (Object)entity.getUpgradeAgent());
        String localMsgKey = entity.isMatch() ? "bundle.upgrade.param.strategy.table.cell.matched" : "bundle.upgrade.param.strategy.table.cell.mismatching";
        row.setValueAt(col++, (Object)RES.getString(localMsgKey));
        row.setValueAt(col, (Object)entity.getStrategyComboBoxCell());
        return row;
    }

    private TableRow<StrategySettingTableRowEntity, String> notMatchTableRow(StrategySettingTableRowEntity entity) {
        String key = entity.getUuid().toString();
        int columnCount = this.layout.getStrategySettingTable().getColumnCount();
        DefaultTableRow row = new DefaultTableRow(columnCount, (Object)entity, (Object)key);
        row.setValueAt(6, (Object)RES.getString("bundle.upgrade.param.strategy.table.cell.mismatching"));
        return row;
    }

    public String getTitle() {
        return RES.getString("bundle.upgrade.param.setting.step2.title");
    }

    public int getStep() {
        return 1;
    }

    protected ToolWizardDialog.Card getNextCard() {
        BundleUpgradeContext.getInstance().setSettingTableRowEntityList(this.settingTableRowEntityList);
        return new UpgradeOrderSettingCard((ToolWizardDialog.Card)this, ToolWizardDialog.Navigation.PREVIOUS, ToolWizardDialog.Navigation.COMPLETE);
    }

    protected boolean isValid(ToolWizardDialog.Navigation navigation) {
        return true;
    }

    protected boolean process(ToolWizardDialog.Navigation navigation) {
        if (ToolWizardDialog.Navigation.NEXT.equals((Object)navigation)) {
            if (this.checkSpStrategySetting()) {
                this.saveUpgradeSpStrategy();
                this.service.refreshMainDialog();
            } else {
                return false;
            }
        }
        return true;
    }

    private boolean checkSpStrategySetting() {
        if ("".equals(this.getDeviceIp())) {
            DialogUtils.showInfoDialog((Frame)((Object)BundleUpgradeContext.getInstance().getMainDialog()), (String)RES.getString("bundle.upgrade.sp.check.no.basic.device"));
            return false;
        }
        if (StringUtils.isNULLStr((String)this.layout.getSpUpgradePkgField().getText().trim())) {
            DialogUtils.showInfoDialog((Frame)((Object)BundleUpgradeContext.getInstance().getMainDialog()), (String)RES.getString("bundle.upgrade.sp.check.no.version.xml"));
            return false;
        }
        if (!this.sameProcessorArchitecture) {
            DialogUtils.showInfoDialog((Frame)((Object)BundleUpgradeContext.getInstance().getMainDialog()), (String)RES.getString("bundle.upgrade.sp.check.not.same.architecture"));
            return false;
        }
        return !this.checkSharedIp() && !this.checkSharedUser() && !this.checkSharedPassword() && !this.checkBasicUrl();
    }

    private boolean checkSharedIp() {
        String sharedIp = this.layout.getSharedIpFiled().getText().trim();
        if (StringUtils.isNULLStr((String)sharedIp)) {
            DialogUtils.showInfoDialog((Frame)((Object)BundleUpgradeContext.getInstance().getMainDialog()), (String)RES.getString("bundle.upgrade.sp.check.no.ip"));
            return true;
        }
        if (!NetUtil.isValidIP((String)sharedIp)) {
            DialogUtils.showInfoDialog((Frame)((Object)BundleUpgradeContext.getInstance().getMainDialog()), (String)RES.getString("bundle.upgrade.sp.check.ip.error"));
            return true;
        }
        return false;
    }

    private boolean checkSharedUser() {
        String sharedUser = this.layout.getSharedUserFiled().getText().trim();
        if (StringUtils.isNULLStr((String)sharedUser)) {
            DialogUtils.showInfoDialog((Frame)((Object)BundleUpgradeContext.getInstance().getMainDialog()), (String)RES.getString("bundle.upgrade.sp.check.no.user"));
            return true;
        }
        if (Arrays.stream(ILLEGAL_USERS).anyMatch(sharedUser::contains)) {
            DialogUtils.showInfoDialog((Frame)((Object)BundleUpgradeContext.getInstance().getMainDialog()), (String)RES.getString("bundle.upgrade.sp.check.user.error"));
            return true;
        }
        if (sharedUser.length() > 32) {
            DialogUtils.showInfoDialog((Frame)((Object)BundleUpgradeContext.getInstance().getMainDialog()), (String)RES.getString("bundle.upgrade.sp.check.user.too.long"));
            return true;
        }
        return false;
    }

    private boolean checkSharedPassword() {
        char[] pwd = this.layout.getSharedPwdFiled().getPassword();
        if (pwd.length < 6) {
            DialogUtils.showInfoDialog((Frame)((Object)BundleUpgradeContext.getInstance().getMainDialog()), (String)RES.getString("bundle.upgrade.sp.check.pwd.too.short"));
            return true;
        }
        if (Arrays.stream(ILLEGAL_URLS).anyMatch(String.valueOf(pwd)::contains)) {
            DialogUtils.showInfoDialog((Frame)((Object)BundleUpgradeContext.getInstance().getMainDialog()), (String)RES.getString("bundle.upgrade.sp.check.pwd.error"));
            return true;
        }
        return false;
    }

    private boolean checkBasicUrl() {
        String basicUrl = this.layout.getBasicPathField().getText().trim();
        if (StringUtils.isNULLStr((String)basicUrl)) {
            DialogUtils.showInfoDialog((Frame)((Object)BundleUpgradeContext.getInstance().getMainDialog()), (String)RES.getString("bundle.upgrade.sp.check.no.basicurl"));
            return true;
        }
        if (basicUrl.length() >= 200) {
            DialogUtils.showInfoDialog((Frame)((Object)BundleUpgradeContext.getInstance().getMainDialog()), (String)RES.getString("bundle.upgrade.sp.check.basicurl.too.long"));
            return true;
        }
        if (Arrays.stream(ILLEGAL_PATHS).anyMatch(basicUrl::contains)) {
            DialogUtils.showInfoDialog((Frame)((Object)BundleUpgradeContext.getInstance().getMainDialog()), (String)RES.getString("bundle.upgrade.sp.check.basicurl.error"));
            return true;
        }
        String fileName = this.firmwarePackageEntity.getPackageInfo().getFileName().toLowerCase(Locale.ENGLISH);
        if (!basicUrl.toLowerCase(Locale.ENGLISH).endsWith(fileName)) {
            DialogUtils.showInfoDialog((Frame)((Object)BundleUpgradeContext.getInstance().getMainDialog()), (String)RES.getString("bundle.upgrade.sp.check.basicurl.not.same"));
            return true;
        }
        return false;
    }

    private void saveUpgradeSpStrategy() {
        UpgradeStrategyEntity strategyEntity = new UpgradeStrategyEntity();
        String uuid = strategyEntity.getUuid().toString();
        BundleUpgradeContext.getInstance().setLatestStrategyUuid(uuid);
        BundleUpgradeContext.getInstance().getStrategyEntityMap().put(uuid, strategyEntity);
        UpgradeDeviceEntity basicDevice = BundleUpgradeContext.getInstance().getDeviceNodeByIp(this.getDeviceIp());
        strategyEntity.setBaseDevice(basicDevice);
        EnumMap<UpgradeParamConstants.ModuleType, List<String>> moduleTargetFirmwareMap = new EnumMap<UpgradeParamConstants.ModuleType, List<String>>(UpgradeParamConstants.ModuleType.class);
        String convertValue = ServiceUtil.getPackageInfoKey(this.firmwarePackageEntity);
        ArrayList<String> fwPackageInfoList = new ArrayList<String>();
        fwPackageInfoList.add(convertValue);
        moduleTargetFirmwareMap.put(UpgradeParamConstants.ModuleType.SP, fwPackageInfoList);
        strategyEntity.setModuleTargetFirmwareMap(moduleTargetFirmwareMap);
        HashMap<String, UpgradeParamConstants.FirmwareUpgradeStrategy> upgradeStrategyMap = new HashMap<String, UpgradeParamConstants.FirmwareUpgradeStrategy>();
        Object selectedItem = this.settingTableRowEntityList.get(0).getStrategyComboBoxCell().getSelectedItem();
        upgradeStrategyMap.put(convertValue, this.convertValueToStrategyEnum(selectedItem.toString()));
        strategyEntity.setUpgradeStrategyMap(upgradeStrategyMap);
        this.params.setUpgradeMode(this.layout.getUpgradeModeCombo().getSelectedItem().toString());
        this.params.setActiveMethod("OSRestart");
        FirmwarePackageEntity.PackageInfo packageInfo = this.firmwarePackageEntity.getPackageInfo();
        this.params.setMaxUpgradeTime(packageInfo.getMaxUpgradeTime());
        this.params.setFileName(packageInfo.getFileName());
        this.params.setTargetVersion(packageInfo.getVersion());
        strategyEntity.setUpgradeSpParams(this.params);
    }

    private UpgradeParamConstants.FirmwareUpgradeStrategy convertValueToStrategyEnum(Object selected) {
        if (selected.toString().equals(RES.getString("bundle.upgrade.param.strategy.table.cell.upgrade"))) {
            return UpgradeParamConstants.FirmwareUpgradeStrategy.MANDATORY_UPGRADE;
        }
        return UpgradeParamConstants.FirmwareUpgradeStrategy.LOWER_VERSION_UPGRADE;
    }

    public List<StrategySettingTableRowEntity> getSettingTableRowEntityList() {
        return this.settingTableRowEntityList;
    }

    public UpgradeSpParams getParams() {
        return this.params;
    }
}

