/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.bundleupgrade.ui.card;

import com.huawei.bundleupgrade.entity.DeviceEntity;
import com.huawei.bundleupgrade.entity.StrategySettingTableRowEntity;
import com.huawei.bundleupgrade.service.StrategyOrderSettingService;
import com.huawei.bundleupgrade.ui.BundleUpgradeMainDialog;
import com.huawei.bundleupgrade.ui.layout.UpgradeOrderSettingLayout;
import com.huawei.bundleupgrade.utils.BundleUpgradeContext;
import com.huawei.bundleupgrade.utils.ServiceUtil;
import com.huawei.ism.tool.base.ui.component.wizard.ToolWizardDialog;
import com.huawei.ism.tool.base.ui.filechooser.ToolFileChooser;
import com.huawei.ism.tool.base.utils.FilePathUtils;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.table.DefaultTableModel;
import com.huawei.ism.ui.swing.table.DefaultTableRow;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.uMate.common.utils.ResUtil;
import java.awt.BorderLayout;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import javax.swing.JComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeOrderSettingCard
extends ToolWizardDialog.Card {
    private static final Logger log = LoggerFactory.getLogger(UpgradeOrderSettingCard.class);
    private static final ResUtil RES = ResUtil.getInstance((String)"BundleUpgrade");
    private UpgradeOrderSettingLayout layout = new UpgradeOrderSettingLayout();
    private StrategyOrderSettingService service = new StrategyOrderSettingService();
    private List<StrategySettingTableRowEntity> reorderedTableRowEntityList;
    private String deviceIp;

    public UpgradeOrderSettingCard(ToolWizardDialog.Card previousCard, String deviceIp, ToolWizardDialog.Navigation ... supportedNavigation) {
        super(previousCard, supportedNavigation);
        this.deviceIp = deviceIp;
        this.addLayout(this.layout);
        this.showOrderSettingTableInfo();
        this.cachePanGeaInBandModuleVersion();
        this.initUI();
        this.checkIfShowLogSelectUi();
    }

    public UpgradeOrderSettingCard(ToolWizardDialog.Card previousCard, ToolWizardDialog.Navigation ... supportedNavigation) {
        super(previousCard, supportedNavigation);
        this.addLayout(this.layout);
        this.showOrderSettingTableInfo();
        this.initUI();
        this.layout.getLogBox().setVisible(false);
    }

    private void logPathSelectActionEvent(ActionEvent evt) {
        File file = new File(".");
        BundleUpgradeMainDialog dialog = BundleUpgradeContext.getInstance().getMainDialog();
        File selectedFile = ToolFileChooser.selectFile((Window)((Object)dialog), (String)RES.getString("bundle.upgrade.type.panel.local.btn.select"), (String[])new String[0], (String)file.getPath(), (String)"Directory", (int)1, (boolean)true, (boolean)true, (Locale)Locale.getDefault());
        if (null == selectedFile || !selectedFile.exists()) {
            return;
        }
        try {
            String canonicalPath = selectedFile.getCanonicalPath();
            this.layout.getLogPathField().setText(canonicalPath);
        }
        catch (IOException e) {
            log.error("The current log path is invalid. Select another one.", (Throwable)e);
        }
    }

    protected void addLayout(JComponent layout) {
        this.setLayout(new BorderLayout());
        this.add(layout, "North");
    }

    private void showOrderSettingTableInfo() {
        DefaultTableModel tableModel = this.layout.getCompTableModel();
        tableModel.removeAll();
        List<StrategySettingTableRowEntity> settingTableRowEntityList = BundleUpgradeContext.getInstance().getSettingTableRowEntityList();
        List<StrategySettingTableRowEntity> selectedModuleList = this.service.getSelectedUpgradeModuleList(settingTableRowEntityList);
        this.reorderedTableRowEntityList = this.service.reorderTableRowEntity(selectedModuleList);
        boolean isAllPcieModule = this.service.isAllPcieModule(this.reorderedTableRowEntityList);
        int order = 1;
        for (StrategySettingTableRowEntity entity : this.reorderedTableRowEntityList) {
            TableRow<StrategySettingTableRowEntity, String> row = isAllPcieModule ? this.createStrategyOrderTableRow(entity, 1) : this.createStrategyOrderTableRow(entity, order);
            tableModel.addRow(new TableRow[]{row});
            if (entity.isPCIeModule()) continue;
            ++order;
        }
        if (!tableModel.getAllRows().isEmpty()) {
            this.layout.getCompTable().addRowSelectionInterval(0, 0);
        }
    }

    private void cachePanGeaInBandModuleVersion() {
        DeviceEntity device = BundleUpgradeContext.getInstance().getDeviceNodeByIp(this.deviceIp).getDeviceEntity();
        List<StrategySettingTableRowEntity> settingTableRowEntityList = BundleUpgradeContext.getInstance().getSettingTableRowEntityList();
        List<StrategySettingTableRowEntity> selectedModuleList = this.service.getSelectedUpgradeModuleList(settingTableRowEntityList);
        selectedModuleList.stream().filter(entity -> ServiceUtil.isPanGeaIntraBandModule(entity.getModule())).forEach(entity -> device.getPanGeaInBandModuleVersion().put(entity.getModule(), entity.getCurrentVersion()));
    }

    private TableRow<StrategySettingTableRowEntity, String> createStrategyOrderTableRow(StrategySettingTableRowEntity entity, int order) {
        String key = entity.getModule() + "_" + entity.getTargetVersion();
        int columnCount = this.layout.getCompTable().getColumnCount();
        DefaultTableRow row = new DefaultTableRow(columnCount, (Object)entity, (Object)key);
        int col = 0;
        row.setValueAt(col++, (Object)entity.getModule());
        row.setValueAt(col++, (Object)entity.getSupportModels());
        row.setValueAt(col++, (Object)entity.getUpgradeAgent());
        row.setValueAt(col++, (Object)entity.getActiveMode());
        row.setValueAt(col++, (Object)entity.getTargetVersion());
        return row;
    }

    private void initUI() {
        this.layout.getManualReset().setSelected(true);
        this.layout.getBottomBox().setVisible(false);
    }

    private void checkIfShowLogSelectUi() {
        boolean isContainsPanGeaInBandModule = false;
        for (StrategySettingTableRowEntity tableRow : this.reorderedTableRowEntityList) {
            if (!ServiceUtil.isPanGeaIntraBandModule(tableRow.getModule())) continue;
            isContainsPanGeaInBandModule = true;
            this.layout.getSelectLogPathBtn().addActionListener(this::logPathSelectActionEvent);
            break;
        }
        this.layout.getLogBox().setVisible(isContainsPanGeaInBandModule);
    }

    private boolean checkStrategySetting() {
        if (!this.layout.getAutoReset().isSelected() && !this.layout.getManualReset().isSelected()) {
            DialogUtils.showInfoDialog((Frame)((Object)BundleUpgradeContext.getInstance().getMainDialog()), (String)RES.getString("bundle.upgrade.order.error1"));
            return false;
        }
        if (this.reorderedTableRowEntityList.isEmpty()) {
            DialogUtils.showInfoDialog((Frame)((Object)BundleUpgradeContext.getInstance().getMainDialog()), (String)RES.getString("bundle.upgrade.order.error3"));
            return false;
        }
        List<String> res = this.service.checkIfOrderSettingMatchDependence(this.reorderedTableRowEntityList);
        if (res.size() == 2) {
            DialogUtils.showInfoDialog((Frame)((Object)BundleUpgradeContext.getInstance().getMainDialog()), (String)RES.getStringWithParams("bundle.upgrade.order.dependence.error", new Object[]{res.get(0), res.get(1)}));
            return false;
        }
        if (this.layout.getLogBox().isVisible()) {
            String logPathStr = this.layout.getLogPathField().getText().trim();
            File logPath = new File(FilePathUtils.checkFile((String)logPathStr));
            if ("".equals(logPathStr)) {
                DialogUtils.showInfoDialog((Frame)((Object)BundleUpgradeContext.getInstance().getMainDialog()), (String)RES.getString("bundle.upgrade.order.log.path.empty.error"));
                return false;
            }
            if (!logPath.exists()) {
                DialogUtils.showInfoDialog((Frame)((Object)BundleUpgradeContext.getInstance().getMainDialog()), (String)RES.getString("bundle.upgrade.order.log.path.not.exists"));
                return false;
            }
            return true;
        }
        return true;
    }

    public String getTitle() {
        return RES.getString("bundle.upgrade.param.setting.step3.title");
    }

    public int getStep() {
        return 2;
    }

    protected ToolWizardDialog.Card getNextCard() {
        return null;
    }

    protected boolean isValid(ToolWizardDialog.Navigation navigation) {
        return true;
    }

    protected boolean process(ToolWizardDialog.Navigation navigation) {
        if (ToolWizardDialog.Navigation.COMPLETE.equals((Object)navigation)) {
            if (this.checkStrategySetting() && this.service.saveUpgradeStrategy(this.reorderedTableRowEntityList, this.layout)) {
                this.service.refreshMainDialog();
            } else {
                return false;
            }
        }
        if (ToolWizardDialog.Navigation.PREVIOUS.equals((Object)navigation)) {
            log.info("click previous card.");
        }
        if (ToolWizardDialog.Navigation.NEXT.equals((Object)navigation)) {
            log.info("click next card.");
        }
        return true;
    }
}

