/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.bundleupgrade.ui.card;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.huawei.bundleupgrade.constants.UpgradeParamConstants;
import com.huawei.bundleupgrade.entity.DeviceEntity;
import com.huawei.bundleupgrade.entity.FirmwarePackageEntity;
import com.huawei.bundleupgrade.entity.FwUpgradeScenarioAdaptation;
import com.huawei.bundleupgrade.entity.OperationResultEntity;
import com.huawei.bundleupgrade.entity.StrategySettingTableRowEntity;
import com.huawei.bundleupgrade.entity.UpgradeDeviceEntity;
import com.huawei.bundleupgrade.entity.fusionstrg.PanGeaPackageEntity;
import com.huawei.bundleupgrade.entity.fusionstrg.UpgDeviceExtendFSDataEntity;
import com.huawei.bundleupgrade.model.ModuleEnum;
import com.huawei.bundleupgrade.service.StrategyParamsSettingService;
import com.huawei.bundleupgrade.service.connection.RestConnPool;
import com.huawei.bundleupgrade.service.connection.fusionstrg.FusionStorageRestConnector;
import com.huawei.bundleupgrade.service.connection.fusionstrg.FusionStorageSshPool;
import com.huawei.bundleupgrade.ui.BundleUpgradeMainDialog;
import com.huawei.bundleupgrade.ui.card.UpgradeOrderSettingCard;
import com.huawei.bundleupgrade.ui.dialog.FirmwareOnlineDownloadDialog;
import com.huawei.bundleupgrade.ui.dialog.StrategyPreviewDialog;
import com.huawei.bundleupgrade.ui.layout.strategy.StrategySettingLayout;
import com.huawei.bundleupgrade.ui.layout.strategy.UpgradeStrategySettingMainLayout;
import com.huawei.bundleupgrade.utils.BundleUpgradeContext;
import com.huawei.bundleupgrade.utils.NodeServiceUtils;
import com.huawei.bundleupgrade.utils.PythonExecuteUtils;
import com.huawei.bundleupgrade.utils.ScriptConfigUtil;
import com.huawei.bundleupgrade.utils.ServiceUtil;
import com.huawei.bundleupgrade.utils.UpgradeConstants;
import com.huawei.bundleupgrade.utils.UpgradeCustomizationUtil;
import com.huawei.bundleupgrade.utils.UpgradeScenarioUtil;
import com.huawei.bundleupgrade.utils.fusionstrg.FusionStrgUpgradeContext;
import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.tool.base.ui.UiMethod;
import com.huawei.ism.tool.base.ui.component.wizard.ToolWizardDialog;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.devicemanager.service.implement.DefaultNodeProviderImpl;
import com.huawei.ism.tool.framework.platform.util.LanguageManager;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.CollectionUtil;
import com.huawei.ism.tool.protocol.rest.entity.ResponseInfo;
import com.huawei.ism.tool.service.common.DevInfoUtil;
import com.huawei.ism.ui.swing.dialog.CustMsgProgressDialog;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.dialog.ProgressDialog;
import com.huawei.ism.ui.swing.dialog.WarningDialog;
import com.huawei.ism.ui.swing.dialog.WarningInfo;
import com.huawei.ism.ui.swing.table.DefaultTableModel;
import com.huawei.ism.ui.swing.table.DefaultTableRow;
import com.huawei.ism.ui.swing.table.IsmTableCell;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.uMate.common.SystemConfig;
import com.huawei.uMate.common.UMateException;
import com.huawei.uMate.common.utils.RedfishUtils;
import com.huawei.uMate.common.utils.ResUtil;
import java.awt.BorderLayout;
import java.awt.Frame;
import java.awt.Window;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeParamsSettingCard
extends ToolWizardDialog.Card {
    private static final Logger log = LoggerFactory.getLogger(UpgradeParamsSettingCard.class);
    private static final ResUtil RES = ResUtil.getInstance((String)"BundleUpgrade");
    private static final String QUERY_PCIE_ERROR = "bundle.upgrade.param.device.pcie.error";
    private static final String CELL_VALUE_DEFAULT = "bundle.upgrade.param.strategy.table.cell.default";
    private static final String NO_COMPONENT = "bundle.upgrade.param.strategy.table.cell.no.fw.upgrade";
    private final UpgradeStrategySettingMainLayout layout = new UpgradeStrategySettingMainLayout();
    private final StrategySettingLayout settingLayout = new StrategySettingLayout();
    private StrategyPreviewDialog previewDialog;
    private FirmwareOnlineDownloadDialog firmwareOnlineDownloadDialog;
    private final StrategyParamsSettingService service = new StrategyParamsSettingService(this.settingLayout);
    private List<StrategySettingTableRowEntity> settingTableRowEntityList;
    private List<StrategySettingTableRowEntity> preViewTableRowEntityList;
    private String deviceIp;

    public UpgradeParamsSettingCard(ToolWizardDialog.Card previousCard, ToolWizardDialog.Navigation ... supportedNavigation) {
        super(previousCard, supportedNavigation);
        this.initListener();
        this.addLayout(this.layout);
    }

    public String getDeviceIpForNext() {
        return this.deviceIp;
    }

    protected void addLayout(JComponent layout) {
        this.setLayout(new BorderLayout());
        this.add(layout, "North");
    }

    private void initListener() {
        this.layout.getPcieCheckBox().addActionListener(event -> this.pcieCheckBoxAction());
        this.layout.getObtainInfoBtn().addActionListener(event -> this.obtainInfoBtnAction());
        this.settingLayout.getUnMatchCheckBox().addActionListener(event -> this.unMatchCheckBoxAction());
        this.settingLayout.getMandatoryUpgradeCheckBox().addActionListener(event -> this.mandatoryUpgradeCheckBoxAction());
        this.settingLayout.getLowVersionUpgradeCheckBox().addActionListener(event -> this.lowVersionUpgradeCheckBoxAction());
    }

    private void showStrategyTableInfo(List<StrategySettingTableRowEntity> strategySettingTableRowEntityList, boolean isShowNotMatched) {
        this.settingLayout.getDefaultTableModel().removeAll();
        List<StrategySettingTableRowEntity> filteredTableRowEntityList = this.service.filterTableRowEntityList(strategySettingTableRowEntityList, isShowNotMatched);
        if (filteredTableRowEntityList.isEmpty()) {
            TableRow<String, String> row = this.createNoModuleMatchedTableRow();
            this.settingLayout.getDefaultTableModel().addRow(new TableRow[]{row});
        } else {
            boolean isOnlineMatched = this.isOnlineMatched(filteredTableRowEntityList);
            for (StrategySettingTableRowEntity entity : filteredTableRowEntityList) {
                TableRow<StrategySettingTableRowEntity, String> row = this.createStrategyTableRow(entity, isOnlineMatched);
                this.settingLayout.getDefaultTableModel().addRow(new TableRow[]{row});
            }
        }
        this.settingLayout.getStrategySettingTable().selectFirstRow();
        boolean isShowAdvanced = this.service.isUpgradeAgentContainsSp(filteredTableRowEntityList);
        this.settingLayout.initAdvancedComponent(isShowAdvanced);
        this.settingLayout.getStrategyPreviewBtn().addActionListener(event -> this.strategyPreviewBtnAction());
    }

    private boolean isOnlineMatched(List<StrategySettingTableRowEntity> settingTableRowEntityList) {
        for (StrategySettingTableRowEntity entity : settingTableRowEntityList) {
            if (!BundleUpgradeContext.isOnlineFirmware() || !entity.isOnlineFirmwareMatch()) continue;
            return true;
        }
        return false;
    }

    private TableRow<String, String> createNoModuleMatchedTableRow() {
        DefaultTableRow notMatchedRow = new DefaultTableRow(1, (Object)RES.getString("bundle.upgrade.param.strategy.unmatched.tip"));
        notMatchedRow.setValueAt(0, (Object)RES.getString("bundle.upgrade.param.strategy.unmatched.tip"));
        return notMatchedRow;
    }

    private TableRow<StrategySettingTableRowEntity, String> createStrategyTableRow(StrategySettingTableRowEntity entity, boolean isOnlineMatched) {
        String key = entity.getUuid().toString();
        int columnCount = this.settingLayout.getStrategySettingTable().getColumnCount();
        DefaultTableRow row = new DefaultTableRow(columnCount, (Object)entity, (Object)key);
        int col = 0;
        if (BundleUpgradeContext.isOnlineFirmware()) {
            row.setValueAt(col++, (Object)String.join((CharSequence)";", (CharSequence[])entity.getFirmwarePackageEntity().getProducts().stream().map(FirmwarePackageEntity.Product::getName).toArray(String[]::new)));
        }
        row.setValueAt(col++, (Object)entity.getModule());
        row.setValueAt(col++, (Object)entity.getSupportModels());
        row.setValueAt(col++, (Object)entity.getActiveMode());
        row.setValueAt(col++, (Object)entity.getCurrentVersion());
        row.setValueAt(col++, (Object)entity.getTargetVersion());
        row.setValueAt(col++, (Object)entity.getUpgradeAgent());
        if (isOnlineMatched) {
            String onlineMsgKey = entity.isOnlineFirmwareMatch() ? "bundle.upgrade.param.strategy.table.cell.matched" : "bundle.upgrade.param.strategy.table.cell.mismatching";
            row.setValueAt(col++, (Object)RES.getString(onlineMsgKey));
        } else {
            String localMsgKey = entity.isMatch() ? "bundle.upgrade.param.strategy.table.cell.matched" : "bundle.upgrade.param.strategy.table.cell.mismatching";
            row.setValueAt(col++, (Object)RES.getString(localMsgKey));
        }
        row.setValueAt(col, (Object)entity.getStrategyComboBoxCell());
        return row;
    }

    private void showStrategyPreviewDeviceTableInfo() {
        DeviceEntity device;
        DefaultTableModel tableModel = this.previewDialog.getPreviewLayout().getBaseInfoTableModel();
        tableModel.removeAll();
        UpgradeDeviceEntity upgradeDeviceEntity = BundleUpgradeContext.getInstance().getDeviceNodeByIp(this.deviceIp);
        if (upgradeDeviceEntity != null && (device = upgradeDeviceEntity.getDeviceEntity()) != null) {
            TableRow<DeviceEntity, String> row = this.createDeviceInfoPreviewTableRow(device);
            tableModel.addRow(new TableRow[]{row});
        }
    }

    private TableRow<DeviceEntity, String> createDeviceInfoPreviewTableRow(DeviceEntity deviceEntity) {
        String key = deviceEntity.getIp();
        int columnCount = this.previewDialog.getPreviewLayout().getBaseInfoIsmTable().getColumnCount();
        return this.getRowDate(columnCount, deviceEntity, key);
    }

    private TableRow<DeviceEntity, String> getRowDate(int columnCount, DeviceEntity deviceEntity, String key) {
        DefaultTableRow row = new DefaultTableRow(columnCount, (Object)deviceEntity, (Object)key);
        int col = 0;
        row.setValueAt(col++, (Object)deviceEntity.getIp());
        row.setValueAt(col++, (Object)deviceEntity.getProductType());
        row.setValueAt(col++, (Object)deviceEntity.getProductType());
        row.setValueAt(col++, (Object)deviceEntity.getSerialNumber());
        row.setValueAt(col++, (Object)deviceEntity.getMasterBMC());
        row.setValueAt(col++, (Object)deviceEntity.getBiosVersion());
        row.setValueAt(col, (Object)deviceEntity.getSpVersion());
        return row;
    }

    private void showStrategyPreviewTableInfo() {
        DefaultTableModel tableModel = this.previewDialog.getPreviewLayout().getStrategyTableModel();
        tableModel.removeAll();
        this.preViewTableRowEntityList = this.service.getPreViewTableRowEntity(this.settingTableRowEntityList);
        for (StrategySettingTableRowEntity entity : this.preViewTableRowEntityList) {
            TableRow<StrategySettingTableRowEntity, String> row = this.createStrategyPreViewTableRow(entity);
            tableModel.addRow(new TableRow[]{row});
        }
    }

    private TableRow<StrategySettingTableRowEntity, String> createStrategyPreViewTableRow(StrategySettingTableRowEntity entity) {
        String key = entity.getUuid().toString();
        int columnCount = this.previewDialog.getPreviewLayout().getStrategyIsmTable().getColumnCount();
        DefaultTableRow row = new DefaultTableRow(columnCount, (Object)entity, (Object)key);
        int col = 0;
        row.setValueAt(col++, (Object)entity.getModule());
        row.setValueAt(col++, (Object)entity.getUpgradeAgent());
        row.setValueAt(col++, (Object)entity.getActiveMode());
        row.setValueAt(col++, (Object)entity.getCurrentVersion());
        row.setValueAt(col++, (Object)entity.getTargetVersion());
        row.setValueAt(col++, entity.getStrategyComboBoxCell().getSelectedItem());
        UpgradeParamConstants.UpgradeExpectEffect expectEffect = entity.getExpectEffect();
        if (null != expectEffect) {
            row.setValueAt(col, (Object)RES.getString(expectEffect.toString()));
        } else {
            row.setValueAt(col, (Object)"--");
        }
        return row;
    }

    private void obtainInfoBtnAction() {
        log.info("click obtaining Information button.");
        this.deviceIp = this.getDeviceIp();
        if (StringUtils.isNULLStr((String)this.deviceIp)) {
            return;
        }
        this.add(this.settingLayout);
        BundleUpgradeContext context = BundleUpgradeContext.getInstance();
        String uuid = context.getLatestStrategyUuid();
        context.getStrategyEntityMap().get(uuid).setBaseDevice(BundleUpgradeContext.getInstance().getDeviceNodeByIp(this.deviceIp));
        CustMsgProgressDialog progressDialog = new CustMsgProgressDialog((Window)((Object)context.getMainDialog()), RES.getString("bundle.upgrade.param.panel.match.package.tip"), 300);
        try {
            String keyOfBundleMap = context.getStrategyEntityMap().get(uuid).getBaselineVersion();
            this.settingTableRowEntityList = (List)AsyncExcutor.execute((ProgressDialog)progressDialog, (boolean)true, (long)0L, (Callable[])new Callable[]{() -> this.service.matchDeviceModuleWithFwPackage(this.deviceIp, keyOfBundleMap)}).get(0);
        }
        catch (Exception e) {
            log.error("match device module with package fail", (Throwable)e);
            DialogUtils.showInfoDialog((Frame)((Object)context.getMainDialog()), (String)RES.getString("bundle.upgrade.match.error"));
            return;
        }
        this.showStrategyTableInfo(this.settingTableRowEntityList, false);
        this.service.setMutualExclusionEffect(this.settingTableRowEntityList);
        this.settingLayout.getMandatoryUpgradeCheckBox().setSelected(false);
        this.settingLayout.getLowVersionUpgradeCheckBox().setSelected(false);
        this.settingLayout.getUnMatchCheckBox().setSelected(false);
        this.revalidate();
    }

    private String getDeviceIp() {
        Object selectItem = this.layout.getDeviceSelectCombo().getSelectedItem();
        String selectedDeviceIp = "";
        if (null != selectItem && !selectItem.toString().equals(RES.getString("bundle.upgrade.param.device.combo.default"))) {
            selectedDeviceIp = selectItem.toString();
            return selectedDeviceIp;
        }
        DialogUtils.showInfoDialog((Frame)((Object)BundleUpgradeContext.getInstance().getMainDialog()), (String)RES.getString("bundle.upgrade.param.read.tip"));
        return selectedDeviceIp;
    }

    private void strategyPreviewBtnAction() {
        log.info("click strategy preview btn.");
        this.previewDialog = new StrategyPreviewDialog((Window)((Object)BundleUpgradeContext.getInstance().getMainDialog()));
        this.showStrategyPreviewDeviceTableInfo();
        this.showStrategyPreviewTableInfo();
        UiMethod.putScreenCenter((Window)((Object)this.previewDialog));
        this.previewDialog.setVisible(true);
    }

    private void unMatchCheckBoxAction() {
        log.info("Click to display unmatched firmware packages.");
        JCheckBox checkbox = this.settingLayout.getUnMatchCheckBox();
        String selectedDeviceIp = this.getDeviceIp();
        if (selectedDeviceIp.equals(this.deviceIp)) {
            this.showStrategyTableInfo(this.settingTableRowEntityList, checkbox.isSelected());
        } else {
            DialogUtils.showInfoDialog((Frame)((Object)BundleUpgradeContext.getInstance().getMainDialog()), (String)RES.getString("bundle.upgrade.param.strategy.checkbox.unmatch.tip1"));
            checkbox.setSelected(false);
        }
        this.revalidate();
    }

    private void pcieCheckBoxAction() {
        log.info("click Re-obtaining PCIe Card Information button.");
        if (this.layout.getPcieCheckBox().isSelected()) {
            if (!this.isSpVersionOfSelectedDevicesAbove("1.24")) {
                this.layout.getPcieCheckBox().setSelected(false);
                return;
            }
            BundleUpgradeMainDialog mainDialog = BundleUpgradeContext.getInstance().getMainDialog();
            WarningDialog dialog = DialogUtils.showYesNoDialog((Window)((Object)mainDialog), (String)RES.getString("bundle.upgrade.param.device.pcie.info"));
            if (dialog.getValue() == 0) {
                this.queryPCIeCardsInfo(mainDialog);
            }
        }
        this.layout.getPcieCheckBox().setSelected(false);
    }

    private void queryPCIeCardsInfo(BundleUpgradeMainDialog mainDialog) {
        log.info("query PCIe Card Information.");
        String selectedDeviceIp = this.getDeviceIp();
        if (StringUtils.isNULLStr((String)selectedDeviceIp)) {
            return;
        }
        UpgradeDeviceEntity selectedDevice = BundleUpgradeContext.getInstance().getDeviceNodeByIp(selectedDeviceIp);
        CustMsgProgressDialog progressDialog = new CustMsgProgressDialog((Window)((Object)mainDialog), RES.getString("bundle.upgrade.waite.tip"));
        AsyncExcutor.execute((ProgressDialog)progressDialog, (boolean)true, (long)0L, (Callable[])new Callable[]{() -> {
            try {
                OperationResultEntity resultEntity = this.service.obtainPcieInfoBySP(selectedDevice);
                if (resultEntity.isPassed()) {
                    DialogUtils.showInfoDialog((Frame)((Object)mainDialog), (String)RES.getString("bundle.upgrade.param.device.pcie.tip"));
                    Boolean bl = true;
                    return bl;
                }
                DialogUtils.showInfoDialog((Frame)((Object)mainDialog), (String)RES.getString(QUERY_PCIE_ERROR));
                Boolean bl = false;
                return bl;
            }
            catch (UMateException | InterruptedException ex) {
                log.error(String.format(Locale.ENGLISH, "%s failed to re-query PCIe cards information.", selectedDeviceIp));
                DialogUtils.showInfoDialog((Frame)((Object)mainDialog), (String)RES.getString(QUERY_PCIE_ERROR));
                Boolean bl = false;
                return bl;
            }
            finally {
                log.info("Re-obtaining PCIe Card Information finish.");
            }
        }});
    }

    private void mandatoryUpgradeCheckBoxAction() {
        log.info("click mandatory upgrade button.");
        if (this.settingLayout.getMandatoryUpgradeCheckBox().isSelected()) {
            log.info("Select Upgrade Policy is Force upgrade.");
            this.settingLayout.getLowVersionUpgradeCheckBox().setSelected(false);
            String selectedItem = RES.getString("bundle.upgrade.param.strategy.table.cell.upgrade");
            this.setUpgradeStrategyByBatch(selectedItem, false);
        } else {
            log.info("selsect Upgrade Policy is Don't upgrade.");
            String selectedItem = RES.getString(CELL_VALUE_DEFAULT);
            this.setUpgradeStrategyByBatch(selectedItem, false);
        }
    }

    private void lowVersionUpgradeCheckBoxAction() {
        log.info("click Performing the Upgrade button.");
        if (this.settingLayout.getLowVersionUpgradeCheckBox().isSelected()) {
            this.settingLayout.getMandatoryUpgradeCheckBox().setSelected(false);
            log.info("Select Upgrade Policy is Do Upgrade.");
            String selectedItem = RES.getString("bundle.upgrade.param.strategy.table.cell.demotion");
            this.setUpgradeStrategyByBatch(selectedItem, true);
        } else {
            log.info("Select Upgrade Policy is Don't upgrade.");
            String selectedItem = RES.getString(CELL_VALUE_DEFAULT);
            this.setUpgradeStrategyByBatch(selectedItem, false);
        }
    }

    private void setUpgradeStrategyByBatch(String selectedItem, boolean isDemotion) {
        List tableRows = this.settingLayout.getDefaultTableModel().getAllRows();
        HashSet<String> moduleSet = new HashSet<String>();
        HashSet<String> modelSet = new HashSet<String>();
        for (TableRow tableRow : tableRows) {
            IsmTableCell.ComboBoxCell comboBoxCell;
            Object isMatchedObj = tableRow.getValueAt(6);
            Object comboBoxObj = tableRow.getValueAt(7);
            Object moduleObj = tableRow.getValueAt(0);
            Object modelObj = tableRow.getValueAt(1);
            if (BundleUpgradeContext.isOnlineFirmware()) {
                isMatchedObj = tableRow.getValueAt(7);
                comboBoxObj = tableRow.getValueAt(8);
                moduleObj = tableRow.getValueAt(1);
                modelObj = tableRow.getValueAt(2);
            }
            if (isMatchedObj == null || comboBoxObj == null || moduleObj == null || modelObj == null) continue;
            if ((moduleObj = this.resetModuleObj(tableRow, moduleObj, modelObj)).toString().equalsIgnoreCase(ModuleEnum.CPLD.getName())) {
                if (!this.canSetRow(moduleObj, isDemotion) || !RES.getString("bundle.upgrade.param.strategy.table.cell.matched").equals(isMatchedObj.toString()) || !(comboBoxObj instanceof IsmTableCell.ComboBoxCell) || modelSet.contains(modelObj.toString())) continue;
                comboBoxCell = (IsmTableCell.ComboBoxCell)comboBoxObj;
                comboBoxCell.setSelectedItem((Object)selectedItem);
                moduleSet.add(moduleObj.toString());
                modelSet.add(moduleObj.toString());
                continue;
            }
            if (!this.canSetRow(moduleObj, isDemotion) || !RES.getString("bundle.upgrade.param.strategy.table.cell.matched").equals(isMatchedObj.toString()) || !(comboBoxObj instanceof IsmTableCell.ComboBoxCell) || moduleSet.contains(moduleObj.toString())) continue;
            comboBoxCell = (IsmTableCell.ComboBoxCell)comboBoxObj;
            comboBoxCell.setSelectedItem((Object)selectedItem);
            moduleSet.add(moduleObj.toString());
        }
        this.settingLayout.getStrategySettingTable().repaint();
    }

    private boolean canSetRow(Object moduleObj, boolean isDemotion) {
        boolean excludeDemotionItem;
        boolean bl = excludeDemotionItem = ServiceUtil.isPCIeModule(moduleObj.toString()) && !ServiceUtil.isExtendsPublicModule(moduleObj.toString());
        return excludeDemotionItem ? !isDemotion : true;
    }

    private Object resetModuleObj(TableRow tableRow, Object moduleObj, Object modelObj) {
        Object obj = moduleObj;
        if (moduleObj.toString().equalsIgnoreCase(ModuleEnum.BIOS.getName()) && ((StrategySettingTableRowEntity)tableRow.getUserObject()).getFwPackageName().toLowerCase(Locale.ENGLISH).contains("iob")) {
            obj = "IOB_" + obj;
        } else if (obj.toString().equalsIgnoreCase(UpgradeParamConstants.ModuleType.ES3000.getModule())) {
            obj = obj + "_" + modelObj;
        }
        return obj;
    }

    public String getTitle() {
        return RES.getString("bundle.upgrade.param.setting.step2.title");
    }

    public int getStep() {
        return 1;
    }

    protected ToolWizardDialog.Card getNextCard() {
        AtomicReference<OperationResultEntity> saveUpgradeStrategyResult;
        if (this.settingTableRowEntityList == null) {
            DialogUtils.showInfoDialog((Frame)((Object)BundleUpgradeContext.getInstance().getMainDialog()), (String)RES.getString("bundle.upgrade.param.strategy.next.check.tip"));
            return null;
        }
        List<StrategySettingTableRowEntity> selectedRows = this.service.getSelectedUpgradeModuleList(this.settingTableRowEntityList);
        if (selectedRows.stream().allMatch(selectedRow -> RES.getString(CELL_VALUE_DEFAULT).equals(selectedRow.getStrategyComboBoxCell().getSelectedItem()))) {
            DialogUtils.showInfoDialog((Frame)((Object)BundleUpgradeContext.getInstance().getMainDialog()), (String)RES.getString(NO_COMPONENT));
            log.info("No upgrade component is available. Select another component.");
            return null;
        }
        if (!this.upgradeCheck(selectedRows) || !this.checkBbuCanUpgradeAndShowWarnInfo(selectedRows)) {
            return null;
        }
        if (this.checkHasInBandAndOutBandFw(selectedRows)) {
            DialogUtils.showErrorDialog((Window)((Object)BundleUpgradeContext.getInstance().getMainDialog()), (String)RES.getString("bundle.upgrade.param.strategy.inband.outband.error"));
            return null;
        }
        List<String> result = this.checkDependence();
        if (result.size() == 2) {
            DialogUtils.showInfoDialog((Frame)((Object)BundleUpgradeContext.getInstance().getMainDialog()), (String)RES.getStringWithParams("bundle.upgrade.param.strategy.next.check.dependence.tip", new Object[]{result.get(0), result.get(1)}));
            return null;
        }
        if (this.service.isUpgradeAgentContainsSp(selectedRows)) {
            if (!this.isSpVersionOfSelectedDevicesAbove("1.24")) {
                return null;
            }
            UpgradeDeviceEntity baseDevice = BundleUpgradeContext.getInstance().getDeviceNodeByIp(this.deviceIp);
            if (!baseDevice.getDeviceEntity().isSupportSp()) {
                DialogUtils.showInfoDialog((Frame)((Object)BundleUpgradeContext.getInstance().getMainDialog()), (String)RES.getStringWithParams("bundle.upgrade.check.sp.agent.not.support", new Object[]{baseDevice.getDeviceEntity().getProductType()}));
                return null;
            }
        }
        if ((saveUpgradeStrategyResult = this.getOperationResultEntityAtomicReference()).get().isPassed()) {
            return new UpgradeOrderSettingCard((ToolWizardDialog.Card)this, this.getDeviceIpForNext(), ToolWizardDialog.Navigation.PREVIOUS, ToolWizardDialog.Navigation.COMPLETE);
        }
        if (BundleUpgradeContext.isOnlineFirmware()) {
            this.buildOnlineDialog(saveUpgradeStrategyResult);
        }
        return null;
    }

    boolean checkBbuCanUpgradeAndShowWarnInfo(List<StrategySettingTableRowEntity> selectedRows) {
        Optional<StrategySettingTableRowEntity> bbuRow = this.getMatchRow(selectedRows, UpgradeParamConstants.ModuleType.BBU.getModule());
        ArrayList<UpgradeDeviceEntity> deviceWithBbuWarns = new ArrayList<UpgradeDeviceEntity>();
        if (bbuRow.isPresent() && ServiceUtil.isForceUpgradeCell(bbuRow.get().getStrategyComboBoxCell())) {
            try {
                deviceWithBbuWarns.addAll(this.getDeviceWithBbuWarns(bbuRow.get(), BundleUpgradeContext.getInstance().getSelectedDeviceEntities()));
            }
            catch (UMateException e) {
                DialogUtils.showErrorDialog((Window)((Object)BundleUpgradeContext.getInstance().getMainDialog()), (String)e.getMessage());
                return false;
            }
        }
        if (deviceWithBbuWarns.isEmpty()) {
            log.info("No BBU version that has the upgrade risk exists");
            return true;
        }
        WarningDialog warningDialog = DialogUtils.showMultiWarningDialogWithHyperlink((Window)((Object)BundleUpgradeContext.getInstance().getMainDialog()), this.getWarningInfos(deviceWithBbuWarns), (String)RES.getString("mainframe.replace.common.ensure"));
        return warningDialog.isConfirmClick();
    }

    private List<UpgradeDeviceEntity> getDeviceWithBbuWarns(StrategySettingTableRowEntity bbuRow, List<UpgradeDeviceEntity> selectedDevice) throws UMateException {
        ArrayList<UpgradeDeviceEntity> devices = new ArrayList<UpgradeDeviceEntity>();
        for (UpgradeDeviceEntity upgradeDeviceEntity : selectedDevice) {
            if (upgradeDeviceEntity.getDeviceEntity() == null) continue;
            for (DeviceEntity.BbuModel bbuModel : upgradeDeviceEntity.getDeviceEntity().getBbuModels()) {
                try {
                    this.addDeviceWithBbuWarn(bbuRow, devices, upgradeDeviceEntity, bbuModel);
                }
                catch (UMateException e) {
                    log.error("Node:{} current or target version illegal", (Object)upgradeDeviceEntity.getDeviceEntity().getIp(), (Object)e);
                    throw e;
                }
            }
        }
        return devices;
    }

    private void addDeviceWithBbuWarn(StrategySettingTableRowEntity bbuRow, List<UpgradeDeviceEntity> devices, UpgradeDeviceEntity upgradeDeviceEntity, DeviceEntity.BbuModel bbuModel) throws UMateException {
        if (Objects.equals(bbuModel.getBbuVersion(), bbuRow.getTargetVersion())) {
            return;
        }
        if (UpgradeScenarioUtil.isFromVersionLowerThanToVersion(bbuModel.getBbuVersion(), bbuRow.getTargetVersion())) {
            return;
        }
        log.info("Node:{}, Risks exist when the current version {} is upgraded to the target version {}.", new Object[]{upgradeDeviceEntity.getDeviceEntity().getIp(), bbuModel.getBbuVersion(), bbuRow.getTargetVersion()});
        if (!devices.contains(upgradeDeviceEntity)) {
            devices.add(upgradeDeviceEntity);
        }
    }

    private List<WarningInfo> getWarningInfos(List<UpgradeDeviceEntity> deviceBbuWarn) {
        ArrayList<WarningInfo> warningInfos = new ArrayList<WarningInfo>();
        WarningInfo warningInfo = WarningInfo.builder().message(RES.getString("bbu.upgrade.alarm.information")).build();
        WarningInfo involvedNodes = WarningInfo.builder().message(deviceBbuWarn.stream().map(device -> device.getDeviceEntity().getIp()).collect(Collectors.joining(","))).hiddenIfTooLong(true).build();
        warningInfos.add(warningInfo);
        warningInfos.add(involvedNodes);
        return warningInfos;
    }

    private void buildOnlineDialog(AtomicReference<OperationResultEntity> saveUpgradeStrategyResult) {
        if (!StringUtils.isNULLStr((String)saveUpgradeStrategyResult.get().getReturnParam())) {
            List<StrategySettingTableRowEntity> firmwareTableRowEntityList = this.getStrategySettingTableRowEntities(saveUpgradeStrategyResult.get());
            this.firmwareOnlineDownloadDialog = new FirmwareOnlineDownloadDialog((Window)((Object)BundleUpgradeContext.getInstance().getMainDialog()));
            this.showFirmwarePermissionDeviceTableInfo();
            this.showFirmwarePermissionTableInfo(firmwareTableRowEntityList);
            UiMethod.putScreenCenter((Window)((Object)this.firmwareOnlineDownloadDialog));
            this.firmwareOnlineDownloadDialog.setVisible(true);
        }
    }

    private boolean upgradeCheck(List<StrategySettingTableRowEntity> selectedRows) {
        try {
            OperationResultEntity operationResultEntity = new OperationResultEntity(true, "");
            CustMsgProgressDialog progressDialog = new CustMsgProgressDialog((Window)((Object)BundleUpgradeContext.getInstance().getMainDialog()), RES.getString("bundle.upgrade.waite.tip"));
            if (UpgradeScenarioUtil.isYinglong()) {
                return this.checkCanUpgradeYingLongScene(selectedRows, operationResultEntity, (ProgressDialog)progressDialog);
            }
            this.checkCanUpgradeCommonScene(selectedRows, operationResultEntity, (ProgressDialog)progressDialog);
            if (!operationResultEntity.isNextStep()) {
                return false;
            }
            if (operationResultEntity.getPreUpgradeResult().values().stream().anyMatch(value -> value == false)) {
                this.showMultiErrorInfo(operationResultEntity);
                return false;
            }
            return true;
        }
        catch (Exception e) {
            log.error("An unknown exception occurred.", (Throwable)e);
            return true;
        }
    }

    private void checkCanUpgradeCommonScene(List<StrategySettingTableRowEntity> selectedRows, OperationResultEntity operationResultEntity, ProgressDialog progressDialog) {
        AsyncExcutor.execute((ProgressDialog)progressDialog, (boolean)true, (long)0L, (Callable[])new Callable[]{() -> {
            this.executeBiosCheck(operationResultEntity, selectedRows);
            this.checkBmc(operationResultEntity, selectedRows);
            this.checkErasureStatus(operationResultEntity, selectedRows);
            this.checkBlackDisk(operationResultEntity, selectedRows);
            return true;
        }});
    }

    private OperationResultEntity checkBlackDisk(OperationResultEntity operationResultEntity, List<StrategySettingTableRowEntity> selectedRows) {
        boolean isCheckBlackDisk = Boolean.parseBoolean(SystemConfig.createSystemConfig().getConfigVlaue("is.check.black.disk"));
        if (!isCheckBlackDisk) {
            log.info("Black Disk Check Flag is false. No check is required.");
            return operationResultEntity;
        }
        this.getMatchRowContains(selectedRows, UpgradeParamConstants.ModuleType.SSD_SP.getModule()).ifPresent(ssdpRow -> this.setAndSaveBlackInfo(operationResultEntity, (StrategySettingTableRowEntity)ssdpRow, UpgradeParamConstants.ModuleType.SSD_SP, (device, pkgEntity) -> UpgradeCustomizationUtil.getBlackModels(device, pkgEntity).isEmpty()));
        this.getMatchRowContains(selectedRows, UpgradeParamConstants.ModuleType.DISK_FW.getModule()).ifPresent(diskFwRow -> this.setAndSaveBlackInfo(operationResultEntity, (StrategySettingTableRowEntity)diskFwRow, UpgradeParamConstants.ModuleType.DISK_FW, (device, pkgEntity) -> !UpgradeCustomizationUtil.isAnyDiskInBlack(device, pkgEntity)));
        return operationResultEntity;
    }

    private void setAndSaveBlackInfo(OperationResultEntity operationResultEntity, StrategySettingTableRowEntity matchRow, UpgradeParamConstants.ModuleType moduleType, BiFunction<DeviceEntity, FirmwarePackageEntity, Boolean> biFunction) {
        FirmwarePackageEntity pkgEntity = matchRow.getFirmwarePackageEntity();
        List<DeviceEntity> selectDevices = this.getSelectDevices();
        if (selectDevices.stream().allMatch(device -> (Boolean)biFunction.apply((DeviceEntity)device, pkgEntity))) {
            log.info("No disk in balck, Continue the upgrade");
            return;
        }
        String errorMsg = RES.getStringWithParams("step.power.device.change.info", new Object[]{moduleType.getModule()});
        operationResultEntity.getPreUpgradeResult().put("blackDiskCheck", false);
        selectDevices.stream().filter(device -> (Boolean)biFunction.apply((DeviceEntity)device, pkgEntity) == false).forEach(device -> operationResultEntity.getArrayListCheckInfo().put((Object)device.getIp(), (Object)errorMsg));
    }

    private boolean checkCanUpgradeYingLongScene(List<StrategySettingTableRowEntity> selectedRows, OperationResultEntity operationResultEntity, ProgressDialog progressDialog) {
        AsyncExcutor.execute((ProgressDialog)progressDialog, (boolean)true, (long)0L, (Callable[])new Callable[]{() -> {
            this.checkBmc(operationResultEntity, selectedRows);
            return true;
        }});
        if (operationResultEntity.getPreUpgradeResult().values().stream().anyMatch(value -> value == false)) {
            this.showMultiErrorInfo(operationResultEntity);
            return false;
        }
        return true;
    }

    void checkErasureStatus(OperationResultEntity operationResultEntity, List<StrategySettingTableRowEntity> selectedRows) {
        List<String> nodeIpsInErasureStatus;
        Optional<DevNode> selectCluster = this.getSelectCluster();
        if (!selectCluster.isPresent()) {
            return;
        }
        DevNode devNode = selectCluster.get();
        if (!FwUpgradeScenarioAdaptation.ErasureBlockEnum.isSupportErasureProduct(devNode.getDeviceType().toString(), devNode.getProductVersion())) {
            log.info("Device {} do not need check erasure status, type:{},version:{}", new Object[]{devNode.getIp(), devNode.getDeviceType().toString(), devNode.getProductVersion()});
            return;
        }
        List<Optional<StrategySettingTableRowEntity>> rowEntity = this.getFwNeedCheckErasureStatus(selectedRows);
        if (rowEntity.stream().noneMatch(Optional::isPresent)) {
            log.info("No disk fw do not check erasure status ");
            return;
        }
        try {
            nodeIpsInErasureStatus = this.getNodeIpInErasureStatus(devNode, this.getSelectNodeIps());
        }
        catch (ToolException e) {
            log.error("Query device {} erasure status error", (Object)devNode.getIp());
            DialogUtils.showInfoDialog((Frame)((Object)BundleUpgradeContext.getInstance().getMainDialog()), (String)RES.getString("net.error"));
            operationResultEntity.setNextStep(false);
            return;
        }
        if (nodeIpsInErasureStatus.isEmpty()) {
            log.info("Device {} no node in erasure status", (Object)devNode.getIp());
            return;
        }
        this.promptInfoCombination(operationResultEntity, rowEntity, nodeIpsInErasureStatus);
    }

    private Optional<DevNode> getSelectCluster() {
        UpgDeviceExtendFSDataEntity extendDataEntity = FusionStrgUpgradeContext.getInstance().getBusinessIpMapper().get(BundleUpgradeContext.getInstance().getDeviceNodeByIp(this.getDeviceIp()));
        if (extendDataEntity == null) {
            return Optional.empty();
        }
        return DefaultNodeProviderImpl.getInstance().getNodeList().stream().filter(node -> Objects.equals(node.getIp(), extendDataEntity.getBelongsClusterEntity().getFloatIp())).findFirst();
    }

    private List<Optional<StrategySettingTableRowEntity>> getFwNeedCheckErasureStatus(List<StrategySettingTableRowEntity> selectedRows) {
        return UpgradeParamConstants.ModuleType.getAllDiskFw().stream().map(type -> this.getMatchRow(selectedRows, type.getModule())).collect(Collectors.toList());
    }

    private List<String> getNodeIpInErasureStatus(DevNode devNode, List<String> selectNodeIps) throws ToolException {
        Map<String, List<String>> param = Collections.singletonMap("ipList", selectNodeIps);
        ResponseInfo responseInfo = NodeServiceUtils.queryNodeDataErasureStatus(devNode, param);
        return NodeServiceUtils.getNodeIpsInErasureStatusIp(responseInfo);
    }

    private List<String> getSelectNodeBmcIps(List<String> nodesInErasureStatus) {
        return BundleUpgradeContext.getInstance().getSelectedDeviceEntities().stream().map(node -> FusionStrgUpgradeContext.getInstance().getBusinessIpMapper().get(node)).filter(node -> nodesInErasureStatus.contains(node.getManagementIp())).map(UpgDeviceExtendFSDataEntity::getDeviceEntity).map(UpgradeDeviceEntity::getDeviceEntity).map(DeviceEntity::getIp).collect(Collectors.toList());
    }

    private List<String> getSelectNodeIps() {
        return BundleUpgradeContext.getInstance().getSelectedDeviceEntities().stream().map(node -> FusionStrgUpgradeContext.getInstance().getBusinessIpMapper().get(node)).filter(Objects::nonNull).map(UpgDeviceExtendFSDataEntity::getManagementIp).collect(Collectors.toList());
    }

    private void promptInfoCombination(OperationResultEntity operationResultEntity, List<Optional<StrategySettingTableRowEntity>> rowEntity, List<String> nodeInErasureStatus) {
        String diskFwModuleName = rowEntity.stream().filter(Optional::isPresent).map(entity -> ((StrategySettingTableRowEntity)entity.get()).getModule()).collect(Collectors.joining(","));
        String errorInfo = RES.getStringWithParams("upgrade.disk.wipe.status.check", new Object[]{diskFwModuleName});
        List<String> selectNodeBmcIps = this.getSelectNodeBmcIps(nodeInErasureStatus);
        if (!CollectionUtil.isEmpty(selectNodeBmcIps)) {
            operationResultEntity.getPreUpgradeResult().put("erasureCheck", false);
        }
        selectNodeBmcIps.forEach(bmcIp -> operationResultEntity.getArrayListCheckInfo().put(bmcIp, (Object)errorInfo));
    }

    private void showMultiErrorInfo(OperationResultEntity operationResultEntity) {
        DialogUtils.showMultiErrorDialogNoIgnoreButton((Window)((Object)BundleUpgradeContext.getInstance().getMainDialog()), (String)RES.getString("pre.upgrade.check.error"), (String[])new String[]{"BMC IP", RES.getString("report.table.header.error.msg")}, operationResultEntity.getShowInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OperationResultEntity executeBiosCheck(OperationResultEntity operationResultEntity, List<StrategySettingTableRowEntity> selectedRows) {
        boolean isNeedCheck = Boolean.parseBoolean(SystemConfig.createSystemConfig().getConfigVlaue("fw.bios.dsm.check"));
        if (!isNeedCheck) {
            return operationResultEntity;
        }
        Optional<StrategySettingTableRowEntity> biosRow = selectedRows.stream().filter(row -> UpgradeParamConstants.ModuleType.BIOS.getModule().equals(row.getModule())).filter(row -> !row.getFwPackageName().toLowerCase(Locale.ROOT).contains("iob")).findFirst();
        if (!biosRow.isPresent()) {
            return operationResultEntity;
        }
        try {
            String scriptPath = PythonExecuteUtils.intoCanonicalScriptPath(ScriptConfigUtil.getScriptRelativePath("fusionStorage", "bioscheck"));
            if (!Paths.get(scriptPath, new String[0]).toFile().exists()) {
                OperationResultEntity operationResultEntity2 = operationResultEntity;
                return operationResultEntity2;
            }
            String errMsg = PythonExecuteUtils.executeScripts(scriptPath, this.buildScriptEnvs(biosRow.get()));
            if (StringUtils.isNULLStr((String)errMsg)) {
                OperationResultEntity operationResultEntity3 = operationResultEntity;
                return operationResultEntity3;
            }
            operationResultEntity.getPreUpgradeResult().put("bioscheck", false);
            operationResultEntity.cacheCheckBiosErrorInfo(this.getSelectDevices(), errMsg);
        }
        catch (UMateException e) {
            DialogUtils.showInfoDialog((Frame)((Object)BundleUpgradeContext.getInstance().getMainDialog()), (String)e.getMessage());
            operationResultEntity.setNextStep(false);
        }
        finally {
            BundleUpgradeContext.getInstance().getSelectedDeviceEntities().forEach(deviceEntity -> {
                String ip = deviceEntity.getDeviceEntity().getIp();
                UpgDeviceExtendFSDataEntity fsDeviceEntityByBmcIp = FusionStrgUpgradeContext.getInstance().getFsDeviceEntityByBmcIp(ip);
                FusionStorageSshPool.releaseFsSshConnection(fsDeviceEntityByBmcIp);
            });
        }
        return operationResultEntity;
    }

    @NotNull
    private List<DeviceEntity> getSelectDevices() {
        return BundleUpgradeContext.getInstance().getSelectedDeviceEntities().stream().map(UpgradeDeviceEntity::getDeviceEntity).collect(Collectors.toList());
    }

    private OperationResultEntity checkBmc(OperationResultEntity operationResultEntity, List<StrategySettingTableRowEntity> selectedRows) throws UMateException {
        boolean neeCheck = Boolean.parseBoolean(SystemConfig.createSystemConfig().getConfigVlaue("fw.ibmc.ssl.check"));
        if (!neeCheck) {
            return operationResultEntity;
        }
        List<DeviceEntity> specificDevice = this.getSpecificDevice();
        if (specificDevice.isEmpty()) {
            log.info("Specific Device pass");
            return operationResultEntity;
        }
        Optional<StrategySettingTableRowEntity> iBmcRow = this.getMatchRow(selectedRows, UpgradeParamConstants.ModuleType.iBMC.getModule());
        if (!iBmcRow.isPresent()) {
            return operationResultEntity;
        }
        if (!UpgradeScenarioUtil.isFromVersionLowerThanToVersion("3.06.15.06", iBmcRow.get().getTargetVersion())) {
            return operationResultEntity;
        }
        this.executeBmcCheck(operationResultEntity, iBmcRow.get(), specificDevice);
        return operationResultEntity;
    }

    private List<DeviceEntity> getSpecificDevice() {
        return BundleUpgradeContext.getInstance().getSelectedDeviceEntities().stream().map(UpgradeDeviceEntity::getDeviceEntity).filter(DeviceEntity::isSpecificDevice).collect(Collectors.toList());
    }

    private Optional<StrategySettingTableRowEntity> getMatchRow(List<StrategySettingTableRowEntity> selectedRows, String moduleName) {
        return selectedRows.stream().filter(row -> moduleName.equalsIgnoreCase(row.getModule())).findFirst();
    }

    private Optional<StrategySettingTableRowEntity> getMatchRowContains(List<StrategySettingTableRowEntity> selectedRows, String moduleName) {
        return selectedRows.stream().filter(row -> Objects.nonNull(row.getModule()) && row.getModule().contains(moduleName)).findFirst();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OperationResultEntity executeBmcCheck(OperationResultEntity operationResultEntity, StrategySettingTableRowEntity iBmcRow, List<DeviceEntity> deviceEntities) {
        try {
            String scriptPath = this.getScriptPath();
            if (!Paths.get(scriptPath, new String[0]).toFile().exists()) {
                OperationResultEntity operationResultEntity2 = operationResultEntity;
                return operationResultEntity2;
            }
            String errMsg = PythonExecuteUtils.executeScripts(scriptPath, this.buildIBmcEnvs(iBmcRow, deviceEntities));
            if (StringUtils.isNULLStr((String)errMsg)) {
                OperationResultEntity operationResultEntity3 = operationResultEntity;
                return operationResultEntity3;
            }
            log.warn(String.format(Locale.ROOT, "script execute result: %s ", errMsg));
            operationResultEntity.parseAndCacheResultInfo(deviceEntities, errMsg);
            operationResultEntity.getPreUpgradeResult().put("ibmcCheck", false);
            OperationResultEntity operationResultEntity4 = operationResultEntity;
            return operationResultEntity4;
        }
        catch (UMateException e) {
            DialogUtils.showInfoDialog((Frame)((Object)BundleUpgradeContext.getInstance().getMainDialog()), (String)e.getMessage());
            operationResultEntity.setNextStep(false);
        }
        finally {
            deviceEntities.forEach(RestConnPool::releaseConnection);
        }
        return operationResultEntity;
    }

    private String getScriptPath() {
        return PythonExecuteUtils.intoCanonicalScriptPath(ScriptConfigUtil.getScriptRelativePath("fusionStorage", "ibmcCheck"));
    }

    private Map<String, Object> buildIBmcEnvs(StrategySettingTableRowEntity iBmcRow, List<DeviceEntity> deviceEntity) {
        HashMap<String, Object> ssEnv = new HashMap<String, Object>();
        ssEnv.put("logger", log);
        ssEnv.put("lang", LanguageManager.getInstance().getCurrentLanguage().getLanguage());
        ssEnv.put("bmcTargetVersion", iBmcRow.getTargetVersion());
        ssEnv.put("selectedDevices", deviceEntity);
        return ssEnv;
    }

    private Map<String, Object> buildScriptEnvs(StrategySettingTableRowEntity biosRow) throws UMateException {
        HashMap<String, Object> ssEnv = new HashMap<String, Object>(2);
        List<UpgradeDeviceEntity> selectedDevices = BundleUpgradeContext.getInstance().getSelectedDeviceEntities();
        DevNode devNode = this.buildFsDevNode(BundleUpgradeContext.getInstance().getDeviceNodeByIp(this.deviceIp));
        ssEnv.put("logger", log);
        ssEnv.put("lang", LanguageManager.getInstance().getCurrentLanguage().getLanguage());
        ssEnv.put("biosTargetVersion", biosRow.getTargetVersion());
        ssEnv.put("selectedDevices", selectedDevices);
        ssEnv.put("storagePoolContent", NodeServiceUtils.queryStoragePoolInfo(devNode));
        ssEnv.put("productVersion", DevInfoUtil.getCompleteDevVersion((DevNode)devNode));
        return ssEnv;
    }

    private DevNode buildFsDevNode(UpgradeDeviceEntity deviceEntity) {
        UpgDeviceExtendFSDataEntity fsDataEntity = FusionStrgUpgradeContext.getInstance().getBusinessIpMapper().get(deviceEntity);
        return FusionStorageRestConnector.buildDevNode(fsDataEntity.getBelongsClusterEntity());
    }

    private boolean checkHasInBandAndOutBandFw(List<StrategySettingTableRowEntity> selectedRows) {
        List modules = selectedRows.stream().map(StrategySettingTableRowEntity::getModule).collect(Collectors.toList());
        List<String> pcieModules = Arrays.asList(UpgradeConstants.PCIeModule);
        if (modules.stream().anyMatch(pcieModules::contains)) {
            return !pcieModules.containsAll(modules);
        }
        return false;
    }

    private AtomicReference<OperationResultEntity> getOperationResultEntityAtomicReference() {
        AtomicReference<OperationResultEntity> saveUpgradeStrategyResult = new AtomicReference<OperationResultEntity>(new OperationResultEntity(true, ""));
        BundleUpgradeContext.getInstance().setSettingTableRowEntityList(this.settingTableRowEntityList);
        if (BundleUpgradeContext.isOnlineFirmware()) {
            CustMsgProgressDialog progressDialog = new CustMsgProgressDialog((Window)((Object)BundleUpgradeContext.getInstance().getMainDialog()), RES.getString("bundle.upgrade.waite.tip"));
            AsyncExcutor.execute((ProgressDialog)progressDialog, (boolean)true, (long)0L, (Callable[])new Callable[]{() -> {
                saveUpgradeStrategyResult.set(this.service.saveUpgradeStrategy());
                log.info("save Upgrade Strategy Result finish.");
                return true;
            }});
        } else {
            saveUpgradeStrategyResult.set(this.service.saveUpgradeStrategy());
        }
        return saveUpgradeStrategyResult;
    }

    private List<StrategySettingTableRowEntity> getStrategySettingTableRowEntities(OperationResultEntity saveUpgradeStrategyResult) {
        JSONArray errlist = (JSONArray)RedfishUtils.getObjectAttr((String)saveUpgradeStrategyResult.getReturnParam(), JSONArray.class, (String[])new String[]{"errorList"});
        LinkedList<StrategySettingTableRowEntity> firmwareTableRowEntityList = new LinkedList<StrategySettingTableRowEntity>();
        if (null != errlist) {
            for (int i = 0; i < errlist.size(); ++i) {
                JSONObject errorinfoJson = errlist.getJSONObject(i);
                String path = errorinfoJson.getString("path");
                String errorCode = errorinfoJson.getString("errorCode");
                String responseCode = errorinfoJson.getString("responseCode");
                for (StrategySettingTableRowEntity strategySettingTableRowEntity : this.settingTableRowEntityList) {
                    if (!path.contains(strategySettingTableRowEntity.getFirmwarePackageEntity().getOnlineFilePath())) continue;
                    UpgradeParamsSettingCard.obtainsFwPermissionFailReason(Integer.parseInt(responseCode), Integer.parseInt(errorCode), strategySettingTableRowEntity);
                    firmwareTableRowEntityList.add(strategySettingTableRowEntity);
                }
                log.info(path);
                log.info(errorCode);
                log.info(responseCode);
            }
        }
        return firmwareTableRowEntityList;
    }

    public static void obtainsFwPermissionFailReason(int responseCode, int errorCode, StrategySettingTableRowEntity strategySettingTableRowEntity) {
        switch (responseCode) {
            case 401: {
                UpgradeParamsSettingCard.setUnauthoriedResult(errorCode, strategySettingTableRowEntity);
                break;
            }
            case 403: {
                UpgradeParamsSettingCard.setForbiddenResult(errorCode, strategySettingTableRowEntity);
            }
        }
    }

    private static void setForbiddenResult(int errorCode, StrategySettingTableRowEntity strategySettingTableRowEntity) {
        switch (errorCode) {
            case 122: {
                UpgradeParamsSettingCard.setCheckResult(strategySettingTableRowEntity, "bundle.upgrade.firmware.download.premission.check.message122", "bundle.upgrade.firmware.download.premission.check.solution122");
                break;
            }
            case 123: {
                UpgradeParamsSettingCard.setCheckResult(strategySettingTableRowEntity, "bundle.upgrade.firmware.download.premission.check.message123", "bundle.upgrade.firmware.download.premission.check.solution123");
                break;
            }
            default: {
                UpgradeParamsSettingCard.setCheckResult(strategySettingTableRowEntity, "bundle.upgrade.firmware.download.premission.check.message0", "bundle.upgrade.firmware.download.premission.check.solution0");
            }
        }
    }

    private static void setUnauthoriedResult(int errorCode, StrategySettingTableRowEntity strategySettingTableRowEntity) {
        switch (errorCode) {
            case 111: {
                UpgradeParamsSettingCard.setCheckResult(strategySettingTableRowEntity, "bundle.upgrade.firmware.download.premission.check.message111", "bundle.upgrade.firmware.download.premission.check.solution111");
                break;
            }
            case 110: {
                UpgradeParamsSettingCard.setCheckResult(strategySettingTableRowEntity, "bundle.upgrade.firmware.download.premission.check.message110", "bundle.upgrade.firmware.download.premission.check.solution110");
                break;
            }
            default: {
                UpgradeParamsSettingCard.setCheckResult(strategySettingTableRowEntity, "bundle.upgrade.firmware.download.premission.check.message0", "bundle.upgrade.firmware.download.premission.check.solution0");
            }
        }
    }

    private static void setCheckResult(StrategySettingTableRowEntity strategySettingTableRowEntity, String errorMessage, String solution) {
        strategySettingTableRowEntity.setErrorMessage(RES.getString(errorMessage));
        strategySettingTableRowEntity.setSolution(RES.getString(solution));
    }

    private void showFirmwarePermissionDeviceTableInfo() {
        DeviceEntity device;
        DefaultTableModel tableModel = this.firmwareOnlineDownloadDialog.getFirmwarePermissionLayout().getBaseInfoTableModel();
        tableModel.removeAll();
        UpgradeDeviceEntity upgradeDeviceEntity = BundleUpgradeContext.getInstance().getDeviceNodeByIp(this.deviceIp);
        if (upgradeDeviceEntity != null && (device = upgradeDeviceEntity.getDeviceEntity()) != null) {
            TableRow<DeviceEntity, String> row = this.createFwDeviceInfoPreviewTableRow(device);
            tableModel.addRow(new TableRow[]{row});
        }
    }

    private void showFirmwarePermissionTableInfo(List<StrategySettingTableRowEntity> firmwareTableRowEntityList) {
        DefaultTableModel tableModel = this.firmwareOnlineDownloadDialog.getFirmwarePermissionLayout().getFirmwarePermissionTableModel();
        tableModel.removeAll();
        List<StrategySettingTableRowEntity> getPreViewTableRowEntity = this.service.getPreViewTableRowEntity(firmwareTableRowEntityList);
        for (StrategySettingTableRowEntity entity : getPreViewTableRowEntity) {
            TableRow<StrategySettingTableRowEntity, String> row = this.createFirmwarePressionTableRow(entity);
            tableModel.addRow(new TableRow[]{row});
        }
    }

    private TableRow<StrategySettingTableRowEntity, String> createFirmwarePressionTableRow(StrategySettingTableRowEntity entity) {
        String key = entity.getUuid().toString();
        int columnCount = this.firmwareOnlineDownloadDialog.getFirmwarePermissionLayout().getFirmwarePermissionTableModel().getColumnCount();
        DefaultTableRow row = new DefaultTableRow(columnCount, (Object)entity, (Object)key);
        int col = 0;
        row.setValueAt(col++, (Object)entity.getModule());
        row.setValueAt(col++, (Object)entity.getCurrentVersion());
        row.setValueAt(col++, (Object)entity.getTargetVersion());
        row.setValueAt(col++, (Object)entity.getErrorMessage());
        row.setValueAt(col, (Object)entity.getSolution());
        return row;
    }

    private TableRow<DeviceEntity, String> createFwDeviceInfoPreviewTableRow(DeviceEntity deviceEntity) {
        String key = deviceEntity.getIp();
        int columnCount = this.firmwareOnlineDownloadDialog.getFirmwarePermissionLayout().getBaseInfoIsmTable().getColumnCount();
        return this.getRowDate(columnCount, deviceEntity, key);
    }

    protected boolean isValid(ToolWizardDialog.Navigation navigation) {
        return true;
    }

    protected boolean process(ToolWizardDialog.Navigation navigation) {
        if (ToolWizardDialog.Navigation.PREVIOUS.equals((Object)navigation)) {
            log.info("click previous card.");
        }
        if (ToolWizardDialog.Navigation.NEXT.equals((Object)navigation)) {
            log.info("click next card.");
        }
        return true;
    }

    private boolean isSpVersionOfSelectedDevicesAbove(String requiredVersion) {
        List<UpgradeDeviceEntity> upgradeDeviceEntityList = BundleUpgradeContext.getInstance().getSelectedDeviceEntities();
        ArrayList<String> invalidDeviceIps = new ArrayList<String>();
        for (UpgradeDeviceEntity upgradeDeviceEntity : upgradeDeviceEntityList) {
            DeviceEntity deviceEntity = upgradeDeviceEntity.getDeviceEntity();
            String spVersion = deviceEntity.getSpVersion();
            String spVersionAppVersion = spVersion.split("/")[0].trim();
            String ip = deviceEntity.getIp();
            String processorArchitecture = deviceEntity.getProcessorArchitecture();
            log.info(String.format(Locale.ENGLISH, "sp version is %s", spVersionAppVersion));
            log.info(String.format(Locale.ENGLISH, "processor architecture is %s", processorArchitecture));
            if (spVersionAppVersion.compareTo(requiredVersion) >= 0 || !processorArchitecture.equalsIgnoreCase("ARM")) continue;
            invalidDeviceIps.add(ip);
        }
        if (invalidDeviceIps.size() > 0) {
            this.showErrorDialogAboutSpVersion(invalidDeviceIps);
            return false;
        }
        return true;
    }

    private List<String> checkDependence() {
        ArrayList<String> res = new ArrayList<String>();
        PanGeaPackageEntity panGeaPackage = BundleUpgradeContext.getInstance().getPanGeaPackageEntity();
        List<StrategySettingTableRowEntity> tableRowEntityList = this.service.getPreViewTableRowEntity(this.settingTableRowEntityList);
        ArrayList<String> panGeaInBandWillUpgradeModuleList = new ArrayList<String>();
        for (StrategySettingTableRowEntity entity : tableRowEntityList) {
            boolean isPanGeaInBand = ServiceUtil.isPanGeaIntraBandModule(entity.getModule());
            UpgradeParamConstants.UpgradeExpectEffect effect = entity.getExpectEffect();
            UpgradeParamConstants.UpgradeExpectEffect cover = UpgradeParamConstants.UpgradeExpectEffect.COVER;
            UpgradeParamConstants.UpgradeExpectEffect upgrade = UpgradeParamConstants.UpgradeExpectEffect.UPGRADE;
            if (effect != cover && effect != upgrade || !isPanGeaInBand) continue;
            panGeaInBandWillUpgradeModuleList.add(entity.getModule());
        }
        for (String module : panGeaInBandWillUpgradeModuleList) {
            List<String> dependenceList = panGeaPackage.getSubModuleDependence(module);
            if (dependenceList == null || dependenceList.size() == 0) continue;
            for (String dependenceModule : dependenceList) {
                if (panGeaInBandWillUpgradeModuleList.contains(dependenceModule) || !this.isInitialInstallation(dependenceModule)) continue;
                res.add(module);
                res.add(dependenceModule);
                return res;
            }
        }
        return res;
    }

    private boolean isInitialInstallation(String dependenceModule) {
        boolean isMatchModule = this.settingTableRowEntityList.stream().filter(StrategySettingTableRowEntity::isMatch).filter(rowEntity -> rowEntity.getModule().equals(dependenceModule)).anyMatch(rowEntity -> "--".equals(rowEntity.getCurrentVersion()));
        return UpgradeScenarioUtil.isYinglong() && isMatchModule;
    }

    private void showErrorDialogAboutSpVersion(List<String> invalidDeviceIps) {
        StringBuilder sb = new StringBuilder();
        sb.append(RES.getString("bundle.upgrade.param.strategy.spversion"));
        sb.append("\n");
        for (String ip : invalidDeviceIps) {
            sb.append(ip);
            sb.append("; ");
        }
        DialogUtils.showErrorDialog((Window)((Object)BundleUpgradeContext.getInstance().getMainDialog()), (String)sb.toString());
    }
}

