/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.bundleupgrade.ui.card;

import com.huawei.bundleupgrade.entity.BaselineFirmwareBundle;
import com.huawei.bundleupgrade.entity.FirmwarePackageEntity;
import com.huawei.bundleupgrade.service.UpgradeTypeSelectionService;
import com.huawei.bundleupgrade.ui.BundleUpgradeMainDialog;
import com.huawei.bundleupgrade.ui.card.SmartProvisioningParamsSettingCard;
import com.huawei.bundleupgrade.ui.card.UpgradeParamsSettingCard;
import com.huawei.bundleupgrade.ui.layout.type.SelectLocalUpgradeLayout;
import com.huawei.bundleupgrade.ui.layout.type.SelectOnlineUpgradeLayout;
import com.huawei.bundleupgrade.ui.layout.type.UpgradeTypeSelectMainLayout;
import com.huawei.bundleupgrade.utils.BundleUpgradeContext;
import com.huawei.bundleupgrade.utils.ServiceUtil;
import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.tool.base.ui.component.wizard.ToolWizardDialog;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.obase.filechooser.HibernateContainer;
import com.huawei.ism.tool.obase.filechooser.ToolFileChooser;
import com.huawei.ism.ui.swing.dialog.CustMsgProgressDialog;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.dialog.ProgressDialog;
import com.huawei.ism.ui.swing.dialog.WarningDialog;
import com.huawei.ism.ui.swing.table.DefaultTableRow;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.ism.ui.swing.text.IsmPasswordField;
import com.huawei.uMate.common.rest.https.HttpsCertManager;
import com.huawei.uMate.common.utils.ResUtil;
import com.huawei.uMate.common.utils.SecurityUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeTypeSelectionCard
extends ToolWizardDialog.Card {
    private static final Logger log = LoggerFactory.getLogger(UpgradeTypeSelectionCard.class);
    private static final ResUtil RES = ResUtil.getInstance((String)"BundleUpgrade");
    private ToolWizardDialog toolWizardDialog;
    private UpgradeTypeSelectMainLayout layout = new UpgradeTypeSelectMainLayout();
    private SelectLocalUpgradeLayout localLayout = new SelectLocalUpgradeLayout();
    private SelectOnlineUpgradeLayout onlineLayout;
    private UpgradeTypeSelectionService selectionService = new UpgradeTypeSelectionService(this);

    public UpgradeTypeSelectionCard(ToolWizardDialog toolWizardDialog, ToolWizardDialog.Card previousCard, ToolWizardDialog.Navigation ... supportedNavigation) {
        super(previousCard, supportedNavigation);
        this.toolWizardDialog = toolWizardDialog;
        this.onlineLayout = new SelectOnlineUpgradeLayout((JDialog)toolWizardDialog);
        this.layout.add(this.localLayout);
        BundleUpgradeContext.setIsOnlineFirmware(false);
        this.addLayout(this.layout);
        this.initListener();
        if (BundleUpgradeContext.getInstance().getSelectedDeviceEntities().get(0).getDeviceEntity().isTwoOceans()) {
            this.layout.getOnlineBtn().setVisible(false);
        }
    }

    protected void addLayout(JComponent layout) {
        this.setLayout(new BorderLayout());
        this.add(layout, "Center");
    }

    private void initListener() {
        this.layout.getSpBtn().addActionListener(event -> {
            this.layout.getButtonBox().setVisible(false);
            this.localLayout.setVisible(false);
            this.onlineLayout.setVisible(false);
        });
        this.layout.getFirmwareBtn().addActionListener(event -> {
            this.layout.getButtonBox().setVisible(true);
            if (this.layout.getOnlineBtn().isSelected()) {
                this.showOnlineLayout();
            } else if (this.layout.getLocalBtn().isSelected()) {
                this.showLocalLayout();
            } else {
                log.error("none of obtaining firmware way is selected");
            }
        });
        this.layout.getLocalBtn().addActionListener(event -> {
            log.info("click local button.");
            this.showLocalLayout();
        });
        this.layout.getOnlineBtn().addActionListener(event -> {
            log.info("click onlin button.");
            this.showOnlineLayout();
        });
        this.localLayout.getPackagePathSelectButton().addActionListener(this::jButtonPackagePathSelectActionEvent);
        this.onlineLayout.getLoginButton().addActionListener(this::loginButtonAction);
        this.onlineLayout.getSelectDownloadToLocalPathBtn().addActionListener(this::jButtonDownloadToLocalPathSelectActionEvent);
    }

    private void showLocalLayout() {
        BundleUpgradeContext.setIsOnlineFirmware(false);
        this.layout.add(this.localLayout);
        this.localLayout.setVisible(true);
        this.onlineLayout.setVisible(false);
    }

    private void showOnlineLayout() {
        BundleUpgradeContext.setIsOnlineFirmware(true);
        this.layout.add((Component)((Object)this.onlineLayout));
        this.onlineLayout.setVisible(true);
        this.localLayout.setVisible(false);
        if (!this.onlineLayout.checkAkSk() || this.onlineLayout.getBaseLineCombo() != null) {
            return;
        }
        CompletableFuture.runAsync(() -> this.loginButtonAction(null));
    }

    private void showBaselineInfo(BaselineFirmwareBundle firmwareBundle) {
        this.onlineLayout.getDefaultTableModel().removeAll();
        for (int i = 0; i < firmwareBundle.getPackageList().size(); ++i) {
            TableRow<FirmwarePackageEntity, String> row = this.createBaselineTableRow(firmwareBundle.getPackageList().get(i));
            this.onlineLayout.getDefaultTableModel().addRow(new TableRow[]{row});
        }
        this.onlineLayout.getScrollPane().repaint();
    }

    private void showLocalTableInfo(BaselineFirmwareBundle firmwareBundle) {
        this.localLayout.getDefaultTableModel().removeAll();
        for (int i = 0; i < firmwareBundle.getPackageList().size(); ++i) {
            TableRow<FirmwarePackageEntity, String> row = this.createLocalPackageTableRow(firmwareBundle.getPackageList().get(i));
            this.localLayout.getDefaultTableModel().addRow(new TableRow[]{row});
        }
        this.localLayout.getScrollPane().repaint();
    }

    private TableRow<FirmwarePackageEntity, String> createBaselineTableRow(FirmwarePackageEntity firmwarePackage) {
        String key = UUID.randomUUID().toString();
        int columnCount = this.onlineLayout.getBaseTable().getColumnCount();
        DefaultTableRow row = new DefaultTableRow(columnCount, (Object)firmwarePackage, (Object)key);
        int col = 0;
        row.setValueAt(col++, (Object)String.join((CharSequence)";", (CharSequence[])firmwarePackage.getProducts().stream().map(FirmwarePackageEntity.Product::getName).toArray(String[]::new)));
        row.setValueAt(col++, (Object)firmwarePackage.getPackageInfo().getModule());
        row.setValueAt(col++, (Object)firmwarePackage.getPackageInfo().getSupportModel());
        row.setValueAt(col++, (Object)firmwarePackage.getPackageInfo().getVersion());
        row.setValueAt(col, (Object)ServiceUtil.formatFwPackageSize(firmwarePackage.getSize()));
        return row;
    }

    private TableRow<FirmwarePackageEntity, String> createLocalPackageTableRow(FirmwarePackageEntity firmwarePackage) {
        String key = UUID.randomUUID().toString();
        int columnCount = this.localLayout.getLocalPackageTable().getColumnCount();
        DefaultTableRow row = new DefaultTableRow(columnCount, (Object)firmwarePackage, (Object)key);
        int col = 0;
        row.setValueAt(col++, (Object)firmwarePackage.getPackageInfo().getModule());
        row.setValueAt(col++, (Object)firmwarePackage.getSupportModels());
        row.setValueAt(col++, (Object)firmwarePackage.getPackageInfo().getVersion());
        String path = firmwarePackage.getLocalPathAbs();
        String fileName = path.substring(path.lastIndexOf(File.separator) + 1);
        row.setValueAt(col, (Object)fileName);
        return row;
    }

    private void loginButtonAction(ActionEvent evt) {
        WarningDialog dialog;
        log.info("loginTask loginTask button.");
        if (!this.onlineLayout.checkAkSk()) {
            this.onlineLayout.setAkskParamError();
            return;
        }
        if (this.onlineLayout.getHoupCertNoCheckBtn().isSelected() && (dialog = DialogUtils.showWarnConfirmDialog((Window)((Object)BundleUpgradeContext.getInstance().getMainDialog()), (String)RES.getString("bundle.upgrade.type.panel.online.cert.warn"), (String)RES.getString("bundle.upgrade.type.panel.online.cert.sure"))).getValue() != 0) {
            return;
        }
        this.onlineLayout.clearDetailArea();
        BundleUpgradeContext.getInstance().setVerifyCert(this.onlineLayout.isVerifyCert());
        CustMsgProgressDialog progressDialog = new CustMsgProgressDialog((Window)((Object)BundleUpgradeContext.getInstance().getMainDialog()), RES.getString("bundle.upgrade.waite.tip"));
        AsyncExcutor.execute((ProgressDialog)progressDialog, (boolean)true, (long)0L, (Callable[])new Callable[]{this::loginTask});
    }

    private boolean loginTask() {
        JTextField houpAddressField = this.onlineLayout.getHoupAddrField();
        String houpAddr = houpAddressField.getText().trim();
        if (!SecurityUtils.isValidURL((String)houpAddr)) {
            log.error(String.format(Locale.ROOT, "%s is Invalid.", houpAddr));
            return false;
        }
        if (!this.isSuccessDownload(houpAddr)) {
            return false;
        }
        JPanel baselineComboPanel = this.onlineLayout.loadBaselineTable();
        if (this.onlineLayout.getComponents().length > 1) {
            this.onlineLayout.remove(1);
        }
        this.onlineLayout.add(baselineComboPanel);
        Map<String, BaselineFirmwareBundle> baselineMap = BundleUpgradeContext.getInstance().getBaselineFirmwareBundleMap();
        Iterator<String> iterator = baselineMap.keySet().iterator();
        JComboBox<String> baselineCombo = this.onlineLayout.getBaseLineCombo();
        String tempRecommend = this.getTempRecommend(iterator, baselineCombo);
        baselineCombo.addActionListener(this::baseLineComboBoxAction);
        if (!StringUtils.isNULLStr((String)tempRecommend)) {
            baselineCombo.setSelectedItem(tempRecommend);
        } else {
            baselineCombo.setSelectedIndex(0);
        }
        this.onlineLayout.revalidate();
        return true;
    }

    private boolean isSuccessDownload(String houpAddr) {
        BundleUpgradeContext.getInstance().setHoupUrl(this.urlSplitGetHoupURL(houpAddr));
        JTextField houpAccountFieldField = this.onlineLayout.getHoupAccountField();
        IsmPasswordField houpPwdField = this.onlineLayout.getHoupPwdField();
        String userName = houpAccountFieldField.getText();
        char[] password = houpPwdField.getPassword();
        return this.selectionService.testAndDownload(houpAddr, userName, password);
    }

    private String urlSplitGetHoupURL(String testURL) {
        if (testURL.toLowerCase(Locale.ENGLISH).contains(".com")) {
            String[] urlArray = testURL.split("\\.com");
            log.info(urlArray[0].concat(".com"));
            return urlArray[0].concat(".com");
        }
        return testURL;
    }

    private String getTempRecommend(Iterator<String> iterator, JComboBox<String> baselineCombo) {
        String recommend = BundleUpgradeContext.getInstance().getRecommendBase();
        String tempRecommend = "";
        while (iterator.hasNext()) {
            String key = iterator.next();
            if (!key.equals("localUpgradePackage")) {
                baselineCombo.addItem(key);
            }
            if (StringUtils.isNULLStr((String)recommend) || !key.contains(recommend)) continue;
            baselineCombo.removeItem(key);
            tempRecommend = String.format(Locale.ENGLISH, "%s%s", key, RES.getString("bundle.upgrade.recommend"));
            baselineCombo.addItem(tempRecommend);
        }
        return tempRecommend;
    }

    private void jButtonPackagePathSelectActionEvent(ActionEvent evt) {
        log.info("click selsect package path button");
        File file = new File(".");
        BundleUpgradeMainDialog dialog = BundleUpgradeContext.getInstance().getMainDialog();
        File selectedFile = com.huawei.ism.tool.base.ui.filechooser.ToolFileChooser.selectFile((Window)((Object)dialog), (String)RES.getString("bundle.upgrade.type.panel.local.btn.select"), (String[])new String[0], (String)file.getPath(), (String)"Directory", (int)1, (boolean)true, (boolean)true, (Locale)Locale.getDefault());
        if (selectedFile == null || !selectedFile.exists()) {
            return;
        }
        String packagePath = selectedFile.getPath();
        if (!SecurityUtils.isValidAndSafePath((String)packagePath)) {
            log.error(String.format(Locale.ROOT, "%s is not valid and safe path.", packagePath));
            return;
        }
        if (!this.loadFwPackageInfoFromSelectedPath(packagePath)) {
            log.error(RES.getString("bundle.upgrade.select.local.error1", Locale.ENGLISH));
            DialogUtils.showInfoDialog((Frame)((Object)dialog), (String)RES.getString("bundle.upgrade.select.local.error1"));
            return;
        }
        this.selectionService.showFailedPkgInfo();
        this.localLayout.getPackagePathField().setText(packagePath);
        JPanel bottomPanel = this.localLayout.initLocalTable();
        this.localLayout.getRefreshBtn().addActionListener(event -> this.refreshBtnAction());
        Map<String, BaselineFirmwareBundle> baselineMap = BundleUpgradeContext.getInstance().getBaselineFirmwareBundleMap();
        BaselineFirmwareBundle localPackage = baselineMap.get("localUpgradePackage");
        this.showLocalTableInfo(localPackage);
        if (this.localLayout.getComponents().length > 1) {
            this.localLayout.remove(1);
        }
        this.localLayout.add((Component)bottomPanel, "Center");
        this.localLayout.revalidate();
        this.selectionService.fwPackageListIsRepeated();
    }

    private boolean updateCert(String path) {
        CustMsgProgressDialog progressDialog = new CustMsgProgressDialog((Window)((Object)BundleUpgradeContext.getInstance().getMainDialog()), RES.getString("bundle.upgrade.type.panel.online.cert.import"), 300);
        List result = AsyncExcutor.execute((ProgressDialog)progressDialog, (boolean)true, (long)0L, (Callable[])new Callable[]{() -> HttpsCertManager.getInstance().updateCert(path)});
        return Boolean.TRUE.equals(result.get(0));
    }

    private boolean loadFwPackageInfoFromSelectedPath(String path) {
        CustMsgProgressDialog progressDialog = new CustMsgProgressDialog((Window)((Object)BundleUpgradeContext.getInstance().getMainDialog()), RES.getString("bundle.upgrade.type.panel.local.packagePath.tip"), 400);
        List result = AsyncExcutor.execute((ProgressDialog)progressDialog, (boolean)true, (long)0L, (Callable[])new Callable[]{() -> this.selectionService.getLocalUpgradePackageInfo(path)});
        return Boolean.TRUE.equals(result.get(0));
    }

    private void jButtonDownloadToLocalPathSelectActionEvent(ActionEvent event) {
        log.info("click download toLocal path button.");
        HashMap<String, String> expMap = new HashMap<String, String>();
        expMap.put("PathId", "bundle_upgrade_online_local_save_dir_id");
        expMap.put("title", RES.getString("bundle.upgrade.type.panel.local.btn.select"));
        expMap.put("description", RES.getString("system.local.dir"));
        File selectedFile = ToolFileChooser.selectFile((Window)((Object)BundleUpgradeContext.getInstance().getMainDialog()), (String[])new String[0], (int)1, (boolean)true, expMap);
        if (null != selectedFile && selectedFile.exists()) {
            try {
                HibernateContainer.getInstance().put("bundle_upgrade_online_local_save_dir_id", (Object)selectedFile.getCanonicalPath());
            }
            catch (IOException e) {
                log.error("get save dir error.");
            }
            Object baseLineSelected = this.onlineLayout.getBaseLineCombo().getSelectedItem();
            if (baseLineSelected instanceof String) {
                String baseLine = (String)baseLineSelected;
                baseLine = baseLine.contains(RES.getString("bundle.upgrade.recommend")) ? baseLine.replace(RES.getString("bundle.upgrade.recommend"), "") : baseLine;
                this.selectionService.checkAndSetPkgLocalPath(selectedFile, baseLine, this.onlineLayout);
            }
        }
    }

    public void refreshBtnAction() {
        log.info("click refresh button.");
        String packagePath = this.localLayout.getPackagePathField().getText().trim();
        if (!SecurityUtils.isValidAndSafePath((String)packagePath)) {
            log.error(String.format(Locale.ROOT, "%s is not valid and safe.", packagePath));
            return;
        }
        if (this.loadFwPackageInfoFromSelectedPath(packagePath)) {
            Map<String, BaselineFirmwareBundle> baselineMap = BundleUpgradeContext.getInstance().getBaselineFirmwareBundleMap();
            BaselineFirmwareBundle localPackage = baselineMap.get("localUpgradePackage");
            this.showLocalTableInfo(localPackage);
        }
        this.selectionService.showFailedPkgInfo();
        this.selectionService.fwPackageListIsRepeated();
    }

    private void baseLineComboBoxAction(ActionEvent event) {
        Object selectedItem = this.onlineLayout.getBaseLineCombo().getSelectedItem();
        if (selectedItem != null) {
            String select = selectedItem.toString();
            select = select.contains(RES.getString("bundle.upgrade.recommend")) ? select.replace(RES.getString("bundle.upgrade.recommend"), "") : select;
            Map<String, BaselineFirmwareBundle> baselineMap = BundleUpgradeContext.getInstance().getBaselineFirmwareBundleMap();
            this.showBaselineInfo(baselineMap.get(select));
            this.onlineLayout.revalidate();
        }
    }

    public String getTitle() {
        return RES.getString("bundle.upgrade.param.setting.step1.title");
    }

    public int getStep() {
        return 0;
    }

    protected ToolWizardDialog.Card getNextCard() {
        if (this.layout.getFirmwareBtn().isSelected()) {
            UpgradeParamsSettingCard nextCard = new UpgradeParamsSettingCard(this, ToolWizardDialog.Navigation.PREVIOUS, ToolWizardDialog.Navigation.NEXT);
            return this.selectionService.saveSelection(this.layout, this.localLayout, this.onlineLayout) ? nextCard : null;
        }
        if (this.layout.getSpBtn().isSelected()) {
            return new SmartProvisioningParamsSettingCard(this, ToolWizardDialog.Navigation.PREVIOUS, ToolWizardDialog.Navigation.NEXT);
        }
        log.error("neither firmware upgrade nor sp upgrade is selected!");
        return null;
    }

    protected boolean isValid(ToolWizardDialog.Navigation navigation) {
        return true;
    }

    protected boolean process(ToolWizardDialog.Navigation navigation) {
        if (ToolWizardDialog.Navigation.PREVIOUS.equals((Object)navigation)) {
            log.info("click previous card.");
        }
        if (ToolWizardDialog.Navigation.NEXT.equals((Object)navigation)) {
            log.info("click next card.");
        }
        return true;
    }
}

