/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.bundleupgrade.ui.component;

import com.huawei.bundleupgrade.constants.UpgradeParamConstants;
import com.huawei.bundleupgrade.model.ExecuteResult;
import com.huawei.bundleupgrade.ui.component.ProgressPanel;
import com.huawei.bundleupgrade.utils.ItemProgressUpdateUtil;
import com.huawei.bundleupgrade.utils.UpgradeConstants;
import com.huawei.ism.tool.framework.platform.util.LanguageManager;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.obase.utils.UiMethod;
import com.huawei.ism.util.UCD;
import com.huawei.uMate.common.utils.ResUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Locale;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.UIManager;

public class DetailListCellRender
extends DefaultListCellRenderer {
    private static final ResUtil RES = ResUtil.getInstance((String)"BundleUpgrade");
    private static final long serialVersionUID = 100000010L;
    private static final int NUM_8 = 8;
    private static final int NUM_18 = 18;
    private static final int NUM_39 = 39;
    private static final int NUM_100 = 100;
    private static final int NUM_180 = 180;
    private static final int NUM_280 = 280;
    private static final int NUM_155 = 155;
    private static final Color COLOR_BEFORE_CLICK = new Color(4359891);

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        Color bg = null;
        Object statusLabel = null;
        JList.DropLocation dropLocation = list.getDropLocation();
        boolean isComponentSelected = isSelected;
        if (dropLocation != null && !dropLocation.isInsert() && dropLocation.getIndex() == index) {
            bg = UIManager.getColor("List.dropCellBackground");
            isComponentSelected = true;
        }
        ProgressPanel viewPan = new ProgressPanel();
        if (value instanceof ExecuteResult) {
            ExecuteResult result = (ExecuteResult)value;
            JLabel devNodeLabel = new JLabel();
            devNodeLabel.setPreferredSize(new Dimension(100, devNodeLabel.getPreferredSize().height));
            String ip = "";
            int dLength = 0;
            if (result.getUpgradeDeviceEntity() != null) {
                ip = result.getUpgradeDeviceEntity().getDeviceEntity().getIp();
                int len = ip.length();
                int n = dLength = 280 * len / 39 - 100 > 180 ? 180 : 280 * len / 39 - 100;
                if (StringUtils.isIpv6Address((String)ip) && dLength > 0) {
                    devNodeLabel.setPreferredSize(new Dimension(dLength + 100, devNodeLabel.getPreferredSize().height));
                }
                devNodeLabel.setText(result.getUpgradeDeviceEntity().getDeviceEntity().getIp());
            }
            this.setStatusLabel(viewPan, result, devNodeLabel, dLength);
            String tips = "";
            String timeLeft = ItemProgressUpdateUtil.INS.getTimeLeft(ip);
            tips = this.getTopTips(result, timeLeft);
            tips = StringUtils.wrapParagraph((String)tips, (String)"<br>", (int)(ApplicationContext.getInstance().isEnglishEnv() ? 25 : 60));
            viewPan.setToolTipText(tips);
        }
        viewPan.setComponentOrientation(list.getComponentOrientation());
        viewPan.setEnabled(list.isEnabled());
        viewPan.setFont(list.getFont());
        if (isComponentSelected) {
            viewPan.setBackground(bg == null ? list.getSelectionBackground() : bg);
            UiMethod.setBatchComponentProperty((String)"setForeground", (Object[])new Object[]{Color.WHITE}, (JComponent[])new JComponent[]{viewPan});
        } else {
            viewPan.setBackground(list.getBackground());
            viewPan.setForeground(list.getForeground());
        }
        return viewPan;
    }

    private String getTopTips(ExecuteResult result, String timeLeft) {
        if (result.getExecuteResult() == UpgradeParamConstants.SubProcessExecutionResult.FAILED) {
            return result.getDescription() + RES.getString("os.checkitem.execute.fail");
        }
        if (!StringUtils.isNULLStr((String)timeLeft) && LanguageManager.getInstance().getCurrentLanguage().equals(Locale.ENGLISH) && result.isRunning()) {
            return timeLeft;
        }
        if (!StringUtils.isNULLStr((String)result.getHoverTips())) {
            return result.getHoverTips();
        }
        return result.getDescription();
    }

    private void setStatusLabel(ProgressPanel viewPan, ExecuteResult result, JLabel devNodeLabel, int dLength) {
        JComponent statusLabel;
        String date = result.getStartDateString();
        JLabel descLabel = new JLabel(result.getDescription());
        Dimension descLabelSize = new Dimension(280 - dLength, 18);
        UiMethod.setComponentSize((Dimension)descLabelSize, (Component[])new Component[]{descLabel});
        JComponent dateComp = UCD.buildHorizotalBox(null, (int)0, (Component[])new Component[]{Box.createHorizontalStrut(5), new JLabel(date)});
        JLabel resultLabel = new JLabel("");
        resultLabel.setForeground(COLOR_BEFORE_CLICK);
        if (!result.isRunning()) {
            if (result.isSuccess()) {
                resultLabel.setIcon(UpgradeConstants.SUCCESS_IMAGE);
                resultLabel.setText(UpgradeParamConstants.UpgradeStatus.COMPLETED.toString());
            } else if (result.getExecuteResult() == UpgradeParamConstants.SubProcessExecutionResult.NOT_INVOLVED) {
                resultLabel.setIcon(UpgradeConstants.NOTSUPPORT_IMAGE);
                resultLabel.setText(RES.getString("current.step.does.not.support"));
            } else if (UpgradeParamConstants.SubProcessExecutionResult.IGNORE.equals((Object)result.getExecuteResult())) {
                resultLabel.setIcon(UpgradeConstants.NOTSUPPORT_IMAGE);
                resultLabel.setText(RES.getString("current.step.does.ignore"));
            } else if (result.getExecuteResult() == UpgradeParamConstants.SubProcessExecutionResult.PARITIAL_SUCC) {
                resultLabel.setIcon(UpgradeConstants.WARNING_IMAGE);
                resultLabel.setText(UpgradeParamConstants.UpgradeStatus.UPGRADE_PARTIAL_SUCCESS.toString());
            } else {
                resultLabel.setIcon(UpgradeConstants.FAILED_IMAGE);
                resultLabel.setText(UpgradeParamConstants.UpgradeStatus.FAILED.toString());
            }
            statusLabel = new JLabel("");
        } else if (result.getDescription().equals(RES.getString("bundle.upgrade.main.detail.info.start"))) {
            resultLabel.setIcon(UpgradeConstants.WAIT_IMAGE);
            resultLabel.setText(UpgradeParamConstants.UpgradeStatus.WAITING.toString());
            statusLabel = this.createCheckingView(result, viewPan);
        } else {
            resultLabel.setIcon(UpgradeConstants.PROCESSING_IMAGE);
            resultLabel.setText(UpgradeParamConstants.UpgradeStatus.RUNNING.toString());
            statusLabel = this.createCheckingView(result, viewPan);
        }
        JComponent view = UCD.buildHorizotalBox(null, (Component[])new Component[]{dateComp, devNodeLabel, descLabel, Box.createGlue(), UCD.buildHBoxRight((Component[])new Component[]{statusLabel}), resultLabel, Box.createHorizontalStrut(8)});
        viewPan.setLayout(new BorderLayout());
        viewPan.add((Component)view, "North");
    }

    private JComponent createCheckingView(ExecuteResult evaluItem, ProgressPanel panel) {
        JComponent statusLabel = null;
        String devIp = evaluItem.getUpgradeDeviceEntity().getDeviceEntity().getIp();
        int progress = ItemProgressUpdateUtil.INS.getProgress(devIp);
        if (progress >= 0 && progress <= 100) {
            String timeLeft = ItemProgressUpdateUtil.INS.getTimeLeft(devIp);
            if (StringUtils.isNULLStr((String)timeLeft)) {
                statusLabel = UCD.buildHorizotalBox(null, (Component[])new Component[]{new JLabel(RES.getStringWithParams("evalu.device.item.wait.progress", new Object[]{progress})), Box.createHorizontalStrut(12)});
            } else {
                JLabel timeLabel = new JLabel(timeLeft);
                if (LanguageManager.getInstance().getCurrentLanguage().equals(Locale.ENGLISH)) {
                    timeLabel.setPreferredSize(new Dimension(155, timeLabel.getPreferredSize().height));
                }
                statusLabel = UCD.buildHorizotalBox(null, (Component[])new Component[]{new JLabel(RES.getStringWithParams("evalu.device.item.wait.progress", new Object[]{progress})), Box.createHorizontalStrut(12), timeLabel, Box.createHorizontalStrut(12)});
            }
            panel.setShow(true);
            panel.setProgress(progress);
        } else {
            statusLabel = new JLabel("");
        }
        return statusLabel;
    }
}

