/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.bundleupgrade.ui.component;

import com.huawei.bundleupgrade.ui.component.MultiPopup;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicArrowButton;

public class MultiComboBox
extends JComponent {
    private static final String DEFAULT_VALUE_SPERATOR = ",";
    private List<Object> values;
    private List<Object> defaultValues;
    private List<ActionListener> listeners = new ArrayList<ActionListener>();
    private MultiPopup popup;
    private JTextField editor;
    private JButton arrowButton;
    private String valueSperator;

    public MultiComboBox(List<Object> value, List<Object> defaultValue) {
        this(value, defaultValue, DEFAULT_VALUE_SPERATOR);
    }

    public MultiComboBox(List<Object> value, List<Object> defaultValue, String valueSperator) {
        this.values = value;
        this.defaultValues = defaultValue;
        this.valueSperator = valueSperator;
        this.initComponent();
    }

    private void initComponent() {
        this.setLayout(new BorderLayout());
        this.popup = new MultiPopup(this.values, this.defaultValues);
        this.popup.addActionListener(new PopupAction());
        this.editor = new JTextField();
        this.editor.setBackground(Color.WHITE);
        this.editor.setEditable(false);
        this.editor.addMouseListener(new EditorHandler());
        this.arrowButton = this.createArrowButton();
        this.arrowButton.addMouseListener(new EditorHandler());
        this.arrowButton.setPreferredSize(new Dimension(20, 22));
        this.add((Component)this.editor, "Center");
        this.add((Component)this.arrowButton, "East");
        this.setText();
    }

    public MultiPopup getMultiPopup() {
        return this.popup;
    }

    public List<Object> getSelectedValues() {
        return this.popup.getSelectedValues();
    }

    public void addActionListener(ActionListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    protected void fireActionPerformed(ActionEvent e) {
        for (ActionListener l : this.listeners) {
            l.actionPerformed(e);
        }
    }

    private void togglePopup() {
        if (this.popup.isVisible()) {
            this.popup.setVisible(false);
        } else {
            this.popup.setDefaultValue(this.defaultValues);
            this.popup.show(this, 0, this.getHeight());
        }
    }

    private void setText() {
        StringBuilder builder = new StringBuilder();
        for (Object dv : this.defaultValues) {
            builder.append(dv);
            builder.append(this.valueSperator);
        }
        this.editor.setText(builder.substring(0, builder.length() > 0 ? builder.length() - 1 : 0));
    }

    private JButton createArrowButton() {
        BasicArrowButton button = new BasicArrowButton(5, UIManager.getColor("ComboBox.buttonBackground"), UIManager.getColor("ComboBox.buttonShadow"), UIManager.getColor("ComboBox.buttonDarkShadow"), UIManager.getColor("ComboBox.buttonHighlight"));
        button.setName("ComboBox.arrowButton");
        return button;
    }

    private class EditorHandler
    implements MouseListener {
        private EditorHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            MultiComboBox.this.togglePopup();
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }
    }

    private class PopupAction
    implements ActionListener {
        private PopupAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getActionCommand().equals("commit")) {
                MultiComboBox.this.defaultValues = MultiComboBox.this.popup.getSelectedValues();
                MultiComboBox.this.setText();
                MultiComboBox.this.fireActionPerformed(e);
            }
            MultiComboBox.this.togglePopup();
        }
    }
}

