/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.bundleupgrade.ui.component;

import com.huawei.uMate.common.utils.ResUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

public class MultiPopup
extends JPopupMenu {
    public static final String COMMIT_EVENT = "commit";
    public static final String CANCEL_EVENT = "cancel";
    private static final ResUtil RES = ResUtil.getInstance((String)"BundleUpgrade");
    private List<Object> values;
    private List<Object> defaultValues;
    private Object selectAllValue;
    private List<ActionListener> listeners = new ArrayList<ActionListener>();
    private List<JCheckBox> checkBoxList = new ArrayList<JCheckBox>();
    private JButton commitButton;
    private JButton cancelButton;
    private JPanel checkboxPane = new JPanel();

    public MultiPopup(List<Object> value, List<Object> defaultValue) {
        this.values = value;
        this.defaultValues = defaultValue;
        this.selectAllValue = this.values.get(0);
        this.initComponent();
    }

    public <T> void addItem(T item) {
        JCheckBox temp = new JCheckBox(item.toString());
        this.values.add(item);
        this.checkBoxList.add(temp);
        this.checkboxPane.add(temp);
        this.checkboxPane.setLayout(new GridLayout(this.checkBoxList.size(), 1, 3, 3));
    }

    public List<Object> getValues() {
        return this.values;
    }

    public void addActionListener(ActionListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    protected void fireActionPerformed(ActionEvent e) {
        for (ActionListener l : this.listeners) {
            l.actionPerformed(e);
        }
    }

    private void initComponent() {
        this.setLayout(new BorderLayout());
        for (Object v : this.values) {
            JCheckBox temp = new JCheckBox(v.toString());
            this.checkBoxList.add(temp);
        }
        if (this.checkBoxList.get(0).getText().equals(this.selectAllValue.toString())) {
            this.checkBoxList.get(0).addItemListener(listener -> this.setItemsStatus());
        }
        this.checkboxPane.setLayout(new GridLayout(this.checkBoxList.size(), 1, 3, 3));
        for (JCheckBox box : this.checkBoxList) {
            this.checkboxPane.add(box);
        }
        this.commitButton = new JButton(RES.getString("text.ok"));
        this.commitButton.addActionListener(actionEvent -> this.commit());
        this.cancelButton = new JButton(RES.getString("text.cancel"));
        this.cancelButton.addActionListener(actionEvent -> this.cancel());
        JPanel buttonPane = new JPanel();
        buttonPane.add(this.commitButton);
        buttonPane.add(this.cancelButton);
        this.add((Component)this.checkboxPane, "Center");
        this.add((Component)buttonPane, "South");
    }

    private void setItemsStatus() {
        if (this.checkBoxList.get(0).isSelected()) {
            for (int i = 1; i < this.checkBoxList.size(); ++i) {
                if (this.checkBoxList.get(i).isSelected()) continue;
                this.checkBoxList.get(i).setSelected(true);
            }
        } else {
            for (int i = 1; i < this.checkBoxList.size(); ++i) {
                if (!this.checkBoxList.get(i).isSelected()) continue;
                this.checkBoxList.get(i).setSelected(false);
            }
        }
    }

    public List<Object> getSelectedValues() {
        int i;
        ArrayList<Object> selectedValues = new ArrayList<Object>();
        boolean selectedAll = true;
        for (i = 0; i < this.checkBoxList.size(); ++i) {
            if (this.checkBoxList.get(i).isSelected()) continue;
            selectedAll = false;
        }
        if (this.checkBoxList.get(0).getText().equals(this.selectAllValue.toString()) && selectedAll) {
            selectedValues.add(this.values.get(0));
            return selectedValues;
        }
        for (i = 1; i < this.checkBoxList.size(); ++i) {
            if (!this.checkBoxList.get(i).isSelected()) continue;
            selectedValues.add(this.values.get(i));
        }
        return selectedValues;
    }

    public void setDefaultValue(List<Object> defaultValue) {
        this.defaultValues = defaultValue;
    }

    public void commit() {
        this.fireActionPerformed(new ActionEvent(this, 0, COMMIT_EVENT));
    }

    public void cancel() {
        this.fireActionPerformed(new ActionEvent(this, 0, CANCEL_EVENT));
    }
}

