/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.bundleupgrade.ui.component;

import com.huawei.bundleupgrade.ui.component.MultiComboBox;
import com.huawei.ism.tool.base.ui.UiMethod;
import com.huawei.ism.ui.swing.table.IsmTable;
import com.huawei.ism.ui.swing.table.IsmTableScrollPane;
import com.huawei.ism.ui.swing.table.KeywordFilterField;
import com.huawei.ism.ui.swing.table.TableCountPane;
import com.huawei.ism.util.UCD;
import com.huawei.uMate.common.utils.ResUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class TableWithFilterPanel
extends JPanel {
    private static final ResUtil RES = ResUtil.getInstance((String)"BundleUpgrade");
    private JComboBox<String> productTypeComboBox;
    private MultiComboBox pmMultiCombox;
    private MultiComboBox statusMultiCombox;
    private KeywordFilterField filterFiled;
    private IsmTableScrollPane tablePane;
    private IsmTable table;
    private AtomicInteger finishDevsNum = new AtomicInteger(0);
    private volatile int devsNum = 0;
    private JLabel devNumsProgressLabel = new JLabel();
    private JLabel remainTimeDescLabel = new JLabel();
    private JLabel remainTimeValueLabel = new JLabel();

    public TableWithFilterPanel(IsmTable table, boolean multiSelection) {
        this.table = table;
        this.filterFiled = null;
        this.tablePane = null;
        this.tablePane = new IsmTableScrollPane(table, multiSelection);
        this.remainTimeValueLabel.setForeground(Color.RED);
        this.remainTimeDescLabel.setText(RES.getString("bundle.upgrade.main.table.status.number.times.desc"));
        JPanel southPane = new JPanel();
        southPane.setLayout(new BoxLayout(southPane, 0));
        JPanel northPane = this.paintNorthPanel(table);
        JPanel tableAndCountPane = UCD.createTransparentPane((LayoutManager)new BorderLayout());
        tableAndCountPane.add((Component)this.tablePane, "Center");
        tableAndCountPane.add((Component)southPane, "South");
        this.setLayout(new BorderLayout());
        this.add((Component)northPane, "North");
        this.add((Component)tableAndCountPane, "Center");
        this.setOpaque(false);
        this.setCompName();
    }

    private JPanel paintNorthPanel(IsmTable table) {
        JPanel northPane = UCD.createBoxLayoutPane((int)0);
        TableCountPane countPane = new TableCountPane(table);
        northPane.add((Component)countPane);
        northPane.add(Box.createRigidArea(new Dimension(0, 25)));
        this.initComboBoxValue();
        JPanel filterAreaPane = UCD.createBoxLayoutPane((int)0);
        this.filterFiled = new KeywordFilterField(table);
        JLabel globalFilter = UiMethod.createLabel((String)RES.getString("bundle.upgrade.main.label.global.filter"));
        JLabel fastFilter = UiMethod.createLabel((String)RES.getString("bundle.upgrade.main.label.device.filter"));
        filterAreaPane.add(UCD.buildHBoxRight((Component[])new Component[]{this.remainTimeDescLabel, this.remainTimeValueLabel, this.devNumsProgressLabel, fastFilter, this.pmMultiCombox, this.statusMultiCombox, globalFilter, this.filterFiled}));
        northPane.add(Box.createRigidArea(new Dimension(0, 33)));
        northPane.add(Box.createHorizontalGlue());
        northPane.add(filterAreaPane);
        return northPane;
    }

    private void setCompName() {
        if (this.filterFiled != null) {
            this.filterFiled.setName("_KeywordFilterField_filterFiled");
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.tablePane.setEnabled(enabled);
        if (null != this.filterFiled) {
            this.filterFiled.setEnabled(enabled);
        }
    }

    public void setKeyword(String keyword) {
        if (null != this.filterFiled) {
            this.filterFiled.setKeyword(keyword);
        }
    }

    private void initComboBoxValue() {
        String defaultAllDevices = RES.getString("filter.comboBox.default.all.device.type");
        ArrayList<Object> productModelValue = new ArrayList<Object>();
        productModelValue.add(defaultAllDevices);
        ArrayList<Object> productModelDefaultValue = new ArrayList<Object>();
        productModelDefaultValue.add(defaultAllDevices);
        this.pmMultiCombox = new MultiComboBox(productModelValue, productModelDefaultValue);
        UCD.setJComponentSize((JComponent)this.pmMultiCombox, (Dimension)new Dimension(155, 22));
        ArrayList<Object> statusValue = new ArrayList<Object>();
        statusValue.add(RES.getString("filter.comboBox.default.all.upgrade.status"));
        statusValue.add(RES.getString("bundle.upgrade.main.table.status.ASSOCIATED"));
        statusValue.add(RES.getString("bundle.upgrade.main.table.status.WAITING"));
        statusValue.add(RES.getString("bundle.upgrade.main.table.status.RUNNING"));
        statusValue.add(RES.getString("bundle.upgrade.main.table.status.COMPLETED"));
        statusValue.add(RES.getString("bundle.upgrade.main.table.status.FAILED"));
        statusValue.add(RES.getString("bundle.upgrade.main.table.status.NOTASSOCIATED"));
        statusValue.add(RES.getString("bundle.upgrade.main.table.status.NOSUPPORTED"));
        statusValue.add(RES.getString("bundle.upgrade.main.table.status.UNKNOWN"));
        statusValue.add(RES.getString("bundle.upgrade.main.table.status.QUERYDEVINFO"));
        statusValue.add(RES.getString("bundle.upgrade.main.table.status.UPGRADE_PARTIAL_SUCCESS"));
        statusValue.add(RES.getString("bundle.upgrade.main.table.status.REBOOT"));
        statusValue.add(RES.getString("bundle.upgrade.main.table.status.WAIT_REBOOT"));
        statusValue.add(RES.getString("bundle.upgrade.main.table.status.ABORT_REBOOT"));
        ArrayList<Object> statusDefaultValue = new ArrayList<Object>();
        statusDefaultValue.add(RES.getString("filter.comboBox.default.all.upgrade.status"));
        this.statusMultiCombox = new MultiComboBox(statusValue, statusDefaultValue);
        UCD.setJComponentSize((JComponent)this.statusMultiCombox, (Dimension)new Dimension(155, 22));
    }

    public JComboBox<String> getProductTypeComboBox() {
        return this.productTypeComboBox;
    }

    public MultiComboBox getPmMultiCombox() {
        return this.pmMultiCombox;
    }

    public MultiComboBox getStatusMultiCombox() {
        return this.statusMultiCombox;
    }

    public IsmTable getTable() {
        return this.table;
    }

    public void initDevsNum(int devsNum) {
        this.devsNum = devsNum;
        this.finishDevsNum = new AtomicInteger(0);
        this.refreshedDevsfinishNum();
        this.refreshRemainTime(0, 0);
    }

    public void finishOneDev() {
        this.finishDevsNum.getAndIncrement();
        this.refreshedDevsfinishNum();
    }

    public void refreshRemainTime(int hour, int min) {
        this.remainTimeValueLabel.setText(RES.getStringWithParams("bundle.upgrade.main.table.status.number.times.value", new Object[]{hour, min}));
    }

    private void refreshedDevsfinishNum() {
        this.devNumsProgressLabel.setText(RES.getStringWithParams("bundle.upgrade.main.table.status.number.devices", new Object[]{this.finishDevsNum.get(), this.devsNum}));
    }
}

