/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.bundleupgrade.ui.component;

import com.huawei.bundleupgrade.constants.UpgradeParamConstants;
import com.huawei.bundleupgrade.utils.UpgradeConstants;
import com.huawei.ism.ui.swing.table.IsmTableCell;
import com.huawei.ism.ui.swing.table.IsmTableCellRenderer;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public final class UpgradeStatusCell
extends IsmTableCell {
    private static final long serialVersionUID = 1L;
    private static final int NUM_17 = 17;
    private UpgradeParamConstants.UpgradeStatus status;
    private IsmTableCellRenderer render = new PatchStatusRender();

    public UpgradeStatusCell(UpgradeParamConstants.UpgradeStatus status) {
        this.status = status;
    }

    public UpgradeParamConstants.UpgradeStatus getStatus() {
        return this.status;
    }

    public TableCellRenderer getRender() {
        return this.render;
    }

    public String toString() {
        return this.status.toString();
    }

    public int compareTo(IsmTableCell obj) {
        if (!(obj instanceof UpgradeStatusCell)) {
            return -1;
        }
        UpgradeParamConstants.UpgradeStatus value = ((UpgradeStatusCell)obj).getStatus();
        if (this.status.ordinal() > value.ordinal()) {
            return 1;
        }
        if (this.status.ordinal() < value.ordinal()) {
            return -1;
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpgradeStatusCell)) {
            return false;
        }
        UpgradeParamConstants.UpgradeStatus thatVal = ((UpgradeStatusCell)((Object)obj)).getStatus();
        return thatVal.equals((Object)this.getStatus());
    }

    public int hashCode() {
        return 17 + this.status.hashCode();
    }

    private static class PatchStatusRender
    extends IsmTableCellRenderer {
        private static final long serialVersionUID = 1L;

        private PatchStatusRender() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            JLabel label = (JLabel)comp;
            UpgradeStatusCell cell = (UpgradeStatusCell)((Object)value);
            UpgradeParamConstants.UpgradeStatus status = cell.getStatus();
            if (status.equals((Object)UpgradeParamConstants.UpgradeStatus.COMPLETED)) {
                label.setIcon(UpgradeConstants.SUCCESS_IMAGE);
            } else if (status.equals((Object)UpgradeParamConstants.UpgradeStatus.RUNNING) || status.equals((Object)UpgradeParamConstants.UpgradeStatus.QUERYDEVINFO) || status.equals((Object)UpgradeParamConstants.UpgradeStatus.REBOOT) || status.equals((Object)UpgradeParamConstants.UpgradeStatus.WAIT_REBOOT)) {
                label.setIcon(UpgradeConstants.PROCESSING_IMAGE);
            } else if (status.equals((Object)UpgradeParamConstants.UpgradeStatus.ABORT_REBOOT)) {
                label.setIcon(UpgradeConstants.FAILED_IMAGE);
            } else if (status.equals((Object)UpgradeParamConstants.UpgradeStatus.WAITING)) {
                label.setIcon(UpgradeConstants.WAIT_IMAGE);
            } else if (status.equals((Object)UpgradeParamConstants.UpgradeStatus.FAILED)) {
                label.setIcon(UpgradeConstants.FAILED_IMAGE);
            } else if (status.equals((Object)UpgradeParamConstants.UpgradeStatus.NOTASSOCIATED)) {
                label.setIcon(UpgradeConstants.NOTASSOCIATED_IMAGE);
            } else if (status.equals((Object)UpgradeParamConstants.UpgradeStatus.NOSUPPORTED)) {
                label.setIcon(UpgradeConstants.NOTSUPPORT_IMAGE);
            } else if (UpgradeParamConstants.UpgradeStatus.NOT_INVOLVED.equals((Object)status)) {
                label.setIcon(UpgradeConstants.NOTSUPPORT_IMAGE);
            } else if (status.equals((Object)UpgradeParamConstants.UpgradeStatus.UNKNOWN)) {
                label.setIcon(UpgradeConstants.UNKNOWN_IMAGE);
            } else if (status.equals((Object)UpgradeParamConstants.UpgradeStatus.ASSOCIATED)) {
                label.setIcon(UpgradeConstants.ASSOCIATED_IMAGE);
            } else if (status.equals((Object)UpgradeParamConstants.UpgradeStatus.UPGRADE_PARTIAL_SUCCESS)) {
                label.setIcon(UpgradeConstants.WARNING_IMAGE);
            } else if (status.equals((Object)UpgradeParamConstants.UpgradeStatus.NOT_EXECUTED)) {
                label.setIcon(UpgradeConstants.SUCCESS_IMAGE);
            } else {
                label.setIcon(UpgradeConstants.FAILED_IMAGE);
            }
            label.setText(status.toString());
            label.setToolTipText(status.toString());
            return label;
        }
    }
}

