/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.bundleupgrade.ui.dialog;

import com.huawei.bundleupgrade.constants.UpgradeParamConstants;
import com.huawei.bundleupgrade.entity.DeviceEntity;
import com.huawei.bundleupgrade.entity.UpgradeDeviceEntity;
import com.huawei.bundleupgrade.entity.UpgradeStrategyEntity;
import com.huawei.bundleupgrade.ui.dialog.SftpPortSetDialog;
import com.huawei.bundleupgrade.utils.BundleUpgradeContext;
import com.huawei.bundleupgrade.utils.UpgradeScenarioUtil;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.obase.utils.FileUtils;
import com.huawei.ism.tool.obase.utils.NetUtil;
import com.huawei.ism.tool.obase.utils.UiMethod;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.dialog.WarningDialog;
import com.huawei.ism.ui.swing.table.DefaultTableModel;
import com.huawei.ism.ui.swing.table.DefaultTableRow;
import com.huawei.ism.ui.swing.table.IsmTable;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.ism.util.SwingUtil;
import com.huawei.ism.util.UCD;
import com.huawei.uMate.common.UMateException;
import com.huawei.uMate.common.file.FileOperation;
import com.huawei.uMate.common.ftp.SFTPServer;
import com.huawei.uMate.common.model.SFTPModel;
import com.huawei.uMate.common.utils.AppContext;
import com.huawei.uMate.common.utils.ResUtil;
import com.huawei.uMate.common.utils.SecurityUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FoolProofingBeforeExecutionDialog
extends JDialog {
    private static final Logger log = LoggerFactory.getLogger(FoolProofingBeforeExecutionDialog.class);
    private static final long serialVersionUID = 2655787478380300921L;
    private static final ResUtil RES = ResUtil.getInstance((String)"BundleUpgrade");
    private static final int DIALOG_HEIGHT = 600;
    private static final int DIALOG_WIDTH = 850;
    private static final Dimension TABLE_DIM = new Dimension(820, 350);
    private static final String SUCCESS_CODE = "0";
    private static final String FAIL_CODE = "-1";
    private ImageIcon questionImg;
    private transient List<UpgradeDeviceEntity> devices;
    private IsmTable deviceTable;
    private boolean isOKClick;
    private JCheckBox checkBox;
    private JButton okBtn;
    private JButton cancelBtn;
    private JPanel contentPanel;
    private JLabel remainTimeDescPanel = new JLabel();
    private JLabel remainTimeValuePanel = new JLabel();
    private JLabel remainTimeTipsPanel = new JLabel();
    private int remainTime;
    private String sftpIp = "";

    public FoolProofingBeforeExecutionDialog(Window owner, List<UpgradeDeviceEntity> devs, int remainTime) {
        super(owner);
        this.devices = devs;
        this.remainTime = remainTime;
        this.questionImg = new ImageIcon("images/danger.png");
        this.contentPanel = new JPanel();
        this.okBtn = UiMethod.createButton((String)RES.getString("text.ok"), (char)'O');
        this.cancelBtn = UiMethod.createButton((String)RES.getString("text.cancel"), (char)'C');
        this.checkBox = new JCheckBox(RES.getString("upgrade.comfirm.dlg.tips"));
        this.initComponents();
    }

    private void initComponents() {
        this.setModal(true);
        this.setTitle(RES.getString("please.confirm"));
        this.initTableData();
        this.getOkBtn().setEnabled(false);
        this.contentPanel.setLayout(new BorderLayout());
        this.contentPanel.add((Component)this.createMidPanelUI(), "North");
        this.contentPanel.add(UCD.buildVerticalBox(null, (Component[])new Component[]{UCD.buildHBoxLeft((Component[])new Component[]{Box.createHorizontalStrut(0), this.remainTimeDescPanel, this.remainTimeValuePanel, this.remainTimeTipsPanel}), UCD.buildHBoxLeft((Component[])new Component[]{Box.createHorizontalStrut(0), this.checkBox})}));
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.contentPanel, "North");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JSeparator sp = new JSeparator();
        jPanel.add((Component)sp, "North");
        jPanel.add(this.buildBtnPanel(), "East");
        this.getContentPane().add((Component)jPanel, "South");
        Dimension dimension = new Dimension(850, 600);
        UiMethod.setComponentSize((Dimension)dimension, (Component[])new Component[]{this});
        this.pack();
        this.setResizable(false);
        SwingUtil.setCloseWhenEscKeyPressed((JDialog)this);
        SwingUtil.putScreenCenter((Window)this);
        this.initListener();
        this.setCompName();
    }

    private void initTableData() {
        DefaultTableModel defaultTableModel = new DefaultTableModel(new String[]{RES.getString("bundle.upgrade.param.dev.table.col1"), RES.getString("bundle.upgrade.param.dev.table.col7"), RES.getString("bundle.upgrade.confirm.table.header.upgrade.Modules"), RES.getString("bundle.upgrade.param.foolProf.reboot.way")}, new int[]{0, 1, 2, 3});
        this.deviceTable = new IsmTable((TableModel)defaultTableModel);
        TableColumnModel colModel = this.deviceTable.getColumnModel();
        colModel.getColumn(0).setPreferredWidth(100);
        colModel.getColumn(1).setPreferredWidth(50);
        colModel.getColumn(2).setPreferredWidth(450);
        for (UpgradeDeviceEntity dev : this.devices) {
            DefaultTableRow row = new DefaultTableRow(4, (Object)dev);
            row.setValueAt(0, (Object)dev.getDeviceEntity().getIp());
            row.setValueAt(1, (Object)dev.getDeviceEntity().getProductType());
            row.setValueAt(2, (Object)this.getPrettyUpgradeStrategy(dev));
            row.setValueAt(3, (Object)(dev.needReboot() ? RES.getString("reboot.method.reboot.automatically") : RES.getString("reboot.method.reboot.not_involved")));
            defaultTableModel.addRow(new TableRow[]{row});
        }
        this.refreshRemainTime();
    }

    private void refreshRemainTime() {
        int hour = this.remainTime / 60;
        int min = this.remainTime % 60;
        this.remainTimeDescPanel.setText(RES.getString("bundle.upgrade.main.table.status.number.times.desc"));
        this.remainTimeValuePanel.setText(RES.getStringWithParams("bundle.upgrade.main.table.status.number.times.value", new Object[]{hour, min}));
        this.remainTimeTipsPanel.setText(RES.getString("bundle.upgrade.main.table.status.number.times.tips"));
    }

    private String getPrettyUpgradeStrategy(UpgradeDeviceEntity dev) {
        UpgradeStrategyEntity strategyEntity = BundleUpgradeContext.getInstance().getStrategyEntityMap().get(dev.getAssociatedStrategyId());
        ArrayList<String> upgradeOrdersPrettyList = new ArrayList<String>();
        for (int order = 0; order < strategyEntity.getUpgradeOrders().size(); ++order) {
            upgradeOrdersPrettyList.add(order + 1 + ")" + strategyEntity.getUpgradeOrders().get(order).stream().map(UpgradeParamConstants.ModuleType::getModule).collect(Collectors.joining(", ")));
        }
        return RES.getStringWithParams("upgrade.strategy.details", new Object[]{String.join((CharSequence)" -> ", upgradeOrdersPrettyList)});
    }

    private boolean checkStrategyContainPCIe() {
        if (this.devices.stream().map(dev -> BundleUpgradeContext.getInstance().getStrategyEntityMap().get(dev.getAssociatedStrategyId())).flatMap(strategyEntity -> strategyEntity.getUpgradeOrders().stream()).anyMatch(UpgradeScenarioUtil::containsInBandModuleUpgrade)) {
            return true;
        }
        log.info("check strategy not contain pcie.");
        return false;
    }

    private Component buildBtnPanel() {
        JPanel btnPanel = new JPanel();
        btnPanel.setLayout(new BoxLayout(btnPanel, 0));
        btnPanel.add(Box.createHorizontalGlue());
        btnPanel.add(this.okBtn);
        btnPanel.add(Box.createHorizontalStrut(10));
        Component marginComp = Box.createHorizontalStrut(12);
        btnPanel.add(marginComp);
        btnPanel.add(this.cancelBtn);
        btnPanel.add(marginComp);
        return Optional.of(UCD.buildVerticalBox(null, (Component[])new Component[]{Box.createVerticalStrut(0), btnPanel, Box.createVerticalStrut(0)})).orElse(new JLabel("--"));
    }

    private JComponent createMidPanelUI() {
        String tips = UpgradeScenarioUtil.isYinglong() ? RES.getString("confirm.dlg.yinglong.tips") : (this.devices.stream().anyMatch(dev -> dev.getDeviceEntity().isDirectPlane()) ? RES.getString("confirm.dlg.tips1") : RES.getString("confirm.dlg.tips"));
        JTextArea tipsText = UiMethod.createJTextArea((String)tips);
        JComponent warningTips = UCD.buildVerticalBox(null, (Component[])new Component[]{tipsText});
        JScrollPane tableScroll = new JScrollPane((Component)this.deviceTable);
        tableScroll.setPreferredSize(TABLE_DIM);
        tableScroll.setMinimumSize(TABLE_DIM);
        tableScroll.setMaximumSize(TABLE_DIM);
        return Optional.of(UCD.buildVerticalBox(null, (Component[])new Component[]{Box.createVerticalStrut(0), UCD.buildHBoxRight((Component[])new Component[]{Box.createHorizontalStrut(0), new JLabel(this.questionImg), warningTips, Box.createHorizontalStrut(0)}), UCD.buildHorizotalBox(null, (Component[])new Component[]{Box.createHorizontalStrut(0), tableScroll, Box.createHorizontalStrut(0)}), Box.createVerticalStrut(0)})).orElse(new JLabel("--"));
    }

    private void initListener() {
        this.cancelBtn.addActionListener(event -> {
            log.info("user clicked cancel.");
            this.dispose();
        });
        this.checkBox.addActionListener(ex -> this.getOkBtn().setEnabled(this.checkBox.isSelected()));
        this.getOkBtn().addActionListener(ex -> {
            log.info("user clicked continue.");
            this.isOKClick = true;
            this.dispose();
            if (!SFTPServer.getSFTP_SERVER().isAlive() && this.checkStrategyContainPCIe()) {
                try {
                    FileOperation.mkdirs((File)FileOperation.getFile((String)"template/BundleUpgrade/FirmwarePackages/"));
                }
                catch (UMateException e) {
                    log.error("Create directory failed.");
                }
                WarningDialog wd = DialogUtils.showYesNoDialog((Window)AppContext.getInstance().getMainJFrame(), (String)RES.getStringWithParams("upgrade.dlg.sftp", new Object[]{RES.getString("upgrade.sftp.not.running")}));
                if (wd.getValue() == 0) {
                    if (!this.startSFTP("22")) {
                        this.isOKClick = false;
                        log.error("The SFTP server start failed!");
                    } else {
                        log.info("The SFTP server start successful!");
                    }
                } else {
                    this.isOKClick = false;
                }
            }
        });
    }

    private JButton getOkBtn() {
        return this.okBtn;
    }

    private void setCompName() {
        this.checkBox.setName("_JCheckBox_checkBox");
        this.okBtn.setName("_Button_okBtn");
        this.cancelBtn.setName("_Button_cancelBtn");
    }

    public boolean isOKClick() {
        return this.isOKClick;
    }

    private boolean startSFTP(String port) {
        boolean sftpFlag;
        String exec = "";
        try {
            SFTPModel.setZERO_FLAG((boolean)true);
            String sftpIpConnect = this.getSftpIp();
            if (StringUtils.isNULLStr((String)sftpIpConnect)) {
                DialogUtils.showInfoDialog((JDialog)this, (String)RES.getString("upgrade.dlg.ftp.start.error"));
                return false;
            }
            this.sftpIp = sftpIpConnect;
            SFTPModel.setSFTP_IP((String)sftpIpConnect);
            SFTPModel.setSFTP_SERVER_PORT((String)port);
            SFTPModel.setSFTP_User((String)"sftp_user");
            SFTPModel.setSFTP_PWD((char[])SecurityUtils.generatePassword((int)18).toCharArray());
            SFTPModel.setSftpPath((String)"template/BundleUpgrade/FirmwarePackages/");
            sftpFlag = SFTPServer.startReadOnlySftp();
        }
        catch (UMateException | InterruptedException ex) {
            log.error("start SFTP server error.", ex);
            exec = SFTPServer.getExecPrint();
            return this.startSFTPConfirm(exec);
        }
        if (!sftpFlag) {
            exec = SFTPServer.getExecPrint();
            return this.startSFTPConfirm(exec);
        }
        return true;
    }

    private String getSftpIp() {
        Optional<DeviceEntity> upgradeDevice = this.devices.stream().map(UpgradeDeviceEntity::getDeviceEntity).filter(DeviceEntity::isSelected).findFirst();
        if (!upgradeDevice.isPresent()) {
            log.info("No node to be upgraded is selected.");
            return "";
        }
        if (this.isConnectFromCacheSftpIp(upgradeDevice.get())) {
            return this.sftpIp;
        }
        for (NetworkInterface networkInterface : NetUtil.availableInterface()) {
            Enumeration<InetAddress> addresses = networkInterface.getInetAddresses();
            while (addresses.hasMoreElements()) {
                InetAddress inetAddress = addresses.nextElement();
                if (!this.isDeviceReachable(inetAddress, upgradeDevice.get())) continue;
                return inetAddress.getHostAddress();
            }
        }
        log.info("The local IP address cannot be connected to any target device.");
        return "";
    }

    private boolean isConnectFromCacheSftpIp(DeviceEntity deviceEntity) {
        if (StringUtils.isNULLStr((String)this.sftpIp)) {
            log.info("No sftpIp is cached. Please try the connectivity of other sftpIp addresses.");
            return false;
        }
        try {
            log.info("Attempt to test connectivity to the target device from the sftpIp: {} in the cache", (Object)this.sftpIp);
            return this.isDeviceReachable(InetAddress.getByName(this.sftpIp), deviceEntity);
        }
        catch (UnknownHostException e) {
            log.info("The current sftpIp: {} cannot connect to all target devices. Try another sftpIp.", (Object)this.sftpIp, (Object)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isDeviceReachable(InetAddress localInetAddress, DeviceEntity deviceEntity) {
        SSLSocket ssLsocket;
        Socket defaultSoket;
        block5: {
            defaultSoket = null;
            ssLsocket = null;
            defaultSoket = SSLSocketFactory.getDefault().createSocket();
            if (defaultSoket instanceof SSLSocket) break block5;
            boolean bl = false;
            FileUtils.close((Closeable[])new Closeable[]{ssLsocket});
            FileUtils.close((Closeable[])new Closeable[]{defaultSoket});
            return bl;
        }
        try {
            ssLsocket = (SSLSocket)defaultSoket;
            ssLsocket.bind(new InetSocketAddress(localInetAddress, 0));
            InetSocketAddress remoteSocketAddress = new InetSocketAddress(InetAddress.getByName(deviceEntity.getIp()), 443);
            ssLsocket.connect(remoteSocketAddress, 5000);
        }
        catch (IOException e) {
            boolean bl;
            try {
                log.info("FAILRE - Can not connect: LocalIp: {}, RemoteIp:{}", (Object)localInetAddress.getHostAddress(), (Object)deviceEntity.getIp());
                bl = false;
            }
            catch (Throwable throwable) {
                FileUtils.close((Closeable[])new Closeable[]{ssLsocket});
                FileUtils.close((Closeable[])new Closeable[]{defaultSoket});
                throw throwable;
            }
            FileUtils.close((Closeable[])new Closeable[]{ssLsocket});
            FileUtils.close((Closeable[])new Closeable[]{defaultSoket});
            return bl;
        }
        FileUtils.close((Closeable[])new Closeable[]{ssLsocket});
        FileUtils.close((Closeable[])new Closeable[]{defaultSoket});
        log.info("SUCCESS - Connect: LocalIp: {}, RemoteIp:{}", (Object)localInetAddress.getHostAddress(), (Object)deviceEntity.getIp());
        return true;
    }

    private boolean startSFTPConfirm(String exec) {
        if (exec.contains("Server port is already in use")) {
            String errorMsg = RES.getString("upgrade.ftp.port.occupied.error");
            WarningDialog wd = DialogUtils.showYesNoDialog((Window)AppContext.getInstance().getMainJFrame(), (String)RES.getStringWithParams("upgrade.dlg.ftp.start.err1", new Object[]{errorMsg}));
            if (wd.getValue() == 0) {
                SftpPortSetDialog sftpPortSetDialog = new SftpPortSetDialog(this, RES.getString("upgrade.dlg.ftp.start.input"));
                sftpPortSetDialog.setVisible(true);
                com.huawei.ism.tool.base.ui.UiMethod.putScreenCenter((Window)((Object)sftpPortSetDialog));
                if (!StringUtils.isNULLStr((String)sftpPortSetDialog.getInputSport())) {
                    log.info(sftpPortSetDialog.getInputSport());
                    return this.startSFTP(sftpPortSetDialog.getInputSport());
                }
                return false;
            }
            return false;
        }
        DialogUtils.showInfoDialog((Frame)AppContext.getInstance().getMainJFrame(), (String)RES.getStringWithParams("upgrade.dlg.ftp.start.err", new Object[]{SFTPServer.getExecPrint()}));
        return false;
    }
}

