/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.bundleupgrade.ui.dialog;

import com.huawei.bundleupgrade.constants.UpgradeParamConstants;
import com.huawei.bundleupgrade.entity.DiskPkgInfo;
import com.huawei.bundleupgrade.entity.FirmwarePackageEntity;
import com.huawei.bundleupgrade.entity.FunctionMap;
import com.huawei.bundleupgrade.entity.PcieCardEntity;
import com.huawei.bundleupgrade.entity.UpgradeDeviceEntity;
import com.huawei.bundleupgrade.entity.UpgradeStrategyEntity;
import com.huawei.bundleupgrade.model.Module;
import com.huawei.bundleupgrade.ui.layout.ParamDetailLayout;
import com.huawei.bundleupgrade.utils.BundleUpgradeContext;
import com.huawei.bundleupgrade.utils.ServiceUtil;
import com.huawei.ism.tool.obase.utils.CollectionUtil;
import com.huawei.ism.tool.obase.utils.UiMethod;
import com.huawei.ism.ui.swing.table.DefaultTableModel;
import com.huawei.ism.ui.swing.table.DefaultTableRow;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.ism.ui.templets.IsmDialog;
import com.huawei.uMate.common.utils.ResUtil;
import java.awt.Dimension;
import java.awt.Window;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParamDetailDialog
extends IsmDialog {
    private static final Logger LOGGER = LoggerFactory.getLogger(ParamDetailDialog.class);
    private static final ResUtil RES = ResUtil.getInstance((String)"BundleUpgrade");
    private static final Dimension SIZE = new Dimension(740, 400);
    private ParamDetailLayout layout;
    private UpgradeDeviceEntity upgradeDeviceEntity;
    private UpgradeDeviceEntity baseDevice;
    private Map<String, String> currentDevPanGeaInBandModuleVersion;
    private Map<String, String> baseDevPanGeaInBandModuleVersion;

    public ParamDetailDialog(Window parent, UpgradeDeviceEntity upgradeDeviceEntity) {
        super(parent, RES.getString("bundle.upgrade.main.table.detail.parameter"), new IsmDialog.ECommonButton[]{IsmDialog.ECommonButton.Close});
        this.upgradeDeviceEntity = upgradeDeviceEntity;
        this.currentDevPanGeaInBandModuleVersion = upgradeDeviceEntity.getDeviceEntity().getPanGeaInBandModuleVersion();
        UpgradeStrategyEntity strategyEntity = BundleUpgradeContext.getInstance().getStrategyEntityMap().get(upgradeDeviceEntity.getAssociatedStrategyId());
        this.baseDevice = strategyEntity.getBaseDevice();
        this.baseDevPanGeaInBandModuleVersion = this.baseDevice.getDeviceEntity().getPanGeaInBandModuleVersion();
        this.layout = new ParamDetailLayout(upgradeDeviceEntity);
        this.add(this.layout);
        this.setSize(SIZE);
        UiMethod.putScreenCenter((Window)((Object)this));
        this.setModal(true);
        this.showParamDetail();
    }

    private void showParamDetail() {
        String uuid = this.upgradeDeviceEntity.getAssociatedStrategyId();
        UpgradeStrategyEntity strategyEntity = BundleUpgradeContext.getInstance().getStrategyEntityMap().get(uuid);
        DefaultTableModel tableModel = this.layout.getCompTableModel();
        List<List<UpgradeParamConstants.ModuleType>> orderList = strategyEntity.getUpgradeOrders();
        for (List<UpgradeParamConstants.ModuleType> typeList : orderList) {
            int order = orderList.indexOf(typeList) + 1;
            typeList.forEach(type -> strategyEntity.getModuleTargetFirmwareMap().get(type).forEach(packageInfo -> {
                if (type == UpgradeParamConstants.ModuleType.DISK_FW) {
                    tableModel.addRows(this.createDiskRows((String)packageInfo, (UpgradeParamConstants.ModuleType)((Object)type), order, strategyEntity));
                    return;
                }
                TableRow<Object, String> tableRow = this.createTableRow((String)packageInfo, (UpgradeParamConstants.ModuleType)((Object)type), order, strategyEntity);
                tableModel.addRow(new TableRow[]{tableRow});
            }));
        }
    }

    private List<TableRow> createDiskRows(String packageKey, UpgradeParamConstants.ModuleType moduleType, int order, UpgradeStrategyEntity strategyEntity) {
        FirmwarePackageEntity fwPkg = BundleUpgradeContext.getInstance().getFirmwarePackageMap().get(packageKey);
        Map<String, DiskPkgInfo> diskUidMap = Module.DiskFw.buildDiskUidMap(fwPkg.getDiskPkgInfos());
        return this.upgradeDeviceEntity.getDeviceEntity().getDiskInfo().stream().map(disk -> {
            Object obj = new Object();
            DefaultTableRow tableRow = new DefaultTableRow(this.layout.getCompTable().getColumnCount(), obj, (Object)disk.getEsn());
            int col = 0;
            tableRow.setValueAt(col++, (Object)RES.getString(moduleType.toString()));
            tableRow.setValueAt(col++, (Object)order);
            tableRow.setValueAt(col++, (Object)(disk.getEsn() + ":" + disk.getFirmwareVersion()));
            tableRow.setValueAt(col++, (Object)Module.DiskFw.findDiskInfo(diskUidMap, disk).map(DiskPkgInfo::getTargetVersion).orElse("--"));
            tableRow.setValueAt(col++, (Object)this.getUpgradeStrategyEnumValue(packageKey, strategyEntity));
            tableRow.setValueAt(col, (Object)this.getPackageLocalAbsPath(packageKey));
            return tableRow;
        }).collect(Collectors.toList());
    }

    private TableRow<Object, String> createTableRow(String packageKey, UpgradeParamConstants.ModuleType moduleType, int order, UpgradeStrategyEntity strategyEntity) {
        Object obj = new Object();
        DefaultTableRow tableRow = new DefaultTableRow(this.layout.getCompTable().getColumnCount(), obj, (Object)packageKey);
        int col = 0;
        tableRow.setValueAt(col++, (Object)RES.getString(moduleType.toString()));
        tableRow.setValueAt(col++, (Object)order);
        tableRow.setValueAt(col++, (Object)this.getVersion(moduleType, this.getTargetFwPkg(packageKey)));
        tableRow.setValueAt(col++, (Object)this.getTargetVersion(packageKey));
        tableRow.setValueAt(col++, (Object)this.getUpgradeStrategyEnumValue(packageKey, strategyEntity));
        tableRow.setValueAt(col, (Object)this.getPackageLocalAbsPath(packageKey));
        return tableRow;
    }

    private String getVersion(UpgradeParamConstants.ModuleType moduleType, FirmwarePackageEntity targetFwPkg) {
        String moduleName = moduleType.getModule();
        if (ServiceUtil.isPanGeaIntraBandModule(moduleName)) {
            if (this.currentDevPanGeaInBandModuleVersion.containsKey(moduleName)) {
                return this.currentDevPanGeaInBandModuleVersion.get(moduleName);
            }
            if (this.baseDevice != null) {
                LOGGER.info("Can not find {} version,return base dev's module version.", (Object)moduleName);
                return this.baseDevPanGeaInBandModuleVersion.getOrDefault(moduleName, "--") + " " + RES.getStringWithParams("bundle.upgrade.main.table.detail.baseDev.tips", new Object[]{this.baseDevice.getDeviceEntity().getIp()});
            }
        }
        if (moduleType == UpgradeParamConstants.ModuleType.BIOS) {
            Module.Bios bios = (Module.Bios)FunctionMap.ModuleFunction.getModule(moduleType.getModule());
            return bios.getVersion(this.upgradeDeviceEntity.getDeviceEntity(), targetFwPkg);
        }
        List<PcieCardEntity> currentPcieCards = this.getCurrentPcieCards(targetFwPkg);
        if (!CollectionUtil.isEmpty(currentPcieCards)) {
            return this.getCurrentPcieCardVersion(currentPcieCards);
        }
        return FunctionMap.ModuleFunction.getModule(moduleType.getModule()).getVersion(this.upgradeDeviceEntity.getDeviceEntity(), targetFwPkg);
    }

    private List<PcieCardEntity> getCurrentPcieCards(FirmwarePackageEntity targetFwPkg) {
        String supportModelUID = targetFwPkg.getPackageInfo().getSupportModelUID().replace(";", ", ");
        String firmwareSupportUID = "[" + supportModelUID + "]";
        return this.upgradeDeviceEntity.getDeviceEntity().getPcieCardsInfos().getOrDefault(firmwareSupportUID, Collections.emptyList());
    }

    @NotNull
    private String getCurrentPcieCardVersion(List<PcieCardEntity> currentPcieCard) {
        return currentPcieCard.stream().map(PcieCardEntity::getFirmwareVersion).distinct().collect(Collectors.joining(";"));
    }

    private String getTargetVersion(String packageKey) {
        FirmwarePackageEntity firmwarePackageEntity = this.getTargetFwPkg(packageKey);
        return null != firmwarePackageEntity ? firmwarePackageEntity.getPackageInfo().getVersion() : "";
    }

    private FirmwarePackageEntity getTargetFwPkg(String packageKey) {
        return BundleUpgradeContext.getInstance().getFirmwarePackageMap().get(packageKey);
    }

    private String getUpgradeStrategyEnumValue(String packageName, UpgradeStrategyEntity strategyEntity) {
        Map<String, UpgradeParamConstants.FirmwareUpgradeStrategy> strategyMap = strategyEntity.getUpgradeStrategyMap();
        return RES.getString(strategyMap.get(packageName).toString());
    }

    private String getPackageLocalAbsPath(String packageKey) {
        FirmwarePackageEntity firmwarePackageEntity = BundleUpgradeContext.getInstance().getFirmwarePackageMap().get(packageKey);
        return null != firmwarePackageEntity ? firmwarePackageEntity.getLocalPathAbs() : "";
    }
}

