/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.bundleupgrade.ui.dialog;

import com.huawei.bundleupgrade.ui.card.UpgradeTypeSelectionCard;
import com.huawei.bundleupgrade.ui.layout.RepeatedFwPackageViewLayout;
import com.huawei.bundleupgrade.utils.UpgradeConstants;
import com.huawei.ism.tool.base.ui.UiMethod;
import com.huawei.ism.ui.swing.table.DefaultTableModel;
import com.huawei.ism.ui.swing.table.DefaultTableRow;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.ism.ui.templets.IsmDialog;
import com.huawei.uMate.common.utils.ResUtil;
import java.awt.Dimension;
import java.awt.Window;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;

public class RepeatedFwPackageViewDialog
extends IsmDialog {
    private static final ResUtil RES = ResUtil.getInstance((String)"BundleUpgrade");
    private static final Dimension SIZE = new Dimension(750, 450);
    private RepeatedFwPackageViewLayout layout = new RepeatedFwPackageViewLayout();
    private UpgradeTypeSelectionCard typeSelectionCard;

    public RepeatedFwPackageViewDialog(Window parent, Map<String, List<String>> packagePathMap, UpgradeTypeSelectionCard typeSelectionCard) {
        super(parent, RES.getString("bundle.upgrade.repeated.package.view.dialog.title"), new IsmDialog.ECommonButton[]{IsmDialog.ECommonButton.Confirm});
        this.typeSelectionCard = typeSelectionCard;
        this.add(this.layout);
        this.add(UiMethod.buildFrameSpace((JComponent)this.layout, (int)12), "Center");
        this.setSize(SIZE);
        this.setModal(true);
        this.showRepeatedPackagesInfo(packagePathMap);
        this.initListener();
    }

    private void initListener() {
        this.layout.getRefreshBtn().addActionListener(event -> {
            this.doConfirmTask();
            this.typeSelectionCard.refreshBtnAction();
        });
    }

    private void showRepeatedPackagesInfo(Map<String, List<String>> packagePathMap) {
        HashMap<String, String> repeatedInfoMap = new HashMap<String, String>();
        packagePathMap.forEach((k, v) -> {
            if (v.size() > 1) {
                String repeatedInfo = String.join((CharSequence)";", (CharSequence[])v.stream().toArray(String[]::new));
                int index = repeatedInfo.indexOf(";");
                String key = repeatedInfo.substring(0, index);
                String value = repeatedInfo.substring(index + 1);
                if (value.contains(UpgradeConstants.PAN_GEA_PACKAGE_TEMP_PATH)) {
                    repeatedInfoMap.put(value, key);
                } else {
                    repeatedInfoMap.put(key, value);
                }
            }
        });
        DefaultTableModel tableModel = this.layout.getCompTableModel();
        tableModel.removeAll();
        repeatedInfoMap.forEach((k, v) -> {
            TableRow<String, String> row = this.createTableRow((String)k, (String)v);
            tableModel.addRow(new TableRow[]{row});
        });
    }

    private TableRow<String, String> createTableRow(String key, String value) {
        int columnCount = this.layout.getCompTable().getColumnCount();
        DefaultTableRow row = new DefaultTableRow(columnCount, (Object)value, (Object)key);
        int col = 0;
        row.setValueAt(col++, (Object)key);
        row.setValueAt(col, (Object)value);
        return row;
    }

    protected void doConfirmTask() {
        super.doCloseTask();
    }
}

