/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.bundleupgrade.ui.dialog;

import com.huawei.ism.tool.base.ui.UiMethod;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.templets.IsmDialog;
import com.huawei.ism.util.SwingUtil;
import com.huawei.ism.util.UCD;
import com.huawei.uMate.common.utils.ResUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Window;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.border.Border;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SftpPortSetDialog
extends IsmDialog {
    private static final Logger log = LoggerFactory.getLogger(SftpPortSetDialog.class);
    private static final ResUtil RES = ResUtil.getInstance((String)"BundleUpgrade");
    String tips = null;
    JTextField input = null;
    JButton confirmBtn = null;
    String inputSport = "";

    public String getInputSport() {
        return this.inputSport;
    }

    public SftpPortSetDialog(Window parent, String tips1) {
        super(parent, RES.getString("upgrade.ftp.port.input"), new IsmDialog.ECommonButton[0]);
        this.tips = tips1;
        this.setLayout(new BorderLayout());
        this.setTitle(RES.getString("upgrade.ftp.port.input"));
        this.setResizable(false);
        this.add(this.init(), "Center");
        this.setModal(true);
        this.pack();
        SwingUtil.putScreenCenter((Window)((Object)this));
        SwingUtil.setCloseWhenEscKeyPressed((JDialog)((Object)this));
        this.setSize(415, 185);
        this.initListener();
        if (this.confirmBtn != null) {
            this.confirmBtn.requestFocus();
        }
    }

    private JComponent init() {
        JLabel panel = new JLabel(this.tips);
        ImageIcon icon = new ImageIcon("images/notgrab.png");
        panel.setIcon(icon);
        this.input = new JTextField();
        this.input.setEditable(true);
        this.input.setText("");
        this.input.setForeground(new Color(150, 150, 150));
        this.input.setToolTipText("");
        UCD.setSameWidth((JComponent[])new JComponent[]{panel, this.input});
        this.confirmBtn = UiMethod.createButton((String)RES.getString("text.ok"), (char)'O');
        JComponent view = null;
        view = UCD.buildVerticalBox((Border)BorderFactory.createEmptyBorder(), (int)0, (Component[])new Component[]{UiMethod.buildFrameSpace((JComponent)panel, (int)12), this.input, Box.createVerticalStrut(12), new JSeparator(), UiMethod.buildFrameSpace((JComponent)UiMethod.buildCompsRight((int)0, (Component[])new Component[]{this.confirmBtn}), (int)12)});
        this.confirmBtn.requestFocus();
        return view;
    }

    private void initListener() {
        if (this.getConfirmBtn() != null) {
            this.getConfirmBtn().addActionListener(event -> this.actionPerformed());
        }
    }

    public void actionPerformed() {
        log.info("click confirm button.");
        String ver = this.getInput().getText();
        if (StringUtils.isNULLStr((String)ver)) {
            DialogUtils.showInfoDialog((JDialog)((Object)this), (String)RES.getString("upgrade.ftp.port.input.empty"));
            return;
        }
        Pattern pattern = Pattern.compile("^(?:[1-6][0-5]{0,2}?[0-3]?[0-6]?|[1-5][0-9]{0,4})$");
        Matcher matcher = pattern.matcher(ver);
        boolean isMatched = matcher.matches();
        if (!isMatched) {
            DialogUtils.showInfoDialog((JDialog)((Object)this), (String)RES.getString("upgrade.ftp.port.input.error"));
            return;
        }
        this.inputSport = ver;
        this.dispose();
    }

    public JTextField getInput() {
        return this.input;
    }

    public JButton getConfirmBtn() {
        return this.confirmBtn;
    }
}

