/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.bundleupgrade.ui.layout;

import com.huawei.bundleupgrade.ui.component.DetailListCellRender;
import com.huawei.bundleupgrade.ui.component.TableWithFilterPanel;
import com.huawei.bundleupgrade.utils.UpgradeScenarioUtil;
import com.huawei.ism.tool.base.ui.UiMethod;
import com.huawei.ism.ui.swing.RolloverButton;
import com.huawei.ism.ui.swing.table.DefaultTableModel;
import com.huawei.ism.ui.swing.table.IsmTable;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.ism.util.UCD;
import com.huawei.uMate.common.utils.ResUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class BundleUpgradeLayout
extends JPanel {
    private static final ResUtil RES = ResUtil.getInstance((String)"BundleUpgrade");
    private static final Dimension SIZE = new Dimension(1000, 300);
    private static final int MARGIN = 12;
    private static List<String> FUSION_STRG_MAIN_TABLE_COLUMNS = Collections.unmodifiableList(Arrays.asList(RES.getString("bundle.upgrade.main.table.col.fs.bmc.ip"), RES.getString("bundle.upgrade.main.table.col2"), RES.getString("bundle.upgrade.main.table.col.fs.mngmnt.ip"), RES.getString("bundle.upgrade.main.table.col.fs.kernel.version"), RES.getString("bundle.upgrade.main.table.col3"), RES.getString("bundle.upgrade.main.table.col4"), RES.getString("bundle.upgrade.main.table.col5"), RES.getString("bundle.upgrade.main.table.col6"), RES.getString("bundle.upgrade.main.table.service.type"), RES.getString("bundle.upgrade.main.table.col7"), RES.getString("bundle.upgrade.main.table.col8"), RES.getString("bundle.upgrade.main.table.col9"), RES.getString("bundle.upgrade.main.table.pool.id"), RES.getString("bundle.upgrade.main.table.disk.pool.id"), RES.getString("bundle.upgrade.main.table.col.fs.floatip"), RES.getString("bundle.upgrade.main.table.chassisId")));
    private static List<String> BUNDLE_UPG_MAIN_TABLE_COLUMNS = Collections.unmodifiableList(Arrays.asList(RES.getString("bundle.upgrade.main.table.col1"), RES.getString("bundle.upgrade.main.table.col2"), RES.getString("bundle.upgrade.main.table.col3"), RES.getString("bundle.upgrade.main.table.col4"), RES.getString("bundle.upgrade.main.table.col5"), RES.getString("bundle.upgrade.main.table.col6"), RES.getString("bundle.upgrade.main.table.col7"), RES.getString("bundle.upgrade.main.table.col8"), RES.getString("bundle.upgrade.main.table.col9")));
    private JButton paramSetBtn;
    private TableWithFilterPanel tsp;
    private JButton processBtn;
    private JButton exportBtn;
    private JButton terminateBtn;
    private JButton exportUpdReportBtn;
    private JButton filterBtn;
    private IsmTable devTable;
    private JList detailList;
    private JScrollPane detailListScrolPane = null;
    private DefaultTableModel devTableModel = this.initTableModel();
    private transient List<TableRow> tableRows;

    public BundleUpgradeLayout() {
        this.initUi();
    }

    private void initUi() {
        this.setLayout(new BorderLayout());
        this.exportBtn = UCD.createButton((String)RES.getString("bundle.upgrade.main.btn.export", new Object[]{Character.valueOf('E')}));
        this.terminateBtn = UCD.createButton((String)RES.getString("bundle.upgrade.main.btn.terminate", new Object[]{Character.valueOf('T')}));
        this.terminateBtn.setVisible(false);
        this.exportBtn.setVisible(false);
        this.exportUpdReportBtn = new RolloverButton(RES.getString("bundle.upgrade.main.btn.export.result"));
        this.exportUpdReportBtn.setForeground(new Color(66, 124, 211));
        this.filterBtn = new JButton(RES.getString("bundle.upgrade.main.btn.filter"));
        this.devTable = new IsmTable((TableModel)this.devTableModel);
        this.detailList = new JList(new DefaultListModel());
        this.detailList.setCellRenderer(new DetailListCellRender());
        this.detailList.setSelectionMode(0);
        this.detailListScrolPane = new JScrollPane(this.detailList);
        this.detailListScrolPane.setPreferredSize(SIZE);
        this.tsp = new TableWithFilterPanel(this.devTable, true);
        this.tsp.setPreferredSize(SIZE);
        this.tsp.setMinimumSize(new Dimension(this.tsp.getPreferredSize().width, 90));
        TableColumnModel colModel = this.devTable.getColumnModel();
        colModel.getColumn(this.getTargetCellPosition(RES.getString("bundle.upgrade.main.table.col8"))).setPreferredWidth(100);
        colModel.getColumn(this.getTargetCellPosition(RES.getString("bundle.upgrade.main.table.col6"))).setPreferredWidth(80);
        JSplitPane splitPane = new JSplitPane(0, true);
        splitPane.setTopComponent(this.tsp);
        splitPane.setBottomComponent(this.detailListScrolPane);
        splitPane.setDividerLocation(300);
        splitPane.setBorder(null);
        JLabel descLabel = new JLabel(this.getMainDesc());
        this.paramSetBtn = UCD.createButton((String)RES.getString("bundle.upgrade.main.btn.param", new Object[]{Character.valueOf('S')}));
        this.processBtn = UCD.createButton((String)RES.getString("bundle.upgrade.main.btn.process", new Object[]{Character.valueOf('R')}));
        JLabel tipLabel = new JLabel(RES.getString("bundle.upgrade.main.tip1"));
        tipLabel.setForeground(Color.red);
        ArrayList<Box> toolTips = new ArrayList<Box>();
        toolTips.add(UCD.buildHBoxLeft((int)12, (Component[])new Component[]{descLabel}));
        JLabel descLabel2 = new JLabel(RES.getString("bundle.upgrade.main.desc2"));
        toolTips.add(UCD.buildHBoxLeft((int)12, (Component[])new Component[]{descLabel2}));
        toolTips.add(UCD.buildHBoxLeft((int)12, (Component[])new Component[]{this.paramSetBtn, this.processBtn, this.terminateBtn}));
        Box infoPanel = UCD.buildVBoxTop((Component[])toolTips.toArray(new JComponent[0]));
        Box tableBox = UCD.buildVBoxTop((Component[])new Component[]{UCD.buildHBoxLeft((int)12, (Component[])new Component[]{splitPane})});
        JComponent mainBox = UCD.buildVerticalBox(null, (Component[])new Component[]{infoPanel, tableBox});
        this.add((Component)UiMethod.buildFrameSpace((JComponent)mainBox, (int)12), "Center");
        JComponent bottomPane = UCD.buildVerticalBox(null, (int)0, (Component[])new Component[]{new JSeparator(), Box.createVerticalStrut(5), UCD.buildHBoxRight((Component[])new Component[]{this.exportUpdReportBtn, Box.createHorizontalStrut(3)}), Box.createVerticalStrut(12)});
        this.add((Component)bottomPane, "South");
    }

    private String getMainDesc() {
        if (UpgradeScenarioUtil.isYinglong()) {
            return UpgradeScenarioUtil.isOutBound() ? RES.getString("bundle.upgrade.main.desc.fw") : RES.getString("bundle.upgrade.main.desc.driver");
        }
        return RES.getString("bundle.upgrade.main.desc");
    }

    public int getTargetCellPosition(String tableCellName) {
        return FUSION_STRG_MAIN_TABLE_COLUMNS.indexOf(tableCellName);
    }

    private DefaultTableModel initTableModel() {
        String[] tableColName = FUSION_STRG_MAIN_TABLE_COLUMNS.toArray(new String[0]);
        return new DefaultTableModel(tableColName, new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10});
    }

    public JButton getParamSetBtn() {
        return this.paramSetBtn;
    }

    public JButton getProcessBtn() {
        return this.processBtn;
    }

    public JButton getTerminateBtn() {
        return this.terminateBtn;
    }

    public IsmTable getDevTable() {
        return this.devTable;
    }

    public JList getDetailList() {
        return this.detailList;
    }

    public DefaultTableModel getDevTableModel() {
        return this.devTableModel;
    }

    public JScrollPane getDetailListScrolPane() {
        return this.detailListScrolPane;
    }

    public JButton getExportBtn() {
        return this.exportBtn;
    }

    public JButton getExportUpdReportBtn() {
        return this.exportUpdReportBtn;
    }

    public List<TableRow> getTableRows() {
        return this.tableRows;
    }

    public void setTableRows(List<TableRow> tableRows) {
        this.tableRows = tableRows;
    }

    public static List<String> getFusionStrgMainTableColumnsList() {
        return FUSION_STRG_MAIN_TABLE_COLUMNS;
    }

    public static List<String> getBundleUpgradeMainTableColunmsList() {
        return BUNDLE_UPG_MAIN_TABLE_COLUMNS;
    }

    public TableWithFilterPanel getTableContentPane() {
        return this.tsp;
    }
}

