/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.bundleupgrade.ui.layout;

import com.huawei.bundleupgrade.entity.UpgradeDeviceEntity;
import com.huawei.bundleupgrade.utils.BundleUpgradeContext;
import com.huawei.bundleupgrade.utils.ServiceUtil;
import com.huawei.ism.tool.base.ui.UiMethod;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.ui.swing.table.DefaultTableModel;
import com.huawei.ism.ui.swing.table.IsmTable;
import com.huawei.ism.ui.swing.table.TableScrollPane;
import com.huawei.ism.util.UCD;
import com.huawei.uMate.common.utils.ResUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Collection;
import java.util.Locale;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParamDetailLayout
extends JPanel {
    private static final Logger log = LoggerFactory.getLogger(ParamDetailLayout.class);
    private static final ResUtil RES = ResUtil.getInstance((String)"BundleUpgrade");
    private static final String[] tableColName = new String[]{RES.getString("bundle.upgrade.param.component.table.col1"), RES.getString("bundle.upgrade.param.component.table.col8"), RES.getString("bundle.upgrade.param.component.table.col3"), RES.getString("bundle.upgrade.param.component.table.col4"), RES.getString("bundle.upgrade.param.component.table.col9"), RES.getString("bundle.upgrade.param.component.table.col10")};
    private IsmTable compTable;
    private DefaultTableModel compTableModel = new DefaultTableModel(tableColName, new int[0]);
    private UpgradeDeviceEntity upgradeDeviceEntity;

    public ParamDetailLayout(UpgradeDeviceEntity upgradeDeviceEntity) {
        this.upgradeDeviceEntity = upgradeDeviceEntity;
        this.initUi();
    }

    private void initUi() {
        this.setLayout(new BorderLayout());
        this.compTable = new IsmTable((TableModel)this.compTableModel);
        TableColumnModel tcm = this.compTable.getColumnModel();
        ServiceUtil.setTableColWidth(tcm.getColumn(0), 110, 110, 110);
        ServiceUtil.setTableColWidth(tcm.getColumn(1), 50, 110, 110);
        ServiceUtil.setTableColWidth(tcm.getColumn(3), 110, 110, 110);
        JLabel packageImportMethod = UiMethod.createLabel((String)RES.getString("bundle.upgrade.package.import.method"));
        TableScrollPane tableScrollPane = new TableScrollPane(this.compTable);
        UCD.setJComponentSize((JComponent)tableScrollPane, (Dimension)new Dimension(700, 240));
        Box tableBox = UCD.buildHBoxLeft((Component[])new Component[]{tableScrollPane});
        Box mainBox = UCD.buildVBoxTop((int)9, (Component[])new Component[]{Box.createVerticalStrut(20), UCD.buildHBoxLeft((Component[])new Component[]{Box.createHorizontalStrut(12), packageImportMethod, this.getPackageImportMethod()}), UCD.buildHBoxLeft((Component[])new Component[]{Box.createHorizontalStrut(12), tableBox, Box.createHorizontalStrut(12)})});
        this.add((Component)mainBox, "North");
    }

    private Component getPackageImportMethod() {
        boolean isOnline = BundleUpgradeContext.getInstance().getStrategyEntityMap().get(this.upgradeDeviceEntity.getAssociatedStrategyId()).getModuleTargetFirmwareMap().values().stream().flatMap(Collection::parallelStream).map(fwKey -> BundleUpgradeContext.getInstance().getFirmwarePackageMap().get(fwKey)).anyMatch(fwPkg -> !StringUtils.isNULLStr((String)fwPkg.getOnlinePathAbs()));
        log.info(String.format(Locale.ROOT, "get Package Import Method is %s.", isOnline));
        return isOnline ? new JLabel(RES.getString("bundle.upgrade.type.panel.online")) : new JLabel(RES.getString("bundle.upgrade.type.panel.local"));
    }

    public DefaultTableModel getCompTableModel() {
        return this.compTableModel;
    }

    public IsmTable getCompTable() {
        return this.compTable;
    }
}

