/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.bundleupgrade.ui.layout.strategy;

import com.huawei.bundleupgrade.entity.UpgradeDeviceEntity;
import com.huawei.bundleupgrade.utils.BundleUpgradeContext;
import com.huawei.bundleupgrade.utils.UpgradeConstants;
import com.huawei.ism.tool.base.ui.UiMethod;
import com.huawei.ism.util.UCD;
import com.huawei.uMate.common.utils.ResUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class UpgradeStrategySettingMainLayout
extends JPanel {
    private static final ResUtil RES = ResUtil.getInstance((String)"BundleUpgrade");
    private static final Dimension DEVICE_COMBO_SIZE = new Dimension(200, 20);
    private static final Dimension TITLE_LABEL_SIZE = new Dimension(85, 15);
    private JComboBox<String> deviceSelectCombo;
    private JCheckBox pcieCheckBox;
    private JButton obtainInfoBtn;

    public UpgradeStrategySettingMainLayout() {
        this.initUi();
    }

    private void initUi() {
        this.setLayout(new BorderLayout());
        JLabel deviceTypeLabel = UiMethod.createLabel((String)RES.getString("bundle.upgrade.param.device.type"));
        UCD.setJComponentSize((JComponent)deviceTypeLabel, (Dimension)TITLE_LABEL_SIZE);
        JLabel deviceFormLabel = UiMethod.createLabel((String)RES.getString("bundle.upgrade.param.device.form"));
        UCD.setJComponentSize((JComponent)deviceFormLabel, (Dimension)TITLE_LABEL_SIZE);
        List<UpgradeDeviceEntity> upgradeDeviceEntityList = BundleUpgradeContext.getInstance().getSelectedDeviceEntities();
        this.deviceSelectCombo = new JComboBox();
        UCD.setJComponentSize(this.deviceSelectCombo, (Dimension)DEVICE_COMBO_SIZE);
        this.initDevicesComboBoxValue(upgradeDeviceEntityList);
        this.pcieCheckBox = new JCheckBox(RES.getString("bundle.upgrade.param.device.pcie"));
        JLabel infoTipIcon = new JLabel(UpgradeConstants.TIP_INFO_IMAGE);
        this.pcieCheckBox.setVisible(false);
        infoTipIcon.setVisible(false);
        this.obtainInfoBtn = new JButton(RES.getString("bundle.upgrade.param.read"));
        UCD.setJComponentSize((JComponent)this.obtainInfoBtn, (Dimension)DEVICE_COMBO_SIZE);
        JLabel descLabel = new JLabel(RES.getString("bundle.upgrade.param.title.desc"));
        infoTipIcon.setToolTipText(RES.getString("bundle.upgrade.pcie.refetch.tip"));
        String productType = upgradeDeviceEntityList.get(0).getDeviceEntity().getProductType();
        JLabel selectedDeviceType = new JLabel(productType);
        JLabel deviceFormDescLabel = new JLabel(RES.getString("bundle.upgrade.param.device.form.desc"));
        JComponent topBox = UCD.buildVerticalBox(null, (int)9, (Component[])new Component[]{UCD.buildHBoxLeft((Component[])new Component[]{descLabel}), UCD.buildHBoxLeft((Component[])new Component[]{deviceTypeLabel, selectedDeviceType}), UCD.buildHBoxLeft((Component[])new Component[]{UCD.buildVBoxTop((Component[])new Component[]{deviceFormLabel}), UCD.buildVBoxTop((Component[])new Component[]{UCD.buildHBoxLeft((Component[])new Component[]{deviceFormDescLabel}), UCD.buildHBoxLeft((Component[])new Component[]{this.deviceSelectCombo, this.pcieCheckBox, infoTipIcon}), UCD.buildHBoxLeft((Component[])new Component[]{this.obtainInfoBtn})})})});
        this.add((Component)topBox, "North");
    }

    private void initDevicesComboBoxValue(List<UpgradeDeviceEntity> upgradeDeviceEntityList) {
        this.deviceSelectCombo.addItem(RES.getString("bundle.upgrade.param.device.combo.default"));
        for (UpgradeDeviceEntity upgradeDeviceEntity : upgradeDeviceEntityList) {
            String ip = upgradeDeviceEntity.getDeviceEntity().getIp();
            this.deviceSelectCombo.addItem(ip);
        }
    }

    public JButton getObtainInfoBtn() {
        return this.obtainInfoBtn;
    }

    public JComboBox<String> getDeviceSelectCombo() {
        return this.deviceSelectCombo;
    }

    public JCheckBox getPcieCheckBox() {
        return this.pcieCheckBox;
    }
}

