/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.bundleupgrade.ui.layout.type;

import com.huawei.bundleupgrade.entity.UpgradeDeviceEntity;
import com.huawei.bundleupgrade.utils.BundleUpgradeContext;
import com.huawei.bundleupgrade.utils.UpgradeConstants;
import com.huawei.bundleupgrade.utils.UpgradeScenarioUtil;
import com.huawei.ism.tool.base.ui.UiMethod;
import com.huawei.ism.util.UCD;
import com.huawei.uMate.common.utils.ResUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class UpgradeTypeSelectMainLayout
extends JPanel {
    private static final ResUtil RES = ResUtil.getInstance((String)"BundleUpgrade");
    private JLabel selectUpgradeTypeLabel = new JLabel();
    private JRadioButton firmwareBtn;
    private JRadioButton spBtn;
    JComponent buttonBox;
    private JRadioButton localBtn;
    private JRadioButton onlineBtn;
    private JLabel selectedProductTypeLabel = new JLabel();

    public UpgradeTypeSelectMainLayout() {
        this.initUi();
    }

    private void initUi() {
        this.setLayout(new BorderLayout());
        this.selectUpgradeTypeLabel = UiMethod.createLabel((String)RES.getString("bundle.upgrade.type.panel.desc"));
        this.firmwareBtn = new JRadioButton(this.getBthDesc());
        this.spBtn = new JRadioButton(RES.getString("bundle.upgrade.type.panel.sp"));
        this.initSpBtn();
        ButtonGroup typeGroup = new ButtonGroup();
        typeGroup.add(this.firmwareBtn);
        typeGroup.add(this.spBtn);
        this.firmwareBtn.setSelected(true);
        List<UpgradeDeviceEntity> upgradeDeviceEntityList = BundleUpgradeContext.getInstance().getSelectedDeviceEntities();
        String productType = upgradeDeviceEntityList.get(0).getDeviceEntity().getProductType();
        this.selectedProductTypeLabel.setText(productType);
        this.localBtn = new JRadioButton(RES.getString("bundle.upgrade.type.panel.local"), true);
        this.onlineBtn = new JRadioButton(RES.getString("bundle.upgrade.type.panel.online"));
        this.onlineBtn.setVisible(!UpgradeScenarioUtil.isYinglong());
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.localBtn);
        buttonGroup.add(this.onlineBtn);
        JLabel devsTypeLabel = UiMethod.createLabel((String)RES.getString("bundle.upgrade.type.panel.product.type"));
        JLabel fetchPackageLabel = UiMethod.createLabel((String)RES.getString("bundle.upgrade.type.panel.upgrade.model"));
        UCD.setSameWidth((JComponent[])new JComponent[]{devsTypeLabel, fetchPackageLabel, this.selectUpgradeTypeLabel});
        Box titleBox = UCD.buildVBoxTop((int)12, (Component[])new Component[]{UCD.buildHBoxLeft((Component[])new Component[]{new JLabel(RES.getString("bundle.upgrade.type.panel.title"))}), UCD.buildHBoxLeft((Component[])new Component[]{devsTypeLabel, this.selectedProductTypeLabel})});
        JLabel onlineImportTipIcon = new JLabel(UpgradeConstants.TIP_INFO_IMAGE);
        onlineImportTipIcon.setToolTipText(RES.getString("bundle.upgrade.type.panel.local.desc"));
        JLabel offlineImportTipIcon = new JLabel(UpgradeConstants.TIP_INFO_IMAGE);
        offlineImportTipIcon.setToolTipText(RES.getString("bundle.upgrade.type.panel.online.desc"));
        Box typeBox = UCD.buildHBoxLeft((Component[])new Component[]{this.selectUpgradeTypeLabel, this.firmwareBtn, this.spBtn});
        this.buttonBox = UCD.buildHBoxLeft((Component[])new Component[]{fetchPackageLabel, this.localBtn, onlineImportTipIcon, this.onlineBtn, offlineImportTipIcon});
        Box topBox = UCD.buildVBoxTop((int)12, (Component[])new Component[]{titleBox, typeBox, this.buttonBox});
        this.add((Component)topBox, "North");
    }

    private String getBthDesc() {
        if (UpgradeScenarioUtil.isYinglong()) {
            return UpgradeScenarioUtil.isOutBound() ? RES.getString("bundle.upgrade.type.panel.fw") : RES.getString("bundle.upgrade.type.panel.driver");
        }
        return RES.getString("bundle.upgrade.type.panel.fw.or.driver");
    }

    private void initSpBtn() {
        boolean isAllSupportSp = BundleUpgradeContext.getInstance().getSelectedDeviceEntities().stream().allMatch(deviceEntity -> deviceEntity.getDeviceEntity().isSupportSp());
        this.spBtn.setVisible(isAllSupportSp);
    }

    public JRadioButton getLocalBtn() {
        return this.localBtn;
    }

    public JRadioButton getOnlineBtn() {
        return this.onlineBtn;
    }

    public JRadioButton getFirmwareBtn() {
        return this.firmwareBtn;
    }

    public JRadioButton getSpBtn() {
        return this.spBtn;
    }

    public JComponent getButtonBox() {
        return this.buttonBox;
    }
}

