/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.bundleupgrade.ui.listener;

import com.huawei.bundleupgrade.actions.CleanUpExecutionContextsAction;
import com.huawei.bundleupgrade.constants.UpgradeParamConstants;
import com.huawei.bundleupgrade.entity.UpgradeDeviceEntity;
import com.huawei.bundleupgrade.utils.BundleUpgradeContext;
import com.huawei.bundleupgrade.utils.UpgradeConstants;
import com.huawei.bundleupgrade.utils.UpgradeScenarioUtil;
import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.tool.base.utils.FileUtils;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.utils.CollectionUtil;
import com.huawei.ism.tool.service.sanbox.ISandBoxService;
import com.huawei.ism.tool.service.sanbox.SandBoxService;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.dialog.MultiErrorDialog;
import com.huawei.ism.ui.swing.dialog.ProgressDialog;
import com.huawei.ism.ui.swing.dialog.WarningDialog;
import com.huawei.uMate.common.utils.AppContext;
import com.huawei.uMate.common.utils.ResUtil;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import javax.swing.JFrame;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeWindowListener
extends WindowAdapter {
    private static final Logger log = LoggerFactory.getLogger(UpgradeWindowListener.class);
    private static final ResUtil RES = ResUtil.getInstance((String)"BundleUpgrade");
    protected ISandBoxService sandBoxService;
    private List<DevNode> sandboxCloseChange;

    @Override
    public void windowClosing(WindowEvent e) {
        WarningDialog wd;
        WarningDialog wd2;
        if (this.whetherHasUnfinishedUpgradeDevice()) {
            DialogUtils.showInfoDialog((Frame)AppContext.getInstance().getMainJFrame(), (String)RES.getString("upgrade.still.on.quit.may.corrupt"));
            return;
        }
        if (this.hasDeviceNotUpgraded() && (wd2 = DialogUtils.showYesNoDialog((Window)AppContext.getInstance().getMainJFrame(), (String)RES.getString("contains.device.not.performed.upgraded"))).getValue() != 0) {
            log.info("user cancelled quitting.");
            return;
        }
        this.sandBoxService = new SandBoxService();
        Map<DevNode, List<String>> sandboxCloseMap = BundleUpgradeContext.getInstance().getSandboxClosedMap();
        if (!sandboxCloseMap.isEmpty() && (wd = DialogUtils.showYesNoDialog((Window)AppContext.getInstance().getMainJFrame(), (String)RES.getString("sandbox.opened.text"))).getValue() == 0) {
            this.sandboxOpenWaiting(sandboxCloseMap);
        }
        CleanUpExecutionContextsAction closeAction = new CleanUpExecutionContextsAction();
        if (UpgradeScenarioUtil.containsFirmwarePackageOnlineDownloaded()) {
            WarningDialog wd3 = DialogUtils.showYesNoDialog((Window)AppContext.getInstance().getMainJFrame(), (String)RES.getString("if.should.save.packages.before.exit"));
            if (wd3.getValue() == 0) {
                log.info("user choose to exit without cleaning .");
            } else if (wd3.getValue() == 1) {
                log.info("user choose to exit and clean up saved firmware packages locally.");
                closeAction.cleanUpDownloadedPackages();
            } else {
                log.info("user cancelled quitting.");
                return;
            }
        }
        FileUtils.clearDir((String)UpgradeConstants.PAN_GEA_PACKAGE_TEMP_PATH);
        FileUtils.clearDir((String)UpgradeConstants.PSU_BBU_PACKAGE_TEMP_PATH);
        FileUtils.clearDir((String)UpgradeConstants.DISK_PACKAGE_TEMP_PATH);
        closeAction.doExecutionExit();
    }

    private boolean hasDeviceNotUpgraded() {
        List<UpgradeDeviceEntity> upgradeDevices = BundleUpgradeContext.getInstance().getDeviceUpgradeInfos();
        return upgradeDevices.stream().map(UpgradeDeviceEntity::getProcessStatus).anyMatch(status -> status == UpgradeParamConstants.UpgradeStatus.ASSOCIATED || status == UpgradeParamConstants.UpgradeStatus.NOTASSOCIATED);
    }

    private boolean whetherHasUnfinishedUpgradeDevice() {
        List<UpgradeDeviceEntity> upgradeDevices = BundleUpgradeContext.getInstance().getDeviceUpgradeInfos();
        return upgradeDevices.stream().map(UpgradeDeviceEntity::getProcessStatus).anyMatch(UpgradeScenarioUtil::isUpgradeNotFinished);
    }

    private void sandboxOpenWaiting(final Map<DevNode, List<String>> sandboxCloseMap) {
        String custMizeMsg = RES.getString("loading.open.text");
        JFrame parent = AppContext.getInstance().getMainJFrame();
        AsyncExcutor.execute((ProgressDialog)new ProgressDialog((Window)parent, custMizeMsg), (boolean)true, (long)0L, (Callable[])new Callable[]{new Callable<Boolean>(){

            @Override
            public Boolean call() {
                UpgradeWindowListener.this.sandboxOpen(sandboxCloseMap);
                return true;
            }
        }});
    }

    private void sandboxOpen(Map<DevNode, List<String>> sandboxCloseMap) {
        log.info("Start to enable the sandbox.");
        List errorIps = sandboxCloseMap.entrySet().stream().flatMap(entry -> this.setErrorIps((Map.Entry<DevNode, List<String>>)entry).stream()).collect(Collectors.toList());
        if (!CollectionUtil.isEmpty(errorIps)) {
            log.info(String.format(Locale.ENGLISH, "Failed to enable the sandbox for the following nodes:%s", errorIps));
            String[] headers = new String[]{RES.getString("sandbox.failed.open.ip")};
            List errorIpList = errorIps.stream().map(errorIp -> this.errorIpData((String)errorIp)).collect(Collectors.toList());
            MultiErrorDialog multiErrorDialog = DialogUtils.showMultiErrorDialog((Window)AppContext.getInstance().getMainJFrame(), (String)RES.getString("sandbox.enabled.retry"), (String[])headers, errorIpList, (Pair)Pair.of((Object)RES.getString("sandbox.enabled.btn.close"), (Object)RES.getString("sandbox.enabled.btn.retry")));
            log.info(String.format(Locale.ENGLISH, "The selected operation policy is:%s", multiErrorDialog.getDialogValue()));
            if (multiErrorDialog.getDialogValue() == 0) {
                this.sandboxOpen(sandboxCloseMap);
            }
        } else {
            DialogUtils.showInfoDialog((Frame)AppContext.getInstance().getMainJFrame(), (String)RES.getString("sandbox.enabled.success"));
            log.info("Sandbox enabled successfully.");
        }
    }

    private ArrayList<Object> errorIpData(String errorIp) {
        ArrayList<Object> ipData = new ArrayList<Object>();
        ipData.add(errorIp);
        return ipData;
    }

    private List<String> setErrorIps(Map.Entry<DevNode, List<String>> entry) {
        List successIps = this.sandBoxService.batchOpenSandBox(entry.getKey(), entry.getValue());
        return entry.getValue().stream().filter(ip -> !successIps.contains(ip)).collect(Collectors.toList());
    }
}

