/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.bundleupgrade.utils;

import com.huawei.bundleupgrade.entity.BaselineFirmwareBundle;
import com.huawei.bundleupgrade.entity.DeviceEntity;
import com.huawei.bundleupgrade.entity.FirmwarePackageEntity;
import com.huawei.bundleupgrade.entity.StrategySettingTableRowEntity;
import com.huawei.bundleupgrade.entity.UpgradeDeviceEntity;
import com.huawei.bundleupgrade.entity.UpgradeStrategyEntity;
import com.huawei.bundleupgrade.entity.fusionstrg.FusionStorageClusterInfoEntity;
import com.huawei.bundleupgrade.entity.fusionstrg.PanGeaPackageEntity;
import com.huawei.bundleupgrade.service.connection.fusionstrg.FusionStorageRestConnector;
import com.huawei.bundleupgrade.ui.BundleUpgradeMainDialog;
import com.huawei.bundleupgrade.ui.IUpgradeUiObserver;
import com.huawei.bundleupgrade.utils.UpgradeConstants;
import com.huawei.ism.tool.base.utils.AESEncrypt;
import com.huawei.ism.tool.framework.platform.context.AbstractContext;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.XmlUtils;
import com.huawei.uMate.common.SystemConfig;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BundleUpgradeContext
extends AbstractContext {
    public static final int TIME_OUT = 600000;
    private static final Logger LOGGER = LoggerFactory.getLogger(BundleUpgradeContext.class);
    private static boolean isOnlineFirmware = false;
    private static String recommendBase;
    private static final String XML_PRODUCT_NAME_VIEW_KEY = "view";
    private static final String XML_PRODUCT_NAME_MODEL_KEY = "model";
    private List<UpgradeDeviceEntity> selectedDeviceEntities = new ArrayList<UpgradeDeviceEntity>();
    private ConcurrentHashMap<String, UpgradeStrategyEntity> strategyEntityMap = new ConcurrentHashMap();
    private List<UpgradeDeviceEntity> deviceUpgradeInfos = new ArrayList<UpgradeDeviceEntity>();
    private List<UpgradeDeviceEntity> allDeviceList = new ArrayList<UpgradeDeviceEntity>();
    private ConcurrentHashMap<String, FirmwarePackageEntity> firmwarePackageMap = new ConcurrentHashMap();
    private Map<String, BaselineFirmwareBundle> baselineFirmwareBundleMap = new HashMap<String, BaselineFirmwareBundle>();
    private BundleUpgradeMainDialog mainDialog;
    private List<IUpgradeUiObserver> observers = new ArrayList<IUpgradeUiObserver>();
    private String latestStrategyUuid;
    private List<StrategySettingTableRowEntity> settingTableRowEntityList;
    private PanGeaPackageEntity panGeaPackageEntity = new PanGeaPackageEntity();
    private String houpUrl;
    private final Map<DevNode, List<String>> sandboxClosedMap = new HashMap<DevNode, List<String>>();
    private boolean isVerifyCert = false;
    private String fwTempId = System.currentTimeMillis() + "";
    private Map<String, String> productNameViewAndModel = new HashMap<String, String>();
    private String houpSk;

    public void setHoupSk(String sk) {
        this.houpSk = AESEncrypt.encrypt((String)sk);
    }

    public String getHoupSk() {
        return AESEncrypt.decrypt((String)this.houpSk);
    }

    public static BundleUpgradeContext getInstance() {
        return Holder.instance;
    }

    private BundleUpgradeContext() {
        this.loadStrategy();
    }

    private void loadStrategy() {
        File file = new File(new File(ApplicationContext.getInstance().getWorkPath()), "packages" + File.separator + "fusion_storage" + File.separator + "strategy.xml");
        if (!file.exists()) {
            LOGGER.warn("not found file:{}", (Object)file);
            return;
        }
        try (FileInputStream in = new FileInputStream(file);){
            Document doc = XmlUtils.parseDocument((InputStream)in);
            Element root = doc.getDocumentElement();
            NodeList nodeList = XmlUtils.searchNodeByExp((Element)root, (String)"nameMap/productName");
            if (nodeList == null) {
                LOGGER.error("Get null nodes by searching strategy.xml ");
                return;
            }
            this.initProductNameMap(nodeList);
        }
        catch (Exception e) {
            LOGGER.error("Failed to load strategy.xml");
        }
    }

    private void initProductNameMap(NodeList nodeList) {
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            Element ele = (Element)node;
            this.productNameViewAndModel.put(ele.getAttribute(XML_PRODUCT_NAME_VIEW_KEY), ele.getAttribute(XML_PRODUCT_NAME_MODEL_KEY));
        }
    }

    public static void updateProcessInfo(UpgradeDeviceEntity upgradeDevice, String detail, Double totalProgress, Boolean isSuccess) {
        BundleUpgradeContext.getInstance().getMainDialog().updateExecuteResult(upgradeDevice, detail, totalProgress, isSuccess);
    }

    public void addObserver(IUpgradeUiObserver observer) {
        this.observers.add(observer);
    }

    public void uiCallBack(UpgradeDeviceEntity upgradeDeviceEntity) {
        this.mainDialog.resultCallBack(upgradeDeviceEntity);
    }

    public BundleUpgradeMainDialog getMainDialog() {
        return this.mainDialog;
    }

    public void setMainDialog(BundleUpgradeMainDialog mainDialog) {
        this.mainDialog = mainDialog;
    }

    public Map<String, UpgradeStrategyEntity> getStrategyEntityMap() {
        return this.strategyEntityMap;
    }

    public List<UpgradeDeviceEntity> getDeviceUpgradeInfos() {
        return this.deviceUpgradeInfos;
    }

    public void setDeviceUpgradeInfos(List<UpgradeDeviceEntity> deviceUpgradeInfos) {
        this.deviceUpgradeInfos = deviceUpgradeInfos;
    }

    public ConcurrentHashMap<String, FirmwarePackageEntity> getFirmwarePackageMap() {
        return this.firmwarePackageMap;
    }

    public Map<String, BaselineFirmwareBundle> getBaselineFirmwareBundleMap() {
        return this.baselineFirmwareBundleMap;
    }

    public List<UpgradeDeviceEntity> getSelectedDeviceEntities() {
        return this.selectedDeviceEntities;
    }

    public void setSelectedDeviceEntities(List<UpgradeDeviceEntity> deviceEntities) {
        this.selectedDeviceEntities = deviceEntities;
    }

    public UpgradeDeviceEntity getDeviceNodeByIp(String devIp) {
        for (UpgradeDeviceEntity deviceNode : this.allDeviceList) {
            if (!deviceNode.getDeviceEntity().getIp().equals(devIp)) continue;
            return deviceNode;
        }
        return null;
    }

    public String getLatestStrategyUuid() {
        return this.latestStrategyUuid;
    }

    public void setLatestStrategyUuid(String latestStrategyUuid) {
        this.latestStrategyUuid = latestStrategyUuid;
    }

    public List<StrategySettingTableRowEntity> getSettingTableRowEntityList() {
        return this.settingTableRowEntityList;
    }

    public void setSettingTableRowEntityList(List<StrategySettingTableRowEntity> settingTableRowEntityList) {
        this.settingTableRowEntityList = settingTableRowEntityList;
    }

    public static boolean isOnlineFirmware() {
        return isOnlineFirmware;
    }

    public static void setIsOnlineFirmware(boolean isOnlineFirmware) {
        BundleUpgradeContext.isOnlineFirmware = isOnlineFirmware;
    }

    public String getRecommendBase() {
        return recommendBase;
    }

    public void setRecommendBase(String recommendBase) {
        BundleUpgradeContext.recommendBase = recommendBase;
    }

    public void setHoupUrl(String houpUrl) {
        this.houpUrl = houpUrl;
    }

    public String getHoupUrl() {
        return this.houpUrl == null ? "" : this.houpUrl;
    }

    public boolean isVerifyDevCert() {
        return SystemConfig.createSystemConfig().getIntConfigValue("isVerifyCert", 0) == 1;
    }

    public boolean isVerifyCert() {
        return this.isVerifyCert;
    }

    public void setVerifyCert(boolean verifyCert) {
        this.isVerifyCert = verifyCert;
    }

    public PanGeaPackageEntity getPanGeaPackageEntity() {
        return this.panGeaPackageEntity;
    }

    public void setPanGeaPackageEntity(PanGeaPackageEntity panGeaPackageEntity) {
        this.panGeaPackageEntity = panGeaPackageEntity;
    }

    public String getCurrentPangeaFwTempPath() {
        return UpgradeConstants.PAN_GEA_PACKAGE_TEMP_PATH + File.separator + this.fwTempId;
    }

    public String getCurrentPsuAndBbuFwTempPath() {
        return UpgradeConstants.PSU_BBU_PACKAGE_TEMP_PATH + File.separator + this.fwTempId;
    }

    public String getCurrentPanGeaAndPsuAndBbuPath() {
        return UpgradeConstants.PAN_GEA_PSU_BBU_PACKAGE_TEMP_PATH + File.separator + this.fwTempId;
    }

    public String getCurrentDiskFwTempPath() {
        return UpgradeConstants.DISK_PACKAGE_TEMP_PATH + File.separator + this.fwTempId;
    }

    public String getCurrentNodeTempPath(DeviceEntity device) {
        String deviceIpParam = device.getIp().replace(":", "_");
        return Paths.get(UpgradeConstants.PACKAGE_TEMP, deviceIpParam, BundleUpgradeContext.getInstance().getFwTempId()).toString();
    }

    public String getCurrentTempPath() {
        return Paths.get(UpgradeConstants.PACKAGE_TEMP, BundleUpgradeContext.getInstance().getFwTempId()).toString();
    }

    public void updateFwTempId() {
        this.fwTempId = System.currentTimeMillis() + "";
    }

    public String getProductModelName(String viewName) {
        return this.productNameViewAndModel.getOrDefault(viewName, viewName);
    }

    public boolean isSshAuthCheckOpen() {
        return Boolean.parseBoolean(SystemConfig.createSystemConfig().getConfigVlaue("fw.os.auth.check"));
    }

    public boolean isBmcAuthCheckOpen() {
        return Boolean.parseBoolean(SystemConfig.createSystemConfig().getConfigVlaue("fw.bmc.auth.check"));
    }

    public void recordSandboxClose(FusionStorageClusterInfoEntity fusionStorageClusterInfoEntity) {
        DevNode devNode = FusionStorageRestConnector.buildDevNode(fusionStorageClusterInfoEntity);
        List<String> successIps = fusionStorageClusterInfoEntity.getSandboxClosedList();
        BundleUpgradeContext.getInstance().getSandboxClosedMap().computeIfAbsent(devNode, key -> new ArrayList()).addAll(successIps);
    }

    public void setAllDeviceList(List<UpgradeDeviceEntity> allDeviceList) {
        this.allDeviceList = allDeviceList;
    }

    public List<UpgradeDeviceEntity> getAllDeviceList() {
        return this.allDeviceList;
    }

    public Map<DevNode, List<String>> getSandboxClosedMap() {
        return this.sandboxClosedMap;
    }

    public String getFwTempId() {
        return this.fwTempId;
    }

    private static final class Holder {
        private static final BundleUpgradeContext instance = new BundleUpgradeContext();

        private Holder() {
        }
    }
}

