/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.bundleupgrade.utils;

import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.base.utils.XmlUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class DomXMLUtil {
    private static DocumentBuilder documentBuilder = null;

    private DomXMLUtil() {
    }

    public static synchronized Document parseDocument(InputStream input) {
        Document document = null;
        try {
            document = documentBuilder.parse(input);
            document.normalize();
        }
        catch (IOException | SAXException exp) {
            LoggerFactory.getLogger(XmlUtils.class).error("exception on parse document.", (Throwable)exp);
        }
        return document;
    }

    public static ArrayList<Element> getChildren(Element parent, String childTagName) {
        ArrayList<Element> children = new ArrayList<Element>();
        if (null == parent) {
            return children;
        }
        for (Node child = parent.getFirstChild(); null != child; child = child.getNextSibling()) {
            if (!(child instanceof Element)) continue;
            Element element = (Element)child;
            String tagName = element.getTagName();
            if (null != childTagName && !childTagName.equals(tagName)) continue;
            children.add(element);
        }
        return children;
    }

    public static String getAttribute(Element element, String attribute) {
        String result = element.getAttribute(attribute);
        if (StringUtils.isNULLStr((String)result)) {
            return null;
        }
        return result.trim();
    }

    static {
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        try {
            builderFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            builderFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            builderFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            documentBuilder = builderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            LoggerFactory.getLogger(XmlUtils.class).error("documentBuilder build faild", (Throwable)e);
        }
    }
}

