/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.bundleupgrade.utils;

import com.huawei.bundleupgrade.constants.UpgradeParamConstants;
import com.huawei.bundleupgrade.entity.BaselineFirmwareBundle;
import com.huawei.bundleupgrade.entity.FirmwarePackageEntity;
import com.huawei.bundleupgrade.entity.fusionstrg.PanGeaPackageEntity;
import com.huawei.bundleupgrade.utils.BundleUpgradeContext;
import com.huawei.bundleupgrade.utils.ServiceUtil;
import com.huawei.bundleupgrade.utils.UpgradeConstants;
import com.huawei.bundleupgrade.utils.UpgradeScenarioUtil;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.uMate.common.UMateException;
import com.huawei.uMate.common.utils.ResUtil;
import com.huawei.uMate.common.utils.SecurityUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FirmwareXmlParseUtil {
    private static final Logger log = LoggerFactory.getLogger(FirmwareXmlParseUtil.class);
    private static final String FILE_PATH = "FilePath";
    private static final String BASELINE_REGEX = "(\\/[0-9]*\\/)";
    private static final ResUtil RES = ResUtil.getInstance((String)"BundleUpgrade");
    private static final String BIOS_VERSION_87 = "0.87";
    private static final String BIOS_VERSION_99 = "0.99";
    private static final String BMC_VERSION = "2.64";
    private static final String[] BIOS_VERSION_87_RESTRICTION = new String[]{"0x01011800", "0x01011900", "0x0101bb00", "0x01011500", "0x01011700", "0x0101ba00", "0x01011501", "0x01011701", "0x01043C00", "0x01043C02", "0x01030C00"};
    private static final String[] BIOS_VERSION_99_RESTRICTION = new String[]{"0x01080200", "0x01080300", "0x0108B500", "0x01045900"};
    private static final String X86 = "x86";
    private static final Map<String, FunctionInit> FUNCTION_MAP = new HashMap<String, FunctionInit>();

    private FirmwareXmlParseUtil() {
        throw new IllegalStateException("XmlParseUtil class");
    }

    public static List<String> getBaselineXmlPathFromIndexXml(String prefix, String indexXml) {
        ArrayList<String> baseLineList = new ArrayList<String>();
        try {
            Element rootElement;
            String indexXMLPath = prefix + File.separator + indexXml;
            log.info("start to parse index.xml");
            File indexXMLFile = new File(indexXMLPath);
            SAXReader saxReader = SecurityUtils.getSecuritySAXReader();
            Document document = saxReader.read(indexXMLFile);
            if (document != null) {
                rootElement = document.getRootElement();
                List baseLineElementList = rootElement.elements("BaseLine");
                for (Element baseLineElement : baseLineElementList) {
                    baseLineList.add(baseLineElement.elementText(FILE_PATH));
                }
            } else {
                log.error("failed to read index.xml.");
                return new ArrayList<String>();
            }
            Element recommendElement = rootElement.element("Recommend");
            FirmwareXmlParseUtil.addRecommendElement(recommendElement);
        }
        catch (DocumentException e) {
            log.error("failed to parse index.xml");
            return new ArrayList<String>();
        }
        log.info("parse index.xml successfully.");
        return baseLineList;
    }

    private static void addRecommendElement(Element recommendElement) {
        String recommendName;
        if (recommendElement != null && !StringUtils.isNULLStr((String)(recommendName = recommendElement.elementText("Name")))) {
            BundleUpgradeContext.getInstance().setRecommendBase(recommendName);
            log.info(recommendName);
        }
    }

    public static String getVersionXmlPathFromBaselineXml(String prefix, String baselineXml) {
        String versionXMLPath = "";
        String baselineXMLPath = prefix + File.separator + baselineXml;
        log.info("start to parse baseline.xml");
        try {
            Document document = FirmwareXmlParseUtil.getSafelySAXReaderDocument(baselineXMLPath);
            if (null == document) {
                log.error("failed to read baseline.xml");
                return versionXMLPath;
            }
            Element rootElement = document.getRootElement();
            Element firmwareBaseElement = rootElement.element("FirmwareBase");
            versionXMLPath = firmwareBaseElement.elementText(FILE_PATH);
        }
        catch (DocumentException e) {
            log.error("failed to parse baseline.xml");
            return versionXMLPath;
        }
        log.info("parse baseline.xml successfully.");
        return versionXMLPath;
    }

    public static BaselineFirmwareBundle getPackageInfoFromVersionXml(String prefix, String versionXml, String urlPrefix) {
        BaselineFirmwareBundle firmwareBundle;
        block4: {
            String versionXMLPath = prefix + File.separator + versionXml;
            firmwareBundle = new BaselineFirmwareBundle();
            log.info("start to parse version.xml");
            BundleUpgradeContext context = BundleUpgradeContext.getInstance();
            ConcurrentHashMap<String, FirmwarePackageEntity> cache = context.getFirmwarePackageMap();
            try {
                Document document = FirmwareXmlParseUtil.getSafelySAXReaderDocument(versionXMLPath);
                if (null != document) {
                    Element rootElement = document.getRootElement();
                    Element packageListElement = rootElement.element("PackageList");
                    List firmwarePackageList = packageListElement.elements("FirmwarePackage");
                    for (Element fwPackageElement : firmwarePackageList) {
                        FirmwarePackageEntity firmwarePackageEntity = new FirmwarePackageEntity();
                        FirmwareXmlParseUtil.parseFwPackageElement(fwPackageElement, firmwarePackageEntity, urlPrefix);
                        Element packageElement = fwPackageElement.element("Package");
                        FirmwarePackageEntity.PackageInfo packageInfo = FirmwareXmlParseUtil.parsePackageElement(firmwarePackageEntity, packageElement);
                        String packagePath = prefix + firmwarePackageEntity.getOnlineFilePath();
                        File file = new File(packagePath);
                        packageInfo.setIsExist(file.exists());
                        firmwarePackageEntity.setPackageInfo(packageInfo);
                        String key = ServiceUtil.getPackageInfoKey(firmwarePackageEntity);
                        cache.putIfAbsent(key, firmwarePackageEntity);
                        firmwareBundle.getPackageList().add(cache.get(key));
                    }
                    break block4;
                }
                log.error("failed to read version.xml");
                return null;
            }
            catch (DocumentException e) {
                log.error("failed to parse version.xml");
                return null;
            }
        }
        log.info("parse version.xml successfully.");
        return firmwareBundle;
    }

    private static Document getSafelySAXReaderDocument(String versionXMLPath) throws DocumentException {
        SAXReader saxReader = SecurityUtils.getSecuritySAXReader();
        return saxReader.read(new File(versionXMLPath));
    }

    private static void parseFwPackageElement(Element fwPackageElement, FirmwarePackageEntity firmwarePackageEntity, String urlPrefix) {
        firmwarePackageEntity.setOnlinePathAbs(urlPrefix + fwPackageElement.elementText(FILE_PATH).substring(1));
        firmwarePackageEntity.setOnlineFilePath(fwPackageElement.elementText(FILE_PATH));
        firmwarePackageEntity.setOnlineAesFilePathAbs(urlPrefix + fwPackageElement.elementText("FileAscPath").substring(1));
        firmwarePackageEntity.setSize(ServiceUtil.parseStringValueToInteger(fwPackageElement.elementText("Size")));
        firmwarePackageEntity.setType(fwPackageElement.elementText("Type"));
        Element productsElement = fwPackageElement.element("Products");
        List productElementList = productsElement.elements("Product");
        for (Element productElement : productElementList) {
            FirmwarePackageEntity.Product product = firmwarePackageEntity.new FirmwarePackageEntity.Product();
            product.setName(productElement.attributeValue("name"));
            product.setType(productElement.attributeValue("type"));
            firmwarePackageEntity.getProducts().add(product);
        }
        firmwarePackageEntity.setFirmwarePackageVersion(fwPackageElement.elementText("FirmwarePackageVersion"));
    }

    public static FirmwarePackageEntity.PackageInfo parsePackageElement(FirmwarePackageEntity firmwarePackageEntity, Element packageElement) throws DocumentException {
        FirmwarePackageEntity.PackageInfo packageEntity = firmwarePackageEntity.new FirmwarePackageEntity.PackageInfo();
        FirmwareXmlParseUtil.setFwPackageBaseline(firmwarePackageEntity);
        if ("Package".equals(packageElement.getName())) {
            String supportKernelVersion;
            String processorArchitecture;
            String packageType = packageElement.elementText("PackageType");
            packageEntity.setPackageType(!StringUtils.isNULLStr((String)packageType) ? packageType : "Unknown");
            packageEntity.setPackageName(packageElement.elementText("PackageName"));
            packageEntity.setRpmName(packageElement.elementText("RpmName"));
            packageEntity.setSummary(packageElement.elementText("Summary"));
            packageEntity.setDescription(packageElement.elementText("Description"));
            packageEntity.setVersionPattern(packageElement.elementText("VersionPattern"));
            packageEntity.setFileType(packageElement.elementText("FileType"));
            packageEntity.setMaxUpgradeTime(ServiceUtil.parseStringValueToInteger(packageElement.elementText("MaxUpgradeTime")));
            packageEntity.setMaxActiveTime(ServiceUtil.parseStringValueToInteger(packageElement.elementText("MaxActivetime")));
            packageEntity.setUpgradeAgent(packageElement.elementText("UpgradeAgent"));
            packageEntity.setUpgradeMode(packageElement.elementText("UpgradeMode"));
            packageEntity.setFileName(packageElement.elementText("FileName"));
            packageEntity.setModule(packageElement.elementText("Module"));
            packageEntity.setVersion(packageElement.elementText("Version"));
            packageEntity.setActiveMode(packageElement.elementText("ActiveMode"));
            packageEntity.setVendor(packageElement.elementText("Vendor"));
            packageEntity.setSupportModel(packageElement.elementText("SupportModel"));
            String supportModelUID = packageElement.elementText("SupportModelUID");
            if (!StringUtils.isNULLStr((String)supportModelUID)) {
                packageEntity.setSupportModelUID(supportModelUID);
            }
            String object = packageElement.elementText("Object");
            String objectID = packageElement.elementText("ObjectID");
            if (!StringUtils.isNULLStr((String)object) && !StringUtils.isNULLStr((String)objectID)) {
                packageEntity.setObject(object);
                packageEntity.setObjectID(objectID);
            }
            packageEntity.setProcessorArchitecture(StringUtils.isNULLStr((String)(processorArchitecture = packageElement.elementText("ProcessorArchitecture"))) ? X86 : processorArchitecture);
            if (!StringUtils.isNULLStr((String)processorArchitecture)) {
                packageEntity.setCpuArchitecture(processorArchitecture);
            }
            if (!StringUtils.isNULLStr((String)(supportKernelVersion = packageElement.elementText("SupportKernelVersion")))) {
                packageEntity.setSupportKernelVersion(supportKernelVersion);
            }
            FirmwareXmlParseUtil.checkFwPackageIsMeetVersionRequirements(packageEntity);
            return packageEntity;
        }
        log.error("failed to parse the element, the element's name is not Package.");
        throw new DocumentException();
    }

    public static FirmwarePackageEntity.InterfaceInfo parseInterfaceElement(FirmwarePackageEntity firmwarePackageEntity, Element interfaceElement) throws DocumentException {
        FirmwarePackageEntity.InterfaceInfo interfaceEntity = firmwarePackageEntity.new FirmwarePackageEntity.InterfaceInfo();
        if (!"Interfaces".equals(interfaceElement.getName())) {
            log.error("failed to parse the element, the element's name is not Package.");
            throw new DocumentException();
        }
        interfaceElement.elements().forEach(child -> {
            String func = child.elementText("Function");
            FUNCTION_MAP.getOrDefault(func, (info, ele) -> log.info(String.format(Locale.ENGLISH, "Unknown function %s ", func))).initFunction(interfaceEntity, (Element)child);
        });
        log.info(String.format(Locale.ENGLISH, "Interface GetVersion:%s, UpgradeVersion:%s, GetUpgradeStatus:%s", interfaceEntity.getGetVersionCmd(), interfaceEntity.getUpgradeCmd(), interfaceEntity.getGetUpgradeStatusCmd()));
        return interfaceEntity;
    }

    private static void initFunctionGetUpgradeStatus(FirmwarePackageEntity.InterfaceInfo interfaceEntity, Element child) {
        interfaceEntity.setGetUpgradeStatusCmd(child.elementText("Command"));
    }

    private static void initFunctionUpgradeVersion(FirmwarePackageEntity.InterfaceInfo interfaceEntity, Element child) {
        interfaceEntity.setUpgradeCmd(child.elementText("Command"));
    }

    private static void initFunctionGetVersion(FirmwarePackageEntity.InterfaceInfo interfaceEntity, Element child) {
        interfaceEntity.setGetVersionCmd(child.elementText("Command"));
        String uploadScript = child.elementText("uploadScript");
        interfaceEntity.setUploadScript(uploadScript);
    }

    public static PanGeaPackageEntity parsePanGeaIntraElement(Element element, PanGeaPackageEntity panGeaPackageEntity) {
        log.info("begin to parse pangea Package element");
        String borderType = element.elementText("BoardType");
        String uid = element.elementText("SupportModelUID").toLowerCase(Locale.ENGLISH);
        for (Element child : element.element("Sub-Modules").elements()) {
            String moduleName = child.elementText("Name").trim();
            String dependency = child.elementText("Dependency").trim();
            panGeaPackageEntity.addModuleWithUid(uid, moduleName);
            if (StringUtils.isNULLStr((String)dependency)) continue;
            List<String> dependList = Arrays.asList(dependency.split(","));
            panGeaPackageEntity.addSubModuleDependence(uid, moduleName, dependList);
            panGeaPackageEntity.addSubModuleDependence(borderType, moduleName, dependList);
        }
        log.info("parse pangea Package element success");
        return panGeaPackageEntity;
    }

    private static void setFwPackageBaseline(FirmwarePackageEntity firmwarePackageEntity) {
        if (StringUtils.isNULLStr((String)firmwarePackageEntity.getOnlinePathAbs())) {
            firmwarePackageEntity.setBaseline("localUpgradePackage");
        } else {
            String baseline = "";
            Pattern pattern = Pattern.compile(BASELINE_REGEX);
            Matcher matcher = pattern.matcher(firmwarePackageEntity.getOnlinePathAbs());
            if (matcher.find()) {
                String info = matcher.group(0);
                baseline = info.substring(1, info.length() - 1);
            }
            firmwarePackageEntity.setBaseline(baseline);
        }
    }

    private static void checkFwPackageIsMeetVersionRequirements(FirmwarePackageEntity.PackageInfo packageEntity) {
        String module = packageEntity.getModule();
        if (UpgradeParamConstants.ModuleType.iBMC.getModule().equalsIgnoreCase(module)) {
            FirmwareXmlParseUtil.checkFwPackageIsMeetBmcVersionRequirement(packageEntity);
        }
        if (UpgradeParamConstants.ModuleType.BIOS.getModule().equalsIgnoreCase(module)) {
            FirmwareXmlParseUtil.checkFwPackageIsMeetBiosVersionRequirement(packageEntity);
        }
    }

    private static void checkFwPackageIsMeetBmcVersionRequirement(FirmwarePackageEntity.PackageInfo packageEntity) {
        String packageVersion = packageEntity.getVersion();
        try {
            if (UpgradeScenarioUtil.isFromVersionLowerThanToVersion(packageVersion, BMC_VERSION)) {
                FirmwareXmlParseUtil.setNotSupportedFwPackageVersion(packageEntity);
            }
        }
        catch (UMateException e) {
            log.error(String.format(Locale.ENGLISH, "Failed to determine whether the firmware package version meets the requirements.Firmware package version: %s.", packageVersion));
        }
    }

    private static void checkFwPackageIsMeetBiosVersionRequirement(FirmwarePackageEntity.PackageInfo packageEntity) {
        String packageVersion = packageEntity.getVersion();
        try {
            if (FirmwareXmlParseUtil.isFwPackageContainsRestrictedProductFor87(packageEntity) && UpgradeScenarioUtil.isFromVersionLowerThanToVersion(packageVersion, BIOS_VERSION_87) || FirmwareXmlParseUtil.isFwPackageContainsRestrictedProductFor99(packageEntity) && UpgradeScenarioUtil.isFromVersionLowerThanToVersion(packageVersion, BIOS_VERSION_99)) {
                FirmwareXmlParseUtil.setNotSupportedFwPackageVersion(packageEntity);
            }
        }
        catch (UMateException e) {
            log.error(String.format(Locale.ENGLISH, "Failed to determine whether the firmware package version meets the requirements.Firmware package version: %s.", packageVersion));
        }
    }

    private static void setNotSupportedFwPackageVersion(FirmwarePackageEntity.PackageInfo packageEntity) {
        String packageVersion = packageEntity.getVersion() + RES.getString("bundle.upgrade.type.panel.local.not.support");
        packageEntity.setVersion(packageVersion);
    }

    private static boolean isFwPackageContainsRestrictedProductFor87(FirmwarePackageEntity.PackageInfo packageEntity) {
        for (String restrictedProduct : BIOS_VERSION_87_RESTRICTION) {
            if (!packageEntity.getSupportModelUID().toLowerCase(Locale.ENGLISH).contains(restrictedProduct.toLowerCase(Locale.ENGLISH))) continue;
            return true;
        }
        return false;
    }

    private static boolean isFwPackageContainsRestrictedProductFor99(FirmwarePackageEntity.PackageInfo packageEntity) {
        for (String restrictedProduct : BIOS_VERSION_99_RESTRICTION) {
            if (!packageEntity.getSupportModelUID().toLowerCase(Locale.ENGLISH).contains(restrictedProduct.toLowerCase(Locale.ENGLISH))) continue;
            return true;
        }
        return false;
    }

    public static void deleteTempFile() {
        log.info("start to delete those temporary downloaded files.");
        Path path = Paths.get(UpgradeConstants.TEMP_XML_DOWNLOAD, new String[0]);
        try {
            Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Files.delete(file);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    Files.delete(dir);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            log.error("failed to delete temp file.");
        }
        log.info("delete temp downloaded file successfully.");
    }

    static {
        FUNCTION_MAP.put("GetVersion", FirmwareXmlParseUtil::initFunctionGetVersion);
        FUNCTION_MAP.put("UpgradeVersion", FirmwareXmlParseUtil::initFunctionUpgradeVersion);
        FUNCTION_MAP.put("GetUpgradeStatus", FirmwareXmlParseUtil::initFunctionGetUpgradeStatus);
    }

    static interface FunctionInit {
        public void initFunction(FirmwarePackageEntity.InterfaceInfo var1, Element var2);
    }
}

