/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.bundleupgrade.utils;

import com.huawei.ism.tool.obase.utils.FileUtils;
import freemarker.cache.CacheStorage;
import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.MruCacheStorage;
import freemarker.cache.MultiTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.core.TemplateClassResolver;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FreeMarkerTemplateUtil {
    private static final Logger log = LoggerFactory.getLogger(FreeMarkerTemplateUtil.class);
    private static final String UTF8ENCODE = "UTF-8";
    private static final String TEMPLATE_DICTIONARY = "/config/templates/";
    private static final Configuration CONFIGURATION = new Configuration(Configuration.VERSION_2_3_28);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static boolean processFtl2TargetLocation(String ftlPath, Map<String, Object> data, String newFilePath) {
        File file = new File(newFilePath);
        FileUtils.createDir((String)file.getParent());
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(newFilePath), StandardCharsets.UTF_8));){
            Template template = CONFIGURATION.getTemplate(ftlPath, UTF8ENCODE);
            template.process(data, (Writer)writer);
            boolean bl = true;
            return bl;
        }
        catch (FileNotFoundException exp) {
            log.error("error occurred, file not found.");
            return false;
        }
        catch (IOException exp) {
            log.error("IO exception occurred.", (Throwable)exp);
            return false;
        }
        catch (TemplateException exp) {
            log.error("TemplateException exception occurred.", (Throwable)exp);
            return false;
        }
    }

    private FreeMarkerTemplateUtil() {
    }

    static {
        ClassTemplateLoader classTemplateLoader = new ClassTemplateLoader(FreeMarkerTemplateUtil.class, TEMPLATE_DICTIONARY);
        MultiTemplateLoader loader = new MultiTemplateLoader(new TemplateLoader[]{classTemplateLoader});
        CONFIGURATION.setNewBuiltinClassResolver(TemplateClassResolver.SAFER_RESOLVER);
        CONFIGURATION.setCacheStorage((CacheStorage)new MruCacheStorage(10, 200));
        CONFIGURATION.setLocale(Locale.getDefault());
        CONFIGURATION.clearEncodingMap();
        CONFIGURATION.setEncoding(Locale.CHINESE, UTF8ENCODE);
        CONFIGURATION.setTemplateLoader((TemplateLoader)loader);
    }
}

