/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.bundleupgrade.utils;

import com.huawei.bundleupgrade.utils.FsmNodeStatus;
import com.huawei.ism.tool.obase.utils.CollectionUtil;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FsmNode {
    private static final Logger log = LoggerFactory.getLogger(FsmNode.class);
    private FsmNodeStatus activeNode;
    private FsmNodeStatus standByNode;

    public FsmNode(List<FsmNodeStatus> fsmNodeStatuses) {
        if (CollectionUtil.isEmpty(fsmNodeStatuses)) {
            log.info("The active/standby node information cannot be queried.");
            return;
        }
        fsmNodeStatuses.forEach(this::setFsmNode);
    }

    private void setFsmNode(FsmNodeStatus fsmNodeStatus) {
        if ("active".equals(fsmNodeStatus.getRole())) {
            this.setActiveNode(fsmNodeStatus);
            return;
        }
        if ("standby".equals(fsmNodeStatus.getRole())) {
            this.setStandByNode(fsmNodeStatus);
        }
    }

    public void setActiveNode(FsmNodeStatus activeNode) {
        this.activeNode = activeNode;
    }

    public void setStandByNode(FsmNodeStatus standByNode) {
        this.standByNode = standByNode;
    }

    public FsmNodeStatus getActiveNode() {
        return this.activeNode;
    }

    public FsmNodeStatus getStandByNode() {
        return this.standByNode;
    }
}

