/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.bundleupgrade.utils;

import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.uMate.common.utils.ResUtil;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ItemProgressUpdateUtil {
    private static final ResUtil RES = ResUtil.getInstance((String)"BundleUpgrade");
    public static final ItemProgressUpdateUtil INS = new ItemProgressUpdateUtil();
    private Map<String, ProgressHolder> data = new ConcurrentHashMap<String, ProgressHolder>();

    private ItemProgressUpdateUtil() {
    }

    public void clear(String devId) {
        this.setProgress(devId, -1, "");
    }

    public void setProgress(String devId, int progress, String timeLeft) {
        if (StringUtils.isNULLStr((String)devId)) {
            return;
        }
        ProgressHolder holder = this.data.get(devId);
        if (null == holder) {
            holder = new ProgressHolder();
            this.data.put(devId, holder);
        }
        holder.setProgress(progress);
        holder.setTimeLeft(timeLeft);
    }

    public int getProgress(String devId) {
        if (StringUtils.isNULLStr((String)devId)) {
            return -1;
        }
        ProgressHolder holder = this.data.get(devId);
        if (holder == null) {
            return -1;
        }
        return holder.getProgress();
    }

    public String getTimeLeft(String devId) {
        if (StringUtils.isNULLStr((String)devId)) {
            return "";
        }
        ProgressHolder holder = this.data.get(devId);
        if (null == holder || StringUtils.isNULLStr((String)holder.getTimeLeft())) {
            return "";
        }
        return holder.getTimeLeft();
    }

    private static class ProgressHolder {
        private static final int MAX = 100;
        private static final int MIN = -1;
        private int progress = -1;
        private String timeLeft = "";

        private ProgressHolder() {
        }

        public int getProgress() {
            return this.progress;
        }

        public void setProgress(int progress) {
            this.progress = Math.min(100, Math.max(-1, progress));
        }

        public String getTimeLeft() {
            if (this.timeLeft.equals("")) {
                return "";
            }
            int second = Integer.parseInt(this.timeLeft);
            if (second < 60) {
                return RES.getStringWithParams("evalu.device.item.wait.progress.timeleft.second", new Object[]{second});
            }
            if (second < 3600) {
                int minute = second / 60;
                return RES.getStringWithParams("evalu.device.item.wait.progress.timeleft.minute", new Object[]{minute, second -= minute * 60});
            }
            int hour = second / 3600;
            int minute = (second - hour * 3600) / 60;
            second = second - hour * 3600 - minute * 60;
            return RES.getStringWithParams("evalu.device.item.wait.progress.timeleft.hour", new Object[]{hour, minute, second});
        }

        public void setTimeLeft(String timeLeft) {
            this.timeLeft = timeLeft == null ? this.timeLeft : timeLeft;
        }
    }
}

