/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.bundleupgrade.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.huawei.bundleupgrade.constants.BundleUpgradeConstants;
import com.huawei.bundleupgrade.entity.NodeServiceInfo;
import com.huawei.bundleupgrade.entity.NodeUpgradePriorityEnums;
import com.huawei.bundleupgrade.entity.UpgradeDeviceEntity;
import com.huawei.bundleupgrade.entity.fusionstrg.UpgDeviceExtendFSDataEntity;
import com.huawei.bundleupgrade.service.connection.fusionstrg.FusionStorageRestConnector;
import com.huawei.bundleupgrade.utils.fusionstrg.FusionStrgUpgradeContext;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.ManualConfigItemMgr;
import com.huawei.ism.tool.protocol.rest.RestConnection;
import com.huawei.ism.tool.protocol.rest.RestConnectionManager;
import com.huawei.ism.tool.protocol.rest.entity.ResponseInfo;
import com.huawei.ism.tool.protocol.utils.RestUtil;
import com.huawei.ism.tool.service.common.DevInfoUtil;
import com.huawei.ism.tool.service.rest.query.NodePoolService;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeServiceUtils {
    private static final Logger log = LoggerFactory.getLogger(NodeServiceUtils.class);
    private static final String CLUSTER_SERVERS = "/api/v2/cluster/servers";
    private static final String QUERY_ISCSI_PORTAL = "/dsware/service/cluster/dswareclient/queryIscsiPortal";
    private static final String QUERY_VBS_CLIENT_IP_LIST = "/dsware/service/cluster/dswareclient/queryDSwareClient";
    private static final String QUERY_STORAGE_POOL = "/dsware/service/resource/queryStoragePool";
    private static final String QUERY_NODE_DISK_INFO = "/dsware/service/cluster/storagepool/queryNodeDiskInfo";
    private static final String QUERY_NODE_DATA_ERASURE_STATUS = "/api/v2/data_service/query_node_data_erasure_status";
    private static final String NO_OPEN_ISCSI_SERVICE = "50155018";
    private static final String NO_VBS_CLIENT = "50000005";
    private static final String ERROR_CODE = "errorCode";
    private static final String RESULT = "result";
    private static NodePoolService nodePoolService = new NodePoolService();
    private static final ArrayList<Long> RE_CONN_RESPONSE_CODE = new ArrayList<Long>(Arrays.asList(BundleUpgradeConstants.ERRORCODE_USER_PERMISSION_ERROR, BundleUpgradeConstants.ERRORCODE_USER_CONNECT_ERROR));
    private static final Object lock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, NodeServiceInfo> queryNodeService(DevNode devNode, Set<String> nodeMgrIpSet) {
        ManualConfigItemMgr.getInstance().addItem(NodeServiceUtils.getPermanentIgnoreCheck(devNode) + "IscsiServiceCheck", "no", "Ignore iscsi check,If yes and only the storage pool service is used as a class A node.");
        Map<String, NodeServiceInfo> nodeMap = nodeMgrIpSet.stream().collect(Collectors.toMap(nodeMgrIp -> nodeMgrIp, NodeServiceInfo::new, (key1, key2) -> key1));
        Object object = lock;
        synchronized (object) {
            try {
                RestConnection conn = RestConnectionManager.getRestConnection((DevNode)devNode);
                String baseUri = RestUtil.getDstorageBaseUrlNoV2((DevNode)devNode);
                NodeServiceUtils.initInfo(devNode, nodeMap, conn, baseUri);
            }
            catch (Exception e) {
                nodeMap.values().forEach(nodeServiceInfo -> {
                    nodeServiceInfo.setQueryServiceError(true);
                    nodeServiceInfo.setQueryStoragePoolError(true);
                });
                RestConnectionManager.releaseConn((DevNode)devNode);
                log.error("Query fusionstorage nodes error:", (Throwable)e);
                return NodeServiceUtils.reQueryNodeServiceIfConnectError(devNode, nodeMgrIpSet);
            }
        }
        nodeMap.values().forEach(NodeServiceInfo::resetNodeUpgradePriorityByNodeServiceInfo);
        return nodeMap;
    }

    public static String getPermanentIgnoreCheck(DevNode devNode) {
        return String.join((CharSequence)"-", "permanent", devNode.getIp(), devNode.getDeviceSerialNumber());
    }

    private static void initInfo(DevNode devNode, Map<String, NodeServiceInfo> nodeMap, RestConnection conn, String baseUri) throws ToolException {
        NodeServiceUtils.initNodeServiceInfo(conn, nodeMap, baseUri, devNode);
        NodeServiceUtils.initNodeIscsiServiceInfo(devNode, conn, nodeMap, baseUri);
        NodeServiceUtils.initStorgePoolInfo(conn, nodeMap, baseUri);
        NodeServiceUtils.initDiskPoolInfo(devNode, nodeMap);
    }

    private static void initDiskPoolInfo(DevNode devNode, Map<String, NodeServiceInfo> nodeMap) throws ToolException {
        List managerIps = nodeMap.values().stream().map(NodeServiceInfo::getMgrIP).collect(Collectors.toList());
        if (!DevInfoUtil.isSupportDiskPool((DevNode)devNode)) {
            return;
        }
        Map diskIdMap = nodePoolService.getDiskIdMap(devNode, managerIps);
        if (Objects.isNull(diskIdMap)) {
            log.error("Failed to obtain the mapping between disk pool IDs and node IP addresses.");
            return;
        }
        nodeMap.values().forEach(nodeServiceInfo -> NodeServiceUtils.setDiskPoolId(nodeServiceInfo, diskIdMap));
    }

    private static void setDiskPoolId(NodeServiceInfo nodeServiceInfo, Map<String, List<String>> diskIdMap) {
        diskIdMap.entrySet().stream().filter(diskIdEntry -> ((List)diskIdEntry.getValue()).contains(nodeServiceInfo.getMgrIP())).forEach(diskIdEntry -> {
            nodeServiceInfo.setDiskPoolId((String)diskIdEntry.getKey());
            nodeServiceInfo.setSupportDiskPool(true);
        });
    }

    private static Map<String, NodeServiceInfo> reQueryNodeServiceIfConnectError(DevNode devNode, Set<String> nodeMgrIpSet) {
        Map<String, NodeServiceInfo> nodeMap = nodeMgrIpSet.stream().collect(Collectors.toMap(nodeMgrIp -> nodeMgrIp, NodeServiceInfo::new, (key1, key2) -> key1));
        try {
            RestConnection conn = RestConnectionManager.getRestConnection((DevNode)devNode);
            String baseUri = RestUtil.getDstorageBaseUrlNoV2((DevNode)devNode);
            NodeServiceUtils.initInfo(devNode, nodeMap, conn, baseUri);
        }
        catch (Exception e) {
            nodeMap.values().forEach(nodeServiceInfo -> {
                nodeServiceInfo.setQueryServiceError(true);
                nodeServiceInfo.setQueryStoragePoolError(true);
            });
            RestConnectionManager.releaseConn((DevNode)devNode);
            log.error("reQuery fusionstorage nodes error:", (Throwable)e);
        }
        nodeMap.values().forEach(NodeServiceInfo::resetNodeUpgradePriorityByNodeServiceInfo);
        return nodeMap;
    }

    public static boolean checkServiceInfoOrStoragePoolChange(UpgradeDeviceEntity deviceEntity) {
        NodeServiceInfo oldInfo = deviceEntity.getDeviceEntity().getNodeServiceInfo();
        if (oldInfo == null) {
            return true;
        }
        String nodeMgrIp = oldInfo.getMgrIP();
        UpgDeviceExtendFSDataEntity fsDataEntity = FusionStrgUpgradeContext.getInstance().getBusinessIpMapper().get(deviceEntity);
        DevNode devNode = FusionStorageRestConnector.buildDevNode(fsDataEntity.getBelongsClusterEntity());
        HashSet<String> nodeMgrIpSet = new HashSet<String>();
        nodeMgrIpSet.add(nodeMgrIp);
        NodeServiceInfo nowInfo = NodeServiceUtils.queryNodeService(devNode, nodeMgrIpSet).get(nodeMgrIp);
        if (nowInfo == null) {
            return true;
        }
        nowInfo.setVolumeNum(oldInfo.getVolumeNum());
        nowInfo.resetNodeUpgradePriorityByNodeServiceInfo();
        if (!oldInfo.getNodeUpgradePriority().equals((Object)nowInfo.getNodeUpgradePriority())) {
            return true;
        }
        return NodeServiceUtils.checkStoragePoolInfo(oldInfo, nowInfo);
    }

    private static boolean checkStoragePoolInfo(NodeServiceInfo oldInfo, NodeServiceInfo nowInfo) {
        if (oldInfo.getNodeUpgradePriority().equals((Object)NodeUpgradePriorityEnums.ONLY_STORAGE_POOL_SERVICE)) {
            String oldStoragePoolInfo = oldInfo.getStoragePoolId();
            String nowStoragePoolInfo = nowInfo.getStoragePoolId();
            if (Objects.isNull(oldStoragePoolInfo)) {
                return nowStoragePoolInfo != null;
            }
            if (!oldInfo.isSupportDiskPool()) {
                return !oldStoragePoolInfo.equals(nowStoragePoolInfo);
            }
            String oldDiskPoolId = oldInfo.getDiskPoolId();
            String newDiskPoolId = nowInfo.getDiskPoolId();
            if (Objects.isNull(oldDiskPoolId)) {
                return newDiskPoolId != null;
            }
            return !oldStoragePoolInfo.equals(nowStoragePoolInfo) || !oldDiskPoolId.equals(newDiskPoolId);
        }
        return false;
    }

    private static void initStorgePoolInfo(RestConnection restConnection, Map<String, NodeServiceInfo> nodeMap, String baseUri) throws ToolException {
        ResponseInfo storagePoolResp = restConnection.execGet(baseUri + QUERY_STORAGE_POOL);
        if (NodeServiceUtils.needReConnResponseCode(restConnection, storagePoolResp)) {
            storagePoolResp = restConnection.execGet(baseUri + QUERY_STORAGE_POOL);
        }
        log.info(storagePoolResp.getContent());
        if (NodeServiceUtils.hasErrorByResult(storagePoolResp)) {
            nodeMap.values().forEach(nodeServiceInfo -> nodeServiceInfo.setQueryStoragePoolError(true));
            return;
        }
        JSONObject data = (JSONObject)JSONObject.parseObject((String)storagePoolResp.getContent(), JSONObject.class);
        JSONArray storagePools = data.getJSONArray("storagePools");
        for (int i = 0; i < storagePools.size(); ++i) {
            JSONObject storagePool = storagePools.getJSONObject(i);
            Integer poolId = storagePool.getInteger("poolId");
            if (poolId == null) continue;
            List<String> nodeList = NodeServiceUtils.queryStoragePoplByPoolId(restConnection, poolId, baseUri, nodeMap);
            if (nodeList == null) {
                return;
            }
            nodeMap.values().forEach(nodeServiceInfo -> {
                if (nodeList.contains(nodeServiceInfo.getMgrIP())) {
                    nodeServiceInfo.setStoragePoolId(poolId.toString());
                }
            });
        }
    }

    private static List<String> queryStoragePoplByPoolId(RestConnection restConnection, Integer poolId, String baseUri, Map<String, NodeServiceInfo> nodeMap) throws ToolException {
        HashMap<String, Integer> storagePoolParam = new HashMap<String, Integer>();
        storagePoolParam.put("poolId", poolId);
        ResponseInfo storagePoolResp = restConnection.execGet(baseUri + QUERY_NODE_DISK_INFO, storagePoolParam);
        if (NodeServiceUtils.needReConnResponseCode(restConnection, storagePoolResp)) {
            storagePoolResp = restConnection.execGet(baseUri + QUERY_NODE_DISK_INFO, storagePoolParam);
        }
        if (storagePoolResp != null) {
            log.info(storagePoolResp.getContent());
        } else {
            log.error("Storage pool response is null");
        }
        ArrayList<String> nodeList = new ArrayList<String>();
        if (NodeServiceUtils.hasErrorByResult(storagePoolResp)) {
            nodeMap.values().forEach(nodeServiceInfo -> nodeServiceInfo.setQueryStoragePoolError(true));
            return null;
        }
        JSONObject data = (JSONObject)JSONObject.parseObject((String)storagePoolResp.getContent(), JSONObject.class);
        JSONArray nodeInfos = data.getJSONArray("nodeInfo");
        for (int i = 0; i < nodeInfos.size(); ++i) {
            JSONObject nodeInfo = nodeInfos.getJSONObject(i);
            String nodeMgrIp = nodeInfo.getString("nodeMgrIp");
            if (StringUtils.isNULLStr((String)nodeMgrIp)) continue;
            nodeList.add(nodeMgrIp);
        }
        return nodeList;
    }

    private static void initNodeServiceInfo(RestConnection restConnection, Map<String, NodeServiceInfo> nodeMap, String baseUri, DevNode devNode) throws ToolException {
        nodeMap.values().forEach(nodeServiceInfo -> nodeServiceInfo.setProductVersion(devNode.getProductVersion()));
        ResponseInfo nodesInfo = restConnection.execGet(baseUri + CLUSTER_SERVERS);
        if (NodeServiceUtils.needReConnResponseCode(restConnection, nodesInfo)) {
            nodesInfo = restConnection.execGet(baseUri + CLUSTER_SERVERS);
        }
        log.info(nodesInfo.getContent());
        if (NodeServiceUtils.hasError(nodesInfo)) {
            nodeMap.values().forEach(nodeServiceInfo -> nodeServiceInfo.setQueryServiceError(true));
            return;
        }
        NodeServiceUtils.paresNodeServices(nodesInfo, nodeMap);
    }

    private static void initNodeIscsiServiceInfo(DevNode devNode, RestConnection restConnection, Map<String, NodeServiceInfo> nodeMap, String baseUri) throws ToolException {
        if (ManualConfigItemMgr.getInstance().expected(NodeServiceUtils.getPermanentIgnoreCheck(devNode) + "IscsiServiceCheck", "yes")) {
            log.info("Ignore ISCSI check for dev {}", (Object)devNode.getIp());
            return;
        }
        ResponseInfo vbsClientIPListInfo = restConnection.execGet(baseUri + QUERY_VBS_CLIENT_IP_LIST);
        if (NodeServiceUtils.needReConnResponseCode(restConnection, vbsClientIPListInfo)) {
            vbsClientIPListInfo = restConnection.execGet(baseUri + QUERY_VBS_CLIENT_IP_LIST);
        }
        log.info(vbsClientIPListInfo.getContent());
        if (NodeServiceUtils.hasErrorByResult(vbsClientIPListInfo)) {
            if (NO_VBS_CLIENT.equals(NodeServiceUtils.getErrorByResult(vbsClientIPListInfo))) {
                return;
            }
            NodeServiceUtils.queryIscsiServiceByOneIp(restConnection, nodeMap, baseUri);
            return;
        }
        List<String> vbsClientIpList = NodeServiceUtils.getVBSClientIpList(vbsClientIPListInfo);
        Set<String> selectedVBSClientIpList = nodeMap.keySet().stream().filter(vbsClientIpList::contains).collect(Collectors.toSet());
        NodeServiceUtils.queryIscsiService(restConnection, nodeMap, selectedVBSClientIpList, baseUri);
    }

    private static void queryIscsiServiceByOneIp(RestConnection restConnection, Map<String, NodeServiceInfo> nodeMap, String baseUri) throws ToolException {
        for (String ip : nodeMap.keySet()) {
            HashSet<String> oneIp = new HashSet<String>();
            oneIp.add(ip);
            NodeServiceUtils.queryIscsiService(restConnection, nodeMap, oneIp, baseUri);
        }
    }

    private static void queryIscsiService(RestConnection restConnection, Map<String, NodeServiceInfo> nodeMap, Set<String> mgrIpSet, String baseUri) throws ToolException {
        Map<String, String> param = NodeServiceUtils.buildiIscsiParam(mgrIpSet);
        ResponseInfo iscsiServiceNodesInfo = restConnection.execPost(baseUri + QUERY_ISCSI_PORTAL, param);
        if (NodeServiceUtils.hasErrorByResult(iscsiServiceNodesInfo)) {
            mgrIpSet.forEach(mgrIp -> ((NodeServiceInfo)nodeMap.get(mgrIp)).setQueryServiceError(true));
            return;
        }
        NodeServiceUtils.paresIscsiServiceNodes(iscsiServiceNodesInfo, nodeMap);
    }

    private static Map<String, String> buildiIscsiParam(Set<String> nodes) {
        if (nodes.isEmpty()) {
            return null;
        }
        HashMap<String, String> iscsiParam = new HashMap<String, String>();
        iscsiParam.put("nodeMgrIps", "[\"" + String.join((CharSequence)"\",\"", nodes) + "\"]");
        return iscsiParam;
    }

    private static boolean hasError(ResponseInfo responseInfo) {
        if (responseInfo == null) {
            return true;
        }
        Long errorCode = (Long)responseInfo.getContentMap().get(ERROR_CODE);
        return errorCode != null && 0L != errorCode;
    }

    private static boolean hasErrorByResult(ResponseInfo responseInfo) {
        if (responseInfo == null) {
            return true;
        }
        JSONObject data = (JSONObject)JSONObject.parseObject((String)responseInfo.getContent(), JSONObject.class);
        Integer result = data.getInteger(RESULT);
        if (result != null && result != 0) {
            return true;
        }
        String errorCodeByData = data.getString(ERROR_CODE);
        return !StringUtils.isNULLStr((String)errorCodeByData) && !"0".equals(errorCodeByData);
    }

    private static String getErrorByResult(ResponseInfo responseInfo) {
        if (responseInfo == null) {
            return null;
        }
        JSONObject data = (JSONObject)JSONObject.parseObject((String)responseInfo.getContent(), JSONObject.class);
        return data.getString(ERROR_CODE);
    }

    private static void paresNodeServices(ResponseInfo responseInfo, Map<String, NodeServiceInfo> nodeMap) {
        Object data = responseInfo.getContentMap().get("data");
        JSONArray nodesArray = (JSONArray)JSONObject.parseObject((String)data.toString(), JSONArray.class);
        for (int i = 0; i < nodesArray.size(); ++i) {
            JSONObject node = nodesArray.getJSONObject(i);
            String managementIp = node.getString("management_ip");
            String sandboxstatus = node.getOrDefault((Object)"sandbox_status", (Object)"Null").toString();
            JSONArray usageArray = node.getJSONArray("usage");
            JSONArray rolesArray = node.getJSONArray("role");
            if (rolesArray.contains((Object)"management")) {
                usageArray.add((Object)"fsm_manager");
            }
            if (managementIp == null || usageArray == null || !nodeMap.containsKey(managementIp)) continue;
            NodeServiceInfo nodeServiceInfo = nodeMap.get(managementIp);
            nodeServiceInfo.setSandboxStatus(sandboxstatus);
            nodeServiceInfo.getServiceInfo().addAll(usageArray.toJavaList(String.class));
            nodeServiceInfo.resetNodeUpgradePriorityByNodeServiceInfo();
        }
    }

    private static void paresIscsiServiceNodes(ResponseInfo responseInfo, Map<String, NodeServiceInfo> nodeMap) {
        JSONObject data = (JSONObject)JSONObject.parseObject((String)responseInfo.getContent(), JSONObject.class);
        JSONArray nodesArray = data.getJSONArray("nodeResultList");
        for (int i = 0; i < nodesArray.size(); ++i) {
            JSONObject node = nodesArray.getJSONObject(i);
            String managementIp = node.getString("nodeMgrIp");
            if (StringUtils.isNULLStr((String)managementIp) || !nodeMap.containsKey(managementIp)) {
                return;
            }
            String errorCode = node.getString(ERROR_CODE);
            NodeServiceInfo nodeServiceInfo = nodeMap.get(managementIp);
            if (!StringUtils.isNULLStr((String)errorCode) && !"0".equals(errorCode)) {
                if (NO_OPEN_ISCSI_SERVICE.equals(errorCode) || NO_VBS_CLIENT.equals(errorCode)) continue;
                nodeServiceInfo.setQueryServiceError(true);
                continue;
            }
            nodeServiceInfo.getServiceInfo().add("iscsi");
            nodeServiceInfo.resetNodeUpgradePriorityByNodeServiceInfo();
        }
    }

    private static List<String> getVBSClientIpList(ResponseInfo vbsClientIPListInfo) {
        JSONObject data = (JSONObject)JSONObject.parseObject((String)vbsClientIPListInfo.getContent(), JSONObject.class);
        JSONArray vbsClientIpListArray = data.getJSONArray("nodeMgrIp");
        return vbsClientIpListArray.toJavaList(String.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean needReConnResponseCode(RestConnection conn, ResponseInfo resp) throws ToolException {
        long errorCode = NodeServiceUtils.getErrorCode(resp);
        for (Long reconnCode : RE_CONN_RESPONSE_CODE) {
            if (errorCode != reconnCode) continue;
            Object object = lock;
            synchronized (object) {
                conn.reLogin();
            }
            log.info("Reconnect session by special error code {}", (Object)reconnCode);
            return true;
        }
        return false;
    }

    private static long getErrorCode(ResponseInfo resp) {
        if (resp == null) {
            log.error("resp null or resp does not contain error code.");
            return -1L;
        }
        if (resp.getContentMap().containsKey(ERROR_CODE)) {
            return (Long)resp.getContentMap().get(ERROR_CODE);
        }
        if (resp.getContentMap().containsKey("code")) {
            return (Long)resp.getContentMap().get("code");
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String queryStoragePoolInfo(DevNode devNode) {
        Object object = lock;
        synchronized (object) {
            try {
                RestConnection conn = RestConnectionManager.getRestConnection((DevNode)devNode);
                String baseUri = RestUtil.getDstorageBaseUrlNoV2((DevNode)devNode);
                ResponseInfo storagePoolResp = conn.execGet(baseUri + QUERY_STORAGE_POOL);
                String string = storagePoolResp.getContent();
                return string;
            }
            catch (Exception e) {
                log.error("Query fusionstorage nodes error:", (Throwable)e);
            }
            finally {
                RestConnectionManager.releaseConn((DevNode)devNode);
            }
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResponseInfo queryNodeDataErasureStatus(DevNode devNode, Map param) throws ToolException {
        try {
            RestConnection connection = RestConnectionManager.getRestConnection((DevNode)devNode);
            if (!connection.isLogin()) {
                throw new ToolException("login failed please try again");
            }
            String dstorageUrlHead = RestUtil.getDstorageUrlHead((DevNode)devNode);
            ResponseInfo responseInfo = connection.execGetWithBody(dstorageUrlHead + QUERY_NODE_DATA_ERASURE_STATUS, param);
            if (responseInfo == null) {
                throw new ToolException("net error please try again");
            }
            ResponseInfo responseInfo2 = responseInfo;
            return responseInfo2;
        }
        finally {
            RestConnectionManager.releaseConn((DevNode)devNode);
        }
    }

    public static List<String> getNodeIpsInErasureStatusIp(ResponseInfo responseInfo) {
        JSONObject contentObject = JSON.parseObject((String)responseInfo.getContent());
        JSONArray data = contentObject.getJSONArray("data");
        ArrayList<String> nodesInDataWipe = new ArrayList<String>();
        for (int i = 0; i < data.size(); ++i) {
            if (data.getJSONObject(i).getInteger(RESULT) == 0) continue;
            nodesInDataWipe.add(data.getJSONObject(i).getString("ip"));
        }
        return nodesInDataWipe;
    }

    static {
        File ignoreFile = new File(ApplicationContext.getInstance().getWorkPath(), "ignoreConfig.txt");
        ManualConfigItemMgr.getInstance().init(ignoreFile);
    }
}

