/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.bundleupgrade.utils;

import com.huawei.bundleupgrade.utils.UpgradeScenarioUtil;
import com.huawei.ism.tool.framework.platform.exception.SignException;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.pyengine.engine.JythonExecuter;
import com.huawei.uMate.common.UMateException;
import com.huawei.uMate.common.utils.ResUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PythonExecuteUtils {
    private static final Logger log = LoggerFactory.getLogger(PythonExecuteUtils.class);
    private static final ResUtil RES = ResUtil.getInstance((String)"BundleUpgrade");

    public static String executeScripts(String canonicalScriptPath, Map<String, Object> envs) throws UMateException {
        List<File> scriptDir = UpgradeScenarioUtil.getAllDirectoriesInTargetDir(canonicalScriptPath);
        log.info("execution script {}.", (Object)canonicalScriptPath);
        try {
            JythonExecuter executor = new JythonExecuter(scriptDir);
            executor.compileScript(FileUtils.getFile((String[])new String[]{canonicalScriptPath}));
            List ret = executor.invokeFunction("execute", envs);
            return PythonExecuteUtils.parseScriptResults(ret);
        }
        catch (FileNotFoundException fnf) {
            log.error("file {} not found, tools parts broken.", (Object)FileUtils.getFile((String[])new String[]{canonicalScriptPath}).getName());
            throw new UMateException(RES.getString("tool.parts.lost.please.reinstall"));
        }
        catch (SignException signE) {
            log.error("sign exception:", (Throwable)signE);
            throw new UMateException(RES.getString("sign.exception.might.altered"));
        }
        catch (UMateException e) {
            log.error("Business exception:", (Throwable)e);
            throw e;
        }
        catch (ToolException exception) {
            log.error("exception occurred :", (Throwable)exception);
            throw new UMateException(RES.getString("script.execution.failed.after.retry.all.times"));
        }
    }

    private static String parseScriptResults(List<Object> ret) throws UMateException {
        if (null == ret || ret.size() < 2) {
            log.error("the script's execution result is not valid!");
            throw new UMateException("script.execution.not.recognized.result");
        }
        try {
            if (!Boolean.parseBoolean((String)ret.get(0))) {
                return (String)ret.get(1);
            }
        }
        catch (ClassCastException exp) {
            log.error("class cast exception:", (Throwable)exp);
            throw new UMateException("script.execution.not.recognized.result");
        }
        return "";
    }

    public static String intoCanonicalScriptPath(String targetScriptFilePath) {
        String targetAbsPath = ApplicationContext.getInstance().getPackagesPath() + File.separator + targetScriptFilePath;
        try {
            return FileUtils.getFile((String[])new String[]{targetAbsPath}).getCanonicalPath();
        }
        catch (IOException e) {
            log.error("failed to get canonical path of {}.", (Object)targetAbsPath);
            return targetAbsPath;
        }
    }
}

