/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.bundleupgrade.utils;

import com.huawei.bundleupgrade.constants.BundleUpgradeConstants;
import com.huawei.bundleupgrade.entity.TaskResult;
import com.huawei.bundleupgrade.utils.BundleUpgradeContext;
import com.huawei.ism.tool.base.utils.FilePathUtils;
import com.huawei.ism.tool.base.utils.SHAAndRSAVerifyUtils;
import com.huawei.ism.tool.certbase.integrity.CheckFileIntegrityUtils;
import com.huawei.ism.tool.certbase.integrity.Sha256CheckTool;
import com.huawei.ism.tool.framework.platform.exception.SignException;
import com.huawei.ism.tool.obase.utils.FileUtils;
import com.huawei.ism.util.Pair;
import com.huawei.uMate.common.utils.ResUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SHAAndRSASignCheckUtil {
    private static final ResUtil RES = ResUtil.getInstance((String)"BundleUpgrade");
    private static final Logger LOGGER = LoggerFactory.getLogger(SHAAndRSASignCheckUtil.class);
    private static List<Pair<String, String>> fileAndSha256List = Collections.synchronizedList(new ArrayList());
    private static final List<String> PANGEA_FILE_PATH_LIST = Collections.synchronizedList(new ArrayList());

    private SHAAndRSASignCheckUtil() {
    }

    public static void verifyEntireDirScriptsSignature(File dir) {
        ArrayList scripts = new ArrayList();
        try {
            Stream<Path> walk = Files.walk(dir.toPath(), new FileVisitOption[0]);
            Object object = null;
            try {
                scripts.addAll(new HashSet(walk.filter(path -> path.toFile().isFile() && path.toFile().getName().endsWith(".py")).map(Path::toFile).collect(Collectors.toList())));
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (walk != null) {
                    if (object != null) {
                        try {
                            walk.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        walk.close();
                    }
                }
            }
        }
        catch (IOException ioE) {
            LOGGER.error("io exception occurred.", (Throwable)ioE);
        }
        boolean isPass = false;
        for (File file : scripts) {
            if (file.length() == 0L) continue;
            try {
                isPass = SHAAndRSAVerifyUtils.getInstance().verify(file);
            }
            catch (Exception var7) {
                LOGGER.error(String.format(Locale.ENGLISH, "[%s]verify Script error!", file.getPath()), (Throwable)var7);
            }
            if (isPass) continue;
            throw new SignException();
        }
    }

    public static List<TaskResult<String>> checkSha256Sum(String rootDir, String sha256FilePath) {
        return SHAAndRSASignCheckUtil.checkSha256Sum(SHAAndRSASignCheckUtil.loadSha256File(rootDir, sha256FilePath));
    }

    public static List<TaskResult<String>> checkSha256Sum(List<Pair<String, String>> fileAndSha256List) {
        Sha256CheckTool ins = Sha256CheckTool.getInstance();
        return fileAndSha256List.parallelStream().map(pair -> SHAAndRSASignCheckUtil.checkFile(ins, (Pair<String, String>)pair)).collect(Collectors.toList());
    }

    private static TaskResult<String> checkFile(Sha256CheckTool ins, Pair<String, String> pair) {
        if (!new File((String)pair.getKey()).exists()) {
            return new TaskResult<Object>(pair.getKey(), RES.getString("parse.pangea.pkg.err.fileNotFound"), false);
        }
        if (!ins.isFileSha256Valid((String)pair.getKey(), (String)pair.getValue())) {
            return new TaskResult<Object>(pair.getKey(), RES.getString("parse.pangea.pkg.err.checkFailed"), false);
        }
        return new TaskResult<Object>(pair.getKey(), "", true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<Pair<String, String>> loadSha256File(String rootDir, String sha256FilePath) {
        fileAndSha256List.clear();
        PANGEA_FILE_PATH_LIST.clear();
        try (BufferedReader fis = new BufferedReader(new FileReader(sha256FilePath));){
            String line;
            while ((line = fis.readLine()) != null) {
                String[] data = line.split("\\s\\s");
                fileAndSha256List.add((Pair<String, String>)new Pair((Object)FilePathUtils.checkFile((String)new File(rootDir, data[1]).getCanonicalPath()), (Object)data[0]));
                PANGEA_FILE_PATH_LIST.add(new File(rootDir, data[1]).getCanonicalPath());
            }
            List<Pair<String, String>> list = fileAndSha256List;
            return list;
        }
        catch (FileNotFoundException e) {
            LOGGER.error("Can not find sha256 file {}", (Object)new File(sha256FilePath).getName());
            return Collections.emptyList();
        }
        catch (Exception e) {
            LOGGER.error("Check sha256 file failed: {}", (Object)sha256FilePath, (Object)e);
            return Collections.emptyList();
        }
    }

    public static List<String> getSignatureFailedFileInfos(String filePath) {
        List signatureFailedPaths;
        if (!PANGEA_FILE_PATH_LIST.contains(filePath)) {
            LOGGER.info("The file {} not involve signature verification and skipped.", (Object)new File(filePath).getName());
            return Collections.emptyList();
        }
        String rootDir = BundleUpgradeContext.getInstance().getCurrentPanGeaAndPsuAndBbuPath();
        String certPath = BundleUpgradeConstants.Pangea.HUAWEI_ROOT_CA;
        String sourceFile = String.join((CharSequence)File.separator, rootDir, "sha256sum_sync");
        String crl = String.join((CharSequence)File.separator, rootDir, "crldata.crl");
        String cms = String.join((CharSequence)File.separator, rootDir, "sha256sum_sync.cms");
        if (!CheckFileIntegrityUtils.checkFileByCms((String)certPath, (String)sourceFile, (String)crl, (String)cms)) {
            LOGGER.warn("Pangea package check failed,ignore this package and clear unzip dir {}.", (Object)rootDir);
            FileUtils.clearDir((String)rootDir);
            return Collections.singletonList(RES.getString("bundle.upgrade.select.local.error1"));
        }
        if (fileAndSha256List.isEmpty()) {
            fileAndSha256List = SHAAndRSASignCheckUtil.loadSha256File(rootDir, sourceFile);
        }
        if ((signatureFailedPaths = SHAAndRSASignCheckUtil.checkSha256Sum(fileAndSha256List).stream().filter(result -> !result.isSuccess()).map(TaskResult::getSource).collect(Collectors.toList())).contains(filePath)) {
            String errorMsg = RES.getString("upgrade.pangea.pkg.err.checkFailed", new Object[]{new File(filePath).getName()});
            return Collections.singletonList(errorMsg);
        }
        return Collections.emptyList();
    }
}

