/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.bundleupgrade.utils;

import com.huawei.bundleupgrade.constants.UpgradeParamConstants;
import com.huawei.bundleupgrade.utils.DomXMLUtil;
import com.huawei.bundleupgrade.utils.UpgradeScenarioUtil;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ScriptConfigUtil {
    private static final Logger log = LoggerFactory.getLogger(ScriptConfigUtil.class);
    private static final String XML_TAG_OUT_BAND = "outBand";
    private static final String XML_TAG_IN_BAND = "inBand";
    private static final String XML_ATTR_TAG_PATH = "path";
    private static final String CONFIG_FILE_PATH = ApplicationContext.getInstance().getPackagesPath() + File.separator + "script_config.xml";

    private ScriptConfigUtil() {
    }

    public static String getScriptRelativePath(UpgradeParamConstants.ModuleType module) {
        String tag = UpgradeScenarioUtil.getOutBandToBeUpgradeModules(Collections.singletonList(module)).isEmpty() ? XML_TAG_IN_BAND : XML_TAG_OUT_BAND;
        return ScriptConfigUtil.getScriptPathFromScriptConfig(module.getModule(), tag);
    }

    public static String getScriptRelativePath(String tagName, String subTagName) {
        return ScriptConfigUtil.getScriptPathFromScriptConfig(subTagName, tagName);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getScriptPathFromScriptConfig(String module, String tag) {
        try (FileInputStream stream = new FileInputStream(CONFIG_FILE_PATH);){
            Document document = DomXMLUtil.parseDocument(stream);
            if (null == document) {
                log.error("Failed to parse the script_config XML file.");
                String string = "";
                return string;
            }
            Element root = document.getDocumentElement();
            ArrayList<Element> scriptPathElement = DomXMLUtil.getChildren(root, tag);
            if (scriptPathElement.isEmpty()) {
                log.error("Failed to parse the script_config XML file.");
                String string = "";
                return string;
            }
            Element element = scriptPathElement.get(0);
            String supperPath = DomXMLUtil.getAttribute(element, XML_ATTR_TAG_PATH);
            if (!StringUtils.isNULLStr((String)supperPath)) {
                String string = supperPath;
                return string;
            }
            ArrayList<Element> moduleEle = DomXMLUtil.getChildren(element, module);
            if (moduleEle.isEmpty()) {
                log.error("Failed to obtain the upgrade script execution path.");
                String string = "";
                return string;
            }
            element = moduleEle.get(0);
            supperPath = DomXMLUtil.getAttribute(element, XML_ATTR_TAG_PATH);
            if (!StringUtils.isNULLStr((String)supperPath)) {
                String string = supperPath;
                return string;
            }
        }
        catch (FileNotFoundException exp) {
            log.error(String.format(Locale.ENGLISH, "target file %s not found !", "script_config.xml"));
        }
        catch (IOException exp) {
            log.error(String.format(Locale.ENGLISH, "io exception on parsing ! %s", exp));
        }
        log.error("Failed to obtain the upgrade script execution path.");
        return "";
    }
}

