/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.bundleupgrade.utils;

import com.huawei.bundleupgrade.entity.FirmwarePackageEntity;
import com.huawei.bundleupgrade.service.connection.fusionstrg.FusionStorageSshConnector;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.uMate.common.UMateException;
import com.huawei.uMate.common.utils.ResUtil;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptExecuteUtil {
    private static final Logger log = LoggerFactory.getLogger(ScriptExecuteUtil.class);
    public static final ResUtil RES = ResUtil.getInstance((String)"BundleUpgrade");
    public static final String EXECUTE_FAIL = RES.getString("bundle.upgrade.execute.script.fail");

    private static List<String> execAndGetReturn(FusionStorageSshConnector ssh, String cmd) throws Exception {
        String cmdResult = ssh.executeCmd(cmd);
        if (StringUtils.isNULLStr((String)cmdResult)) {
            return Collections.emptyList();
        }
        List<String> resultList = Arrays.asList(cmdResult.split("\n"));
        if (resultList.size() <= 1) {
            log.info("Parsing result error,original ret: {}", (Object)cmdResult);
            return resultList;
        }
        return resultList.subList(1, resultList.size() - 1);
    }

    public static List<String> uploadAndExecuteScript(FusionStorageSshConnector ssh, ScriptType scriptType, String sourceScript, String targetDir) {
        try {
            String fileName = new File(sourceScript).getName();
            ssh.mkdirs(targetDir);
            String targetFile = targetDir + '/' + fileName;
            ssh.uploadFile(targetFile, sourceScript, true);
            String cmd = scriptType.completeCommand(targetFile);
            return ScriptExecuteUtil.execAndGetReturn(ssh, cmd);
        }
        catch (UMateException e) {
            log.error("get ssh connector fail.", (Throwable)e);
        }
        catch (Exception e) {
            log.error("execute ssh cmd fail.", (Throwable)e);
        }
        return Collections.singletonList(EXECUTE_FAIL);
    }

    public static void removeDir(FusionStorageSshConnector ssh, String targetDir) {
        try {
            String cmdRemove = String.format(Locale.ROOT, "rm -rf %s", targetDir);
            ssh.executeCmd(cmdRemove);
        }
        catch (UMateException e) {
            log.error("get ssh connector fail.", (Throwable)e);
        }
        catch (Exception e) {
            log.error("remove dir {} fail.", (Object)targetDir, (Object)e);
        }
    }

    public static String catRstFile(FusionStorageSshConnector ssh, String filePath) {
        try {
            String cmdCat = String.format(Locale.ROOT, "cat %s", filePath);
            List<String> catResult = ScriptExecuteUtil.execAndGetReturn(ssh, cmdCat);
            String cmdRemove = String.format(Locale.ROOT, "rm -f %s", filePath);
            ssh.executeCmd(cmdRemove);
            if (catResult.size() < 1) {
                return EXECUTE_FAIL;
            }
            return catResult.get(0).trim();
        }
        catch (UMateException e) {
            log.error("get ssh connector fail.", (Throwable)e);
        }
        catch (Exception e) {
            log.error("execute ssh cmd fail.", (Throwable)e);
        }
        return EXECUTE_FAIL;
    }

    public static boolean needUnzipTwice(FirmwarePackageEntity fwEntity) {
        return fwEntity.getPackageInfo().isNeedUnzipTwice();
    }

    public static String unzipTwice(FusionStorageSshConnector ssh, String targetFile, String unzipPath) throws Exception {
        String unzipCmd = String.format(Locale.ENGLISH, "unzip -qo %s -d %s", targetFile, unzipPath);
        ssh.executeCmd(unzipCmd, false);
        String tgzUnzipPath = unzipPath;
        List<String> fileList = ScriptExecuteUtil.listFiles(ssh, unzipPath);
        for (String fileName : fileList) {
            String tgzFilePath = unzipPath + '/' + fileName;
            String tgzUnzipDir = fileName.replace(".tgz", "");
            tgzUnzipPath = unzipPath + '/' + tgzUnzipDir;
            String mkdirCmd = String.format(Locale.ENGLISH, "mkdir -p %s", tgzUnzipPath);
            ssh.executeCmd(mkdirCmd, false);
            String tarCmd = String.format(Locale.ENGLISH, "tar -zxf %s -C %s", tgzFilePath, tgzUnzipPath);
            ssh.executeCmd(tarCmd, false);
        }
        log.info("Decompress the package twice,to File: {}", (Object)new File(unzipPath).getName());
        return tgzUnzipPath;
    }

    private static List<String> listFiles(FusionStorageSshConnector ssh, String path) throws Exception {
        String lsCmd = String.format(Locale.ENGLISH, "ls %s", path);
        String response = ssh.executeCmd(lsCmd);
        List<String> responseLines = Arrays.asList(response.split("\n"));
        if (responseLines.size() < 2) {
            return Collections.emptyList();
        }
        List<String> fileNameList = responseLines.subList(1, responseLines.size() - 1);
        if (fileNameList.isEmpty()) {
            return Collections.emptyList();
        }
        return fileNameList.stream().map(line -> line.split("\t|\r| ")).map(Arrays::asList).flatMap(Collection::stream).filter(string -> !StringUtils.isNULLStr((String)string)).collect(Collectors.toList());
    }

    public static enum ScriptType {
        SHELL("sh %s"),
        PYTHON("python %s");

        private String command;

        private ScriptType(String command) {
            this.command = command;
        }

        public String completeCommand(String script) {
            return String.format(Locale.ROOT, this.command, script);
        }
    }
}

