/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.bundleupgrade.utils;

import com.huawei.bundleupgrade.constants.UpgradeParamConstants;
import com.huawei.bundleupgrade.entity.DeviceEntity;
import com.huawei.bundleupgrade.entity.FirmwarePackageEntity;
import com.huawei.bundleupgrade.entity.StrategySettingTableRowEntity;
import com.huawei.bundleupgrade.entity.UpgradeDeviceEntity;
import com.huawei.bundleupgrade.entity.fusionstrg.UpgDeviceExtendFSDataEntity;
import com.huawei.bundleupgrade.service.connection.fusionstrg.FusionStorageRestConnector;
import com.huawei.bundleupgrade.utils.UpgradeConstants;
import com.huawei.bundleupgrade.utils.fusionstrg.FusionStrgUpgradeContext;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.ui.swing.table.IsmTableCell;
import com.huawei.uMate.common.utils.ResUtil;
import java.io.File;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import javax.swing.table.TableColumn;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceUtil {
    private static final Logger log = LoggerFactory.getLogger(ServiceUtil.class);
    private static final ResUtil RES = ResUtil.getInstance((String)"BundleUpgrade");

    private ServiceUtil() {
        throw new IllegalStateException("ServiceUtil class");
    }

    public static boolean isPCIeModule(String module) {
        for (String name : UpgradeConstants.PCIeModule) {
            if (!module.equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public static boolean isExtendsPublicModule(String moduleName) {
        return Stream.of(UpgradeParamConstants.ModuleType.HDD.getModule(), UpgradeParamConstants.ModuleType.SSD_SP.getModule()).anyMatch(module -> module.equalsIgnoreCase(moduleName));
    }

    public static boolean isPanGeaIntraBandModule(String module) {
        return Arrays.stream(UpgradeConstants.PAN_GEA_INTRA_BAND_MODULE).anyMatch(module::equalsIgnoreCase);
    }

    public static UpgradeParamConstants.ModuleType convertModuleToEnum(String moduleName) {
        if (StringUtils.isNULLStr((String)moduleName)) {
            log.error("moduleName: {} is a null string.", (Object)moduleName);
            return null;
        }
        return UpgradeParamConstants.ModuleType.parseModule(moduleName);
    }

    public static boolean isStrategyTableRowSelected(StrategySettingTableRowEntity tableRowEntity) {
        IsmTableCell.ComboBoxCell comboBoxCell = tableRowEntity.getStrategyComboBoxCell();
        if (null == comboBoxCell) {
            return false;
        }
        if (null == comboBoxCell.getSelectedItem()) {
            return false;
        }
        return !RES.getString("bundle.upgrade.param.strategy.table.cell.default").equals(comboBoxCell.getComboBox().getSelectedItem());
    }

    public static boolean isForcedUpgrade(StrategySettingTableRowEntity tableRowEntity) {
        IsmTableCell.ComboBoxCell comboBoxCell = tableRowEntity.getStrategyComboBoxCell();
        return ServiceUtil.isForceUpgradeCell(comboBoxCell);
    }

    public static boolean isForceUpgradeCell(IsmTableCell.ComboBoxCell comboBoxCell) {
        if (null == comboBoxCell || null == comboBoxCell.getSelectedItem()) {
            return false;
        }
        return RES.getString("bundle.upgrade.param.strategy.table.cell.upgrade").equals(comboBoxCell.getComboBox().getSelectedItem());
    }

    public static String formatFwPackageSize(int size) {
        DecimalFormat df = new DecimalFormat("0.00");
        return df.format((double)size / 1048576.0) + "M";
    }

    public static int parseStringValueToInteger(String value) {
        int parsedValue = 0;
        if (StringUtils.isNULLStr((String)value)) {
            log.error("failed to parse the value: {} to integer.", (Object)value);
            return parsedValue;
        }
        try {
            parsedValue = Integer.parseInt(value);
        }
        catch (NumberFormatException ex) {
            log.error("failed to parse the value: {} to integer.", (Object)value);
            return parsedValue;
        }
        return parsedValue;
    }

    public static void setTableColWidth(TableColumn tc, int min, int preferred, int max) {
        if (null == tc) {
            return;
        }
        tc.setMinWidth(min);
        tc.setPreferredWidth(preferred);
        tc.setMaxWidth(max);
    }

    private static String addExtraPackageInfoToKey(String key, FirmwarePackageEntity firmwarePackageEntity) {
        String reKey = key;
        if (null == firmwarePackageEntity || null == firmwarePackageEntity.getPackageInfo()) {
            return reKey;
        }
        String object = firmwarePackageEntity.getPackageInfo().getObject();
        String objectId = firmwarePackageEntity.getPackageInfo().getObjectID();
        String module = firmwarePackageEntity.getPackageInfo().getModule();
        if (UpgradeParamConstants.ModuleType.CPLD.getModule().equals(module) && !StringUtils.isNULLStr((String)object) && !StringUtils.isNULLStr((String)objectId)) {
            reKey = reKey + "#" + object + "#" + objectId;
        }
        return reKey + "#" + firmwarePackageEntity.getBaseline();
    }

    public static String getPackageInfoKey(FirmwarePackageEntity firmwarePackage) {
        FirmwarePackageEntity.PackageInfo packageEntity = firmwarePackage.getPackageInfo();
        String key = packageEntity.getPackageName() + "#" + packageEntity.getSupportModelUID() + "#" + ServiceUtil.getVersion(packageEntity) + "#" + packageEntity.getProcessorArchitecture();
        key = ServiceUtil.addExtraPackageInfoToKey(key, firmwarePackage);
        if (StringUtils.isNULLStr((String)firmwarePackage.getOnlinePathAbs()) && !StringUtils.isNULLStr((String)firmwarePackage.getLocalPathAbs())) {
            key = key + "#" + firmwarePackage.getLocalPathAbs();
        }
        key = key + "#" + firmwarePackage.getTempId();
        return key;
    }

    private static String getVersion(FirmwarePackageEntity.PackageInfo packageEntity) {
        if (UpgradeParamConstants.ModuleType.DRIVE.getModule().equalsIgnoreCase(packageEntity.getModule())) {
            return "NULL";
        }
        if (UpgradeParamConstants.ModuleType.DFS.getModule().equalsIgnoreCase(packageEntity.getModule())) {
            return "NULL";
        }
        return packageEntity.getVersion();
    }

    public static String getPackageInfoKeyWithoutPath(FirmwarePackageEntity firmwarePackage) {
        FirmwarePackageEntity.PackageInfo packageEntity = firmwarePackage.getPackageInfo();
        String key = packageEntity.getPackageName() + "#" + packageEntity.getSupportModelUID() + "#" + ServiceUtil.getVersion(packageEntity) + "#" + packageEntity.getProcessorArchitecture();
        key = ServiceUtil.addExtraPackageInfoToKey(key, firmwarePackage);
        return key;
    }

    public static void safeSleep(long sleepTime) {
        try {
            Thread.sleep(sleepTime);
        }
        catch (InterruptedException e) {
            log.error("sleep interrupted exception:", (Throwable)e);
        }
    }

    public static String getFSClusterVersion(UpgradeDeviceEntity device) {
        UpgDeviceExtendFSDataEntity fsDataEntity = FusionStrgUpgradeContext.getInstance().getBusinessIpMapper().get(device);
        return fsDataEntity.getBelongsClusterEntity().getProductVersion().trim();
    }

    public static List<UpgradeParamConstants.ModuleType> getOnlineUpgModuleByVer(UpgradeDeviceEntity device) {
        if (device.isPlaneNode()) {
            return Collections.emptyList();
        }
        String productVer = ServiceUtil.getFSClusterVersion(device);
        List<UpgradeParamConstants.ModuleType> onlineModules = UpgradeParamConstants.ModuleType.getFsOnlineModules();
        if (productVer.contains("8.0.1")) {
            onlineModules.add(UpgradeParamConstants.ModuleType.BIOS);
        }
        if (device.getDeviceEntity().isTwoOceans()) {
            onlineModules.add(UpgradeParamConstants.ModuleType.BIOS);
            onlineModules.add(UpgradeParamConstants.ModuleType.MCU);
            onlineModules.add(UpgradeParamConstants.ModuleType.FAN);
            onlineModules.add(UpgradeParamConstants.ModuleType.ETH_CDR);
            onlineModules.add(UpgradeParamConstants.ModuleType.BBU);
            onlineModules.add(UpgradeParamConstants.ModuleType.PSU);
        }
        if (device.getDeviceEntity().isEastSea() || device.getDeviceEntity().isSnService()) {
            onlineModules.add(UpgradeParamConstants.ModuleType.BIOS);
            onlineModules.add(UpgradeParamConstants.ModuleType.ETH_CDR);
            onlineModules.add(UpgradeParamConstants.ModuleType.BBU);
            onlineModules.add(UpgradeParamConstants.ModuleType.PCIE_RETIMER);
            onlineModules.add(UpgradeParamConstants.ModuleType.PCIE_RETIMER_TI_RETIMER);
        }
        return onlineModules;
    }

    public static String getFirmwarePackageName(FirmwarePackageEntity entity) {
        File file = new File(entity.getLocalPathAbs());
        return file.getName();
    }

    public static DevNode buildDevNode(DeviceEntity device) {
        Map<UpgradeDeviceEntity, UpgDeviceExtendFSDataEntity> businessIpMapper = FusionStrgUpgradeContext.getInstance().getBusinessIpMapper();
        return businessIpMapper.entrySet().stream().filter(entry -> Objects.equals(device.getIp(), ((UpgradeDeviceEntity)entry.getKey()).getDeviceEntity().getIp())).map(Map.Entry::getValue).map(UpgDeviceExtendFSDataEntity::getBelongsClusterEntity).map(FusionStorageRestConnector::buildDevNode).findFirst().orElse(null);
    }
}

