/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.bundleupgrade.utils;

import com.huawei.bundleupgrade.service.connection.fusionstrg.FusionStorageSshConnector;
import com.huawei.bundleupgrade.utils.FsmNode;
import com.huawei.bundleupgrade.utils.FsmNodeStatus;
import com.huawei.ism.tool.obase.connection.support.ConnUtils;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.CliResolverUtils;
import com.huawei.ism.tool.protocol.rest.RestConnection;
import com.huawei.uMate.common.UMateException;
import com.huawei.uMate.common.utils.ResUtil;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SwitchActiveNodeUtils {
    private static final Logger log = LoggerFactory.getLogger(SwitchActiveNodeUtils.class);
    public static final String ACTIVE_STANDBY_CMD = "/opt/dfv/oam/oam-u/ha/ha/module/hacom/script/get_harole.sh";
    public static final String SWITCH_ACTIVE_STATUS = "/opt/dfv/oam/oam-u/ha/ha/module/hacom/tools/ha_client_tool --gethastatusV2";
    public static final String SWITCH_ACTIVE_NODE = "/opt/dfv/oam/oam-u/ha/ha/module/hacom/tools/ha_client_tool --switchover --name=forceswap";
    public static final String SWITCH_ACTIVE_SUCCESS = "successfully";
    public static final String ACTIVE = "active";
    private static final ResUtil RES = ResUtil.getInstance((String)"BundleUpgrade");

    public static boolean isActiveNode(FusionStorageSshConnector ssh) throws UMateException {
        try {
            String result = ssh.executeCmd(ACTIVE_STANDBY_CMD).replace(ACTIVE_STANDBY_CMD, "");
            return result.contains(ACTIVE);
        }
        catch (Exception e) {
            log.error("Execute cmd {} failed ", (Object)ACTIVE_STANDBY_CMD);
            throw new UMateException(RES.getString("bundle.upgrade.main.connection.error"));
        }
    }

    public static FsmNode queryNodeStatu(FusionStorageSshConnector ssh) throws UMateException {
        try {
            List datas = CliResolverUtils.parseHorizontalTable((String)ssh.executeCmd(SWITCH_ACTIVE_STATUS), Arrays.asList("NODE", "ROLE", "RESS"), (String)"\\s+");
            return SwitchActiveNodeUtils.buildFsmNode(datas);
        }
        catch (Exception e) {
            log.error("Execute cmd {} failed ", (Object)SWITCH_ACTIVE_STATUS);
            throw new UMateException(RES.getString("bundle.upgrade.main.connection.error"));
        }
    }

    private static FsmNode buildFsmNode(List<Map<String, String>> datas) {
        return new FsmNode(datas.stream().map(data -> FsmNodeStatus.builder().nodeName((String)data.get("NODE")).role((String)data.get("ROLE")).ress((String)data.get("RESS")).build()).collect(Collectors.toList()));
    }

    public static boolean switchActive(FusionStorageSshConnector ssh, FsmNode oldNode) throws UMateException {
        try {
            String switchResult = ssh.executeCmd(SWITCH_ACTIVE_NODE).replace(SWITCH_ACTIVE_NODE, "");
            if (!switchResult.contains(SWITCH_ACTIVE_SUCCESS)) {
                log.error("Node active/standby switchover failed.");
                return false;
            }
            if (SwitchActiveNodeUtils.waitSwitchSuccess(ssh, oldNode)) {
                return true;
            }
        }
        catch (Exception e) {
            log.error("Execute cmd {} failed ", (Object)SWITCH_ACTIVE_NODE);
            throw new UMateException(RES.getString("bundle.upgrade.main.connection.error"));
        }
        throw new UMateException(RES.getString("node.switch.active.time.out"));
    }

    private static boolean waitSwitchSuccess(FusionStorageSshConnector ssh, FsmNode oldNode) throws UMateException {
        long startTime = System.currentTimeMillis();
        while (System.currentTimeMillis() - startTime < 600000L) {
            FsmNode currentNode = SwitchActiveNodeUtils.queryNodeStatu(ssh);
            if (SwitchActiveNodeUtils.switchSuccess(oldNode, currentNode)) {
                return true;
            }
            ConnUtils.sleep((int)5000);
            log.info("The current node is being switched over to the active/standby.");
        }
        return false;
    }

    private static boolean switchSuccess(FsmNode old, FsmNode currentStatus) {
        if (Objects.isNull(currentStatus.getActiveNode()) || Objects.isNull(currentStatus.getStandByNode())) {
            return false;
        }
        if (!currentStatus.getStandByNode().isNormal() || !currentStatus.getActiveNode().isNormal()) {
            return false;
        }
        return Objects.equals(old.getActiveNode().getNodeName(), currentStatus.getStandByNode().getNodeName());
    }

    public static boolean isLogSuccess(RestConnection restConnector) {
        long startTime = System.currentTimeMillis();
        while (System.currentTimeMillis() - startTime < 1200000L) {
            try {
                restConnector.reLogin();
            }
            catch (ToolException e) {
                log.info("Current rest not ready,please wait");
            }
            if (restConnector.isLogin()) {
                return true;
            }
            ConnUtils.sleep((int)5000);
        }
        return false;
    }

    private SwitchActiveNodeUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

