/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.bundleupgrade.utils;

import com.google.common.collect.ArrayListMultimap;
import com.huawei.bundleupgrade.constants.UpgradeParamConstants;
import com.huawei.bundleupgrade.entity.BlackDiskModelEnum;
import com.huawei.bundleupgrade.entity.DeviceEntity;
import com.huawei.bundleupgrade.entity.DiskPkgInfo;
import com.huawei.bundleupgrade.entity.FirmwarePackageEntity;
import com.huawei.bundleupgrade.entity.FwUpgradeScenarioAdaptation;
import com.huawei.bundleupgrade.entity.UpgradeDeviceEntity;
import com.huawei.bundleupgrade.entity.UpgradeStrategyEntity;
import com.huawei.bundleupgrade.model.Module;
import com.huawei.bundleupgrade.service.impl.FusionStorageCheckService;
import com.huawei.bundleupgrade.service.impl.PanGeaInBandUpgradeServiceImpl;
import com.huawei.bundleupgrade.utils.BundleUpgradeContext;
import com.huawei.bundleupgrade.utils.UpgradeScenarioUtil;
import com.huawei.ism.tool.distributedfwupg.entity.FSDevNode;
import com.huawei.ism.tool.distributedfwupg.utils.UpgradeContext;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.protocol.rest.RestConnection;
import com.huawei.ism.tool.service.rest.query.NodePoolService;
import com.huawei.uMate.common.SystemConfig;
import com.huawei.uMate.common.UMateException;
import com.huawei.uMate.common.utils.ResUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class UpgradeCustomizationUtil {
    private static final Logger log = LoggerFactory.getLogger(UpgradeCustomizationUtil.class);
    private static final ResUtil RES = ResUtil.getInstance((String)"BundleUpgrade");

    public static void upgradeSesWhenVnodeEcPool(FusionStorageCheckService fsService, UpgradeStrategyEntity strategy, UpgradeDeviceEntity device, Double progressStepLen) throws UMateException {
        if (UpgradeScenarioUtil.isYinglong() || !UpgradeCustomizationUtil.isVnodeEcPool(fsService)) {
            return;
        }
        device.setOnlyUpgradeSesInVnodeEc(strategy.getUpgradeOrders().stream().flatMap(Collection::stream).allMatch(moduleType -> UpgradeParamConstants.ModuleType.SES.equals(moduleType)));
        List<UpgradeParamConstants.ModuleType> sesModule = UpgradeCustomizationUtil.getSesModule(strategy);
        if (sesModule.isEmpty()) {
            return;
        }
        log.info("start upgrade ses module in vnodeEc");
        UpgradeCustomizationUtil.upgradeSes(sesModule, progressStepLen, device);
        device.setFinishModules(sesModule);
    }

    private static List<UpgradeParamConstants.ModuleType> getSesModule(UpgradeStrategyEntity strategy) {
        for (List<UpgradeParamConstants.ModuleType> upgradeModules : strategy.getUpgradeOrders()) {
            if (!UpgradeScenarioUtil.containsSesModule(upgradeModules)) continue;
            return upgradeModules;
        }
        return Collections.emptyList();
    }

    private static void upgradeSes(List<UpgradeParamConstants.ModuleType> upgradeModules, Double progressStepLen, UpgradeDeviceEntity device) {
        log.info("upgrade progress step size :{}", (Object)progressStepLen);
        PanGeaInBandUpgradeServiceImpl panGeaInBandUpgrade = new PanGeaInBandUpgradeServiceImpl(device);
        panGeaInBandUpgrade.upgrade(upgradeModules.get(0), progressStepLen);
    }

    private static boolean isVnodeEcPool(FusionStorageCheckService fsService) throws UMateException {
        return NodePoolService.isVnodeEcPool((RestConnection)fsService.getRestConnector(), (String)fsService.getBaseUrl().concat("/dsware/service/resource/queryPoolBasicInfo"), (String)fsService.getDiskPoolId());
    }

    public static List<List<String>> getShowInfo(ArrayListMultimap<String, String> arrayListCheckInfo) {
        return arrayListCheckInfo.asMap().entrySet().stream().map(device -> UpgradeCustomizationUtil.getInfoAndSetNum((String)device.getKey(), (Collection)device.getValue())).collect(Collectors.toList());
    }

    private static List<String> getInfoAndSetNum(String deviceIp, Collection<String> errorInfo) {
        ArrayList<String> resultInfos = new ArrayList<String>();
        resultInfos.add(deviceIp);
        AtomicInteger index = new AtomicInteger(0);
        resultInfos.add(errorInfo.stream().map(info -> String.join((CharSequence)".", String.valueOf(index.incrementAndGet()), info)).collect(Collectors.joining("<br/>")));
        return resultInfos;
    }

    public static void resetDiskInfos(DeviceEntity device, FirmwarePackageEntity pkg) {
        Map<String, DiskPkgInfo> diskPkgInfoMap = Module.DiskFw.buildDiskUidMap(pkg.getDiskPkgInfos());
        List<DeviceEntity.DiskModel> diskInfos = device.getDiskInfo().stream().filter(diskModel -> !UpgradeCustomizationUtil.isBlackDiskModel(diskPkgInfoMap, diskModel)).collect(Collectors.toList());
        device.setDiskInfo(diskInfos);
    }

    private static boolean isBlackDiskModel(Map<String, DiskPkgInfo> diskPkgInfoMap, DeviceEntity.DiskModel disk) {
        String targetVersion = Module.DiskFw.findDiskInfo(diskPkgInfoMap, disk).orElse(new DiskPkgInfo()).getTargetVersion();
        return BlackDiskModelEnum.isBlackModel(disk.getModel(), targetVersion);
    }

    public static boolean isAnyDiskInBlack(DeviceEntity device, FirmwarePackageEntity pkg) {
        Map<String, DiskPkgInfo> diskPkgInfoMap = Module.DiskFw.buildDiskUidMap(pkg.getDiskPkgInfos());
        return device.getDiskInfo().stream().anyMatch(diskModel -> UpgradeCustomizationUtil.isBlackDiskModel(diskPkgInfoMap, diskModel));
    }

    public static List<DeviceEntity.DiskModel> getBlackModels(DeviceEntity device, FirmwarePackageEntity pkg) {
        return device.getDiskInfo().stream().filter(diskModel -> pkg.getDiskPkgInfos().stream().anyMatch(disk -> UpgradeCustomizationUtil.isBlackModel(diskModel, disk))).collect(Collectors.toList());
    }

    private static boolean isBlackModel(DeviceEntity.DiskModel diskModel, DiskPkgInfo disk) {
        if (disk.getUid().equalsIgnoreCase(diskModel.getSupportModelUID())) {
            return BlackDiskModelEnum.isBlackModel(diskModel.getModel(), disk.getTargetVersion());
        }
        return false;
    }

    public static boolean checkCanUpgradeSsdSp(UpgradeDeviceEntity upgradeDevice) {
        Map<String, FirmwarePackageEntity> firmwareMap = UpgradeCustomizationUtil.getPcieFwPackageEntityMap(upgradeDevice);
        if (!UpgradeCustomizationUtil.getBlackModels(upgradeDevice.getDeviceEntity(), firmwareMap.getOrDefault(Module.SsdSp.getName(), new FirmwarePackageEntity())).isEmpty()) {
            log.info("Device {} Upgrading the ssd_sp component may be risky. Do not upgrade it now.", (Object)upgradeDevice.getDeviceEntity().getIp());
            return false;
        }
        return true;
    }

    public static boolean isContainsSsdSp(UpgradeStrategyEntity strategy) {
        List moduleToUpgrade = strategy.getUpgradeOrders().stream().flatMap(Collection::stream).collect(Collectors.toList());
        if (!moduleToUpgrade.contains((Object)UpgradeParamConstants.ModuleType.SSD_SP)) {
            log.info("The ssd_sp component does not need to be upgraded.");
            return false;
        }
        return true;
    }

    public static Map<String, FirmwarePackageEntity> getPcieFwPackageEntityMap(UpgradeDeviceEntity upgradeDevice) {
        Map moduleTargetFirmwareMap = Optional.ofNullable(BundleUpgradeContext.getInstance().getStrategyEntityMap()).map(entityMap -> (UpgradeStrategyEntity)entityMap.get(upgradeDevice.getAssociatedStrategyId())).map(UpgradeStrategyEntity::getModuleTargetFirmwareMap).orElse(Collections.emptyMap());
        List firmwareFileInfoList = moduleTargetFirmwareMap.entrySet().stream().filter(entity -> UpgradeParamConstants.ModuleType.getPcieModule().contains(entity.getKey())).map(Map.Entry::getValue).flatMap(Collection::stream).collect(Collectors.toList());
        ConcurrentHashMap<String, FirmwarePackageEntity> firmwarePackageMap = BundleUpgradeContext.getInstance().getFirmwarePackageMap();
        if (!firmwareFileInfoList.isEmpty()) {
            return firmwareFileInfoList.stream().map(firmwarePackageMap::get).collect(Collectors.toMap(key -> key.getPackageInfo().getModule(), Function.identity()));
        }
        log.error("Device {} pcie model firmwareFileInfoList is empty", (Object)upgradeDevice.getDeviceEntity().getIp());
        return Collections.emptyMap();
    }

    public static boolean isSupportBatchDpcUpgradeDevice(DevNode node, List<FSDevNode> fsdNodeList) {
        return UpgradeContext.getInstance().isComputeUpgradeScene() && UpgradeCustomizationUtil.isBatchUpgrade(node) && fsdNodeList.stream().anyMatch(fsDevNode -> fsDevNode.isDpcComputeNode());
    }

    private static boolean isBatchUpgrade(DevNode node) {
        String supportVersion = SystemConfig.createSystemConfig().getConfigVlaue("dpc.upgrade.version.check");
        return Arrays.stream(supportVersion.trim().split(";")).anyMatch(node.getProductVersion()::equals);
    }

    public static boolean isCheckNodeStatus(String productVerison) {
        return Arrays.stream(FwUpgradeScenarioAdaptation.PostCheckVrsion.values()).anyMatch(checVersion -> Arrays.stream(checVersion.getProductVersion().split(",")).anyMatch(version -> productVerison.startsWith((String)version)));
    }

    public static String getDpcTipToShow(DevNode node) {
        String productInfo = String.join((CharSequence)" ", node.getProductModel(), node.getProductVersion());
        return RES.getStringWithParams("dpc.upgrade.tip", new Object[]{node.getIp(), productInfo});
    }

    public static boolean hasDictPlane(DevNode node) {
        String configVlaue = SystemConfig.createSystemConfig().getConfigVlaue("pacific.hasDirectPlane.model");
        return configVlaue != null && configVlaue.contains(node.getProductModel());
    }

    public static boolean isSupportExtendInspect(String productModule, String version) {
        return Arrays.stream(FwUpgradeScenarioAdaptation.BlockInspectEnum.values()).filter(block -> productModule.contains(block.getProductModule())).noneMatch(block -> UpgradeCustomizationUtil.isBlockVersion(version, block));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isBlockVersion(String version, FwUpgradeScenarioAdaptation.BlockInspectEnum block) {
        if ("8.2.0L15Y01".equalsIgnoreCase(version)) {
            return false;
        }
        if ("ALL".equals(block.getVersion())) return true;
        if (!Arrays.stream(block.getVersion().split(",")).anyMatch(version::startsWith)) return false;
        return true;
    }

    public static boolean canConnectOs(DeviceEntity device) {
        if (UpgradeScenarioUtil.isOutBound() || device.isDirectPlane()) {
            log.info("Current scene is OutBand or Device {} is DirectPlane, OS cannot be connected.", (Object)device.getIp());
            return false;
        }
        return true;
    }

    private UpgradeCustomizationUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

