/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.bundleupgrade.utils;

import com.huawei.bundleupgrade.entity.FeedsOfWatchDog;
import com.huawei.bundleupgrade.entity.UpgradeDeviceEntity;
import com.huawei.bundleupgrade.ui.IUpgradeTaskListner;
import com.huawei.bundleupgrade.utils.UpgradeScenarioUtil;
import com.huawei.uMate.common.UMateException;
import java.util.Locale;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeExecutionWatchDog {
    private static final Logger log = LoggerFactory.getLogger(UpgradeExecutionWatchDog.class);
    private static UpgradeExecutionWatchDog puppy = null;
    private static boolean isAsk2Stop = false;
    private static ConcurrentLinkedQueue<FeedsOfWatchDog> results2Watch = new ConcurrentLinkedQueue();
    private static ExecutorService executor = Executors.newSingleThreadExecutor();

    private UpgradeExecutionWatchDog(IUpgradeTaskListner upgradeTaskListner) {
        log.info("[Bundle Upgrade]system watch dog now start.");
        executor.submit(new UpgradeTaskResultConsumer(upgradeTaskListner));
    }

    public static void feed(FeedsOfWatchDog feed) throws UMateException {
        if (puppy == null) {
            throw new UMateException("watch.dog.not.initial.yet");
        }
        results2Watch.add(feed);
    }

    public static void wakeDog(IUpgradeTaskListner upgradeTaskListner) {
        if (puppy == null) {
            puppy = new UpgradeExecutionWatchDog(upgradeTaskListner);
        }
    }

    private static void ask2Stop() {
        isAsk2Stop = true;
    }

    public static void killDog() {
        UpgradeExecutionWatchDog.ask2Stop();
        if (executor != null && executor.isShutdown()) {
            executor.shutdownNow();
        }
    }

    class UpgradeTaskResultConsumer
    implements Callable<Object> {
        private IUpgradeTaskListner upgradeTaskListner;

        public UpgradeTaskResultConsumer(IUpgradeTaskListner upgradeTaskListner) {
            this.upgradeTaskListner = upgradeTaskListner;
        }

        private boolean isAllow2Run() {
            return !isAsk2Stop;
        }

        @Override
        public Boolean call() throws Exception {
            while (this.isAllow2Run()) {
                FeedsOfWatchDog feed = (FeedsOfWatchDog)results2Watch.poll();
                if (feed == null) {
                    Thread.sleep(10000L);
                    continue;
                }
                CompletionService service = feed.getExecutionService();
                if (service == null) continue;
                for (int poi = 0; poi < feed.getFutureTaskSize() && this.isAllow2Run(); ++poi) {
                    Object result = service.take().get();
                    if (!(result instanceof UpgradeDeviceEntity)) continue;
                    log.info(String.format(Locale.ROOT, "[Upgrade Result of %s]finished device upgrade, the result is %s, duration: %s.", ((UpgradeDeviceEntity)result).getDeviceEntity().getIp(), ((UpgradeDeviceEntity)result).getProcessStatus().toString(), ((UpgradeDeviceEntity)result).getUsedTimeSeconds()));
                    UpgradeScenarioUtil.refreshExecutionResult((UpgradeDeviceEntity)result);
                }
            }
            this.upgradeTaskListner.taskEnd();
            log.info("watch dog exits successfully due to user operation.");
            return Boolean.TRUE;
        }
    }
}

