/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.bundleupgrade.utils;

import com.huawei.bundleupgrade.constants.UpgradeParamConstants;
import com.huawei.bundleupgrade.entity.DeviceEntity;
import com.huawei.bundleupgrade.entity.FirmwarePackageEntity;
import com.huawei.bundleupgrade.entity.RetimerTypeEnum;
import com.huawei.bundleupgrade.entity.UpgradeDeviceEntity;
import com.huawei.bundleupgrade.entity.fusionstrg.UpgDeviceExtendFSDataEntity;
import com.huawei.bundleupgrade.ui.layout.BundleUpgradeLayout;
import com.huawei.bundleupgrade.utils.BundleUpgradeContext;
import com.huawei.bundleupgrade.utils.FreeMarkerTemplateUtil;
import com.huawei.bundleupgrade.utils.SystemConfigUtil;
import com.huawei.ism.tool.obase.utils.NetUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.ui.swing.table.IsmTableCell;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.uMate.HWDiscover.model.HWDiscoverModel;
import com.huawei.uMate.common.UMateException;
import com.huawei.uMate.common.utils.ResUtil;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class UpgradeScenarioUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(UpgradeScenarioUtil.class);
    private static final String SNMP_COMMON_RETRY_MAX_PLACEHOLDER = "snmp.retry.max.times";
    private static final ResUtil RES = ResUtil.getInstance((String)"BundleUpgrade");
    private static final int MIN_CONCURRENT_NUMBER = 20;
    private static final int MAX_CONCURRENT_NUMBER = 100;

    private UpgradeScenarioUtil() {
    }

    public static boolean containsOutBandModuleUpgrade(List<UpgradeParamConstants.ModuleType> modules) {
        Set<UpgradeParamConstants.ModuleType> targets = UpgradeScenarioUtil.getTargetTypeModules2Upgrade(modules, UpgradeParamConstants.ModuleType.getOutBandModules());
        return !targets.isEmpty();
    }

    public static boolean containsInBandModuleUpgrade(List<UpgradeParamConstants.ModuleType> modules) {
        Set<UpgradeParamConstants.ModuleType> targets = UpgradeScenarioUtil.getTargetTypeModules2Upgrade(modules, UpgradeParamConstants.ModuleType.getInBandModules());
        return !targets.isEmpty() || UpgradeScenarioUtil.containsSpChannelEs3000Module(modules);
    }

    public static boolean containsRebootBySshModules(List<UpgradeParamConstants.ModuleType> modules) {
        return !modules.isEmpty() && UpgradeParamConstants.ModuleType.rebootBySshModules().containsAll(modules);
    }

    public static boolean containsEs3000Module(List<UpgradeParamConstants.ModuleType> modules) {
        Set<UpgradeParamConstants.ModuleType> targets = UpgradeScenarioUtil.getTargetTypeModules2Upgrade(modules, Arrays.asList(UpgradeParamConstants.ModuleType.ES3000));
        return !targets.isEmpty();
    }

    public static boolean containsSesModule(List<UpgradeParamConstants.ModuleType> modules) {
        Set<UpgradeParamConstants.ModuleType> targets = UpgradeScenarioUtil.getTargetTypeModules2Upgrade(modules, Collections.singletonList(UpgradeParamConstants.ModuleType.SES));
        return !targets.isEmpty();
    }

    public static boolean containsSpChannelEs3000Module(List<UpgradeParamConstants.ModuleType> modules) {
        Set<UpgradeParamConstants.ModuleType> targets = UpgradeScenarioUtil.getTargetTypeModules2Upgrade(modules, Arrays.asList(UpgradeParamConstants.ModuleType.SSD_SP));
        return !targets.isEmpty();
    }

    public static boolean containsFwUpgradeBySshForDisk(List<UpgradeParamConstants.ModuleType> modules) {
        return modules.contains((Object)UpgradeParamConstants.ModuleType.DISK_FW);
    }

    public static boolean isSpModule(List<UpgradeParamConstants.ModuleType> modules) {
        return modules.size() == 1 && modules.get(0).equals((Object)UpgradeParamConstants.ModuleType.SP);
    }

    public static boolean canUpgradeRetimerModule(String currentVer, String newVer, String targetVer, UpgradeParamConstants.ModuleType module, UpgradeDeviceEntity device) throws UMateException {
        String minVersion = device.getDeviceEntity().getMinRetimerVersion(module);
        if ("--".equals(minVersion) || !UpgradeScenarioUtil.canUpgrade(currentVer, newVer, targetVer, minVersion)) {
            LOGGER.info("Abort upgrade module {} .", (Object)module.getModule());
            return false;
        }
        return true;
    }

    private static boolean canUpgrade(String currentVer, String newVer, String targetVer, String minVersion) throws UMateException {
        return currentVer.equals(newVer) || UpgradeScenarioUtil.isFromVersionLowerThanToVersion(minVersion, targetVer);
    }

    public static String getMinVersion(String version, String newVersion) {
        try {
            return UpgradeScenarioUtil.isFromVersionLowerThanToVersion(version, newVersion) ? version : newVersion;
        }
        catch (UMateException e) {
            LOGGER.error("An error occurred during version comparison. version: {}, newVersion: {}", (Object)version, (Object)newVersion);
            return StringUtils.isNULLStr((String)newVersion) ? version : newVersion;
        }
    }

    public static boolean containsPanGeaInBandModuleUpgrade(List<UpgradeParamConstants.ModuleType> modules) {
        Set<UpgradeParamConstants.ModuleType> targets = UpgradeScenarioUtil.getTargetTypeModules2Upgrade(modules, UpgradeParamConstants.ModuleType.getPanGeaInBandModules());
        return !targets.isEmpty();
    }

    public static String getCurrentTimePrettyInSeconds() {
        Date date = new Date();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmmss");
        return formatter.format(date);
    }

    public static Set<UpgradeParamConstants.ModuleType> getOutBandToBeUpgradeModules(List<UpgradeParamConstants.ModuleType> modules) {
        return UpgradeScenarioUtil.getTargetTypeModules2Upgrade(modules, UpgradeParamConstants.ModuleType.getOutBandModules());
    }

    private static Set<UpgradeParamConstants.ModuleType> getTargetTypeModules2Upgrade(List<UpgradeParamConstants.ModuleType> moduleList, List<UpgradeParamConstants.ModuleType> types) {
        HashSet<UpgradeParamConstants.ModuleType> moduleTypeSet = new HashSet<UpgradeParamConstants.ModuleType>(moduleList);
        moduleTypeSet.retainAll(new HashSet<UpgradeParamConstants.ModuleType>(types));
        return moduleTypeSet;
    }

    public static boolean writeServerTargetProfileXMLContent(String serverType, UpgradeParamConstants.ModuleType moduleType, UpgradeDeviceEntity deviceEntity, String packagePath, String targetPath) {
        HashMap<String, Object> data = new HashMap<String, Object>(10);
        if (serverType.equals("RACK")) {
            data.put("productType", "Common");
            data.put("upgradeType", moduleType.getModule());
            data.put("ip", deviceEntity.getDeviceEntity().getIp());
            data.put("firmware", UpgradeScenarioUtil.escape4XMLCharacters(packagePath));
            data.put("timeout", "");
            data.put("sshPort", deviceEntity.getDeviceEntity().getSshPort());
            return FreeMarkerTemplateUtil.processFtl2TargetLocation("rack_server_profile_template.ftl", data, targetPath);
        }
        return false;
    }

    public static String replaceSpecialChar2UnderlineString(String charSequence) {
        if (StringUtils.isNULLStr((String)charSequence)) {
            return "";
        }
        return charSequence.replaceAll("[/:;*?\"<>| \\.]", "_");
    }

    public static HWDiscoverModel convertDeviceEntity2HWDiscoverModel(DeviceEntity deviceEntity) throws UMateException {
        HWDiscoverModel deviceModel = new HWDiscoverModel();
        deviceModel.setIPAddress(deviceEntity.getIp());
        deviceModel.setUserName(deviceEntity.getAccount().getUserName());
        deviceModel.setUserPwd(deviceEntity.getAccount().getPassword());
        return deviceModel;
    }

    public static HWDiscoverModel convertFSEntity2HWDiscoverModel(UpgDeviceExtendFSDataEntity deviceEntity) throws UMateException {
        HWDiscoverModel deviceModel = new HWDiscoverModel();
        deviceModel.setIPAddress(deviceEntity.getManagementIp());
        deviceModel.setUserName(deviceEntity.getSshAccount().getUserName());
        deviceModel.setUserPwd(deviceEntity.getSshAccount().getPassword());
        deviceModel.setRootPwd(deviceEntity.getSshAccount().getOsRootPassword());
        return deviceModel;
    }

    private static String escape4XMLCharacters(String oriString) {
        if (StringUtils.isNULLStr((String)oriString)) {
            return "";
        }
        return oriString.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;");
    }

    public static int getUpgradeExecutionQueueSize() {
        try {
            return Integer.parseInt(SystemConfigUtil.getSysConfig("execution.max.queue.length"));
        }
        catch (NumberFormatException nfe) {
            return 200;
        }
    }

    public static int getUpgradeExecutionThreadMaxSize() {
        try {
            String concurrentNumberStr = System.getenv("concurrentNumber");
            int numFromFile = Integer.parseInt(SystemConfigUtil.getSysConfig("execution.allow.max.threads"));
            if (UpgradeScenarioUtil.isYinglong() && !StringUtils.isNULLStr((String)concurrentNumberStr)) {
                int maxThreadNum = Integer.parseInt(concurrentNumberStr);
                if (maxThreadNum < 20 || maxThreadNum > 100) {
                    LOGGER.warn("The current number is {}, less than 20 or greater than 100, Set the number of threads: {}", (Object)maxThreadNum, (Object)numFromFile);
                    return numFromFile;
                }
                LOGGER.info("In the yingling scenario, set the number of concurrent upgrades to {}.", (Object)maxThreadNum);
                return maxThreadNum;
            }
            LOGGER.info("In the Upgrade_FSFW scenario, set the number of concurrent upgrades to {}.", (Object)numFromFile);
            return numFromFile;
        }
        catch (NumberFormatException nfe) {
            LOGGER.warn("An exception occurs, set the number of concurrent requests to the default value 20.", (Throwable)nfe);
            return 20;
        }
    }

    public static String getTargetModuleVersion(DeviceEntity deviceEntity, UpgradeParamConstants.ModuleType module, FirmwarePackageEntity packageEntity) {
        switch (module) {
            case CPLD_MAIN: {
                if (deviceEntity.isSpecificDevice()) {
                    return deviceEntity.getActiveCPLDVersion();
                }
                return deviceEntity.getCpldModels().stream().filter(baseModule -> baseModule.getDeviceType().equalsIgnoreCase("MainBoard")).filter(UpgradeScenarioUtil.getCpldModelPredicate(deviceEntity, packageEntity)).map(DeviceEntity.CpldModel::getCpldVersion).findAny().orElse("");
            }
            case PSU: {
                return deviceEntity.getPsuModels().stream().filter(UpgradeScenarioUtil.filterTargetPsuModelPredicate(deviceEntity, packageEntity)).map(DeviceEntity.PsuModel::getPsuVersion).findAny().orElse("");
            }
            case CPLD: {
                return UpgradeScenarioUtil.getCpldVersion(deviceEntity, packageEntity);
            }
            case BIOS: {
                return UpgradeScenarioUtil.getDiffBiosVersion(deviceEntity, packageEntity);
            }
            case iBMC: {
                return deviceEntity.getMasterBMC();
            }
            case CDR: {
                return deviceEntity.getCdrVersion();
            }
            case Retimer: {
                return deviceEntity.getRetimerVersion();
            }
            case PCIE_RETIMER: 
            case PCIE_RETIMER_TI_RETIMER: {
                return deviceEntity.getExpRetimerByType(RetimerTypeEnum.getRetimerTypeByKey(packageEntity.getPackageInfo().getRetimerId()));
            }
            case MCU: {
                return deviceEntity.getMcuVersion();
            }
            case FAN: {
                return deviceEntity.getFanVersion();
            }
            case ETH_CDR: {
                return deviceEntity.getEthCdrVersion();
            }
            case BBU: {
                return deviceEntity.getBbuModel();
            }
            case VRD: {
                return deviceEntity.getVrdVersion();
            }
        }
        return "";
    }

    private static String getCpldVersion(DeviceEntity deviceEntity, FirmwarePackageEntity packageEntity) {
        return deviceEntity.getCpldModels().stream().filter(baseModule -> baseModule.getDeviceType().equalsIgnoreCase("Backplane")).filter(UpgradeScenarioUtil.getCpldModelPredicate(deviceEntity, packageEntity)).map(DeviceEntity.CpldModel::getCpldVersion).findAny().orElse("");
    }

    private static String getVrdVersion(DeviceEntity deviceEntity) {
        return Arrays.stream(deviceEntity.getVrdVersion().split("\\.")).findFirst().orElse("--");
    }

    private static String getDiffBiosVersion(DeviceEntity deviceEntity, FirmwarePackageEntity packageEntity) {
        if (packageEntity.getPackageInfo().getFileName().toLowerCase(Locale.ENGLISH).contains("iob")) {
            return deviceEntity.getIobBiosVersion();
        }
        return deviceEntity.getBiosVersion();
    }

    private static Predicate<DeviceEntity.PsuModel> filterTargetPsuModelPredicate(DeviceEntity deviceEntity, FirmwarePackageEntity packageEntity) {
        return baseModule -> packageEntity.getPackageInfo() != null && packageEntity.getPackageInfo().getSupportModelUID().toLowerCase(Locale.ENGLISH).contains(baseModule.getSupportModelUID().toLowerCase(Locale.ENGLISH));
    }

    private static Predicate<DeviceEntity.CpldModel> getCpldModelPredicate(DeviceEntity deviceEntity, FirmwarePackageEntity packageEntity) {
        return baseModule -> packageEntity.getPackageInfo().getSupportModelUID().toLowerCase(Locale.ENGLISH).contains(deviceEntity.getProductUniqueId().toLowerCase(Locale.ENGLISH)) && packageEntity.getPackageInfo() != null && (packageEntity.getPackageInfo().getObject() != null && packageEntity.getPackageInfo().getObject().equalsIgnoreCase(baseModule.getBoardName()) || packageEntity.getPackageInfo().getObjectID() != null && packageEntity.getPackageInfo().getObjectID().toLowerCase(Locale.ENGLISH).contains(baseModule.getBoardId().toLowerCase(Locale.ENGLISH)));
    }

    public static boolean isUpgradeNotFinished(UpgradeParamConstants.UpgradeStatus upgradeStatus) {
        return upgradeStatus == UpgradeParamConstants.UpgradeStatus.RUNNING || upgradeStatus == UpgradeParamConstants.UpgradeStatus.WAITING || upgradeStatus == UpgradeParamConstants.UpgradeStatus.REBOOT || upgradeStatus == UpgradeParamConstants.UpgradeStatus.WAIT_REBOOT;
    }

    public static boolean containsFirmwarePackageOnlineDownloaded() {
        return BundleUpgradeContext.getInstance().getFirmwarePackageMap().values().stream().anyMatch(firmwarePackageEntity -> !StringUtils.isNULLStr((String)firmwarePackageEntity.getOnlinePathAbs()) && firmwarePackageEntity.getDownloadStatus() != null);
    }

    public static boolean isFromVersionLowerThanToVersion(String fromVersion, String toVersion) throws UMateException {
        if (StringUtils.isNULLStr((String)fromVersion) || StringUtils.isNULLStr((String)toVersion)) {
            throw new UMateException(RES.getString("target.module.version.compare.failed.invalid"));
        }
        String extractedFromVersion = UpgradeScenarioUtil.extractVersionsWithPattern(fromVersion.toLowerCase(Locale.ENGLISH));
        String extractedToVersion = UpgradeScenarioUtil.extractVersionsWithPattern(toVersion.toLowerCase(Locale.ENGLISH));
        String[] cutFromVersion = extractedFromVersion.split("\\.");
        String[] cutToVersion = extractedToVersion.split("\\.");
        for (int cutPoi = 0; cutPoi < cutFromVersion.length; ++cutPoi) {
            if (cutToVersion.length > cutPoi && cutFromVersion[cutPoi].equalsIgnoreCase(cutToVersion[cutPoi])) continue;
            if (cutToVersion.length - 1 < cutPoi) {
                return false;
            }
            return UpgradeScenarioUtil.compareSetVersionStr(cutFromVersion[cutPoi], cutToVersion[cutPoi]);
        }
        return extractedFromVersion.length() < extractedToVersion.length();
    }

    public static boolean isCurrentNotEqualTarget(String current, String target) {
        return !current.equals(target);
    }

    public static boolean isValidFromVersion(String currentVersion) {
        return org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)currentVersion) && !org.apache.commons.lang3.StringUtils.equalsAny((CharSequence)currentVersion, (CharSequence[])new CharSequence[]{"--"}) && !currentVersion.toUpperCase(Locale.ROOT).contains("NOT_MATCH");
    }

    public static boolean isValidVersion(String currentVersion, String moduleName) {
        if (UpgradeScenarioUtil.isYinglong() || UpgradeParamConstants.ModuleType.RAID_CONFIG.getModule().equals(moduleName)) {
            return org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)currentVersion) && !currentVersion.toUpperCase(Locale.ROOT).contains("NOT_MATCH");
        }
        return org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)currentVersion) && !org.apache.commons.lang3.StringUtils.equalsAny((CharSequence)currentVersion, (CharSequence[])new CharSequence[]{"--"}) && !currentVersion.toUpperCase(Locale.ROOT).contains("NOT_MATCH");
    }

    public static boolean isValidVersionInPangea(String currentVersion, String moduleName) {
        if (UpgradeScenarioUtil.isVersionValidMode(moduleName)) {
            return !StringUtils.isNULLStr((String)currentVersion) && currentVersion.toUpperCase(Locale.ROOT).contains("--");
        }
        return false;
    }

    private static boolean isVersionValidMode(String moduleName) {
        return UpgradeParamConstants.ModuleType.getVesionValid().stream().anyMatch(moduleType -> Objects.equals(moduleType.getModule(), moduleName));
    }

    public static boolean isCurrentLowerThanTargetByStrComparators(String current, String target) {
        return current.compareTo(target) < 0;
    }

    public static boolean isCurrentLowerThanTargetByRadix(String current, String target, int radix) {
        try {
            int currentNum = Integer.parseInt(current, radix);
            int targetNum = Integer.parseInt(target, radix);
            return currentNum < targetNum;
        }
        catch (Exception e) {
            LOGGER.info(" currentVer {} comparator targetVer {} error.", (Object)current, (Object)target);
            return UpgradeScenarioUtil.isCurrentLowerThanTargetByStrComparators(current, target);
        }
    }

    private static boolean compareSetVersionStr(String leftStr, String rightStr) {
        StringBuilder leftInt = new StringBuilder();
        StringBuilder rightInt = new StringBuilder();
        boolean isLeftIntEnd = false;
        boolean isRightIntEnd = false;
        for (int poi = 0; poi < Math.max(leftStr.length(), rightStr.length()); ++poi) {
            String leftDigit = UpgradeScenarioUtil.parse4DigitInSetStrPoi(leftStr, poi);
            UpgradeScenarioUtil.appendIntStrIfNotEnd(leftInt, leftDigit, isLeftIntEnd);
            isLeftIntEnd = isLeftIntEnd || leftInt.length() > 0 && StringUtils.isNULLStr((String)leftDigit);
            String rightDigit = UpgradeScenarioUtil.parse4DigitInSetStrPoi(rightStr, poi);
            UpgradeScenarioUtil.appendIntStrIfNotEnd(rightInt, rightDigit, isRightIntEnd);
            boolean bl = isRightIntEnd = isRightIntEnd || rightInt.length() > 0 && StringUtils.isNULLStr((String)rightDigit);
            if (isLeftIntEnd && isRightIntEnd) {
                double right;
                double left = Double.parseDouble(leftInt.toString());
                if (new BigDecimal(left).compareTo(new BigDecimal(right = Double.parseDouble(rightInt.toString()))) == 0) {
                    leftInt.delete(0, leftInt.length());
                    rightInt.delete(0, rightInt.length());
                    isLeftIntEnd = false;
                    isRightIntEnd = false;
                } else {
                    return left < right;
                }
            }
            if (!StringUtils.isNULLStr((String)leftDigit) || !StringUtils.isNULLStr((String)rightDigit) || UpgradeScenarioUtil.safelyGetChar(leftStr, poi) == UpgradeScenarioUtil.safelyGetChar(rightStr, poi)) continue;
            return UpgradeScenarioUtil.safelyGetChar(leftStr, poi) < UpgradeScenarioUtil.safelyGetChar(rightStr, poi);
        }
        return Double.parseDouble(UpgradeScenarioUtil.safelyGetDoubleStr(leftInt.toString())) < Double.parseDouble(UpgradeScenarioUtil.safelyGetDoubleStr(rightInt.toString()));
    }

    private static void appendIntStrIfNotEnd(StringBuilder intStr, String targetDigit, boolean isAppendIntEnd) {
        if (!isAppendIntEnd) {
            intStr.append(targetDigit);
        }
    }

    private static String safelyGetDoubleStr(String string) {
        if (StringUtils.isNULLStr((String)string)) {
            return "0";
        }
        return string;
    }

    private static char safelyGetChar(String str, int poi) {
        if (str.length() - 1 < poi) {
            return '\u0000';
        }
        return str.charAt(poi);
    }

    private static String parse4DigitInSetStrPoi(String str, int poi) {
        if (poi > str.length() - 1 || !Character.isDigit(str.charAt(poi))) {
            return "";
        }
        return String.valueOf(str.charAt(poi));
    }

    static String extractVersionsWithPattern(String version) {
        if (!version.contains("(") || !version.contains(")")) {
            return version;
        }
        int[] leftBracketsLoc = new int[version.length()];
        int leftPointer = 0;
        int rightPointer = 0;
        int[] rightBracketsLoc = new int[version.length()];
        for (int loc = 0; loc < version.length(); ++loc) {
            if (version.charAt(loc) == '(') {
                leftBracketsLoc[leftPointer] = loc + 1;
                ++leftPointer;
                continue;
            }
            if (version.charAt(loc) != ')') continue;
            rightBracketsLoc[rightPointer] = loc + 1;
            ++rightPointer;
        }
        int bracketsLayer = Math.min(leftPointer, rightPointer);
        int outerLeftBracketsPoi = leftBracketsLoc[leftPointer - bracketsLayer];
        int outerRightBracketsPoi = rightBracketsLoc[bracketsLayer - 1];
        if (outerLeftBracketsPoi == 0) {
            return version.substring(outerRightBracketsPoi);
        }
        if (outerRightBracketsPoi == version.length()) {
            return version.substring(0, outerLeftBracketsPoi - 1);
        }
        return version.substring(0, outerLeftBracketsPoi - 1) + version.substring(outerRightBracketsPoi);
    }

    public static int getUserDefinedSNMPRetryTimes() {
        String userSetVal = SystemConfigUtil.getSysConfig(SNMP_COMMON_RETRY_MAX_PLACEHOLDER);
        if (!StringUtils.isNULLStr((String)userSetVal)) {
            int retryMax;
            try {
                retryMax = Integer.parseInt(userSetVal);
            }
            catch (NumberFormatException e) {
                retryMax = 3;
            }
            return retryMax;
        }
        return 3;
    }

    public static void refreshExecutionResult(UpgradeDeviceEntity result) {
        List rows = BundleUpgradeContext.getInstance().getMainDialog().getMainPanel().getDevTable().getAllRows();
        List<String> currentTableHeaders = BundleUpgradeLayout.getFusionStrgMainTableColumnsList();
        for (TableRow row : rows) {
            if (!(row.getUserObject() instanceof UpgradeDeviceEntity) || !UpgradeScenarioUtil.getUpgradeDeviceEntityUniqueId((UpgradeDeviceEntity)row.getUserObject()).equalsIgnoreCase(UpgradeScenarioUtil.getUpgradeDeviceEntityUniqueId(result))) continue;
            row.setValueAt(currentTableHeaders.indexOf(RES.getString("bundle.upgrade.main.table.col7")), (Object)new IsmTableCell.ProgressCell(100));
            break;
        }
    }

    public static String getUpgradeDeviceEntityUniqueId(UpgradeDeviceEntity deviceEntity) {
        return deviceEntity.getDeviceEntity().getSerialNumber() == null ? "" : deviceEntity.getDeviceEntity().getSerialNumber() + deviceEntity.getDeviceEntity().getIp();
    }

    public static String foldIpWithBracketsIfIpV6(String ip) {
        if (NetUtil.isValidIPV6((String)ip)) {
            return '[' + ip + ']';
        }
        return ip;
    }

    public static List<File> getAllDirectoriesInTargetDir(String targetScriptFilePath) {
        ArrayList<File> scriptDir = new ArrayList<File>();
        try (Stream<Path> walk = Files.walk(FileUtils.getFile((String[])new String[]{targetScriptFilePath}).getParentFile().toPath(), new FileVisitOption[0]);){
            scriptDir.addAll(new HashSet(walk.map(Path::toFile).filter(File::isDirectory).collect(Collectors.toList())));
        }
        catch (IOException ioE) {
            scriptDir.add(FileUtils.getFile((String[])new String[]{targetScriptFilePath}).getParentFile());
        }
        return scriptDir;
    }

    public static int getWaitingNmaRebootTimeOut() {
        try {
            return Integer.parseInt(SystemConfigUtil.getSysConfig("nma.process.reboot.time.out"));
        }
        catch (NumberFormatException nfe) {
            return 1800;
        }
    }

    public static boolean isYinglong() {
        return "yinglong".equalsIgnoreCase(System.getenv("framework.scene"));
    }

    public static boolean isOutBound() {
        return "out-band".equals(System.getProperty("upgradeType"));
    }
}

