/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.bundleupgrade.utils;

import com.huawei.bundleupgrade.constants.UpgradeParamConstants;
import com.huawei.bundleupgrade.entity.DeviceEntity;
import com.huawei.bundleupgrade.entity.DiskPkgInfo;
import com.huawei.bundleupgrade.entity.StrategySettingTableRowEntity;
import com.huawei.bundleupgrade.model.Module;
import com.huawei.bundleupgrade.utils.BundleUpgradeContext;
import com.huawei.bundleupgrade.utils.ServiceUtil;
import com.huawei.bundleupgrade.utils.UpgradeScenarioUtil;
import com.huawei.uMate.common.UMateException;
import java.util.Arrays;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VersionComparisonTools {
    private static final Logger log = LoggerFactory.getLogger(VersionComparisonTools.class);

    public static void compareVersionByCommonWay(StrategySettingTableRowEntity tableRowEntity) {
        VersionComparisonTools.setEffectCommon(tableRowEntity, tableRowEntity.getCurrentVersion(), tableRowEntity.getTargetVersion());
    }

    private static void setEffectCommon(StrategySettingTableRowEntity tableRowEntity, String current, String target) {
        if (ServiceUtil.isForcedUpgrade(tableRowEntity)) {
            VersionComparisonTools.setForcedUpgradeEffect(tableRowEntity, current, target);
        } else {
            VersionComparisonTools.setBelowToTargetUpgradeEffect(tableRowEntity, current, target);
        }
    }

    private static void setForcedUpgradeEffect(StrategySettingTableRowEntity tableRowEntity, String currentVersion, String targetVersion) {
        try {
            if (!UpgradeScenarioUtil.isValidVersion(currentVersion, tableRowEntity.getModule())) {
                tableRowEntity.setExpectEffect(UpgradeParamConstants.UpgradeExpectEffect.NON_EXECUTION);
            } else if ("--".equals(currentVersion) || UpgradeScenarioUtil.isFromVersionLowerThanToVersion(currentVersion, targetVersion)) {
                tableRowEntity.setExpectEffect(UpgradeParamConstants.UpgradeExpectEffect.UPGRADE);
            } else if (currentVersion.equals(targetVersion)) {
                tableRowEntity.setExpectEffect(UpgradeParamConstants.UpgradeExpectEffect.COVER);
            } else {
                tableRowEntity.setExpectEffect(UpgradeParamConstants.UpgradeExpectEffect.DEGRADATION);
            }
        }
        catch (UMateException e) {
            log.error("failed to compare currentVersion and targetVersion.");
        }
    }

    private static void setBelowToTargetUpgradeEffect(StrategySettingTableRowEntity tableRowEntity, String currentVersion, String targetVersion) {
        try {
            if (!UpgradeScenarioUtil.isValidVersion(currentVersion, tableRowEntity.getModule())) {
                tableRowEntity.setExpectEffect(UpgradeParamConstants.UpgradeExpectEffect.NON_EXECUTION);
            } else if ("--".equals(currentVersion) || UpgradeScenarioUtil.isFromVersionLowerThanToVersion(currentVersion, targetVersion)) {
                tableRowEntity.setExpectEffect(UpgradeParamConstants.UpgradeExpectEffect.UPGRADE);
            } else {
                tableRowEntity.setExpectEffect(UpgradeParamConstants.UpgradeExpectEffect.NON_EXECUTION);
            }
        }
        catch (UMateException e) {
            log.error("failed to compare currentVersion and targetVersion.");
        }
    }

    public static void updateExpectEffect(StrategySettingTableRowEntity tableRowEntity) {
        String current = tableRowEntity.getCurrentVersion();
        String target = tableRowEntity.getTargetVersion();
        if (!UpgradeScenarioUtil.isValidVersion(current, tableRowEntity.getModule())) {
            tableRowEntity.setExpectEffect(UpgradeParamConstants.UpgradeExpectEffect.NON_EXECUTION);
        } else if (ServiceUtil.isForcedUpgrade(tableRowEntity) || !current.equals(target)) {
            tableRowEntity.setExpectEffect(UpgradeParamConstants.UpgradeExpectEffect.UPGRADE);
        } else {
            tableRowEntity.setExpectEffect(UpgradeParamConstants.UpgradeExpectEffect.NON_EXECUTION);
        }
    }

    public static void compareGlounVersion(StrategySettingTableRowEntity tableRowEntity) {
        String target = tableRowEntity.getTargetVersion();
        String current = VersionComparisonTools.findUpgradeVersionForGloun(tableRowEntity.getCurrentVersion(), target);
        VersionComparisonTools.setEffectCommon(tableRowEntity, current, target);
    }

    public static String findUpgradeVersionForGloun(String verStr, String target) {
        if (!UpgradeScenarioUtil.isValidFromVersion(verStr)) {
            return verStr;
        }
        String[] versionList = (String[])Arrays.stream(verStr.split("\r")).map(version -> version.split(":")).filter(versionSplit -> ((String[])versionSplit).length > 1).map(versionSplit -> versionSplit[1].trim()).toArray(String[]::new);
        return VersionComparisonTools.getCurrentVersion(versionList, target);
    }

    public static void compareVersionExpRetimer(StrategySettingTableRowEntity tableRowEntity) {
        String targetVersion = tableRowEntity.getTargetVersion();
        String currentVersion = Arrays.stream(tableRowEntity.getCurrentVersion().split(":")).filter(version -> version.matches("\\d+(\\.\\d+){0,3}")).reduce(UpgradeScenarioUtil::getMinVersion).orElse("--");
        VersionComparisonTools.setEffectCommon(tableRowEntity, currentVersion, targetVersion);
    }

    public static void compareBaseKnl(StrategySettingTableRowEntity tableRowEntity) {
        tableRowEntity.setExpectEffect(VersionComparisonTools.compareBaseKnlVersion(tableRowEntity));
    }

    private static UpgradeParamConstants.UpgradeExpectEffect compareBaseKnlVersion(StrategySettingTableRowEntity tableRowEntity) {
        String current = tableRowEntity.getCurrentVersion();
        String target = tableRowEntity.getTargetVersion();
        if (!UpgradeScenarioUtil.isValidVersion(current, tableRowEntity.getModule())) {
            return UpgradeParamConstants.UpgradeExpectEffect.NON_EXECUTION;
        }
        if (ServiceUtil.isForcedUpgrade(tableRowEntity) && current.equals(target)) {
            return UpgradeParamConstants.UpgradeExpectEffect.COVER;
        }
        if (current.equals(target)) {
            return UpgradeParamConstants.UpgradeExpectEffect.NON_EXECUTION;
        }
        if ("--".equals(current) && UpgradeScenarioUtil.isYinglong()) {
            return UpgradeParamConstants.UpgradeExpectEffect.UPGRADE;
        }
        return VersionComparisonTools.getUpgradeExpectEffect(tableRowEntity, Module.BaseKnl.isCurrentLowerThanTarget(current, target));
    }

    private static UpgradeParamConstants.UpgradeExpectEffect getUpgradeExpectEffect(StrategySettingTableRowEntity tableRowEntity, boolean currentLowerThanTarget) {
        if (ServiceUtil.isForcedUpgrade(tableRowEntity)) {
            return currentLowerThanTarget ? UpgradeParamConstants.UpgradeExpectEffect.UPGRADE : UpgradeParamConstants.UpgradeExpectEffect.DEGRADATION;
        }
        return currentLowerThanTarget ? UpgradeParamConstants.UpgradeExpectEffect.UPGRADE : UpgradeParamConstants.UpgradeExpectEffect.NON_EXECUTION;
    }

    public static void comparePsuVersion(StrategySettingTableRowEntity tableRowEntity) {
        if (!UpgradeScenarioUtil.isValidFromVersion(tableRowEntity.getCurrentVersion())) {
            tableRowEntity.setExpectEffect(UpgradeParamConstants.UpgradeExpectEffect.NON_EXECUTION);
            return;
        }
        String[] current = tableRowEntity.getCurrentVersion().split(" ");
        String[] target = tableRowEntity.getTargetVersion().split(" ");
        String currentDC = current[0].substring(3);
        String targetDC = target[0].substring(3);
        VersionComparisonTools.setEffectCommon(tableRowEntity, currentDC, targetDC);
        if (currentDC.equals(targetDC)) {
            String currentPFC = current[1].substring(4);
            String targetPFC = target[1].substring(4);
            VersionComparisonTools.setEffectCommon(tableRowEntity, currentPFC, targetPFC);
        }
    }

    public static void compareSesVersion(StrategySettingTableRowEntity tableRowEntity) {
        String target = tableRowEntity.getTargetVersion();
        String current = VersionComparisonTools.findUpgradeVersionForSes(tableRowEntity.getCurrentVersion(), target);
        VersionComparisonTools.setEffectCommon(tableRowEntity, current, target);
    }

    public static String findUpgradeVersionForSes(String verStr, String target) {
        String[] versionList = (String[])Arrays.stream(verStr.split(" ")).map(version -> {
            String[] versionSplit = version.split(":");
            return versionSplit.length > 1 ? versionSplit[1] : versionSplit[0];
        }).toArray(String[]::new);
        return VersionComparisonTools.getCurrentVersion(versionList, target);
    }

    private static String getCurrentVersion(String[] versionList, String target) {
        String minVersion;
        Arrays.sort(versionList);
        String maxVersion = versionList[versionList.length - 1];
        String current = minVersion = versionList[0];
        if (target.compareToIgnoreCase(minVersion) > 0 && target.compareToIgnoreCase(maxVersion) < 0) {
            current = maxVersion;
        }
        return current;
    }

    public static void compareES3000(StrategySettingTableRowEntity tableRowEntity) {
        String[] diskSnAndVersionStr = tableRowEntity.getCurrentVersion().split(":");
        VersionComparisonTools.getDeviceByUid().getDiskInfo().stream().filter(disk -> diskSnAndVersionStr[0].equals(disk.getEsn())).findFirst().ifPresent(disk -> {
            if (disk.getFirmwareVersion().equalsIgnoreCase(tableRowEntity.getTargetVersion())) {
                tableRowEntity.setExpectEffect(UpgradeParamConstants.UpgradeExpectEffect.NON_EXECUTION);
                return;
            }
            tableRowEntity.setExpectEffect(UpgradeParamConstants.UpgradeExpectEffect.UPGRADE);
        });
    }

    private static DeviceEntity getDeviceByUid() {
        String uid = BundleUpgradeContext.getInstance().getLatestStrategyUuid();
        return BundleUpgradeContext.getInstance().getStrategyEntityMap().get(uid).getBaseDevice().getDeviceEntity();
    }

    public static void compareDiskFw(StrategySettingTableRowEntity tableRowEntity) {
        if (!UpgradeScenarioUtil.isValidFromVersion(tableRowEntity.getCurrentVersion())) {
            tableRowEntity.setExpectEffect(UpgradeParamConstants.UpgradeExpectEffect.NON_EXECUTION);
            return;
        }
        String[] diskSnAndVersionStr = tableRowEntity.getCurrentVersion().split(":");
        tableRowEntity.setExpectEffect(UpgradeParamConstants.UpgradeExpectEffect.NON_EXECUTION);
        tableRowEntity.setTargetVersion("--");
        Map<String, DiskPkgInfo> diskPkgMap = Module.DiskFw.buildDiskUidMap(tableRowEntity.getFirmwarePackageEntity().getDiskPkgInfos());
        VersionComparisonTools.getDeviceByUid().getDiskInfo().stream().filter(disk -> diskSnAndVersionStr[0].equals(disk.getEsn())).findFirst().ifPresent(disk -> VersionComparisonTools.initDiskUpgradeExpectEffect(tableRowEntity, diskPkgMap, disk));
    }

    private static void initDiskUpgradeExpectEffect(StrategySettingTableRowEntity tableRowEntity, Map<String, DiskPkgInfo> diskPkgMap, DeviceEntity.DiskModel disk) {
        if (!Module.DiskFw.canUpgrade(diskPkgMap, disk)) {
            String targetVersion = Module.DiskFw.findDiskInfo(diskPkgMap, disk).map(diskInf -> diskInf.getTargetVersion()).orElse("--");
            tableRowEntity.setTargetVersion(targetVersion);
            tableRowEntity.setExpectEffect(UpgradeParamConstants.UpgradeExpectEffect.NON_EXECUTION);
            return;
        }
        tableRowEntity.setTargetVersion(Module.DiskFw.findDiskInfo(diskPkgMap, disk).get().getTargetVersion());
        tableRowEntity.setExpectEffect(UpgradeParamConstants.UpgradeExpectEffect.UPGRADE);
    }

    public static void compareSsdSp(StrategySettingTableRowEntity tableRowEntity) {
        String[] diskSnAndVersionStr = tableRowEntity.getCurrentVersion().split(":");
        tableRowEntity.setExpectEffect(UpgradeParamConstants.UpgradeExpectEffect.NON_EXECUTION);
        tableRowEntity.setTargetVersion("NOT_MATCH");
        VersionComparisonTools.getDeviceByUid().getDiskInfo().stream().filter(disk -> diskSnAndVersionStr[0].equals(disk.getEsn())).findFirst().ifPresent(disk -> VersionComparisonTools.initSsdSpUpgradeExpectEffect(tableRowEntity, disk));
    }

    private static void initSsdSpUpgradeExpectEffect(StrategySettingTableRowEntity tableRowEntity, DeviceEntity.DiskModel disk) {
        String model;
        Map<String, DiskPkgInfo> diskPkgMap = Module.DiskFw.buildDiskUidMap(tableRowEntity.getFirmwarePackageEntity().getDiskPkgInfos());
        if (!diskPkgMap.containsKey(model = disk.getSupportModelUID())) {
            tableRowEntity.setExpectEffect(UpgradeParamConstants.UpgradeExpectEffect.NON_EXECUTION);
            return;
        }
        String targetVer = diskPkgMap.get(model).getTargetVersion();
        tableRowEntity.setTargetVersion(targetVer);
        if (targetVer.equalsIgnoreCase(disk.getFirmwareVersion())) {
            if (ServiceUtil.isForcedUpgrade(tableRowEntity)) {
                tableRowEntity.setExpectEffect(UpgradeParamConstants.UpgradeExpectEffect.COVER);
            } else {
                tableRowEntity.setExpectEffect(UpgradeParamConstants.UpgradeExpectEffect.NON_EXECUTION);
            }
        } else {
            tableRowEntity.setExpectEffect(UpgradeParamConstants.UpgradeExpectEffect.UPGRADE);
        }
    }

    public static void compareVrdVersion(StrategySettingTableRowEntity tableRowEntity) {
        String target = tableRowEntity.getTargetVersion();
        String current = Arrays.stream(tableRowEntity.getCurrentVersion().split("\\.")).findFirst().orElse("--");
        VersionComparisonTools.setEffectCommon(tableRowEntity, current, target);
    }
}

